
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <linux/if.h>
#include <linux/sockios.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <errno.h>
// RTF_UP ,  RTF_HOST  , struct rtentry
#include <linux/route.h>
#include "mg_ipinst.h"
#include "function_sys.h"

#define SHAREINF_MAX_VALUE 255

static char EthernetAddress[BSP_LAN1_HWALEN];
static int g_bLatestData = 0;
char recv_data[SZ_RECV_BUFF];

int ret;
struct sockaddr_in myaddr_in, peeraddr_in;
int status;
int ls;				// local socket
int on = 1;
socklen_t peerLen;
FindSvrPkt_t *recvPkt;

int restart = 1;

static int SET_SOCKET()
{

	memset((char *)&myaddr_in, 0, sizeof(struct sockaddr_in));

	myaddr_in.sin_family = AF_INET;
	myaddr_in.sin_addr.s_addr = htonl(INADDR_ANY);
	myaddr_in.sin_port = htons(IPINST_PORT_SERVER);

	close(ls);

	ls = socket(AF_INET, SOCK_DGRAM, 0);

	if (ls == -1) {
		printf("socket error ..\n");
	}

	g_bLatestData = 0;

	ret = setsockopt(ls, SOL_SOCKET, SO_DONTROUTE, (char *)&on, sizeof(on));

	ret = setsockopt(ls, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
	if (ret == -1) {
		DPRINTF(LOG_ERR, AP_NAME "setsockopt error 1 \n");
		printf("socket error .. 1\n");
	}
	ret = setsockopt(ls, SOL_SOCKET, SO_BROADCAST, (char *)&on, sizeof(on));
	if (ret == -1) {
		DPRINTF(LOG_ERR, AP_NAME "setsockopt error 2 \n");
		printf("setsockopt error 2 \n");
	}
	ret = bind(ls, (struct sockaddr *)&myaddr_in, sizeof(struct sockaddr_in));

	if (ret == -1) {
		DPRINTF(LOG_ERR, AP_NAME "bind error \n");
		printf("bind error \n");
	}
	status = BOOTP_STATUS_NORMAL;
	recvPkt = (FindSvrPkt_t *) recv_data;

	RandomInit();

	restart = 0;
	return 0;
}

char host[20];

int main(int argc, char **argv)
{
	memset(host, 0, 20);
	printf("mg_ipinst start ... \n");

	if (sys_connect_mgapp() != EXIT_SUCCESS) {
		printf("Connect Failure!!!\n");
		return EXIT_SUCCESS;
	}
	struct SHM_INFO_STRUCT shm;

	if (INF_attach(&shm, "/etc/system.conf") != EXIT_SUCCESS)
		printf("Inf_Attach fail!\n");

	char *modelname = INF_get(&shm, "Brand.ProdNbr", NULL);

	while (1) {
		if (restart == 1) {
			SET_SOCKET();
		}
		//              printf("while Loop .. HEAD  \n");    
		peerLen = sizeof(peeraddr_in);
		ret = recvfrom(ls, recv_data, SZ_RECV_BUFF, 0, (struct sockaddr *)&peeraddr_in, &peerLen);

		if (ret <= 0) {
			DPRINTF(LOG_DEBUG, AP_NAME "recvfrom error \n");
		}
		if (strncmp(recv_data, FINDSVR_IDENTIFIER, SZ_PKT_IDENTIFIER))
			continue;

		switch (recvPkt->op_code) {
		case IPINST_OPCODE_FINDSVR:
			sprintf(host, "%s", inet_ntoa(peeraddr_in.sin_addr));
			DPRINTF(LOG_DEBUG, AP_NAME "IPINST_OPCODE_FINDSVR \n");

 //2011/07/11 allen add to modify wireless NG 
                        if ((Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "eth0") == BPMACADDR_BROADCAST)
				    || (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "eth0")
					== BPMACADDR_MYSELF)
				    || (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "rausb0")
					== BPMACADDR_BROADCAST)
				    || (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "rausb0")
					== BPMACADDR_MYSELF))
                         {

					recvPkt->op_code = IPINST_OPCODE_OK;
                               if (FillReplyPacket(&shm, recvPkt, "eth0") >= 0)
                                      ret = UDP_Broadcast(ls, IPINST_PORT_CLIENT, recv_data, sizeof(FindSvrPkt_t), "eth0");
                               if (ret < 0) {
						DPRINTF(LOG_ERR, AP_NAME "UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
						printf("UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
					}

                               if (FillReplyPacket(&shm, recvPkt, "rausb0") >= 0)
                                      ret = UDP_Broadcast(ls, IPINST_PORT_CLIENT, recv_data, sizeof(FindSvrPkt_t), "rausb0");
                               if (ret < 0) {
						DPRINTF(LOG_ERR, AP_NAME "UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
						printf("UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
					}     
                               
			      status = BOOTP_STATUS_SETTING;


                         }
#if 0  //2011/07/11 allen modify wireless NG 
			if (strcmp(modelname, "P606W") && strcmp(modelname, "P605W")
			    && strcmp(modelname, "P630W")) {
				if ((Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "eth0") == BPMACADDR_BROADCAST)
				    || (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "eth0")
					== BPMACADDR_MYSELF)) {

					recvPkt->op_code = IPINST_OPCODE_OK;

					if (FillReplyPacket(&shm, recvPkt, "eth0") >= 0)

						ret = UDP_Broadcast(ls, IPINST_PORT_CLIENT, recv_data, sizeof(FindSvrPkt_t), "eth0");
					if (ret < 0) {
						DPRINTF(LOG_ERR, AP_NAME "UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
						printf("UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
					}
					status = BOOTP_STATUS_SETTING;
				}
			} else {
				if ((Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "eth0") == BPMACADDR_BROADCAST)
				    || (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "eth0")
					== BPMACADDR_MYSELF)
				    || (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "rausb0")
					== BPMACADDR_BROADCAST)
				    || (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "rausb0")
					== BPMACADDR_MYSELF)) {
					recvPkt->op_code = IPINST_OPCODE_OK;
					if (FillReplyPacket(&shm, recvPkt, "eth0") >= 0) {
						ret = UDP_Broadcast(ls, IPINST_PORT_CLIENT, recv_data, sizeof(FindSvrPkt_t), "eth0");
					}
					if (FillReplyPacket(&shm, recvPkt, "rausb0") >= 0) {
						//UDP_Broadcast (ls, IPINST_PORT_CLIENT, recv_data,sizeof (FindSvrPkt_t), "rausb0");  

						int i;
						for (i = 0; i < 1; i++) {

							ret = UDP_Broadcast(ls, IPINST_PORT_CLIENT, recv_data, sizeof(FindSvrPkt_t), "rausb0");

							if (ret < 0) {
								DPRINTF(LOG_ERR, AP_NAME "UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
								printf("UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
							}
						}
					}

					if (ret < 0) {
						DPRINTF(LOG_ERR, AP_NAME "UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
						printf("UDP1 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
					}
					status = BOOTP_STATUS_SETTING;
					restart = 1;
				}
			}
#endif
			break;

		case IPINST_OPCODE_SETSVR:
			/*
			 * We use /etc/shadow to do user authorization, 
			 * so if we are unable to open /etc/shadow, the
			 * user authorization failed.
			 */
			{
				char *read = NULL;
				char cmd[100];
				char line_tmp[256];
				FILE *fp;

				memset(cmd, 0, 100);
				if (*recvPkt->password != 0) {
					system("touch /tmp/users.db");
					sprintf(cmd, "/usr/bin/httpPassword -p %s /tmp/users.db Login %s", recvPkt->password, recvPkt->username);
					system(cmd);
					fp = fopen("/tmp/users.db", "r");
					if (fp) {
						fgets(line_tmp, sizeof(line_tmp), fp);
					}
					fclose(fp);
					system("rm /tmp/users.db");
				} else {
					sprintf(line_tmp, "%s", DEFAULT_SETTING);
				}

				fp = fopen("/data/users.db", "r");
				if (fp) {
					char line[256], *cp = NULL;
					char *user = strcat(recvPkt->username, ":");

					while (NULL != (read = fgets(line, sizeof(line), fp))) {
						/*
						   if (0 != strncmp (user, line, strlen (user)))
						   continue;

						   cp = strchr (line + strlen (user), ':');
						   if (!cp)
						   continue;
						   *cp = '\0';
						   cp = crypt (recvPkt->password, line + strlen (user));

						   //printf("%s\n", line + strlen(user));
						   //printf("%s\n", cp);
						   if (0 ==
						   strncmp (line + strlen (user), cp, strlen (cp)))
						   break;
						   }
						 */
						if (0 == strncmp(line, line_tmp, strlen(line_tmp)))
							break;
					}
					fclose(fp);
				}

				if (read == NULL) {
					//// Jim@2009_0922: Allow_return_code ///

					sprintf(recvPkt->model, "%s", modelname);

					recvPkt->op_code = IPINST_OPCODE_OK;
					char *ip = INF_get(&shm, "Network.IPAddress", NULL);

					recvPkt->ip_addr = jsnet_aton(ip);
					sprintf(recvPkt->info, "%s", "404, No Permission");

					ret = UDP_Broadcast(ls, IPINST_PORT_CLIENT, recv_data, sizeof(FindSvrPkt_t), "eth0");
					//////////
					continue;
				}
			}
			// because the packets are broadcast, the modification is carried out only if MAC is mine.
			char interface[10];

			memset(interface, 0, 10);
			if (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "eth0") == BPMACADDR_MYSELF)
				sprintf(interface, "%s", "eth0");

			if (!strcmp(modelname, "P606W") || !strcmp(modelname, "P605W")
			    || !strcmp(modelname, "P630W")) {
				if (Cmp_Macaddr(BSP_LAN1_HWALEN, recvPkt->mac_addr, "rausb0")
				    == BPMACADDR_MYSELF)
					sprintf(interface, "%s", "rausb0");
			}
			if (!strcmp(interface, "rausb0") || !strcmp(interface, "eth0")) {
				if (!strcmp(interface, "eth0"))
					ret = Linux_SetParams(&shm, recvPkt);

				if (!strcmp(interface, "rausb0"))
					ret = Linux_SetParams_W(&shm, recvPkt);

				if (ret) {
					recvPkt->op_code = IPINST_OPCODE_FAIL;
					DPRINTF(LOG_ERR, AP_NAME "IPINST_OPCODE_FAIL \n");
					printf("IPINST_OPCODE_FAIL \n");
				} else {
					recvPkt->op_code = IPINST_OPCODE_OK;
					char *ip = NULL;

					if (!strcmp(interface, "eth0"))
						ip = INF_get(&shm, "Network.IPAddress", NULL);
                                        else if (!strcmp(interface, "rausb0"))
						ip = INF_get(&shm, "Wireless.IPAddress", NULL);

					recvPkt->ip_addr = jsnet_aton(ip);

					//// Jim@2009_0922: Allow_return_code ///
					char *modelname = INF_get(&shm, "Brand.ProdModel", NULL);
					sprintf(recvPkt->model, "%s", modelname);
					sprintf(recvPkt->info, "%s", "200, Ok");
					///

					ret = UDP_Broadcast(ls, IPINST_PORT_CLIENT, recv_data, sizeof(FindSvrPkt_t), interface);

					if (ret <= 0) {
						DPRINTF(LOG_ERR, AP_NAME "UDP3 error [ ret=%d ErrCode=0x%04x ] \n", ret, errno);
						printf("UDP3 error [ ret=%d ErrCode=0x%04x ] \n", ret, errno);
					} else {

						sys_set_network(&shm, NULL, NULL);
						usleep(1000 * 1000);
						system("appweb.sh");
						restart = 1;

					}
				}
			}
			break;
		default:
			break;

		}
		//              printf("while loop .. FOOT\n");
	}
}

int RandomInit(void)
{
	unsigned int seed, mac;
	char hwaddr[30];

	sprintf(hwaddr, "%s", "00:40:05:A9:D1:14");

	mac = MAC_Byte(hwaddr, 3);
	mac = (mac << 8) + MAC_Byte(hwaddr, 4);
	seed = (unsigned int)time(0);

	if (seed < 65536) {
		DPRINTF(LOG_ERR, AP_NAME "Fail to init Rand Seed(t=%d)\n", seed);
		printf("Fail to init Rand Seed(t=%d)\n", seed);
	}

	seed &= 0xff;
	seed <<= 3;
	seed += mac;
	srand(seed);

	return EXIT_SUCCESS;
}

static int Cmp_Macaddr(int mac_len, char *mac_addr, char *interface)
{
	int i;

	memset(EthernetAddress, 0, BSP_LAN1_HWALEN);
	i = 0;
	while (i < mac_len) {
		if (mac_addr[i] != (char)0xff)
			break;
		i++;
	}

	if (i >= mac_len) {
		return BPMACADDR_BROADCAST;
	}
	GetHwAddr(interface, EthernetAddress);

	i = 0;
	while (i < mac_len) {
		if (mac_addr[i] != EthernetAddress[i])
			break;
		i++;
	}
	if (i >= mac_len) {
		return BPMACADDR_MYSELF;
	}

	return BPMACADDR_NOMATCH;

}

static int GetHwAddr(const char *ifname, char *hwaddr)
{
	struct ifreq ifr;
	int skfd;

	if (g_bLatestData) {
		hwaddr = EthernetAddress;
		return EXIT_SUCCESS;
	}

	skfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (skfd < 0) {
		return EXIT_FAILURE;
	}

	strcpy(ifr.ifr_name, ifname);
	if (ioctl(skfd, SIOCGIFHWADDR, &ifr) < 0) {
		close(skfd);
		return EXIT_FAILURE;
	}

	memcpy(EthernetAddress, ifr.ifr_hwaddr.sa_data, BSP_LAN1_HWALEN);
	hwaddr = EthernetAddress;
	g_bLatestData = 0;

	close(skfd);

	return EXIT_SUCCESS;

}

int UDP_Broadcast(int sckt, int port, char *buf, int len, char *interface)
{
	struct sockaddr_in peeraddr_in1;

	//struct sockaddr_intf *myintf;
	struct sockaddr_in *myintf;
	struct ifreq if_ppp0;
	struct hostent *he;

	int ret = 0;
	const int hold = 1;
	int hold1 = 1;
	int sckt1;

	RandomDelay(1000);

	if ((sckt1 = socket(AF_INET, SOCK_DGRAM, 0)) == -1) {
		perror("socket");
		exit(1);
	}

	he = gethostbyname("255.255.255.255");
	memset((char *)&peeraddr_in1, 0, sizeof(struct sockaddr_in));
	peeraddr_in1.sin_family = AF_INET;
	peeraddr_in1.sin_addr.s_addr = htonl(INADDR_BROADCAST);
	//peeraddr_in1.sin_addr.s_addr = inet_addr(host);
	//peeraddr_in1.sin_addr = *((struct in_addr *)he->h_addr);

	peeraddr_in1.sin_port = htons(port);

	myintf = &peeraddr_in1;
	memset(peeraddr_in1.sin_zero, '\0', sizeof peeraddr_in1.sin_zero);

	/*
	   ret=setsockopt (sckt, SOL_SOCKET, SO_REUSEADDR, (char *) &hold1,
	   sizeof (hold1));

	   if (ret==-1)
	   printf("error 4\n");
	 */
	strncpy(if_ppp0.ifr_name, interface, IFNAMSIZ);
	ret = setsockopt(sckt1, SOL_SOCKET, SO_BINDTODEVICE, (char *)&if_ppp0, sizeof(if_ppp0));

	ret = setsockopt(sckt1, SOL_SOCKET, SO_BROADCAST, (char *)&hold, sizeof(hold));

	if (ret == -1) {
		DPRINTF(LOG_ERR, AP_NAME "setsockopt error 3 \n");
	}

	/*
	   else {
	   DPRINTF(LOG_INFO,  AP_NAME "setsockopt ok 3 \n");
	   }
	 */
	//      FindSvrPkt_t * tmp = (FindSvrPkt_t * ) buf;

	//      PRINT_PKG(tmp);

	ret = sendto(sckt1, buf, len, 0, (struct sockaddr *)&peeraddr_in1, sizeof(peeraddr_in1));

	if (ret < 0) {
		DPRINTF(LOG_ERR, AP_NAME "ERRNO=%d, const=%d\n", errno, ENETUNREACH);
		if (errno == ENETUNREACH) {
			IPN_AddRoute(sckt1, INADDR_BROADCAST, 0, RTF_UP | RTF_HOST);
			ret = sendto(sckt1, buf, len, 0, (struct sockaddr *)&peeraddr_in1, sizeof(peeraddr_in1));
		} else {
			DPRINTF(LOG_ERR, AP_NAME "UDP4 error [ ret=%d ErrCode=0x%04x ]\n", ret, errno);
			ret = errno;
		}
	}

	else {
		//DPRINTF(LOG_DEBUG,  AP_NAME "UDP4 ok \n");                                                   
	}

	close(sckt1);
	return ret;
}

static int FillReplyPacket(struct SHM_INFO_STRUCT *shm, FindSvrPkt_t * pkt, char *interface)
{

	struct ifreq ifr;
	struct sockaddr_in *saddr;
	int skfd;
	unsigned long gw_ip = 0;

	skfd = socket(AF_INET, SOCK_DGRAM, 0);
	if (skfd < 0) {
		//              printf("skfd < 0 ... \n");
		return -1;
	}
	/*
	   else {
	   printf("skfd = %d \n", skfd);
	   }
	   printf("FillReplyPacket ...  333\n");
	 */
	// Get Hardware Address

	//strcpy(ifr.ifr_name, IF0_NAME);
	strcpy(ifr.ifr_name, interface);
	if (ioctl(skfd, SIOCGIFHWADDR, &ifr) < 0) {
		//printf("ioctl sdfd SIOCGIFHWADDR error ..\n");
		goto err_label;
	}

	memcpy(pkt->mac_addr, ifr.ifr_hwaddr.sa_data, BSP_LAN1_HWALEN);

	// Get IP Address
	if (ioctl(skfd, SIOCGIFADDR, &ifr) < 0) {
		goto err_label;
	}
	saddr = (struct sockaddr_in *)&ifr.ifr_addr;
	pkt->ip_addr = (saddr->sin_addr).s_addr;

	// Get Subnet Mask
	if (ioctl(skfd, SIOCGIFNETMASK, &ifr) < 0) {
		goto err_label;
	}
	saddr = (struct sockaddr_in *)&ifr.ifr_addr;
	pkt->subnet_msk = (saddr->sin_addr).s_addr;

	// get Default Gateway
	//Do_DefGw(skfd, DEFGW_FIND, &gw_ip);
	//pkt->def_gateway = gw_ip;

	char *ret;

	/*
	   // Get IP Address
	   printf("Get IP Address ... \n");
	   ret = INF_get( &infbuf, "Network.IPAddress", NULL );
	   printf("Network.IPAddress = %s \n", ret );
	   pkt->ip_addr = jsnet_aton( ret );

	   // Get Subnet Mask
	   ret = INF_get( &infbuf, "Network.SubnetMask", NULL );
	   pkt->subnet_msk = jsnet_aton( ret );

	   // get Default Gateway
	   ret = INF_get( &infbuf, "Network.DefaultRouter", NULL );
	   pkt->def_gateway =  jsnet_aton( ret );
	 */

        if (!strcmp(interface, "eth0"))
        {
             ret = INF_get(shm, "Network.DefaultRouter", NULL );
             pkt->def_gateway =  jsnet_aton( ret );
        }
        else if (!strcmp(interface, "rausb0"))
        {
             ret = INF_get(shm, "Wireless.DefaultRouter", NULL );
             pkt->def_gateway =  jsnet_aton( ret );
        }

	// get DNS 1~3 server address
	ret = INF_get(shm, "Network.DNSServer1", NULL);
	pkt->dns1 = jsnet_aton(ret);

	ret = INF_get(shm, "Network.DNSServer2", NULL);
	pkt->dns2 = jsnet_aton(ret);

	ret = INF_get(shm, "Network.DNSServer3", NULL);
	pkt->dns3 = jsnet_aton(ret);

	ret = INF_get(shm, "System.WebPort", NULL);
	pkt->httpPort = htons(atoi(ret));

	// Jim@2009_0827: Still need to be fixed.
	//ret = INF_get( shm, "Brand.ProdNbr", NULL );
	/*
	   if ( strcmp (INF_get( shm, "Brand.Brand", NULL ), "PIXORD") == 0 )
	   ret = INF_get( shm, "Brand.ProdNbr", NULL );
	   else
	 */
	ret = INF_get(shm, "Brand.ProdModel", NULL);

	sprintf(pkt->info, "%s", ret);
	sprintf(pkt->model, "%s", ret);	//also update model name

	ret = INF_get(shm, "Brand.Brand", NULL);
	sprintf(pkt->brand, "%s", ret);
	ret = INF_get(shm, "Properties.Firmware.Version", NULL);
	sprintf(pkt->version, "%s", ret);

	/*
	   GetHttpsStatus(pkt->info, sizeof(pkt->info));
	   sprintf(pkt->version, "%d.%02d%s", WBC_VERSION_MAJOR, WBC_VERSION_MINOR, WBC_VERSION_SUFFIX);
	   pkt->version[IPN_VERSION_MAXLEN-1]='\0';
	 */
	close(skfd);
	return EXIT_SUCCESS;

      err_label:
	close(skfd);
	return -1;

}

static int IPN_AddRoute(int skfd, unsigned long dest_ip, unsigned long gw_ip, int flags)
{
	struct rtentry rt;
	struct sockaddr_in *dst, *gw;

	memset((char *)&rt, 0, sizeof(struct rtentry));
	rt.rt_dev = (char *)IF0_NAME;
	dst = (struct sockaddr_in *)&(rt.rt_dst);
	gw = (struct sockaddr_in *)&(rt.rt_gateway);
	dst->sin_family = AF_INET;
	dst->sin_addr.s_addr = htonl(dest_ip);

	rt.rt_flags = flags;

	if (ioctl(skfd, SIOCADDRT, &rt) < 0) {
		DPRINTF(LOG_DEBUG, AP_NAME "SIOCADDRT error \n");
		return EXIT_FAILURE;
	}

	return EXIT_SUCCESS;
}

// jsnVer2.21 Add:
// This subroutine will delay for a random period of time
// Example: if max_ms = 999, then will delay x milliseconds, n = 0 to 999.
//
// Hint: Maybe we can reference to how TCP/IP can generate sequence number ramdomly.
//
int RandomDelay(ULONG max_ms)
{
	unsigned int dd;

	dd = (int)(((double)max_ms) * rand() / (RAND_MAX + 1.0));
	DPRINTF(LOG_DEBUG, AP_NAME "ipinst=%d\n", dd);
	usleep(dd * 1000);
	return EXIT_SUCCESS;
}

int MAC_Byte(char *hwaddr, int iByte)
{
	int val;
	int p, q;		// index to the string <hwaddr>
	char ch;

	// find the starting index of byte-n
	q = p = GetMacPos(hwaddr, iByte);
	if (p < 0)
		return -1;	// ERROR

	// find the ending index of byte-n
	while ((ch = hwaddr[q]) != '\0') {
		if (ch == SEPARATOR_COLON)
			break;
		q++;
	}

	// now <q> points to either a colon or NULL.
	hwaddr[q] = '\0';
	//printf("DEBUG: M=%s#\n", hwaddr+p);
	val = strtoull(hwaddr + p, NULL, 16);
	hwaddr[q] = ch;		//  restore the original char to overwrite NULL CHAR which we added for previous string processing
	return val;
}

static int GetMacPos(const char *str, int pos)
{
	int p = 0;		// index of <str>
	int i = 0;		// the i-th byte

	// find the head-ptr of byte-n
	while (str[p]) {
		if (i >= pos)
			break;
		if (str[p] == SEPARATOR_COLON) {
			i++;
		}
		p++;
	}			// End while

	if (i >= MAXLEN_ETHERMAC)
		return -1;	//ERROR

	return p;
}

/*
   void PRINT_PKG(FindSvrPkt_t * pkg){
   printf("guid = \t %s\n", pkg->guid);
   printf("comm_id  = \t %s\n", pkg->comm_id);
   printf("len  = \t %d\n", pkg->len);
   printf("must_know  = \t %d\n", pkg->must_know);
   printf("op_code  = \t %d\n", pkg->op_code);
   printf("mac_addr = %.2x:%.2x:%.2x:%.2x:%.2x:%.2x\n",
   (unsigned char)pkg->mac_addr[0],
   (unsigned char)pkg->mac_addr[1],
   (unsigned char)pkg->mac_addr[2],
   (unsigned char)pkg->mac_addr[3],
   (unsigned char)pkg->mac_addr[4],
   (unsigned char)pkg->mac_addr[5] );
   printf("ipn_flag  = \t %d\n", pkg->ipn_flag);	
   printf("reserved  = \t %s\n", pkg->reserved);	
   printf("ip_addr  = \t 0x%x\n", pkg->ip_addr);	
   printf("subnet_msk  = \t 0x%x\n", pkg->subnet_msk);		
   printf("def_gateway  = \t 0x%x\n", pkg->def_gateway);		
   printf("dns1  =  \t0x%x\n", pkg->dns1);		
   printf("dns2  =  \t0x%x\n", pkg->dns2);		
   printf("dns3  =  \t0x%x\n", pkg->dns3);		
   printf("subnet_msk  = \t 0x%x\n", pkg->subnet_msk);			
   printf("httpPort = \t %d\n", pkg->httpPort);
   printf("rsved2  = \t %s\n", pkg->rsved2);	
   printf("username  = \t %s\n", pkg->username);	
   printf("password  = \t %s\n", pkg->password);	
   printf("info  = \t %s\n", pkg->info);	
   printf("version  = \t %s\n", pkg->version);		
   }


*/

static int Linux_SetParams(struct SHM_INFO_STRUCT *shm, FindSvrPkt_t * recvPkt)
{
	//      printf("Linux_SetParams ... \n");
	//      PRINT_PKG(recvPkt);

	char *val = (char *)malloc(SHAREINF_MAX_VALUE + 8);
	char cmd[30];

	memset(val, 0, SHAREINF_MAX_VALUE + 8);
	memset(cmd, 0, 30);

	if (recvPkt->reserved == 1)
		INF_update(shm, "Network.BootProto", "dhcp");
	else if (recvPkt->reserved == 2) {
		INF_update(shm, "Network.BootProto", "pppoe");
		INF_update(shm, "Network.PPPoE.UserName", recvPkt->username_pppoe);
		INF_update(shm, "Network.PPPoE.Password", recvPkt->password_pppoe);
	} else if (recvPkt->reserved == 0) {
		INF_update(shm, "Network.BootProto", "none");

		// Set IP Address
		jsnet_ntoa2(recvPkt->ip_addr, val);
		INF_update(shm, "Network.IPAddress", val);

		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... IPAddress = %s \n", val);

		// Set Subnet Mask
		jsnet_ntoa2(recvPkt->subnet_msk, val);
		INF_update(shm, "Network.SubnetMask", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... SubnetMask = %s \n", val);

		// Set Default Gateway
		jsnet_ntoa2(recvPkt->def_gateway, val);
		INF_update(shm, "Network.DefaultRouter", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... DefaultRouter = %s \n", val);

		// Set DNS 1~3 server address
		jsnet_ntoa2(recvPkt->dns1, val);
		INF_update(shm, "Network.DNSServer1", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... DNSServer1 = %s \n", val);

		jsnet_ntoa2(recvPkt->dns2, val);
		INF_update(shm, "Network.DNSServer2", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... DNSServer2 = %s \n", val);

		jsnet_ntoa2(recvPkt->dns3, val);
		INF_update(shm, "Network.DNSServer3", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... DNSServer3 = %s \n", val);

		// Set AppWeb port
		sprintf(val, "%d", htons(recvPkt->httpPort));
		INF_update(shm, "System.WebPort", val);
		sprintf(cmd, "eeprom httpportw %s", val);
		system(cmd);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... AppWebPort = %s \n", val);

		// Jim@2009_0914: Set as static IP
		INF_update(shm, "Network.BootProto", "none");
	}
	system("killall udhcpc ");

	INF_write(shm);

	return EXIT_SUCCESS;
}

static int Linux_SetParams_W(struct SHM_INFO_STRUCT *shm, FindSvrPkt_t * recvPkt)
{
	//      printf("Linux_SetParams ... \n");
	//      PRINT_PKG(recvPkt);

	char *val = (char *)malloc(SHAREINF_MAX_VALUE + 8);

	memset(val, 0, SHAREINF_MAX_VALUE + 8);

	if (recvPkt->reserved == 1)
		INF_update(shm, "Network.BootProto", "dhcp");
	else {
		INF_update(shm, "Network.BootProto", "none");

		// Set IP Address
		jsnet_ntoa2(recvPkt->ip_addr, val);
		INF_update(shm, "Wireless.IPAddress", val);

		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... IPAddress = %s \n", val);

		// Set Subnet Mask
		jsnet_ntoa2(recvPkt->subnet_msk, val);
		INF_update(shm, "Wireless.SubnetMask", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... SubnetMask = %s \n", val);

		// Set Default Gateway
		jsnet_ntoa2(recvPkt->def_gateway, val);
		INF_update(shm, "Network.DefaultRouter", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... DefaultRouter = %s \n", val);

		// Set DNS 1~3 server address
		jsnet_ntoa2(recvPkt->dns1, val);
		INF_update(shm, "Network.DNSServer1", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... DNSServer1 = %s \n", val);

		jsnet_ntoa2(recvPkt->dns2, val);
		INF_update(shm, "Network.DNSServer2", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... DNSServer2 = %s \n", val);

		jsnet_ntoa2(recvPkt->dns3, val);
		INF_update(shm, "Network.DNSServer3", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... DNSServer3 = %s \n", val);

		// Set AppWeb port
		sprintf(val, "%d", htons(recvPkt->httpPort));
		INF_update(shm, "System.WebPort", val);
		DPRINTF(LOG_INFO, AP_NAME "Ipinstall setting ... AppWebPort = %s \n", val);

		// Jim@2009_0914: Set as static IP
		INF_update(shm, "Network.BootProto", "none");
	}
	system("killall udhcpc ");

	INF_write(shm);
	return EXIT_SUCCESS;
}

static ULONG jsnet_aton(char *str)
{
	struct in_addr addr;

	return inet_aton(str, &addr) ? addr.s_addr : 0;
}

void jsnet_ntoa2(ULONG address, char *val)
{
	struct in_addr addr;

	addr.s_addr = address;
	sprintf(val, "%s", inet_ntoa(addr));
}

static int Do_DefGw(int skfd, int op, unsigned long *gw_addr)
{
	int n_route = 0;
	char devname[64];
	unsigned long int d, g, m;
	int flgs, ref, use, metric, mtu, win, ir;
	char ifo[10];
	FILE *fp = fopen("/proc/net/route", "r");

	if (fp == NULL) {
		printf("ERROR open file\n");
		return -1;
	}

	if (fscanf(fp, "%*[^\n]\n") < 0) {
		printf("ERROR fscanf\n");
		fclose(fp);
		return -1;
	}

	if (op == DEFGW_FIND)
		*gw_addr = 0;
	while (1) {
		int r;

		r = fscanf(fp, "%63s%lx%lx%X%d%d%d%lx%d%d%d\n", devname, &d, &g, &flgs, &ref, &use, &metric, &m, &mtu, &win, &ir);
		if (r != 11) {
			if ((r < 0) && feof(fp)) {
				break;
			}
		}

		if (d == 0) {
			if (op == DEFGW_DEL) {
				/*
				   if (wireless_flag==1)
				   strcpy(ifo,IF0_RAUSB);
				   else strcpy(ifo,IF0_NAME);
				 */
				strcpy(ifo, IF0_NAME);
				/*
				   if (Del_Gw_00(skfd, ifo) < 0) {
				   perror("ERROR: Cannot Delete Gateway");
				   return -1;
				   }
				 */
			} else if (op == DEFGW_FIND) {
				*gw_addr = g;
			}
			n_route++;
		}
	}

	fclose(fp);
	return n_route;
}

/*	
	static int CheckPermission(FindSvrPkt_t *pkt) {
	if (g_DC.OpMode & IPN_PROTECT) {
// check password if corresponding bit is set.

// now only pSOS+
return AdminCheck(pkt->username, pkt->password);
}
else {
return 1; // No need to check password
}
}

int GetHttpsStatus(char *info, int n) {

snprintf(info, n, "%s", "https=On");

return 0;

char line[80];
FILE *fp = fopen( HTTPD_CONF_FILE, "r");

if (fp == NULL) {
DPRINTF(LOG_ERR,  AP_NAME "open HTTPD_CONF_FILE  error \n");								
return -1;
}

while (fgets(line, sizeof(line), fp) > 0) {
char *p=line;

while (*p != '\n') p++;
 *p = '\0';

 if (strcmp(line, "ssl")) {
 continue;
 }
 else {
 snprintf(info, n, "%s", "https=On");
 goto end;
 }

 } 

 snprintf(info, n, "%s", "https=Off");

end:

fclose(fp);

return 0;
}
*/
