#include <string.h>

#include "bcommon.h"
#include "frameQueue.h"

frameQueue::
frameQueue ( unsigned long size) :QueueAr (size){

	this->theArray = (void *)  malloc(size * sizeof(frameObject) );

	if ( this->theArray == NULL ){
		m_DEBUG ("[frameQueue]: malloc is null\n");
		return;
	}
	
	this->arraySize = size;
	
	makeEmpty();
	
	m_DEBUG ("frameQueue constructor arraySize = %d\n", size);
	
	return;	
}

frameQueue::
~frameQueue ()  {
	free (this->theArray);
}

bool frameQueue::
isEmpty() {
	return ( currentSize == 0 );
}

bool frameQueue::
isFull () {
	if  (currentSize == arraySize) {
		m_DEBUG ("[frameQueue::isFull] Queue is full (%ld/%ld)\n", currentSize, arraySize);
		return true;
	}

	return false;
}

bool frameQueue::
isFull (unsigned long size) {
	if  ((currentSize + size) == arraySize) {
		m_DEBUG ("[frameQueue::isFull] Queue is full\n");
		return true;
	}

	return false;
}

void frameQueue::
makeEmpty() {	
	this->currentSize = 0;
	this->front = 1;
	this->end =1;
	m_DEBUG("frame_queue makeEmpty\n");
}


bool frameQueue::
getFront( void* x) {
	//memcpy ( x, ( ((frameObject*) theArray) + front ), sizeof(frameObject) );
	memcpy ( x, (void*)( ((frameObject*) theArray) + front ), sizeof(frameObject) );
	
	return true;
}
	
	
bool frameQueue::
dequeue( void *x) {
	
	if ( isEmpty( ) ) {
		m_DEBUG ("[frameQueue::dequeue] Queue is isEmpty\n");
		return false;
	}

	currentSize--;
	
	m_DEBUG ("[frameQueue::dequeue] frameQueue size=%ld/%ld\n", currentSize, arraySize);
	
	getFront(x);
	
	increment( &front );
	
	return true;
}

bool frameQueue::
enqueue(void *x) {
		
	if (  isFull () ) {
		return false;
	}


	// m_DEBUG("start memcpy\n" );	
	
	//memcpy ( (frameObject*)theArray + end, (frameObject*)x, sizeof(frameObject) );
	memcpy ( (void *)((frameObject*)theArray + end), x, sizeof(frameObject) );

	
	increment (&end);
	currentSize++;

	//m_DEBUG("stop memcpy\n" );	
	return true;
}


void frameQueue::
increment(unsigned long *x) {

	*x = (*x + 1)  % arraySize;	
}


