
--------------------------------------------------------------------------------
-- 9600 CGI command
-- [
-- Open the buffer to start pre-alarm buffering
LUA_OpenBuffering(1, "")##


-- Trigger the buffer to start post-alarm buffering and output the recorded file
LUA_IoctlBuffering (1, '/data/buff_01.avi')##


-- Close and release the buffer 
LUA_CloseBuffering(1)##

--]
--------------------------------------------------------------------------------


-- Jim@2009_0310: Lua script reference for pre-alarm / post-alarm buffering
SHOWRATE			= 	0;
VIDEO_BUFFERING_FILE		=	{};
PRE_SECONDS			=	3;
POST_SECONDS			=	4;
MAX_PRE_BUFFER			=	400000;
MAX_POST_BUFFER			=	600000;


function LUA_OpenBuffering (index, filename)
	-- print("LUA_OpenBuffering start .. \n");

	if ( (filename == nil) or (string.len(filename) == 0) ) then
		print("Filename size = 0 \n");
		VIDEO_BUFFERING_FILE[index]	= 
			string.format("pre_frame_nums=%d,post_frame_nums=%d,max_pre_buf=%d,max_post_buf=%d,width=%d,height=%d,gop=%d,fps=%d",PRE_SECONDS*60, POST_SECONDS*60, MAX_PRE_BUFFER, MAX_POST_BUFFER, 720, 480, 32, 30 );
	else
		VIDEO_RECORD_FILE[index] = filename;
	end

	-- Jim@2009_0310
	ws:open(
			{	type	= "buffering", 
				file 	= VIDEO_BUFFERING_FILE[index], 								
				sid	= {VIDEO_STREAM_ID[index], AUDIO_STREAM_ID}				
			}

		);
	-- print("OpenBuffering done .. \n");
end 


function LUA_IoctlBuffering (index, filename) 
	print("IoctlBuffering start .. \n");
	ws:ioctl(
			{	type	= "buffering", 
				file 	= VIDEO_BUFFERING_FILE[index],
				cmd	= 3,
				args	= filename 								
			}
		);	
	print("IoctlBuffering done .. \n");
end


function LUA_CloseBuffering (index) 
	print("CloseBuffering start .. \n");
	ws:close(
			{	type	= "buffering", 
				file 	= VIDEO_BUFFERING_FILE[index], 								
			}
		);	
	print("CloseBuffering done .. \n");
end


