
#ifndef __BUFFERNG_H__
#define __BUFFERNG_H__



#ifdef __cplusplus
extern "C" {
#endif

#include <pthread.h>


#ifdef jim_using_msgQ
struct MSGDATA{
	char	ch;
	char	num;
	char	eventID;
	char	actionID;
};
struct MSGBUF {
	long    mtype;
	struct	MSGDATA	data;
};
struct MSG_STRUCT{
	struct MSGBUF	buf;
	int		key;
	int		id;
};

#define MSGDATA_SIZE sizeof( struct MSGDATA ) 
#define MSG_STRUCT_SIZE sizeof( struct MSG_STRUCT ) 

#endif

/// \defgroup wsbb_AVHandle AV Storage Handler
/// \{

////////////////////////////////////////////////////////////////////////////////
/// 
/// \page AVHandle AV Storage Handler
/// \latexonly
/// \chapter{AV Storage Handler}
/// \endlatexonly
///
/// The AVHandle is a buffering handler which works as a Queue, first in and first out.  And there are two kinds of buffers in the AVHandle.  They are pre-alarm buffer and post-alarm buffer.  With these buffers, the AVHandle is capable of storing the pre-alarm and post-alarm JPEG images.  According to the requirement, the  AVHandle works in three status, such as,
/// BUFFERING_STATE:  In this state, the AVHandle buffering the JPEG images in the pre-alarm buffer area cycling.
/// RECORDING_STATE:  In this state, the AVHandler stop buffering the JPEG images.  It starts to store the new coming JPEG images into the post-alarm buffer until the post-alarm buffer is full. Then, set the AVHandle status to JOBDONE_STATE.
/// JOBDONE_STATE:   In this sate, the AVHandle combines the pre-alarm buffer and post-alarm buffer JPEG images into one file in MJPEG format.



typedef enum  {
	BUFFERING_STATE,
	RECORDING_STATE,
	JOBDONE_STATE
} enStatus;

typedef enum {
	H4V_FILE,
	AVI_FILE,
	MP4_FILE
} enFILE_TYPE;

typedef void*	AVHandle;

typedef struct {
	int 			buffering_frames;
	int 			recording_frames;
	AVHandle		av[4];	// using double buffer for switch
	int			current_av_id;	
	char			output_filename[240];
	unsigned char	*tmp_packet_buffer;
	pthread_cond_t 	cond_dump;
	pthread_mutex_t	mutex_dump;
	pthread_t		dumpPid;	/// seems to be no used.
	int			dumping;
	int			stopDump;
	enFILE_TYPE	file_type;
	int			image_width;
	int			image_height;
	int			GOP_size;
	int			FPS;
} stBUFFER_CONTEXT;

/// \brief Create a AVHandle to store pre-alarm and post-alarm buffer.
/// \param buffering_frames The totoal frame numbers for cycling buffering the given images.
/// \param recording_frames The totoal frame numbers for buffering the given images with no overwite.
/// \param buffer_size The buffer size in bytes to store the buffering_frames and recording_frames.
/// \param output_filename The file name  to store the dumping frames of buffering_frames and recording_frames.
/// \return AVHandle Handle to the AVHandle.
stBUFFER_CONTEXT* buf_create_storage (int buffering_frames, int recording_frames, int buf_size, int rec_size, int width, int height, int gop, int fps)   ;
bool buf_appendPreAlarmPacket (unsigned char* packet, unsigned long length, stBUFFER_CONTEXT *handler);
bool buf_appendPostAlarmPacket (unsigned char* packet, unsigned long length, stBUFFER_CONTEXT *handler);
void buf_dumpToFile ( char *filename, stBUFFER_CONTEXT *handler);
//bool buf_toAviFile (int dump_id, stBUFFER_CONTEXT*handler);
void buf_restartBuffering ( stBUFFER_CONTEXT *handler);
void buf_release ( stBUFFER_CONTEXT *handler);


#ifdef __cplusplus
}
#endif


#endif
