
///#include <time.h>

#include <avBuffering.h>
#include <buffering_api.h>

#include <bcommon.h>


#ifdef __cplusplus
extern "C" {
#endif

#include <libavformat/avformat.h>
#include <libswscale/swscale.h>
#include <config.h>
#include <string.h>

#ifdef jim_using_msgQ
#include <event.h>
#include <sys/ipc.h>
#include <sys/msg.h>
#endif

#ifdef __cplusplus
}
#endif


extern "C" void init_av_register ()
{
	extern AVOutputFormat avi_muxer;
	extern URLProtocol	file_protocol;
	
	///avcodec_register
	//REGISTER_DECODER (H264, h264);

	/// (de)muxers registe
	/// REGISTER_MUXDEMUX (AVI, avi);
	if (CONFIG_AVI_MUXER == 1) 
		av_register_output_format(&avi_muxer); 


	/// protocols registe
	///  REGISTER_PROTOCOL (FILE, file);
	if ( CONFIG_FILE_PROTOCOL == 1 )
		av_register_protocol (&file_protocol);	
}


extern "C"  void close_video_stream (AVFormatContext *oc, AVStream *st)
{
	if (st->codec->codec) { /// Right now, I don't create any codec instance.
		avcodec_close(st->codec);
	}
#if 0
	av_free(picture->data[0]);
	av_free(picture);
	if (tmp_picture) {
		av_free(tmp_picture->data[0]);
		av_free(tmp_picture);
	}
	av_free(video_outbuf);
#endif

}


/* add a video output stream */
extern "C" AVStream *add_videoStream(AVFormatContext *oc, CodecID codec_id, stBUFFER_CONTEXT *h)
{
	AVCodecContext *c;
	AVStream *st;

	st = av_new_stream(oc, 0);
	if (!st) {
		m_ERROR ( "Could not alloc stream\n");
		return NULL;
	}
	
	avcodec_get_context_defaults (st->codec);


	c = st->codec;
	c->codec_id = codec_id;
	c->codec_type = CODEC_TYPE_VIDEO;

	/* put sample parameters */
	c->bit_rate = 1000000;
	/* resolution must be a multiple of two */
	c->width = h->image_width;
	c->height = h->image_height;
	/* time base: this is the fundamental unit of time (in seconds) in terms
	   of which frame timestamps are represented. for fixed-fps content,
	   timebase should be 1/framerate and timestamp increments should be
	   identically 1. */
	c->time_base.den = h->FPS; //STREAM_FRAME_RATE;  /* 25 images/s */
	c->time_base.num = 1;
	c->gop_size = h->GOP_size; /* emit one intra frame every twelve frames at most */
	
	c->codec_id = CODEC_ID_H264;

	c->max_b_frames = 0;
	c->has_b_frames = 0;
#if 0	
	c->pix_fmt = STREAM_PIX_FMT;
	if (c->codec_id == CODEC_ID_MPEG2VIDEO) {
		/* just for testing, we also add B frames */
		c->max_b_frames = 2;
	}
	if (c->codec_id == CODEC_ID_MPEG1VIDEO){
		/* Needed to avoid using macroblocks in which some coeffs overflow.
		This does not happen with normal video, it just happens here as
		the motion of the chroma plane does not match the luma plane. */
		c->mb_decision=2;
	}
#endif
	// some formats want stream headers to be separate
	if(oc->oformat->flags & AVFMT_GLOBALHEADER)
		c->flags |= CODEC_FLAG_GLOBAL_HEADER;

    return st;
}




extern "C" void ffmpeg_write_frame (unsigned char *pframe, int frameLen, AVFormatContext *oc, AVStream *video_stream)
{
    	AVCodecContext *c;
	AVPacket pkt;
	int	ret;

	c = video_stream->codec;
		
	av_init_packet(&pkt);


#if 0	/// I don't have coded_frame, so  I didn't create codec instance.
	m_DEBUG ("jimdebug: pts=%x, time_base=%d, base=%d\n", c->coded_frame->pts, c->time_base.num, video_stream->time_base.num);

	if (c->coded_frame->pts != AV_NOPTS_VALUE)
		pkt.pts= av_rescale_q(c->coded_frame->pts, c->time_base, video_stream->time_base);
	
	m_DEBUG ("ffmpeg_write_framen 4\n");	

	if(c->coded_frame->key_frame)
		pkt.flags |= PKT_FLAG_KEY;
#endif

	pkt.stream_index= video_stream->index;
	pkt.data= pframe;
	pkt.size= frameLen;
	
	/* write the compressed frame in the media file */
	
	ret = av_interleaved_write_frame(oc, &pkt);
	//ret = av_write_frame (oc, &pkt);

}


extern "C" bool init_ffmpeg (AVOutputFormat **avout_fmt, AVFormatContext **av_format_context,  AVStream **video_stream, stBUFFER_CONTEXT *h)
{
	int i;
	
	/* initialize libavcodec, and register all codecs and formats */
	init_av_register();

	
	*avout_fmt = guess_format ("avi", NULL, NULL);

	if (*avout_fmt == NULL)
	{
		m_ERROR ("jimdebug: guess_format fail\n");
		goto error_exit;
	}

	/* allocate the output media context */
	*av_format_context = avformat_alloc_context();
	if (! (*av_format_context)) {
		m_ERROR( "jimdebug: Memory error\n");
		goto error_exit;

	}

	(*av_format_context)->oformat = *avout_fmt;
	 /// snprintf(av_format_context->filename, sizeof(av_format_context->filename), "%s",output_filename);


#if 1
	/* add the audio and video streams using the default format codecs and initialize the codecs */
	if ((*avout_fmt)->video_codec != CODEC_ID_NONE)
		*video_stream = add_videoStream(*av_format_context, (*avout_fmt)->video_codec, h);
#endif

	/* set the output parameters (must be done even if no parameters). */
	if (av_set_parameters(*av_format_context, NULL) < 0) {
		m_ERROR ( "Invalid output format parameters\n");
		goto error_exit;

	}
	///dump_format(av_format_context, 0, output_filename, 1);
	

	return true;

error_exit:
	

	return false;
}

extern "C" void check_file_type (stBUFFER_CONTEXT *handler)
{
	char			*file_extenstion=NULL;
	
	file_extenstion = strrchr ( handler->output_filename, '.' );

	handler->file_type = H4V_FILE;
	
	if (file_extenstion) {
		if ( strncasecmp (file_extenstion, ".avi", 4) == 0 ) {
			handler->file_type = AVI_FILE;
		}
	}
}
	

extern "C" void release_ffmpeg (AVOutputFormat *avout_fmt, AVFormatContext *av_format_context, AVStream *video_stream)
{
	int i;
	
	if (video_stream)
		close_video_stream (av_format_context, video_stream);


	/* free the streams */
	for(i = 0; i < av_format_context->nb_streams; i++) {
		av_freep(&av_format_context->streams[i]->codec);
		av_freep(&av_format_context->streams[i]);
	}
	
	/* free the stream */
	av_free(av_format_context);

}


#ifdef jim_using_msgQ
extern "C" int MSG_init( const int key, struct MSG_STRUCT *msg){
	int id;

	if( msg == NULL ) msg = (struct MSG_STRUCT*) malloc( sizeof(struct MSG_STRUCT) );

	if (( id = msgget(key, IPC_CREAT | 0666)) < 0) {
		printf( "%s ID=%d\n", __FUNCTION__, id);
		return	EXIT_FAILURE;
	}
	msg->id		= id;
	msg->key	= key;
	return	EXIT_SUCCESS;
}

extern "C" int MSG_write( int ch, struct MSG_STRUCT *msg){
	msg->buf.mtype	= ch;
    
	if (msgsnd( msg->id, &msg->buf, MSGDATA_SIZE, IPC_NOWAIT) < 0) {
		printf( "%s) msgsnd id=%d size=%d\n", __FUNCTION__, msg->id, MSGDATA_SIZE);
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}

extern "C" void	file_ready_notify ()
{

	struct MSG_STRUCT *msg;

	msg = (struct MSG_STRUCT *) malloc (sizeof(struct MSG_STRUCT ));
	if (!msg)
		return;

	memset (msg, 0, sizeof(struct MSG_STRUCT));
	
	MSG_init( Q_CENTER_KEY, msg);

	MSG_write( QTYPE_ALERT_FILE_READY, msg );

}
#endif

extern "C"  bool to_AVI_File (int dump_id, stBUFFER_CONTEXT*handler)
{
#ifdef jim_test_dual_file
	FILE 					*fp;
	char					hv4filename[255];
#endif
	int 					foundSPS, i;
	avBuffering			*avBuf;
	bufferObject			buffer_Obj1;
	bufferObject			buffer_Obj2;
	frameObject 			frame_Obj;
	unsigned char			*packet_buffer;
	int					packet_length;
	char nalhdr[4] = {0x00, 0x00, 0x00, 0x01};

	/// ===============================================
	/// ffmpeg initialization
	
	AVOutputFormat 	*avout_fmt=NULL;
	AVFormatContext 	*av_format_context=NULL;
	AVStream 		*video_stream=NULL;


	if ( init_ffmpeg (&avout_fmt, &av_format_context, &video_stream,  handler) == false ) {
		m_ERROR ("init_ffmpeg failed\n");
		return false;
	}

	packet_buffer = handler->tmp_packet_buffer;
	
#ifdef jim_test_dual_file
	snprintf ( hv4filename, sizeof(hv4filename), "%s.h4v", handler->output_filename );
	fp = fopen (hv4filename, "wb");
#endif

	/// ===================================
	/// open file for file dump
	if (url_fopen (&av_format_context->pb, handler->output_filename, URL_WRONLY) < 0)
	{
		m_ERROR ("error: unable to open output file %s\n", handler->output_filename);
		return false;
	}
	/// write the stream header, if any 
	av_write_header(av_format_context);
	

	/// ===================================
	/// main loop for frame write 
	buffer_Obj1.packet = NULL;
	foundSPS = 0;
	for (  i=dump_id; i <= (dump_id+1); i++) 
	{
		avBuf = (avBuffering*) ( handler->av[i] ) ;
		while ( avBuf->dequeueDataPtr (&frame_Obj, &buffer_Obj1, &buffer_Obj2 ) )
		{
			///printf  ("jimdebug: dequeue NAL size = %d, type=%d\n", buffer_Obj1.packet_size, *(buffer_Obj1.packet) & 0x1f);
			if ( (*(buffer_Obj1.packet) & 0x1f) == 7) {
				///printf ("\njimdebug: found SPS\n");
				foundSPS = 1;
			}
			
			if ( (*(buffer_Obj1.packet) & 0x1f) == 6 ) 
				continue;
			
			if (foundSPS) 
			{
#ifdef jim_test_dual_file
				
				fwrite( nalhdr, sizeof(unsigned char), 4, fp);
				fwrite (buffer_Obj1.packet, sizeof(unsigned char), buffer_Obj1.packet_size, fp );
				if (buffer_Obj2.packet_size > 0 ) {
					fwrite (buffer_Obj2.packet, sizeof(unsigned char), buffer_Obj2.packet_size, fp );
				}
				fflush (fp);
#endif

				memcpy (packet_buffer, nalhdr, 4);
				packet_length = 4;
				memcpy (packet_buffer+packet_length, buffer_Obj1.packet, buffer_Obj1.packet_size);
				packet_length += buffer_Obj1.packet_size;
				if (buffer_Obj2.packet_size > 0 ) {
					memcpy (packet_buffer + packet_length , buffer_Obj2.packet , buffer_Obj2.packet_size);
					packet_length += buffer_Obj2.packet_size;
				}
				ffmpeg_write_frame (packet_buffer, packet_length, av_format_context, video_stream);
				
				/// It's hard to reduce copy
				///ffmpeg_write_frame (buffer_Obj1.packet, buffer_Obj1.packet_size, av_format_context, video_stream);
				
			}
		
		}
	}

	av_write_trailer(av_format_context);

	if (!(avout_fmt->flags & AVFMT_NOFILE)) {
		/* close the output file */
		url_fclose(av_format_context->pb);
	}

#ifdef jim_using_msgQ
	file_ready_notify ();
#endif	

#ifdef jim_test_dual_file
	fclose(fp);
#endif
	

	release_ffmpeg (avout_fmt, av_format_context, video_stream);

	m_MSG ( "\noutput file=%s ok\n", handler->output_filename);	

	return true;
}

extern "C"  bool to_H4V_File (int dump_id, stBUFFER_CONTEXT*handler)
{
	FILE 					*fp;
	int 					foundSPS, i;
	avBuffering			*avBuf;
	bufferObject			buffer_Obj1;
	bufferObject			buffer_Obj2;
	frameObject 			frame_Obj;
	///unsigned char			*packet_buffer;
	char nalhdr[4] = {0x00, 0x00, 0x00, 0x01};


	
	buffer_Obj1.packet = NULL;

	fp = fopen (handler->output_filename, "wb");

	if ( fp == NULL)
		return false;

	foundSPS = 0;
 
	for (  i=dump_id; i <= (dump_id+1); i++) 
	{
		avBuf = (avBuffering*) ( handler->av[i] ) ;
		while ( avBuf->dequeueDataPtr (&frame_Obj, &buffer_Obj1, &buffer_Obj2 ) )
		{
			if ( (*(buffer_Obj1.packet) & 0x1f) == 7) {
				///printf ("\njimdebug: found SPS\n");
				foundSPS = 1;
			}
			if (foundSPS) {
				fwrite( nalhdr, sizeof(unsigned char), 4, fp);
				fwrite (buffer_Obj1.packet, sizeof(unsigned char), buffer_Obj1.packet_size, fp );
				if (buffer_Obj2.packet_size > 0 ) {
					fwrite (buffer_Obj2.packet, sizeof(unsigned char), buffer_Obj2.packet_size, fp );
				}
				fflush (fp);
			}
		}
	}

	fclose(fp);

#ifdef jim_using_msgQ
	file_ready_notify ();
#endif

	m_MSG ( "\nclose file=%s\n", handler->output_filename);

	return true;
}


extern "C"  void buf_release (stBUFFER_CONTEXT*handler)
{

	handler->stopDump = 1;
	pthread_cond_signal (&(handler->cond_dump));

}

extern "C" void buf_dump_loop ( void* param) 
{
	stBUFFER_CONTEXT *handler = (stBUFFER_CONTEXT*) param;
	avBuffering	*avBuf=NULL;	
	unsigned char 	*tmp=NULL;
	int			dump_id, i;


	

	/// ===============================================
	/// main loop
	pthread_cond_init (&(handler->cond_dump), NULL);
	pthread_mutex_init (&(handler->mutex_dump), NULL);
	
	handler->stopDump = 0;
	handler->dumping = 0;

	
	while ( handler->stopDump == 0 ) 
	{
		
		pthread_cond_wait ( &(handler->cond_dump), &(handler->mutex_dump) );

		if (handler->stopDump == 0) 
		{
			handler->dumping = 1;
			
			dump_id = (handler->current_av_id +2 ) % 4;

			check_file_type (handler);
			if (handler->file_type == AVI_FILE) 
			{
			
				//m_MSG ("0. video_stream=%d, video_codec=%d\n", video_stream,  (avout_fmt)->video_codec);
				to_AVI_File (dump_id, handler);
				//m_MSG ("4. video_stream=%d, video_codec=%d\n", video_stream,  (avout_fmt)->video_codec);
			} 
			else if (handler->file_type == H4V_FILE) 
			{	
#if 1
				to_H4V_File (dump_id, handler);
#else
				tmp = (unsigned char*) malloc (100000);
				if (!tmp)
					return;
				avBuf = (avBuffering*) handler->av[dump_id];
				avBuf->toFileWithNALHeader (handler->output_filename, FILE_TRUNCATE, tmp, 1);
				avBuf = (avBuffering*) handler->av[dump_id+1];
				avBuf->toFileWithNALHeader (handler->output_filename, FILE_APPEND, tmp, 0);
				if (tmp)
					free (tmp);
#endif
			} 
			
			handler->dumping = 0;
		}

	}



	for (i =0; i < 4; i++)
	{
		avBuf = (avBuffering*) (handler->av[i]);
		if (avBuf)
			delete avBuf;
	}
	
	if (handler->tmp_packet_buffer)
		free (handler->tmp_packet_buffer);
	
	free (handler);	
	
	m_MSG ("jimdebug: buf_dump_loop() exit \n");
	
}


extern "C" stBUFFER_CONTEXT* buf_create_storage (int buffering_frames, int recording_frames, int buf_size, int rec_size,
		int width, int height, int gop, int fps) 
{
	stBUFFER_CONTEXT *h = (stBUFFER_CONTEXT *) malloc (sizeof(stBUFFER_CONTEXT));
	avBuffering	*tmp0=NULL;
	int			i;
	
	if (!h)
		return NULL;


	for (i=0; i < 4; i++ ) {
		if ( (i % 2) == 0)
			tmp0 =  new  avBuffering (  buffering_frames  ,  buf_size, OVERWRITE ) ;
		else
			tmp0 =  new  avBuffering (  recording_frames  ,  rec_size, NOT_OVERWRITE ) ;

		if (!tmp0) 
			goto error_exit;
		else
			h->av[i] = tmp0;
	}
	
	h->tmp_packet_buffer = (unsigned char*) malloc (128*1024);
	if (h->tmp_packet_buffer == NULL) {
		m_ERROR ("jimdebug: No free space for h->tmp_packet_buffer\n"); 
		goto error_exit;
	}

	h->buffering_frames = buffering_frames;
	h->recording_frames = recording_frames;
	h->current_av_id = 0;
	h->dumpPid = 0;
	h->image_width = width;
	h->image_height = height;
	h->GOP_size = gop;
	h->FPS = fps;
	///h->file_type = AVI_FILE;	/// jimdebug: according to the filename extension
			

	if (pthread_create(&(h->dumpPid), NULL, (void * (*)(void *)) buf_dump_loop , h) !=0) {
		printf ("Failed to create dump_loop\n");
	}

	return h;
	
error_exit:	
	
	for (i=0; i < 4; i++ ) {
		if (h->av[i] )
			delete ( (avBuffering*) (h->av[i]) );
	}

	if (h->tmp_packet_buffer)
		free (h->tmp_packet_buffer);

	if (h)
		free (h);

	return NULL;
}


extern "C" bool buf_appendPreAlarmPacket (unsigned char* packet, unsigned long length, stBUFFER_CONTEXT *handler)
{
	avBuffering	*avBuf = (avBuffering*) (handler->av[handler->current_av_id]);
	
	return avBuf->enqueueData  (packet,  length, VIDEO_PACKET_TYPE);
	//return avBuf->enqueueDataWithLimit ( packet, length, VIDEO_PACKET_TYPE , handler->buffering_frames );
}

extern "C" bool buf_appendPostAlarmPacket (unsigned char* packet, unsigned long length, stBUFFER_CONTEXT *handler)
{
	avBuffering	*avBuf = (avBuffering*) handler->av[handler->current_av_id+1];
		
	return avBuf->enqueueData  (packet,  length, VIDEO_PACKET_TYPE);
}




extern "C" void buf_dumpToFile ( char *filename, stBUFFER_CONTEXT *handler)
{
	avBuffering		*avBuf = (avBuffering*) handler->av[handler->current_av_id];

	strncpy (handler->output_filename, filename, sizeof(handler->output_filename));	

	handler->current_av_id = (handler->current_av_id +2 ) % 4;

	
	pthread_cond_signal (&(handler->cond_dump));


	return ;

}


extern "C" void buf_restartBuffering ( stBUFFER_CONTEXT *handler)
{
	avBuffering	*avBuf1 = (avBuffering*) handler->av[handler->current_av_id];
	avBuffering	*avBuf2 = (avBuffering*) handler->av[handler->current_av_id+1];
	
	avBuf1->restart ();
	avBuf2->restart ();

}



