#ifndef __AVSTORAGE_H__
#define __AVSTORAGE_H__

#include "avBuffering.h"

typedef enum StorageStatus {
	BUFFERING,
	RECORDING,
	JOBDONE
} enStorageStatus;

class avStorage  {
	public:
		avStorage (int buffering_time, int recording_time, int fps, int avg_bitrate, // in kbs
			int audio_bitrate, char *buffering_filename1, char *buffering_filename2, //in sec
			char *output_filename);
		avStorage (int buffering_frames, int recording_frames, int bufferSize_for_eachFrame,  char *output_filename);
		avStorage (int buffering_frames, int recording_frames, int buffering_size,  int recording_size, char *output_filename);
		~avStorage ();
		enStorageStatus getStatus ();
		void setStatus (enStorageStatus st );
		void	stopBuffering ();
		bool isJobDone ();
		bool	appendPacket (unsigned char* packet, unsigned long length);
		bool appendPacket2 (unsigned char* packet, unsigned long length) ;
		void setOutputFilename ( char *filename);
		void restart ( char *filename);
		
	private:
		void outputPackets (unsigned char* packet);
		void outputPacketsWithNALHeader (unsigned char* packet);
		enStorageStatus	fstatus;
		char 			foutput_filename[256];
		avBuffering		*favTmp1, *favTmp2;
		int 			fBuffering_frames;
		int			fRecording_frames;
	
		
};

#endif

