#ifndef __AVBUFFERING_H__
#define __AVBUFFERING_H__

#include "filebufferQueue.h"
#include "bufferQueue.h"
#include "frameQueue.h"

typedef enum BUFFERING_TYPE {
	NOT_OVERWRITE,
	OVERWRITE
} enBUFFERING_TYPE;

typedef enum FILE_OPEN_TYPE {
	FILE_TRUNCATE,
	FILE_APPEND
} enFILE_OPEN_TYPE;


/*
typedef enum STORAGE_TYPE {
	MEMORY_STORAGE,
	FILE_STORAGE
} enSTORAGE_TYPE;
*/


class avBuffering  {
	public :
		avBuffering (int sec, int fps, int avg_bitrate, enBUFFERING_TYPE btype, char *buffer_filename);
		avBuffering (int sec, int fps, int avg_bitrate, enBUFFERING_TYPE btype );
		avBuffering ( int frame_num, int storage_size, enBUFFERING_TYPE btype );
		~avBuffering ();
		bool toFile (char *filename, enFILE_OPEN_TYPE file_out_type, unsigned char *packet_buffer);
		bool toFileWithNALHeader (char *filename, enFILE_OPEN_TYPE file_out_type, unsigned char *packet_buffer, int needIstart);
		bool dequeueData ( frameObject *frame_Obj, bufferObject *buffer_Obj ) ;
		bool dequeueDataPtr ( frameObject *frame_Obj, bufferObject *buffer_Obj1, bufferObject *buffer_Obj2 ) ;
		bool enqueueData ( unsigned char* packet, unsigned long length);
		bool enqueueData ( unsigned char* packet, unsigned long length, enPACKET_TYPE packet_type);

		void restart (void);
			
	private:
		void	initBuffer ( int sec, int fps, int avg_bitrate, enBUFFERING_TYPE btype, char *buffer_filename );
		void initBuffer ( int num, int size, enBUFFERING_TYPE btype, char *buffer_filename );
		
		unsigned long			storage_size;
		unsigned long			frame_num;
		enBUFFERING_TYPE	buffering_type;
		frameObject 			frame_Obj;
		bufferObject 			buffer_Obj;
		
		frameQueue			*frame_queue;
		QueueAr				*data_queue;
	
};


#endif


