.SS CLASSIFY
This module allows you to set the skb\->priority value (and thus classify the packet into a specific CBQ class).
.TP
\fB\-\-set\-class\fP \fImajor\fP\fB:\fP\fIminor\fP
Set the major and minor class value. The values are always interpreted as
hexadecimal even if no 0x prefix is given.
.SS CONNMARK
This module sets the netfilter mark value associated with a connection.
.TP
\fB\-\-set\-xmark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zero out the bits given by \fImask\fR and XOR \fIvalue\fR into the ctmark.
.TP
\fB\-\-save\-mark\fP [\fB\-\-nfmask\fP \fInfmask\fP] [\fB\-\-ctmask\fP \fIctmask\fP]
Copy the packet mark (nfmark) to the connection mark (ctmark) using the given
masks. The new nfmark value is determined as follows:
.IP
ctmark = (ctmark & ~ctmask) ^ (nfmark & nfmask)
.IP
i.e. \fIctmask\fR defines what bits to clear and \fInfmask\fR what bits of the
nfmark to XOR into the ctmark. \fIctmask\fR and \fInfmask\fR default to
0xFFFFFFFF.
.TP
\fB\-\-restore\-mark\fP [\fB\-\-nfmask\fP \fInfmask\fP] [\fB\-\-ctmask\fP \fIctmask\fP]
Copy the connection mark (ctmark) to the packet mark (nfmark) using the given
masks. The new ctmark value is determined as follows:
.IP
nfmark = (nfmark & ~\fInfmask\fR) ^ (ctmark & \fIctmask\fR);
.IP
i.e. \fInfmask\fR defines what bits to clear and \fIctmask\fR what bits of the
ctmark to XOR into the nfmark. \fIctmask\fR and \fInfmask\fR default to
0xFFFFFFFF.
.IP
\fB\-\-restore\-mark\fP is only valid in the \fBmangle\fP table.
.PP
The following mnemonics are available for \fB\-\-set\-xmark\fP:
.TP
\fB\-\-and\-mark\fP \fIbits\fP
Binary AND the ctmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark
0/\fR\fIinvbits\fR, where \fIinvbits\fR is the binary negation of \fIbits\fR.)
.TP
\fB\-\-or\-mark\fP \fIbits\fP
Binary OR the ctmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fR\fB/\fR\fIbits\fR.)
.TP
\fB\-\-xor\-mark\fP \fIbits\fP
Binary XOR the ctmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fR\fB/0\fR.)
.TP
\fB\-\-set\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Set the connection mark. If a mask is specified then only those bits set in the
mask are modified.
.TP
\fB\-\-save\-mark\fP [\fB\-\-mask\fP \fImask\fP]
Copy the nfmark to the ctmark. If a mask is specified, only those bits are
copied.
.TP
\fB\-\-restore\-mark\fP [\fB\-\-mask\fP \fImask\fP]
Copy the ctmark to the nfmark. If a mask is specified, only those bits are
copied. This is only valid in the \fBmangle\fR table.
.SS CONNSECMARK
This module copies security markings from packets to connections
(if unlabeled), and from connections back to packets (also only
if unlabeled).  Typically used in conjunction with SECMARK, it is
only valid in the
.B mangle
table.
.TP
\fB\-\-save\fP
If the packet has a security marking, copy it to the connection
if the connection is not marked.
.TP
\fB\-\-restore\fP
If the packet does not have a security marking, and the connection
does, copy the security marking from the connection to the packet.

.SS DSCP
This target allows to alter the value of the DSCP bits within the TOS
header of the IPv4 packet.  As this manipulates a packet, it can only
be used in the mangle table.
.TP
\fB\-\-set\-dscp\fP \fIvalue\fP
Set the DSCP field to a numerical value (can be decimal or hex)
.TP
\fB\-\-set\-dscp\-class\fP \fIclass\fP
Set the DSCP field to a DiffServ class.
.SS MARK
This target is used to set the Netfilter mark value associated with the packet.
The target can only be used in the \fBmangle\fR table. It can, for example, be
used in conjunction with routing based on fwmark (needs iproute2).
.TP
\fB\-\-set\-xmark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fR and XORs \fIvalue\fR into the packet
mark ("nfmark"). If \fImask\fR is omitted, 0xFFFFFFFF is assumed.
.TP
\fB\-\-set\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fR and ORs \fIvalue\fR into the packet
mark. If \fImask\fR is omitted, 0xFFFFFFFF is assumed.
.PP
The following mnemonics are available:
.TP
\fB\-\-and\-mark\fP \fIbits\fP
Binary AND the nfmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark
0/\fR\fIinvbits\fR, where \fIinvbits\fR is the binary negation of \fIbits\fR.)
.TP
\fB\-\-or\-mark\fP \fIbits\fP
Binary OR the nfmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fR\fB/\fR\fIbits\fR.)
.TP
\fB\-\-xor\-mark\fP \fIbits\fP
Binary XOR the nfmark with \fIbits\fR. (Mnemonic for \fB\-\-set\-xmark\fP
\fIbits\fR\fB/0\fR.)
.SS NFLOG
This target provides logging of matching packets. When this target is
set for a rule, the Linux kernel will pass the packet to the loaded
logging backend to log the packet. This is usually used in combination
with nfnetlink_log as logging backend, which will multicast the packet
through a
.IR netlink
socket to the specified multicast group. One or more userspace processes
may subscribe to the group to receive the packets. Like LOG, this is a
non-terminating target, i.e. rule traversal continues at the next rule.
.TP
\fB\-\-nflog\-group\fP \fInlgroup\fP
The netlink group (1 - 2^32\-1) to which packets are (only applicable for
nfnetlink_log). The default value is 0.
.TP
\fB\-\-nflog\-prefix\fP \fIprefix\fP
A prefix string to include in the log message, up to 64 characters
long, useful for distinguishing messages in the logs.
.TP
\fB\-\-nflog\-range\fP \fIsize\fP
The number of bytes to be copied to userspace (only applicable for
nfnetlink_log). nfnetlink_log instances may specify their own
range, this option overrides it.
.TP
\fB\-\-nflog\-threshold\fP \fIsize\fP
Number of packets to queue inside the kernel before sending them
to userspace (only applicable for nfnetlink_log). Higher values
result in less overhead per packet, but increase delay until the
packets reach userspace. The default value is 1.
.BR
.SS NFQUEUE
This target is an extension of the QUEUE target. As opposed to QUEUE, it allows
you to put a packet into any specific queue, identified by its 16-bit queue
number.  
.TP
\fB\-\-queue\-num\fP \fIvalue\fP
This specifies the QUEUE number to use. Valid queue numbers are 0 to 65535. The default value is 0.
.PP
It can only be used with Kernel versions 2.6.14 or later, since it requires
the
.B
nfnetlink_queue
kernel support.
.SS NOTRACK
This target disables connection tracking for all packets matching that rule.
.PP
It can only be used in the
.B raw
table.
.SS RATEEST
The RATEEST target collects statistics, performs rate estimation calculation
and saves the results for later evaluation using the \fBrateest\fP match.
.TP
\fB\-\-rateest\-name\fP \fIname\fP
Count matched packets into the pool referred to by \fIname\fP, which is freely
choosable.
.TP
\fB\-\-rateest\-interval\fP \fIamount\fP{\fBs\fP|\fBms\fP|\fBus\fP}
Rate measurement interval, in seconds, milliseconds or microseconds.
.TP
\fB\-\-rateest\-ewmalog\fP \fIvalue\fP
Rate measurement averaging time constant.
.SS SECMARK
This is used to set the security mark value associated with the
packet for use by security subsystems such as SELinux.  It is only
valid in the
.B mangle
table.
.TP
\fB\-\-selctx\fP \fIsecurity_context\fP
.SS TCPMSS
This target allows to alter the MSS value of TCP SYN packets, to control
the maximum size for that connection (usually limiting it to your
outgoing interface's MTU minus 40 for IPv4 or 60 for IPv6, respectively).
Of course, it can only be used
in conjunction with
\fB\-p tcp\fP.
It is only valid in the
.BR mangle
table.
.br
This target is used to overcome criminally braindead ISPs or servers
which block "ICMP Fragmentation Needed" or "ICMPv6 Packet Too Big"
packets.  The symptoms of this
problem are that everything works fine from your Linux
firewall/router, but machines behind it can never exchange large
packets:
.PD 0
.RS 0.1i
.TP 0.3i
1)
Web browsers connect, then hang with no data received.
.TP
2)
Small mail works fine, but large emails hang.
.TP
3)
ssh works fine, but scp hangs after initial handshaking.
.RE
.PD
Workaround: activate this option and add a rule to your firewall
configuration like:
.nf
 iptables \-t mangle \-A FORWARD \-p tcp \-\-tcp\-flags SYN,RST SYN \\
             \-j TCPMSS \-\-clamp\-mss\-to\-pmtu
.fi
.TP
\fB\-\-set\-mss\fP \fIvalue\fP
Explicitly set MSS option to specified value.
.TP
\fB\-\-clamp\-mss\-to\-pmtu\fP
Automatically clamp MSS value to (path_MTU \- 40 for IPv4; \-60 for IPv6).
.PP
These options are mutually exclusive.
.SS TCPOPTSTRIP
This target will strip TCP options off a TCP packet. (It will actually replace
them by NO-OPs.) As such, you will need to add the \fB\-p tcp\fP parameters.
.TP
\fB\-\-strip\-options\fP \fIoption\fP[\fB,\fP\fIoption\fP...]
Strip the given option(s). The options may be specified by TCP option number or
by symbolic name. The list of recognized options can be obtained by calling
iptables with \fB\-j TCPOPTSTRIP \-h\fP.
.SS TOS
This module sets the Type of Service field in the IPv4 header (including the
'precedence' bits) or the Priority field in the IPv6 header. Note that TOS
shares the same bits as DSCP and ECN. The TOS target is only valid in the
\fBmangle\fR table.
.TP
\fB\-\-set\-tos\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Zeroes out the bits given by \fImask\fR and XORs \fIvalue\fR into the
TOS/Priority field. If \fImask\fR is omitted, 0xFF is assumed.
.TP
\fB\-\-set\-tos\fP \fIsymbol\fP
You can specify a symbolic name when using the TOS target for IPv4. It implies
a mask of 0xFF. The list of recognized TOS names can be obtained by calling
iptables with \fB\-j TOS \-h\fP.
.PP
The following mnemonics are available:
.TP
\fB\-\-and\-tos\fP \fIbits\fP
Binary AND the TOS value with \fIbits\fR. (Mnemonic for \fB\-\-set\-tos
0/\fR\fIinvbits\fR, where \fIinvbits\fR is the binary negation of \fIbits\fR.)
.TP
\fB\-\-or\-tos\fP \fIbits\fP
Binary OR the TOS value with \fIbits\fR. (Mnemonic for \fB\-\-set\-tos\fP
\fIbits\fR\fB/\fR\fIbits\fR.)
.TP
\fB\-\-xor\-tos\fP \fIbits\fP
Binary XOR the TOS value with \fIbits\fR. (Mnemonic for \fB\-\-set\-tos\fP
\fIbits\fR\fB/0\fR.)
.SS TPROXY
This target is only valid in the \fBmangle\fR table, in the \fBPREROUTING\fR
chain and user-defined chains which are only called from this chain. It
redirects the packet to a local socket without changing the packet header in
any way. It can also change the mark value which can then be used in advanced
routing rules.
It takes three options:
.TP
\fB\-\-on\-port\fP \fIport\fP
This specifies a destination port to use. It is a required option, 0 means the
new destination port is the same as the original. This is only valid if the
rule also specifies \fB\-p tcp\fP or \fB\-p udp\fP.
.TP
\fB\-\-on\-ip\fP \fIaddress\fP
This specifies a destination address to use. By default the address is the IP
address of the incoming interface. This is only valid if the rule also
specifies \fB\-p tcp\fP or \fP\-p udp\fP.
.TP
\fB\-\-tproxy\-mark\fP \fIvalue\fP[\fB/\fP\fImask\fP]
Marks packets with the given value/mask. The fwmark value set here can be used
by advanced routing. (Required for transparent proxying to work: otherwise
these packets will get forwarded, which is probably not what you want.)
.SS TRACE
This target marks packes so that the kernel will log every rule which match 
the packets as those traverse the tables, chains, rules. (The ipt_LOG or
ip6t_LOG module 
is required for the logging.) The packets are logged with the string prefix: 
"TRACE: tablename:chainname:type:rulenum " where type can be "rule" for 
plain rule, "return" for implicit rule at the end of a user defined chain 
and "policy" for the policy of the built in chains. 
.br
It can only be used in the
.BR raw
table.
