/*  nonroot.c: Various database functions for rights and users
    Copyright (C) 1999-2000 Steinar H. Gunderson

    This program is is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2 if the
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

/*
 * make autoconf changeable!!!
 */
#define USERS_FILE "/home/betaftpd/betaftpd.users"
#define GROUP_FILE "/home/betaftpd/betaftpd.groups"

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if WANT_NONROOT

#if HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#if HAVE_STDIO_H
#include <stdio.h>
#endif

#if HAVE_STRING_H
#include <string.h>
#endif

#if HAVE_STRINGS_H
#include <strings.h>
#endif

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

#if HAVE_STDLIB_H
#include <stdlib.h>
#endif

#if HAVE_CRYPT_H
#include <crypt.h>
#endif

#include <nonroot.h>

struct users {
	char username[24];
	char password[14];
	char homedir[128];
	uid_t uid;
	gid_t gid;
};

/* we will add cacheing of both users and rights LATER :-) */

int nr_userinfo(const char * const username, int * const uid,
	        char * const homedir, char * const rootdir,
		const char * const password) 
{
	FILE *users_file = fopen(USERS_FILE, "r");
	char this_username[256];
	char real_password[256];

	if (users_file == NULL) return 0; /* panic, reject all users */

	/* 
	 * ignores gids atm, we may want to change that in the future
	 */
	while (!feof(users_file)) {
		fscanf(users_file, "%d %s %s %s %s %*[^\n]\n", 
			uid, this_username, real_password, homedir, rootdir);
		if (strcmp(this_username, username) != 0) continue;

		fclose(users_file);

		printf("pw = %s\n", real_password);
		printf("uid = %u\n", *uid);
		printf("hdir = %s\n", homedir);
		printf("rdir = %s\nEND\n", rootdir);

		if (strcmp(real_password, crypt(password, real_password)) == 0) {
			return 3;
		} else {
			return 0;
		}
	}
	
	fclose(users_file);
	return 0;		/* no such user */
}

/*
 * Thank goodness for the Unix inventors, who invented all those nice flags! :-)
 * Reduces my code size a lot :-)
 */
int nr_check_permission(const uid_t uid, const char * const object,
	                const int perm, const int is_dir,
			char * const ret_rights)
{
	char temp[256];

	if (is_dir) {
		snprintf(temp, 256, "%s/.rights", object);


		return nr_intperm(uid, temp, ".", perm, ret_rights);
	} else {
		char *ptr;

		snprintf(temp, 256, "%s", object);	/* non-overflow */

		ptr = strrchr(temp, '/');
		if (ptr == NULL) {
			return nr_intperm(uid, "./.rights", temp, perm, ret_rights);
		} else {
			char temp2[256];
			ptr[0] = 0;

			snprintf(temp2, 256, "%s/.rights", temp);
			return nr_intperm(uid, temp2, ptr + 1, perm, ret_rights);
		}
	}
}

int nr_intperm(const uid_t uid, const char * const rightfile,
		const char * const entry, const int perm,
		char * const ret_rights)
{
	FILE *rights = fopen(rightfile, "r");
	char default_rights[] = "---------";
	char this_entry[256], these_rights[16], check_rights[16], *ptr;
	int rights_assigned = 0;
	uid_t this_uid, check_uid;
	gid_t this_gid, check_gid;


	numeric(c, 555, "Permission denied 3");

	printf("Checking permission %u for uid %d, file `%s', entry `%s'\n",
	        perm, uid, rightfile, entry);

	{
		char buf[256];
		getcwd(buf, 256);
		printf("cwd is `%s'\n", buf);
	}

	if (rights == NULL) perror(rightfile);

	if (ret_rights != NULL) strcpy(ret_rights, default_rights);
	if (rights == NULL) return -1;	/* no rights file -- no permission */

	while (!feof(rights)) {
		fscanf(rights, "%s %s %d %d\n", this_entry, these_rights,
			&this_uid, &this_gid);

		if (strcmp(this_entry, entry) == 0) rights_assigned = 1;
		if (strcmp(this_entry, ".default") == 0) rights_assigned = 2;

		if (rights_assigned != 0) {
			if (ret_rights != NULL) strcpy(ret_rights, these_rights);

                        strcpy(check_rights, these_rights);
                        check_uid = this_uid;
                        check_gid = this_gid;

			/* if we found a `real' (non-default) match, break right away */
			if (rights_assigned == 1) break;
		}
	}

	if (rights_assigned == 0) {
		puts("no entry! denying...\n");
		return -1;	/* no entry, no access */
	}

	/* if we're only looking for at entry, return OK now */
	if (perm == 0) {
		puts("Only peeking; OK\n");
		return 0;
	}

	/* now on to the actual checking... */
	ptr = check_rights;
	if (perm != 4) ptr++;		/* check the right bits */
	if (perm == 1) ptr++;

	printf("Actual rights are `%s', filtered: `%s'\n", check_rights, ptr);

	if (ptr[6] != '-') return 0;			  /* all users */
	if (uid == check_uid && ptr[0] != '-') return 0;  /* user owner */
	if (member_of_group(uid, check_gid) && ptr[3] != '-') return 0;
							  /* member of group */

	return -1;		/* no access */
}

int member_of_group(const uid_t uid, const gid_t gid)
{
	printf("For now, `%s' is not member of `%s'\n", 
		nr_get_uname(uid), nr_get_gname(gid));
	return 0;
}

char username[256], groupname[256];	/* static buffer to return */

char *nr_get_uname(const uid_t uid)
{
	FILE *users = fopen(USERS_FILE, "r");
	uid_t uid_this;

	if (users == NULL) return "error";	/* panic */

	while (!feof(users)) {
		if (fscanf(users, "%d %s %*[^\n]\n", &uid_this, username) < 2) continue;
		if (uid_this == uid) return username;
	}
	snprintf(username, 256, "%d", uid);
	return username;
}

char *nr_get_gname(const uid_t gid)
{
	FILE *group = fopen(GROUP_FILE, "r");
	gid_t gid_this;

	if (group == NULL) return "error";	/* panic */

	while (!feof(group)) {
		if (fscanf(group, "%d %s\n", &gid_this, groupname) < 2) continue;
		if (gid_this == gid) return groupname;
	}
	snprintf(groupname, 256, "%d", gid);
	return groupname;
}

#endif /* !WANT_NONROOT */
