/*  ascii.c: BetaFTPD ascii filters, written by Beau Kuiper
    Copyright (C) 1999-2000 Steinar H. Gunderson

    This program is is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License, version 2 if the
    License as published by the Free Software Foundation.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif

#if WANT_ASCII

/*
 * ascii_findlength():
 *		Figures out how much read data was transferred if
 *		a full buffer wasn't sent.
 */
int ascii_findlength(const char * const buffer, const int tranlen)
{
	int count = 0, pos = 0;
		
	while (pos < tranlen) {
		const char ch = buffer[count++];
		if (ch != 13) {
			if (ch == 10) pos++;
			pos++;
		}
	}
	return count;
}

/*
 * ascii_downloadfilter():
 *		Changes LF to CR/LF on the fly (from buffer to
 *		outbuffer), for ASCII downloads.
 */
int ascii_downloadfilter(const char * const buffer, char * const outbuffer, const int length)
{
	int count;
	char *b2ptr = outbuffer;
		
	for (count = 0; count < length; count++) {
		const char ch = buffer[count];

		if (ch != 13) {
			if (ch == 10) {
				*b2ptr++ = 13;
			}
			*b2ptr++ = ch;
		}
	}
	return (b2ptr - outbuffer);
}

/*
 * ascii_uploadfilter():
 *		Removes all CRs (ASCII 13) from buffer on the fly,
 *		for ASCII uploads.
 */
int ascii_uploadfilter(char * const buffer, const int length)
{
	int count;
	char *b2ptr = buffer;
		
	for (count = 0; count < length; count++) {
		const char ch = buffer[count];
		if (ch != 13) {
			*b2ptr++ = ch;
		}
	}
	return (b2ptr - buffer);
}

#endif /* WANT_ASCII */
