#ifndef __KAUD_H__
#define __KAUD_H__
/*=======================================================================================================*/
#define ANTIAUDIO_FIFO_NAME		"/tmp/antipush_audio"
//#define AUDIO_SRC_FROM_FILE
#define AUDIO_FILE_NAME			"/data/hold.dat"
#define GBUFFER_IDX_MAX			8
#define GBUFFER_UNIT_SIZE		1024
#define ELAN_ALLOC_PAGE

#define SND_THREAD_TIMEOUT		HZ*2
#define SND_THREAD_E_THRESHOLD		(2)
#define RCV_THREAD_F_THRESHOLD		(6)

#define CFG_PROC_ENTRY          	"kaud"
#define CFG_PROC_GBUF			"gbuf"
#define CFG_PROC_KTHD			"sndrcv"
/*-------------------------------------------------------------------------------------------------------*/
#define DBG_FLAG_INIT			1
#define DBG_FLAG_SNDTHREAD		0
#define DBG_FLAG_RCVTHREAD		0

#define __DBG_0(...)
#define __DBG_1(...)			printk(__VA_ARGS__)
#define __DBG(N,...)			__DBG_##N(__VA_ARGS__)
#define _DBG(N,...)			__DBG(N,__VA_ARGS__)
#define DBG(N,FMT,...)			_DBG(DBG_FLAG_##N,#N ":%s:%d: " FMT, __FUNCTION__, __LINE__, ##__VA_ARGS__)
/*-------------------------------------------------------------------------------------------------------*/
typedef enum {
	TCP	= 0 ,
	UDP	= 1 ,
	PORT1	= 80,
	PORT2	= 8000
} rcv_net_def;

typedef enum {
	SND	= 0 ,
	RCV	= 1
} kthd_list;

typedef enum {
	PLAY	= 1 ,
	STOP	= 0
} kaud_cmd;

typedef struct _gbuffer_index_t {
	int	idx;
	int	new;
	struct _gbuffer_index_t	*pre;
	struct _gbuffer_index_t	*next;
	u8	*buf;
	u32	phy;
} gbuffer_index_t;

typedef struct {
	u32	va;
	u32	pa;
	int	max;
	u32	unit_size;
	struct semaphore	_gbufMutex;
	gbuffer_index_t		*head;
	gbuffer_index_t		*tail;
	gbuffer_index_t		index[];
} gbuffer_table_t;
/*-------------------------------------------------------------------------------------------------------*/
#ifdef ELAN_ALLOC_PAGE
static inline void *KALLOC(u32 size, int type)
{
	int order;
	for (order=0; (PAGE_SIZE<<order)<size ;order++);
	return (void *)__get_free_pages(type, order);
}

static inline void KFREE(void *p, u32 size)
{
	int order;
	for (order=0; (PAGE_SIZE<<order)<size ;order++);
	free_pages((unsigned int)p, order);
}
#else
	#define KALLOC(SZ,TYPE)		kmalloc(SZ, TYPE)
	#define KFREE(P,SZ)		kfree(P)
#endif

/*time unit: 10ms for arm because HZ=100*/
#define SCH_NONE(...)
#define SCH_TMOUT(...)		{set_current_state(TASK_INTERRUPTIBLE); schedule_timeout((__VA_ARGS__)*HZ/100);}
#define SCH_MSLEEP(...)		{msleep(__VA_ARGS__);}

#define SCH_CTRL(NAME,...)	SCH_##NAME(__VA_ARGS__)
#define SCH(M,...)		SCH_CTRL(M,__VA_ARGS__)
/*-------------------------------------------------------------------------------------------------------*/
struct net_def_struct {
	struct socket	*sock_t;
	struct socket	*sock_b;
	int	type;
	int	port;
} __attribute__((packed));
typedef struct net_def_struct net_def_t;

struct fifo_wfp_struct {
	struct file	*wfp;
} __attribute__((packed));
typedef struct fifo_wfp_struct fifo_wfp_t;

typedef struct kthread_struct {
	int	cmd;
	int	terminate;
	void	*arg;
	wait_queue_head_t	queue;
	struct semaphore	_semMutex;
	struct task_struct	*thread;

	union {
		net_def_t	netarg;
		fifo_wfp_t	fifoarg;
	} snd_rcv_args;
} kthread_t;
/*-------------------------------------------------------------------------------------------------------*/
#ifdef AUDIO_SRC_FROM_FILE
static int recv_gbuf_from_file(gbuffer_index_t *);
static void read_srcaud_from_file(void);
#else
static struct socket* set_up_udpserver_socket(int);
static struct socket* set_up_tcpserver_socket(int);
static struct socket* server_accept_connection(struct socket *);
static int setup_server_daemon(net_def_t *);
static size_t recvbuffer(struct socket *, unsigned char *, size_t);
static int recv_gbuf_from_net(struct socket *, gbuffer_index_t *);
#endif
static gbuffer_table_t* gbuffer_init(int, int);
static void gbuffer_release(void);
static int copy_gbuf_to_aud_fifo(struct file *, gbuffer_index_t *);
static int RCV_kthd_func(void *);
static int SND_kthd_func(void *);
static void setup_kthd_area(int);
static int create_aud_fifo_file(void);
static void release_aud_fifo_file(void);
static void release_kthd_area(int);
static void proc_alloc(void);
static void proc_free(void);
static int proc_read(char *, char **, off_t, int, int *, void *);
/*=======================================================================================================*/
#endif
