#ifndef __KLUANET_H__
#define __KLUANET_H__
/*=======================================================================================================*/
#define CFG_PROC_LUAFD			 "kluanet"

#define KLUANET_NUM	                 100
#define KLUANET_NAME		         "kluanet"
#define KLUANET_LUA_NUM			 KLUANET_NUM
#define KLUANET_LUA_IOCTL_MAGIC		 KLUANET_LUA_NUM
#define KLUANET_LUA_IO(nr)		 _IO(KLUANET_LUA_IOCTL_MAGIC,nr)
#define KLUANET_LUA_IOR(nr,size)	 _IOR(KLUANET_LUA_IOCTL_MAGIC,nr,size)
#define KLUANET_LUA_IOW(nr,size)	 _IOW(KLUANET_LUA_IOCTL_MAGIC,nr,size)
#define KLUANET_LUA_IOWR(nr,size)	 _IOWR(KLUANET_LUA_IOCTL_MAGIC,nr,size)
#define KLUANET_IOCTL_LUA_CMD		 KLUANET_LUA_IOW( 0x00, char * )
#define KLUANET_IOCTL_LUA_Y		 KLUANET_LUA_IO( 0x01 )
#define KLUANET_IOCTL_LUA_N		 KLUANET_LUA_IO( 0x02 )
#define KLUANET_IOCTL_LUA_V		 KLUANET_LUA_IOR( 0x03, int)
#define KLUANET_IOCTL_LUA_JIFFIES        KLUANET_LUA_IOR( 0x04, unsigned long)
#define KLUANET_IOCTL_FE_OFF		 KLUANET_LUA_IO( 0x05 )
#define KLUANET_IOCTL_FE_ON		 KLUANET_LUA_IO( 0x06 )
#define KLUANET_IOCTL_FE_V		 KLUANET_LUA_IOR( 0x07, int)
/*-------------------------------------------------------------------------------------------------------*/
#define CHK_MGAPP
#define DBG_FLAG_INIT			 1
#define DBG_FLAG_LUATHREAD		 1

#define __DBG_0(...)
#define __DBG_1(...)			 printk(__VA_ARGS__)
#define __DBG(N,...)			 __DBG_##N(__VA_ARGS__)
#define _DBG(N,...)			 __DBG(N,__VA_ARGS__)
#define DBG(N,FMT,...)			 _DBG(DBG_FLAG_##N,#N ":%s:%d: " FMT, __FUNCTION__, __LINE__, ##__VA_ARGS__)
/*-------------------------------------------------------------------------------------------------------*/
/*time unit: 10ms for arm because HZ=100*/
#define SCH_NONE(...)
#define SCH_TMOUT(...)		{set_current_state(TASK_INTERRUPTIBLE); schedule_timeout((__VA_ARGS__)*HZ/100);}
#define SCH_MSLEEP(...)		{msleep(__VA_ARGS__);}

#define SCH_CTRL(NAME,...)	SCH_##NAME(__VA_ARGS__)
#define SCH(M,...)		SCH_CTRL(M,__VA_ARGS__)
/*-------------------------------------------------------------------------------------------------------*/
typedef struct fe_action_struct {
	int	mount_view_switch;
} fe_action_t;

typedef struct lua_action_struct {
	struct  socket * sock;
	char	action[256];
	int 	fd;
	int	connected;
	int     mgapp;
	int	runflag;
	fe_action_t		fed;
	wait_queue_head_t       queue;
        struct semaphore        _semMutex;
        struct task_struct      *thread;
} lua_action_t;
/*-------------------------------------------------------------------------------------------------------*/
void lua_client_release(void);
int  lua_client_connection(void);
void do_lua_action(char *);
/*=======================================================================================================*/
#endif
