#ifndef __NVP7000_CLASS__
#define __NVP7000_CLASS__


class NVP7000 {
	public :
		NVP7000();
		~NVP7000();
		
		int Open(char * i2c_bus, int i2c_dev,  int video_format); // 0:ntsc	1:pal	2:Auto detect		
		int Init(char * i2c_bus, int i2c_dev,  int video_format); // 0:ntsc	1:pal	2:Auto detect
		int StartColorBar();
		int StopColorBar();		

		int SetBrightness(int val);
		int SetContrast(int val);
		int SetHue(int val);
		int SetSaturation(int val);
		
		int GetBrightness(int * val);
		int GetContrast(int * val);
		int GetHue(int * val);
		int GetSaturation(int * val);
				
		bool VideoIsLost();
		bool VideoFormatIsPAL();
		bool VideoFormatIsNTSC();		
				
	private :
		int m_fd;
		unsigned char NVP7000_NTBuf[191];
		unsigned char NVP7000_PALBuf[191];
};

#endif 









///////////////////////////////////////////////////////////////////////


/*

#ifndef _HW_I2C_API_H
#define _HW_I2C_API_H

#define def7000Brightness	0
#define def7000Contrast		0
#define def7000Hue			0
#define def7000Saturation		0

#define BRIGHTNESS	1
#define SATURATION	3
#define CONTRAST	2
#define HUE		4

typedef enum{
        NTSC,
        PAL
} enumVIDEO_MODE;

typedef enum{
	CAM_NOT_CONNECTED	= 0x00,
	CAM_CONNECTED		= 0x01
}enumCAMSTATE;

typedef struct data_fm7000 {
	unsigned char addr;
	unsigned char dataNTSC;
	unsigned char dataPAL;
} NVP7000_t;

typedef struct i2c_device_addr {
	int		fd;
//	int		wfd;	
	unsigned char	slaveaddr;
} i2c_device_addr_t;
  
int Set7000Brightness(int val);
int Set7000Contrast(int val);
int Set7000Hue(int val);
int Set7000Saturation( int val);


void NVP7000_check_video_connect ( enumCAMSTATE *conn);
void NVP7000_check_video_state ( enumCAMSTATE *conn, enumVIDEO_MODE *mode);
int NVP7000_SetVideo_PAL ();
int NVP7000_SetVideo_NTSC ();
int hw_NVP7000init( enumVIDEO_MODE mode);
int SetBrightness(int ch, int val);
#endif // _HW_I2C_API_H


*/
