

#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>
#include <sys/ioctl.h>

#include "i2c.h"
#include "NVP7000.h"


NVP7000::NVP7000() {
	unsigned char tmpNVP7000_NTBuf[] = {
		0x00,0x00,0x00,0xCC,0xE6,0x40,0x70,0x8F,0x00,0x30,0x40,0x80,0x50,0x38,0x80,0x00,	// 0
		//0xCC,0x64,0x80,0x30,0x8F,0x00,0x00,0x00,0x40,0x18,0x88,0x00,0x00,0x00,0x00,0x00,	// 1
		0xCC,0x64,0x80,0x30,0x8F,0x00,0x40,0x00,0x40,0x18,0x88,0x00,0x00,0x00,0x00,0x00,	// 1
		0x82,0x26,0xCC,0x1F,0x57,0xFE,0x9A,0x06,0x06,0x00,0xC3,0x90,0x24,0x40,0x00,0x00,	// 2
		0x44,0x90,0x06,0x15,0x78,0xA0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,	// 3
		0x00,0x00,0x07,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// 4
		0x00,0x88,0x00,0x00,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x80,0xB0,0xB0,0x80,0x00,	// 5
		0x8D,0x89,0x92,0x92,0x01,0x25,0x80,0x80,0xD0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,	// 6
		0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x95,0x01,0x02,0x00,0x00,0x00,0x00,	// 7
		0xF9,0xFB,0x25,0x50,0xB8,0x01,0x06,0x06,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// 8
		0x23,0x90,0x02,0x19,0x00,0x05,0x00,0x2A,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// 9
		0x05,0x00,0x43,0x43,0x00,0x43,0x01,0x43,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// A
		0x0A,0x14,0x0A,0xC8,0xB9,0xB2,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00		// B
	};
	

	unsigned char tmpNVP7000_PALBuf[] = {
		0x00,0x00,0x00,0xCC,0xE6,0x40,0x70,0x8F,0x00,0x30,0x40,0x80,0x50,0x38,0x80,0x00,	// 0
		//0xCC,0x64,0x80,0x30,0x8F,0x00,0x1D,0x00,0x80,0x18,0x88,0x00,0x00,0x00,0x00,0x00,	// 1
		0xCC,0x64,0x80,0x30,0x8F,0x00,0x5D,0x00,0x80,0x18,0x88,0x00,0x00,0x00,0x00,0x00,	// 1
		0x01,0x26,0xCC,0x1F,0x57,0x00,0x75,0x06,0x06,0x00,0xC3,0x90,0x24,0x4F,0x00,0x00,	// 2
		0x00,0xC4,0x07,0x17,0x78,0xB7,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// 3
		0x00,0x00,0x07,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// 4
		0x00,0x88,0x00,0x0D,0x8C,0x00,0x01,0x00,0x00,0x00,0x00,0x80,0xB0,0xB0,0x80,0x00,	// 5
		0x95,0x80,0x89,0x92,0x01,0x25,0x80,0x80,0xD0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,	// 6
		0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x95,0x01,0x02,0x00,0x00,0x00,0x00,	// 7
		0x07,0xFC,0x22,0x50,0xB8,0x01,0x06,0x06,0xC0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// 8
		0x23,0x90,0x02,0x19,0x00,0x05,0x00,0x2A,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// 9
		0x05,0x00,0x43,0x43,0x00,0x43,0x01,0x43,0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,	// A
		0x0A,0x14,0x0A,0xC8,0xB9,0xB2,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00		// B
	};


	memcpy( NVP7000_NTBuf,	tmpNVP7000_NTBuf,	191 );
	memcpy( NVP7000_PALBuf,	tmpNVP7000_PALBuf,	191 );	
	
}


NVP7000::~NVP7000() {
	i2c_close( m_fd );
}

int NVP7000::Open( char * i2c_bus, int i2c_dev, int video_format  ) {
	m_fd = 0;
	m_fd = i2c_open( i2c_bus, i2c_dev, I2CDEV_STD );
	if (m_fd < 0 ) {
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}
	
int NVP7000::Init( char * i2c_bus, int i2c_dev, int video_format  ) {
	int ret;
	unsigned char data;
		
	if ( Open( i2c_bus, i2c_dev, I2CDEV_STD ) != EXIT_SUCCESS ) {
//		printf("i2c open error.\n");
//		printf("Open i2c_bus[%s] i2c_dev[%d] error.\n", i2c_bus, i2c_dev);		
		return EXIT_FAILURE;
	}

	
	
	ret = i2c_read_block( m_fd, 0x02, &data, 1);
	if ( ( ret < 0 ) || ( data != 0x88) ) {
//		printf("NVP7000 on i2c_bus[%s] i2c_dev[%d], get DEV_ID and REV_ID error.\n", i2c_bus, i2c_dev);
		return EXIT_FAILURE;
	} 
	
	
	if ( video_format == 2 ) {
		if ( VideoFormatIsPAL() ) {
			video_format = 1;
		} else {
			video_format = 0;			
		}
	} 
	
	if ( video_format == 1 ) {
	//	printf("Initial as PAL.\n");				
		ret = i2c_write_block( m_fd, 0x00, &NVP7000_PALBuf[0], 191);
	} else {
	//	printf("Initial as NTSC.\n");		
		ret = i2c_write_block( m_fd, 0x00, &NVP7000_NTBuf[0], 191);	
	} 
	if ( ret < 0 ) {
//		printf("NVP7000 write registers error.\n");
		return EXIT_FAILURE;
	} 
//	printf("Init OK \n");		
	return EXIT_SUCCESS;

}



bool NVP7000::VideoIsLost() {
	int ret, status;
	unsigned char data;
	
	data = 0;	
	ret = i2c_read_block( m_fd, 0x00, &data, 1);
	status = (data & 0x04) ? 1 : 0;
	if ( status == 1 ) {
		return true;
	} else {
		return false;
	}
}

bool NVP7000::VideoFormatIsPAL() {
	int ret, status;
	unsigned char data;
	data = 0x80;
	ret = i2c_write_block( m_fd, 0x16, &data, 1);	
	ret = i2c_read_block( m_fd, 0x00, &data, 1);	
	status = (data & 0x40) ? 1 : 0;
	if ( status == 1 ) {
		return true;		
	} else {
		return false;		
	}	
}


bool NVP7000::VideoFormatIsNTSC() {
	return ( ! VideoFormatIsPAL() );
}



int NVP7000::SetBrightness(int val) {
//	int high = 127,low = -128;
	int ret;
	unsigned char data;

	data= (unsigned char)val;
	ret = i2c_write_block( m_fd, 0x30, &data, 1);		
	if ( ret < 0) {
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}

int NVP7000::SetContrast(int val) {
//	int high=255,low=0;
	int ret;
	unsigned char data;

	data = (unsigned char)val;
	ret = i2c_write_block( m_fd, 0x31, &data, 1);		
	if ( ret < 0) {
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;	
}

int NVP7000::SetHue(int val) {
//	int high=255,low=0;
	
	int ret;
	unsigned char data;

	data = (unsigned char)val;
	ret = i2c_write_block( m_fd, 0x25, &data, 1);		
	if ( ret < 0) {
		return EXIT_FAILURE;
	}	
	return EXIT_SUCCESS;		
}



int NVP7000::SetSaturation( int val) {
	//int high=255,low=0;	
	int ret;
	unsigned char data;
	
	data = (unsigned char)val;
	ret = i2c_write_block( m_fd, 0x26, &data, 1);			
	if ( ret < 0) {
		return EXIT_FAILURE;
	}	
	return EXIT_SUCCESS;		
}





int NVP7000::GetBrightness(int *val) {
	int ret;
	unsigned char data;

	ret = i2c_read_block( m_fd, 0x30, &data, 1);	
	*val = (int)data;
	
	if ( ret < 0) {
		*val = 0x00;
		return EXIT_FAILURE;
	}	
	return EXIT_SUCCESS;
}


int NVP7000::GetContrast(int *val) {
	int ret;
	unsigned char data;

	ret = i2c_read_block( m_fd, 0x31, &data, 1);	
	*val = (int)data;
	
	if ( ret < 0) {
		*val = 0x00;
		return EXIT_FAILURE;
	}	
	return EXIT_SUCCESS;
}

int NVP7000::GetHue(int *val) {
	int ret;
	unsigned char data;

	ret = i2c_read_block( m_fd, 0x25, &data, 1);	
	*val = (int)data;
	
	if ( ret < 0) {
		*val = 0x00;
		return EXIT_FAILURE;
	}	
	return EXIT_SUCCESS;

}



int NVP7000::GetSaturation( int *val) {
	int ret;
	unsigned char data;

	ret = i2c_read_block( m_fd, 0x26, &data, 1);	
	*val = (int)data;
	
	if ( ret < 0) {
		*val = 0x00;
		return EXIT_FAILURE;
	}	
	return EXIT_SUCCESS;	
}



int NVP7000::StartColorBar(){
	int ret;
	int addr = 0x54;
	unsigned char data = 0x88;

	ret = i2c_write_block( m_fd, addr, &data, 1);	
	if ( ret < 0 ) {
		return EXIT_FAILURE;
	}

	data = 0x40;
	addr = 0x53;
	ret = i2c_write_block( m_fd, addr, &data, 1);	
	if ( ret < 0 ) {
		return EXIT_FAILURE;
	}
	
	return EXIT_SUCCESS;	
}



int NVP7000::StopColorBar(){
	int ret;
	int addr = 0x54;
	unsigned char data = 0x88;

	ret = i2c_write_block( m_fd, addr, &data, 1);	
	if ( ret < 0 ) {
		return EXIT_FAILURE;
	}

	data = 0x00;
	addr = 0x53;
	ret = i2c_write_block( m_fd, addr, &data, 1);	
	if ( ret < 0 ) {
		return EXIT_FAILURE;
	}
	
	return EXIT_SUCCESS;	
}

