/*
 * FILE NAME mobi_pwm.h
 *
 * BRIEF MODULE DESCRIPTION
 *	API to PWM device.
 *
 * Copyright 2007 Mobilygen Corp.
 * Copyright 2009 Maxim IC
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE    LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __MOBI_PWM_H
#define __MOBI_PWM_H

/* Directory in /proc filesystem where stats and debug hooks will be */
#define PWM_PROCDIR        "driver/pwm"

#ifdef __KERNEL__ 

#include <linux/types.h>
#include <linux/proc_fs.h>

#define PWMDRV_NAME_MAXLEN 32

struct pwm_func
{
    int (*read) (int pwm);    /* Read PWM frequency */
    int (*set) (int pwm, int freq);     /* Set PWM with frequency */
    int (*open) (int pwm);        /* Register pwm, should be called first before anything else */
    int (*release) (int pwm);      /* Release pwm, should be called last */
};

#endif
#endif
