/*
 *  This file Copyright (C) 2007 Mobilygen Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef _DWAPBGPIO_H_
#define _DWAPBGPIO_H_

/*-------------------------------------------------------------------------*/

/* General */

/* 
 * AMBA component ID - This value is arbitrarily set,
 * we leave the low order byte for device ID,
 * and the high order byte for designer ID.
 */
#define DWAPBGPIO_ID				0x00198800
#define DWAPBGPIO_ID_MASK			0x00ffff00

struct dwapbgpio_block_data
{
	short port_a_count, port_b_count,
		port_c_count, port_d_count;
	unsigned gpio_id_offset;
	const char *group;
};

/*-------------------------------------------------------------------------*/

/* Component Registers */

#define DWAPBGPIO_IC_SWPORTA_DR			0x00
#define DWAPBGPIO_IC_SWPORTA_DDR		0x04
#define DWAPBGPIO_IC_PORTA_CTL			0x08
#define DWAPBGPIO_IC_SWPORTB_DR			0x0c
#define DWAPBGPIO_IC_SWPORTB_DDR		0x10
#define DWAPBGPIO_IC_PORTB_CTL			0x14
#define DWAPBGPIO_IC_SWPORTC_DR			0x18
#define DWAPBGPIO_IC_SWPORTC_DDR		0x1c
#define DWAPBGPIO_IC_PORTC_CTL			0x20
#define DWAPBGPIO_IC_SWPORTD_DR			0x24
#define DWAPBGPIO_IC_SWPORTD_DDR		0x28
#define DWAPBGPIO_IC_PORTD_CTL			0x2c
#define DWAPBGPIO_IC_INTEN			0x30
#define DWAPBGPIO_IC_INTMASK			0x34
#define DWAPBGPIO_IC_INTTYPE_LEVEL		0x38
#define DWAPBGPIO_IC_INT_POLARITY		0x3c
#define DWAPBGPIO_IC_INTSTATUS			0x40
#define DWAPBGPIO_IC_RAWINTSTATUS		0x44
#define DWAPBGPIO_IC_DEBOUNCE			0x48
#define DWAPBGPIO_IC_PORTA_EOI			0x4c
#define DWAPBGPIO_IC_EXT_PORTA			0x50
#define DWAPBGPIO_IC_EXT_PORTB			0x54
#define DWAPBGPIO_IC_EXT_PORTC			0x58
#define DWAPBGPIO_IC_EXT_PORTD			0x5c
#define DWAPBGPIO_IC_LS_SYNC			0x60
#define DWAPBGPIO_IC_ID_CODE			0x64
#define DWAPBGPIO_IC_COMP_VERSION		0x6c

/*-------------------------------------------------------------------------*/

#endif /* #ifndef _DWAPBGPIO_H_ */
