#define DRIVER_NAME 	"isp1761"
//#define DRIVER_DESC 	"Sample client driver for the GPIO framework"
//#define DRIVER_AUTHOR 	"Gregoire Pean <gpean@mobilygen.com>"
#define DRIVER_VERSION 	"1:0.0"

/*
 *  This file Copyright (C) 2007 Mobilygen Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/version.h>
#include <linux/vermagic.h>
#include <linux/init.h>
#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <linux/delay.h>
#include <linux/device.h>
#include <linux/platform_device.h>

/* Most important: GPIO framework header. */
#include <linux/gpio-core.h>
#include <linux/usb.h>
#include "hal_intf.h"
#include "isp1761.h"

#if	1
//#define DEBUG

/*-------------------------------------------------------------------------*/

#define error(format, arg...)	printk(KERN_ERR DRIVER_NAME ": " format "\n" , ## arg)
//#define info(format, arg...) 	printk(KERN_INFO DRIVER_NAME ": " format "\n" , ## arg)
//#define warn(format, arg...) 	printk(KERN_WARNING DRIVER_NAME ": " format "\n" , ## arg)

#ifdef DEBUG
#define debug(format, arg...) 	printk(KERN_ERR DRIVER_NAME ":%d: " format "\n" , __LINE__, ## arg)
#else
#define debug(format, arg...) 	do {} while (0)
#endif
#endif

/*-------------------------------------------------------------------------*/
enum PIN_DIRECTION {
	PIN_INPUT,
	PIN_OUTPUT,
};

enum PIN_DECLARE {
	PIN_RESET,
	PIN_INTERRUPT,
};

#define	PIN( x)		isp1761_int_pins[x].hdrv, isp1761_int_pins[x].index

static struct gpio_client_pin isp1761_int_pins[] = {
	/* keep it as enum PIN_ DECLARE. */
	{	/* reset */
		.gpio 	= RESET_PIN_ISP1761_INDEX,
		.label	= "reset_" DRIVER_NAME,
	},
	{	/* interrupt */
		.gpio 	= INTERRUPT_PIN_ISP1761_INDEX,
		.label	= "interrupt_" DRIVER_NAME,
	},
};

/* For the modparam, see bottom of file. */
//static int isp1761_int_gpio = 0;

/*-------------------------------------------------------------------------*/

/**
 * This is the interrupt callback that will be called when an interrupt occurs on the GPIO pin.
 * Please note that you can also do the request_irq() call yourself, 
 * but letting the GPIO framework do the job is easier.
 * You can have a look at the gpio-core.c file to see how the request_irq() 
 * is done if you want to do the same manually in your driver.
 */
// kosta static 
int isp1761_int_interrupt_callback(unsigned gpio, 
	unsigned gpio_index, void *cbdata)
{
//	/* Simply print out something... */
//	debug("INT! GPIO %u", gpio);
//printk("INT! GPIO %u\n", gpio);
//printk("%s() gpio=0x%08x gpio_index=0x%08x\n", __func__, gpio, gpio_index);
//printk("%s() isp1761_int_pins[PIN_INTERRUPT].gpio=0x%08x isp1761_int_pins[PIN_INTERRUPT].index=0x%08x\n", __func__, isp1761_int_pins[PIN_INTERRUPT].gpio, isp1761_int_pins[PIN_INTERRUPT].index);

// kosta	isp1761_isr();

	/* Clear the interrupt. */
	gpio_interrupt_clear( PIN(PIN_INTERRUPT));
	
	/* Careful! Any non-zero value will disable the IRQ! */
	return 0;
}

/**
 * This probe function will be called when the pins you requested
 * get available.
 */
static int isp1761_int_probe(struct gpio_client *client)
{
	int ret;
	
	/* Interrupt configuration. */
	static const struct gpio_interrupt_config int_config = {
#ifndef	ISP1761_IRQ_EDGE
		.type 		= GPIO_INT_TYPE_LEVEL,
#else
		.type 		= GPIO_INT_TYPE_EDGE,
#endif
#ifdef	ISP1761_IRQ_ACT_HIGH
		.polarity 	= GPIO_INT_POLARITY_HIGH_OR_RISING,
#else
		.polarity 	= GPIO_INT_POLARITY_LOW_OR_FALLING,
#endif
		.debounce_on	= 1,
	};

/* kosta: DOES NOT WORK */
	/* reset ISP1761 */
//	gpio_set_value(		PIN(PIN_RESET), 0);
//	gpio_direction_output(	PIN(PIN_RESET), PIN_OUTPUT);
	gpio_direction_output(	PIN(PIN_RESET), 0);
	mdelay( 1);
//	gpio_set_value(		PIN(PIN_RESET), 1);
	gpio_direction_output(	PIN(PIN_RESET), 1);

/* kosta: DOES NOT WORK */

	/* interrupt ISP1761 */
	gpio_direction_input( PIN(PIN_INTERRUPT));

#if	0
	debug("probe: RESET     gpio=%u index=%u", isp1761_int_pins[PIN_RESET].gpio, 
		isp1761_int_pins[PIN_RESET].index);
	debug("probe: INTERRUPT gpio=%u index=%u", isp1761_int_pins[PIN_INTERRUPT].gpio, 
		isp1761_int_pins[PIN_INTERRUPT].index);
#else
	printk("probe: RESET     gpio=%u index=%u\n", isp1761_int_pins[PIN_RESET].gpio, 
		isp1761_int_pins[PIN_RESET].index);
	printk("probe: INTERRUPT gpio=%u index=%u\n", isp1761_int_pins[PIN_INTERRUPT].gpio, 
		isp1761_int_pins[PIN_INTERRUPT].index);
#endif
	
	/* Register our interrupt callback. This will not enable the interrupt. */
	debug("register int");
	ret = gpio_interrupt_register( PIN(PIN_INTERRUPT), isp1761_int_interrupt_callback, NULL /* private data */);
	if (unlikely(ret)) {
		error("could not register the interrupt callback (%d)", ret);
		return ret;
	}
	
	/* Configure interrupt type and edge. */
	debug("configure int");
	ret = gpio_interrupt_configure( PIN(PIN_INTERRUPT),  &int_config);
	if (unlikely(ret)) {
		error("could not configure the interrupt (%d)", ret);
		goto end_unreg;
	}

	/* Enable the interrupt. */
	debug("enable int");
	ret = gpio_interrupt_enable( PIN(PIN_INTERRUPT));
	if (unlikely(ret)) {
		error("could not enable the interrupt (%d)", ret);
		goto end_unreg;
	}
	
	debug("probe success");
	return 0;
	
end_unreg:
	debug("unregister int");
	gpio_interrupt_unregister( PIN(PIN_INTERRUPT), 
		isp1761_int_interrupt_callback);
	return ret;
}

/**
 * This remove function will be called when the pins you requested
 * are being unregistered.
 */
static int isp1761_int_remove(struct gpio_client *client)
{
	debug("remove");
	
	debug("unregister int");
	return gpio_interrupt_unregister( PIN(PIN_INTERRUPT), 
		isp1761_int_interrupt_callback);
}

/*-------------------------------------------------------------------------*/

/* This is like a platform_driver struct... */
static struct gpio_client isp1761_int_cli = {
	/* NULL means match any group. On the MG3500 there is
	 * only one GPIO group so that's fine. */
	.match_group	= NULL,
	.match_pins	= isp1761_int_pins,
	.pin_count	= ARRAY_SIZE(isp1761_int_pins),
	.probe		= isp1761_int_probe,
	.remove		= isp1761_int_remove,

	/* Pass any private data using those members: */
	/*
	.parent_data	= ...,
	.client_data	= ...,
	*/
};

//static 
int __init isp1761_int_init(void)
{
	int ret;

//	info(DRIVER_DESC " compiled for Linux %s, version %s (%s at %s)",
//		UTS_RELEASE, DRIVER_VERSION, __DATE__, __TIME__);
	
	/* Register our client driver with the GPIO framework. */
	debug("registering");
	if (unlikely(ret = gpio_client_register(&isp1761_int_cli))) {
		error("%s: failed to register GPIO client, "
			"error is %d\n", __func__, ret);
	}
	
	return ret;
}

//static 
void __exit isp1761_int_exit(void)
{
	int ret;
	debug("unregistering");
        if (unlikely(ret = gpio_client_unregister(&isp1761_int_cli))) {
		error("%s: failed to unregister GPIO client, "
			"error is %d\n", __func__, ret);
	}
}

/**********************************************************/
/* Above functions CAN NOT be used from INTERRUPT CONTEXT */
/**********************************************************/

#include	"linux/dwapbgpio.h"

struct dwapbgpio_drv_data
{
	struct amba_device 		*dev;
	void __iomem 			*base;
	
	struct dwapbgpio_block_data	*bdata;
	
	struct gpio_driver 		drv;
	
	short				port_a_last, port_b_last, 
					port_c_last, port_d_last;

#ifdef CONFIG_ARCH_MERLIN
	int				restore_func;
#endif
};

#define	GPIO_0_BASE			((struct dwapbgpio_drv_data *)(isp1761_int_pins[PIN_INTERRUPT].hdrv->driver_data))->base

static inline u32 apb_read32(void __iomem *base, int reg)
{
	return ioread32(base + reg);
}

static inline void apb_write32(void __iomem *base, int reg, u32 value)
{
	iowrite32(value, base + reg);
}

void pehci_usb_dis_interrupts( void)
{
	apb_write32( GPIO_0_BASE, DWAPBGPIO_IC_INTEN, 
		apb_read32( GPIO_0_BASE, DWAPBGPIO_IC_INTEN) 
		& ~(1 << INTERRUPT_PIN_ISP1761_INDEX));
	apb_write32( GPIO_0_BASE, DWAPBGPIO_IC_INTMASK,
		apb_read32( GPIO_0_BASE, DWAPBGPIO_IC_INTMASK)
		| (1 << INTERRUPT_PIN_ISP1761_INDEX));
}

void pehci_usb_ena_interrupts( void)
{
	apb_write32( GPIO_0_BASE, DWAPBGPIO_IC_SWPORTA_DDR, 
		apb_read32( GPIO_0_BASE, DWAPBGPIO_IC_SWPORTA_DDR)
		& ~(1 << INTERRUPT_PIN_ISP1761_INDEX));
	apb_write32( GPIO_0_BASE, DWAPBGPIO_IC_INTMASK, 
		apb_read32( GPIO_0_BASE, DWAPBGPIO_IC_INTMASK)
		& ~(1 << INTERRUPT_PIN_ISP1761_INDEX));
	apb_write32( GPIO_0_BASE, DWAPBGPIO_IC_INTEN, 
		apb_read32( GPIO_0_BASE, DWAPBGPIO_IC_INTEN)
		| (1 << INTERRUPT_PIN_ISP1761_INDEX));
}

EXPORT_SYMBOL(pehci_usb_ena_interrupts);
EXPORT_SYMBOL(pehci_usb_dis_interrupts);

