/*
 * vid_input_ctrl.c Video input (Composite/SVideo/Component) control interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 */

#include "uvcdescript.h"
#include "vid_input_ctrl.h"
#include "dbgout.h"

struct vid_input_param_t
{
	__u8  bState;
};

// TODO : Fill with suitable values based on the Camera capabilities
static struct vid_input_param_t vid_input_param = 
{
	.bState = 0,		
};

int handle_input_control_composite(void *pCtx, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int result = 0;
	//struct vid_input_param_t *pPram = (struct vid_input_param_t *)pCtx;
	__u16	w_value = __le16_to_cpu(ctrl->wValue);

	int control_selector = w_value >> 8;
	UAV_DBG_MSG("control_selector=%d",control_selector);
	return result;
}

int handle_input_control_svideo(void *pCtx, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int result = 0;
	//struct vid_input_param_t *pPram = (struct vid_input_param_t *)pCtx;
	__u16	w_value = __le16_to_cpu(ctrl->wValue);

	int control_selector = w_value >> 8;
	UAV_DBG_MSG("control_selector=%d",control_selector);
	return result;
}

int handle_input_control_component(void *pCtx, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int result = 0;
	//struct vid_input_param_t *pPram = (struct vid_input_param_t *)pCtx;
	__u16	w_value = __le16_to_cpu(ctrl->wValue);

	int control_selector = w_value >> 8;
	UAV_DBG_MSG("control_selector=%d",control_selector);
	return result;
}

int handle_input_control_hdmi(void *pCtx, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int result = 0;
	//struct vid_input_param_t *pPram = (struct vid_input_param_t *)pCtx;
	__u16	w_value = __le16_to_cpu(ctrl->wValue);

	int control_selector = w_value >> 8;
	UAV_DBG_MSG("control_selector=%d",control_selector);
	return result;
}


void *get_vidcap_control_input(void)
{
	return &vid_input_param;
}
