/*
 * uvcdescriptor.h USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file defines UVC descriptors 
 *
 */

#ifndef __UVCDESCRIPT_H__
#define __UVCDESCRIPT_H__
#include <linux/version.h>
#if LINUX_VERSION_CODE > KERNEL_VERSION(2, 6, 20)
#include <linux/usb/ch9.h>
#else
#include <linux/usb_ch9.h>
#endif

#include <asm/byteorder.h>
#include "platform_caps.h"
#include "mjpeg_param.h"

//#define  ENABLE_UVC_1_1


#define MAX_VID_CAP_FORMATS		1 //3
#define MAX_AUD_CAP_FORMATS		2
#define MAX_VID_CAP_FRAMES		4

#define MAX_FRAMES_PER_FORMAT		4

#define TS_PACKET_SIZE			188
#define PL_HEADER_SIZE			2

#define PKT_SIZE_MP2TS_1		(1 * TS_PACKET_SIZE + PL_HEADER_SIZE)
#define PKT_SIZE_MP2TS_2		(2 * TS_PACKET_SIZE + PL_HEADER_SIZE)
#define PKT_SIZE_MP2TS_3		(3 * TS_PACKET_SIZE + PL_HEADER_SIZE)
#define PKT_SIZE_MP2TS_4		(4 * TS_PACKET_SIZE + PL_HEADER_SIZE)

/* Currently we support PKT SIze of 190 for MPEG2TS and 1024 for MJPEG */
/* Remaining descriptors are place holders for future use */
#define PKT_SIZE_ISOC1          (1 * TS_PACKET_SIZE + PL_HEADER_SIZE)				// 12000000 / 8 / 1000
#define PKT_SIZE_ISOC2          (1 * TS_PACKET_SIZE + PL_HEADER_SIZE)				// 12000000 / 8 / 1000
#define PKT_SIZE_ISOC3          (1 * TS_PACKET_SIZE + PL_HEADER_SIZE)				// 12000000 / 8 / 1000
#define PKT_SIZE_ISOC4          (1 * TS_PACKET_SIZE + PL_HEADER_SIZE)				// 12000000 / 8 / 1000
#define PKT_SIZE_ISOC5          1024
#define PKT_SIZE_ISOC6          1024
#define PKT_SIZE_ISOC7          1024	//0x1400		// 3 micromes of * 0x400

/**
 * Max packet size for ts capture stream bulk EP
 */
#define PKT_SIZE_CAP_BULK		512

/**
 * Max ep size for enc stream bulk ep
 */
#define PKT_SIZE_ENC_BULK		512

/**
 * Max ep size for enc stream bulk ep
 */
#define PKT_SIZE_DEC_BULK		512

/**
 * Max ep size for vendor specific stream
 * TODO : Change the following payload size
 */
#define PKT_SIZE_ENC_VEN_1		512

/******************************************************************************
 * strings
 ******************************************************************************/
#define STN_MANUFACTURER		1 
#define STN_PRODUCT				2 
#define STN_SERIAL				3 
#if 0
#define STN_CFG_MAIN			250
#define STN_STRM_H264_720P		230
#define STN_INPUT_COMPOSITE		231 
#define STN_INPUT_SVIDEO		232 
#define STN_INPUT_COMPONENT		233 
#define STN_INPUT_HDMI			234 
#else
#define STN_CFG_MAIN			4
#define STN_STRM_H264_720P		5
#define STN_INPUT_COMPOSITE		6
#define STN_INPUT_SVIDEO		7
#define STN_INPUT_COMPONENT		8
#define STN_INPUT_HDMI			9
#endif
#define	CONFIG_VALUE			3


#define status_ok	1
#define status_error	-1

//------------------------------------------------------------------------------
// Video Class-Specific Descriptor Types
//------------------------------------------------------------------------------
#define UVC_CS_UNDEFINED								0x20
#define UVC_CS_DEVICE									0x21
#define UVC_CS_CONFIGURATION							0x22
#define UVC_CS_STRING									0x23
#define UVC_CS_INTERFACE								0x24
#define UVC_CS_ENDPOINT									0x25

//------------------------------------------------------------------------------
// Input Terminal Types
//------------------------------------------------------------------------------
#define UVC_ITT_VENDOR_SPECIFIC							0x0200
#define UVC_ITT_CAMERA									0x0201
#define UVC_ITT_MEDIA_TRANSPORT_INPUT					0x0202

//------------------------------------------------------------------------------
// Output Terminal Types
//------------------------------------------------------------------------------
#define UVC_OTT_VENDOR_SPECIFIC							0x0300
#define UVC_OTT_DISPLAY									0x0301
#define UVC_OTT_MEDIA_TRANSPORT_OUTPUT					0x0302

//------------------------------------------------------------------------------
// External Terminal Types
//------------------------------------------------------------------------------
#define UVC_EXTERNAL_VENDOR_SPECIFIC					0x0400
#define UVC_COMPOSITE_CONNECTOR							0x0401
#define UVC_SVIDEO_CONNECTOR							0x0402
#define UVC_COMPONENT_CONNECTOR							0x0403

//------------------------------------------------------------------------------
// Video Interface Class Codes
//------------------------------------------------------------------------------
#define UVC_CC_VIDEO									0x0E

//------------------------------------------------------------------------------
// Video Interface Subclass Codes
//------------------------------------------------------------------------------
#define UVC_SC_UNDEFINED								0x00
#define UVC_SC_VIDEOCONTROL								0x01
#define UVC_SC_VIDEOSTREAMING							0x02
#define UVC_SC_VIDEO_INTERFACE_COLLECTION				0x03

//------------------------------------------------------------------------------
// USB Terminal Types
//------------------------------------------------------------------------------
#define UVC_TT_VENDOR_SPECIFIC							0x0100
#define UVC_TT_STREAMING								0x0101

enum vid_ct_control_selector_t
{
	CT_CONTROL_UNDEFINED,
	CT_SCANNING_MODE_CONTROL,
	CT_AE_MODE_CONTROL,
	CT_AE_PRIORITY_CONTROL,
	CT_EXPOSURE_TIME_ABSOLUTE_CONTROL,
	CT_EXPOSURE_TIME_RELATIVE_CONTROL,
	CT_FOCUS_ABSOLUTE_CONTROL,
	CT_FOCUS_RELATIVE_CONTROL,
	CT_FOCUS_AUTO_CONTROL,
	CT_IRIS_ABSOLUTE_CONTROL,
	CT_IRIS_RELATIVE_CONTROL,
	CT_ZOOM_ABSOLUTE_CONTROL,
	CT_ZOOM_RELATIVE_CONTROL,
	CT_PANTILT_ABSOLUTE_CONTROL,
	CT_PANTILT_RELATIVE_CONTROL,
	CT_ROLL_ABSOLUTE_CONTROL,
	CT_ROLL_RELATIVE_CONTROL,
	CT_PRIVACY_CONTROL
};

enum vid_pu_control_selector_t {
	PU_CONTROL_UNDEFINED,
	PU_BACKLIGHT_COMPENSATION_CONTROL,
	PU_BRIGHTNESS_CONTROL,
	PU_CONTRAST_CONTROL,
	PU_POWER_LINE_FREQUENCY_CONTROL,
	PU_HUE_CONTROL,
	PU_HUE_AUTO_CONTROL,
	PU_SATURATION_CONTROL,
	PU_SHARPNESS_CONTROL,
	PU_GAMMA_CONTROL,
	PU_WHITE_BALANCE_TEMPERATURE_CONTROL,
	PU_WHITE_BALANCE_TEMPERATURE_AUTO_CONTROL,
	PU_WHITE_BALANCE_COMPONENT_CONTROL,
	PU_WHITE_BALANCE_COMPONENT_AUTO_CONTROL,
	PU_DIGITAL_MULTIPLIER_LIMIT_CONTROL,
};

enum vid_vs_control_selector_t{
	VS_CONTROL_UNDEFINED = 0x00,
	VS_PROBE_CONTROL  = 0x01,
	VS_COMMIT_CONTROL = 0x02,
	VS_STILL_PROBE_CONTROL  = 0x03,
	VS_STILL_COMMIT_CONTROL  = 0x04,
	VS_STILL_IMAGE_TRIGGER_CONTROL = 0x05,
	VS_STREAM_ERROR_CODE_CONTROL = 0x06,
	VS_GENERATE_KEY_FRAME_CONTROL = 0x07,
	VS_UPDATE_FRAME_SEGMENT_CONTROL = 0x08,
	VS_SYNCH_DELAY_CONTROL = 0x09
};

typedef enum tag_class_request_id_t
{
	SET_CUR = 0x01,
	GET_CUR = 0x81,
	GET_MIN,
	GET_MAX,
	GET_RES,
	GET_LEN,
	GET_INFO,
	GET_DEF
} class_request_id_t;

struct uvc_vc_interface_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u16 bcdUVC;
	__u16 wTotalLength;
	__u32 dwClockFrequency;
	__u8  bInCollection;
	__u8  baInterfaceNr[1];
} __attribute__ ((packed));

struct uvc_vc_interface_descriptor_transcode {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u16 bcdUVC;
	__u16 wTotalLength;
	__u32 dwClockFrequency;
	__u8  bInCollection;
	__u8  baInterfaceNr[1];
} __attribute__ ((packed));


struct uvc_input_terminal_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bTerminalID;
	__u16 wTerminalType;
	__u8  bAssocTerminal;
	__u8  iTerminal;
} __attribute__ ((packed));


struct uvc_input_terminal_camera_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bTerminalID;
	__u16 wTerminalType;
	__u8  bAssocTerminal;
	__u8  iTerminal;
	//--additional fields depending on termianl type--
	__u16 wObjectiveFocalLengthMin;
	__u16 wObjectiveFocalLengthMax;
	__u16 wOcularFocalLength;
	__u8  bControlSize;
	__u8 bmControls[3];
} __attribute__ ((packed));


struct uvc_output_terminal_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bTerminalID;
	__u16 wTerminalType;
	__u8  bAssocTerminal;
	__u8  bSourceID;
	__u8  iTerminal;
} __attribute__ ((packed));


struct uvc_selector_unit_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bUnitID;
	__u8  bNrInPins;		// number of input pins
	__u8  baSourceID[VID_CONNECTOR_INPUT_ID_LAST - 1];
	__u8  iSelector;
} __attribute__ ((packed));

#ifdef ENABLE_UVC_1_1
struct uvc_processing_unit_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bUnitID;
	__u8  bSourceID;
	__u16 wMaxMultiplier;
	__u8  bControlSize;	// Set to 4 during initialization
	__u8 bmControls[3];
	__u8  iProcessing;
	__u8  bmVideoStandards;
} __attribute__ ((packed));
#else 

struct uvc_processing_unit_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bUnitID;
	__u8  bSourceID;
	__u16 wMaxMultiplier;
	__u8  bControlSize;	// Set to 4 during initialization
	__u8 bmControls[2];
	__u8  iProcessing;
} __attribute__ ((packed));
#endif


struct uvc_class_spec_interrupt_endpoint_descriptor_t {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u16 wMaxTransferSize;
} __attribute__ ((packed));


struct uvc_vs_header_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bNumFormats;
	__u16 wTotalLength;
	__u8  bEndpointAddress;
	__u8  bmInfo;
	__u8  bTerminalLink;
	__u8  bStillCaptureMethod;
	__u8  bTriggerSupport;
	__u8  bTriggerUsage;
	__u8  bControlSize;
	__u8  bmaControls;

} __attribute__ ((packed));

struct uvc_vs_header_descriptor_cap_t {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bNumFormats;
	__u16 wTotalLength;
	__u8  bEndpointAddress;
	__u8  bmInfo;
	__u8  bTerminalLink;
	__u8  bStillCaptureMethod;
	__u8  bTriggerSupport;
	__u8  bTriggerUsage;
	__u8  bControlSize;
	__u8  bmaControls[ ENCODE_FORMAT_INDEX_LAST - 1];

} __attribute__ ((packed));
struct uvc_vs_format_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bFormatIndex;
	__u8  bNumFrameDescriptors;
	__u8  bmFlags;
	__u8  bDefaultFrameIndex;
	__u8  bAspectRatioX;
	__u8  bAspectRatioY;
	__u8  bmInterlaceFlags;
	__u8  bCopyProtect;
} __attribute__ ((packed));

struct uvc_vs_format_descriptor_frame_based {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bFormatIndex;
	__u8  bNumFrameDescriptors;
	__u8  guidStrideFormat[16];
	__u8  bBitsPerPixel;
	__u8  bDefaultFrameIndex;
	__u8  bAspectRatioX;
	__u8  bAspectRatioY;
	__u8  bmInterlaceFlags;
	__u8  bCopyProtect;
	__u8  bVariableSize;
} __attribute__ ((packed));


struct uvc_vs_format_descriptor_mp2ts_t {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bFormatIndex;
	__u8  bDataOffset;
	__u8  bPacketLength;
	__u8  bStrideLength;
#ifdef ENABLE_UVC_1_1
	__u8  guidStrideFormat[16];
#endif
	
} __attribute__ ((packed));



struct uvc_vs_frame_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bFrameIndex;
	__u8  bmCapabilities;
	__u16 wWidth;
	__u16 wHeight;
	__u32 dwMinBitRate;
	__u32 dwMaxBitRate;
	__u32 dwMaxVideoFrameBufSize;
	__u32 dwDefaultFrameInterval;
	__u8  bFrameIntervalType;
	__u32 dwMinFrameInterval;
	__u32 dwMaxFrameInterval;
	__u32 dwFrameIntervalStep;

} __attribute__ ((packed));

struct uvc_vs_frame_descriptor_mjpg {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bFrameIndex;
	__u8  bmCapabilities;
	__u16 wWidth;
	__u16 wHeight;
	__u32 dwMinBitRate;
	__u32 dwMaxBitRate;
	__u32 dwMaxVideoFrameBufSize;
	__u32 dwDefaultFrameInterval;
	__u8  bFrameIntervalType;
	__u32 dwFrameInterval[NUM_MJPEG_FRMAE_INTERVALS];
} __attribute__ ((packed));

struct uvc_vs_frame_descriptor_frame_based {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bFrameIndex;
	__u8  bmCapabilities;
	__u16 wWidth;
	__u16 wHeight;
	__u32 dwMinBitRate;
	__u32 dwMaxBitRate;
	__u32 dwDefaultFrameInterval;
	__u8  bFrameIntervalType;
	__u32 dwBytesPerLine;
	__u32 dwMinFrameInterval;
	__u32 dwMaxFrameInterval;
	__u32 dwFrameIntervalStep;

} __attribute__ ((packed));


struct uvc_streaming_control_request {
	__u16 bmHint;
	__u8  bFormatIndex;
	__u8  bFrameIndex;
	__u32 dwFrameInterval;
	__u16 wKeyFrameRate;
	__u16 wPFrameRate;
	__u16 wCompQuality;
	__u16 wCompWindowSize;
	__u16 wDelay;
	__u32 dwMaxVideoFrameSize;
	__u32 dwMaxPayloadTransferSize;
#ifdef ENABLE_UVC_1_1
	__u32 dwClockFrequency;
	__u8  bmFramingInfo;
	__u8  bPreferedVersion;
	__u8  bMinVersion;
	__u8  bMaxVersion;
#endif
} __attribute__ ((packed));

typedef struct uvc_streaming_control_request uvc_streaming_control_t;

struct uvc_vidcap_extension_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	__u8  bDescriptorSubtype;
	__u8  bUnitID;
	__u8  guidExtensionCode[16];
	__u8  bNumControls;
	__u8  bNrInPins;
	__u8  baSourceID[1];
	__u8  bControlSize;		// Fixed at 4 bytes allowing 32 bit controls.
	__u8  bmControls[4];
	__u8  iExtension;
} __attribute__ ((packed));

typedef enum tag_selector_control_id_t
{
	SU_CONTROL_UNDEFINED =  0x00,
	SU_INPUT_SELECT_CONTROL = 0x01
} selector_control_id_t;


typedef enum tag_vc_interface_crl_id_t
{
	VC_CONTROL_UNDEFINED = 0x00,
	VC_VIDEO_POWER_MODE_CONTROL = 0x01,
	VC_REQUEST_ERROR_CODE_CONTROL = 0x02,
} vc_interface_crl_id_t;

typedef enum tag_vc_interface_error_code_t
{
	ERR_NONE			= 0x00,
	ERR_NOT_READY		= 0x01,
	ERR_WRONG_STATE		= 0x02,
	ERR_POWER			= 0x03,
	ERR_OUT_OF_RANGE	= 0x04,
	ERR__INVALID_UNIT	= 0x05,
	ERR__INVALID_CONTROL= 0x06,
	ERR_INVALID_REQUEST = 0x07,
	ERR_UNKNOWN			= 0xFF
}vc_interface_error_code_t;

typedef enum tag_uvc_vc_interface_descriptor_subtype_t
{
	VC_DESCRIPTOR_UNDEFINED = 0x00,
	VC_HEADER = 0x01,
	VC_INPUT_TERMINAL = 0x02,
	VC_OUTPUT_TERMINAL = 0x03,
	VC_SELECTOR_UNIT = 0x04,
	VC_PROCESSING_UNIT = 0x05,
	VC_EXTENSION_UNIT = 0x06
} uvc_vc_interface_descriptor_subtype_t;

typedef enum tag_uvc_vs_interface_descriptor_subtype_t
{
	VS_UNDEFINED = 0x00,
	VS_INPUT_HEADER = 0x01,
	VS_OUTPUT_HEADER  = 0x02,
	VS_STILL_IMAGE_FRAME = 0x03,
	VS_FORMAT_UNCOMPRESSED = 0x04,
	VS_FRAME_UNCOMPRESSED = 0x05,
	VS_FORMAT_MJPEG  = 0x06,
	VS_FRAME_MJPEG = 0x07,
	VS_Reserved1 =  0x08,
	VS_Reserved2 =  0x09,
	VS_FORMAT_MPEG2TS = 0x0A,
	VS_FORMAT_MPEG4SL = 0x0B,
	VS_FORMAT_DV = 0x0C,
	VS_COLORFORMAT = 0x0D,
	VS_Reserved4 = 0x0E,
	VS_Reserved5 = 0x0F,
	VS_FORMAT_FRAME_BASED = 0x10,
	VS_FRAME_FRAME_BASED = 0x11,
	VS_FORMAT_STREAM_BASED = 0x12
} uvc_vs_interface_descriptor_subtype_t;

//
// Enumeration to map GET_XX to base 1
// e.g. PROBE_INDEX_MIN points param structure corresponding to GET_MIN
//
typedef enum tag_probe_index_t
{
	PROBE_INDEX_MIN,	
	PROBE_INDEX_MAX,
	PROBE_INDEX_DEF,
	PROBE_INDEX_CUR,
	PROBE_INDEX_RES,
	PROBE_INDEX_LAST,
} probe_index_t;

#define BMHINT_FRAME_INTERVAL_MASK	0x0001	// D0: dwFrameInterval
#define BMHINT_KEYFRAME_RATE_MASK	0x0002	//D1: wKeyFrameRate
#define BMHINT_PFRAME_RATE_MASK		0x0004	//D2: wPFrameRate
#define BMHINT_COMP_QUALITY_MASK	0x0008	//D3: wCompQuality
#define BMHINT_COMP_WINDOW_SIZE		0x0010	//D4: wCompWindowSize

#define BMA_CTRL_KEY_FRAME_RATE			0x0001
#define BMA_CTRL_P_FRAME_RATE			0x0002
#define BMA_CTRL_COMP_QUALITY			0x0004
#define BMA_CTRL_COMP_WINDOW_SIZE		0x0008
#define BMA_CTRL_GEN_KEY_FRAME			0x0010
#define BMA_CTRL_UPDATE_FRAME_SEGMENT	0x0020


#define BMA_SUPPORTED_YUV420		(0)
//#define BMA_SUPPORTED_MJPEG		(BMA_CTRL_KEY_FRAME_RATE	| BMA_CTRL_P_FRAME_RATE | BMA_CTRL_COMP_QUALITY | BMA_CTRL_COMP_WINDOW_SIZE | BMA_CTRL_GEN_KEY_FRAME | BMA_CTRL_UPDATE_FRAME_SEGMENT)
#define BMA_SUPPORTED_MJPEG			(BMA_CTRL_COMP_QUALITY)
/*
** USB Device Class Definition for Video Devices: Compliance Test Specification
** TD 23.1
** If the Format is Stream-based, verify that the
** Header does not advertise that the Format support Frame Interval, KeyFrameRate or
** PFrameRate as a parameter
*/
#define BMHINT_SUPPORTED_H264_MP2TS	(0)
#define BMHINT_SUPPORTED_H264		(BMA_CTRL_KEY_FRAME_RATE	| BMA_CTRL_COMP_QUALITY	| BMA_CTRL_GEN_KEY_FRAME | BMA_CTRL_COMP_WINDOW_SIZE | BMA_CTRL_GEN_KEY_FRAME | BMA_CTRL_UPDATE_FRAME_SEGMENT)

struct usb_endpoint_descriptor;	// Defined in usb.h for linux

extern const struct usb_descriptor_header *uvc_interface_descriptors[];
extern const struct usb_descriptor_header *transcode_interface_descriptors[];
struct uvc_vs_frame_descriptor_mjpg *get_frame_descriptor(int index);
struct usb_endpoint_descriptor *get_endpoint_descriptor(int intf, int alt_setting);
struct usb_endpoint_descriptor *get_tr_endpoint_descriptor(int intf, int alt_setting);
#endif //__UVCDESCRIPT_H__
