/*
 * usb_cap_interface.c USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file implements careation UVC descriptors 
 *
 */

#include "uvcdescript.h"
#include "uvc_ext_api.h"
#include "vend_frame_descript.h"
#include "mjpg_frame_descript.h"

struct uvc_vs_input_header_descriptor_tr_t {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bNumFormats;
	__u16 wTotalLength;
	__u8  bEndpointAddress;
	__u8  bmInfo;
	__u8  bTerminalLink;
	__u8  bStillCaptureMethod;
	__u8  bTriggerSupport;
	__u8  bTriggerUsage;
	__u8  bControlSize;
	__u8  bmaControls[TRANS_SINK_FORMAT_INDEX_LAST - 1];

} __attribute__ ((packed));

struct uvc_vs_output_header_descriptor_tr_t {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bNumFormats;
	__u16 wTotalLength;
	__u8  bEndpointAddress;
	__u8  bTerminalLink;
	__u8  bControlSize;
} __attribute__ ((packed));

struct uvc_selector_unit_descriptor_enc {
	__u8  bLength;
	__u8  bDescriptorType;
	//--------------------
	__u8  bDescriptorSubType;
	__u8  bUnitID;
	__u8  bNrInPins;		// number of input pins
	__u8  baSourceID[ENC_INPUT_ID_LAST - 1];
	__u8  iSelector;
} __attribute__ ((packed));

struct uvc_videnc_extension_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	__u8  bDescriptorSubtype;
	__u8  bUnitID;
	__u8  guidExtensionCode[16];
	__u8  bNumControls;
	__u8  bNrInPins;
	__u8  baSourceID[1];
	__u8  bControlSize;		// Fixed at 4 bytes allowing 32 bit controls.
	__u8  bmControls[4];
	__u8  iExtension;
} __attribute__ ((packed));

struct uvc_viddec_extension_descriptor {
	__u8  bLength;
	__u8  bDescriptorType;
	__u8  bDescriptorSubtype;
	__u8  bUnitID;
	__u8  guidExtensionCode[16];
	__u8  bNumControls;
	__u8  bNrInPins;
	__u8  baSourceID[1];
	__u8  bControlSize;		// Fixed at 4 bytes allowing 32 bit controls.
	__u8  bmControls[4];
	__u8  iExtension;
} __attribute__ ((packed));

#if HAS_VID_TRANS == 1


#if HAS_ENC_ISOCH == 1
/* Video Transcode In for sending H.264 data to host*/
struct usb_endpoint_descriptor ep_trans_desc_enc = {
	.bLength 		= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN |  VID_TR_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_MP2TS_2),
	.bInterval		= 1
};
struct usb_endpoint_descriptor ep_trans_desc_dec = {
	.bLength 		= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_OUT |  VID_TR_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_MP2TS_2),
	.bInterval		= 1
};

#else
/* Video Transcode In for sending H.264 data to host*/
struct usb_endpoint_descriptor ep_trans_desc_enc = {
	.bLength 			= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_IN |  VID_TR_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_BULK,
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_ENC_BULK),
};

/* Video Transcode Out for getting MPEG2 data from host*/
struct usb_endpoint_descriptor ep_trans_desc_dec = {
	.bLength 			= USB_DT_ENDPOINT_SIZE,
	.bDescriptorType 	= USB_DT_ENDPOINT,
	.bEndpointAddress 	= USB_DIR_OUT |  VID_TR_EP_ADDR,
	.bmAttributes 		= USB_ENDPOINT_XFER_BULK,
	.wMaxPacketSize 	= __constant_cpu_to_le16(PKT_SIZE_DEC_BULK),
};
#endif


/******************************************************************************
 * IAD descriptor - describes VIC (Video Interface Collection) as Video Function
 * to group mulitple interfaces together in this 'Function'
 *
 ******************************************************************************/
static struct usb_interface_assoc_descriptor iad_desc_tr_dec = 
{
	.bLength 		= sizeof(struct usb_interface_assoc_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE_ASSOCIATION,
	.bFirstInterface	= UVC_TRANS_CTRL_OUT_INDEX, // interface # of the VideoControl interface that is associated with this function
	.bInterfaceCount	= 2,		// Control + 2 streams
	.bFunctionClass		= 0x0E,		// UVC_CC_VIDEO,
	.bFunctionSubClass	= 0x03,		// UVC_SC_VIDEO_INTERFACE_COLLECTION,
	.bFunctionProtocol	= 0x00,		// UVC_PC_PROTOCOL_UNDEFINED,
	.iFunction		= STN_PRODUCT	// Index of a string descriptor that describes this interface. 
									// This must be used for the device (function) name and be 
									// implemented in US English (LANGID = 0x0409) at the minimum.
};
static struct usb_interface_assoc_descriptor iad_desc_tr_enc = 
{
	.bLength 		= sizeof(struct usb_interface_assoc_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE_ASSOCIATION,
	.bFirstInterface	= UVC_ENC_CTRL_IN_INDEX,		// interface # of the VideoControl interface that is associated with this function
	.bInterfaceCount	= 2,							// Control + 2 streams
	.bFunctionClass		= 0x0E,							// UVC_CC_VIDEO,
	.bFunctionSubClass	= 0x03,							// UVC_SC_VIDEO_INTERFACE_COLLECTION,
	.bFunctionProtocol	= 0x00,							// UVC_PC_PROTOCOL_UNDEFINED,
	.iFunction		= STN_PRODUCT						// Index of a string descriptor that describes this interface. 
														// This must be used for the device (function) name and be 
														// implemented in US English (LANGID = 0x0409) at the minimum.
};

static const struct usb_interface_descriptor standard_vc_interface_descriptor_tr_dec = {
	.bLength 		= sizeof(struct usb_interface_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_TRANS_CTRL_OUT_INDEX,
	.bAlternateSetting	= 0,
	.bNumEndpoints 		= 0,	
	.bInterfaceClass 	= 0x0E,	// CC_VIDEO,
	.bInterfaceSubClass	= 0x01,	// SC_VIDEOCONTROL,
	.bInterfaceProtocol	= 0x00,
	.iInterface 		= STN_PRODUCT,
};

static const struct usb_interface_descriptor standard_vc_interface_descriptor_tr_enc = {
	.bLength 		= sizeof(struct usb_interface_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_ENC_CTRL_IN_INDEX,
	.bAlternateSetting	= 0,
	.bNumEndpoints 		= 0,	
	.bInterfaceClass 	= 0x0E,	// CC_VIDEO,
	.bInterfaceSubClass	= 0x01,	// SC_VIDEOCONTROL,
	.bInterfaceProtocol	= 0x00,
	.iInterface 		= STN_PRODUCT,
};

static const struct uvc_vc_interface_descriptor_transcode class_specific_vc_interface_descriptor_dec = {
	.bLength 		= sizeof(struct uvc_vc_interface_descriptor_transcode), 
	.bDescriptorType 	= UVC_CS_INTERFACE,
	.bDescriptorSubType	= VC_HEADER,
#ifdef ENABLE_UVC_1_1
	.bcdUVC			= 0x0110,
#else
	.bcdUVC			= 0x0100,
#endif
	.wTotalLength		= sizeof(struct uvc_vc_interface_descriptor_transcode) + 
							sizeof(struct uvc_input_terminal_descriptor) +
							sizeof(struct uvc_output_terminal_descriptor) +
							sizeof(struct uvc_processing_unit_descriptor) +
							sizeof(struct uvc_viddec_extension_descriptor),
	.dwClockFrequency	= 6000000,
	.bInCollection		= 0x01,			// number of streaming interfaces
	.baInterfaceNr[0]	= UVC_TRANS_STRM_OUT_INDEX,
};

static const struct uvc_vc_interface_descriptor_transcode class_specific_vc_interface_descriptor_enc = {
	.bLength 		= sizeof(struct uvc_vc_interface_descriptor_transcode), 
	.bDescriptorType 	= UVC_CS_INTERFACE,
	.bDescriptorSubType	= VC_HEADER,
#ifdef ENABLE_UVC_1_1
	.bcdUVC			= 0x0110,
#else
	.bcdUVC			= 0x0100,
#endif
	.wTotalLength		= sizeof(struct uvc_vc_interface_descriptor_transcode) + 
							sizeof(struct uvc_input_terminal_descriptor) +
							sizeof(struct uvc_input_terminal_descriptor) +
							sizeof(struct uvc_output_terminal_descriptor) +
							sizeof(struct uvc_selector_unit_descriptor_enc) +
							sizeof(struct uvc_processing_unit_descriptor) +
							sizeof(struct uvc_videnc_extension_descriptor),
	.dwClockFrequency	= 6000000,
	.bInCollection		= 0x01,			// number of streaming interfaces
	.baInterfaceNr[0]	= UVC_ENC_STRM_IN_INDEX,
};


// OT descriptor (to the host)
static const struct uvc_output_terminal_descriptor intf_ot_dec_internal = {
	.bLength			= sizeof(struct uvc_output_terminal_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_OUTPUT_TERMINAL,
	.bTerminalID		= DEC_UNIT_ID_OUT_TERMINAL, // ID of this terminal 
	.wTerminalType		= UVC_TT_VENDOR_SPECIFIC, // this terminal is the composite connector
	.bAssocTerminal		= 0x00, // no association
	.bSourceID			= DEC_UNIT_ID_EXT, // dec Processing unit
	.iTerminal			= 0x00, // unused
};

// OT descriptor (to the host)
static const struct uvc_input_terminal_descriptor intf_it_dec = {
	.bLength			= sizeof(struct uvc_input_terminal_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_INPUT_TERMINAL,
	.bTerminalID		= DEC_UNIT_ID_INPUT,	// ID of this terminal 
	.wTerminalType		= UVC_TT_STREAMING,		// this terminal is the composite connector
	.bAssocTerminal		= 0x00, // no association
	.iTerminal			= 0x00, // unused
};


struct uvc_processing_unit_descriptor processing_unit_descriptor_tr_dec = {
	.bLength		= sizeof(struct uvc_processing_unit_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType	= VC_PROCESSING_UNIT,
	.bUnitID		= DEC_UNIT_ID_PROCESSOR,
	.bSourceID		= DEC_UNIT_ID_INPUT,
	.wMaxMultiplier		= 0x0000,
#ifdef ENABLE_UVC_1_1
	.bControlSize		= 0x03,
	.bmControls		= {0x00,0x00,0x00},
#else
	.bControlSize		= 0x02,
	.bmControls		= {0x00,0x00},

#endif
	.iProcessing		= 0x00
};

// OT descriptor (to the host)
static const struct uvc_input_terminal_descriptor intf_it_internal_avdec = {
	.bLength			= sizeof(struct uvc_input_terminal_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_INPUT_TERMINAL,
	.bTerminalID		= ENC_INPUT_ID_AVDEC,		
	.wTerminalType		= UVC_ITT_VENDOR_SPECIFIC,	
	.bAssocTerminal		= 0x00,						// no association
	.iTerminal			= 0x00,						// unused
};

// OT descriptor (to the host)
static const struct uvc_input_terminal_descriptor intf_it_internal_lvpp = {
	.bLength			= sizeof(struct uvc_input_terminal_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_INPUT_TERMINAL,
	.bTerminalID		= ENC_INPUT_ID_LVPP,		
	.wTerminalType		= UVC_ITT_VENDOR_SPECIFIC,	
	.bAssocTerminal		= 0x00,						// no association
	.iTerminal			= 0x00,						// unused
};

// OT descriptor (to the host)
static const struct uvc_output_terminal_descriptor intf_ot_enc = {
	.bLength			= sizeof(struct uvc_output_terminal_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType = VC_OUTPUT_TERMINAL,
	.bTerminalID		= ENC_UNIT_ID_OUT_TERMINAL,
	.wTerminalType		= UVC_TT_STREAMING,			// this terminal is sttreaming
	.bAssocTerminal		= 0x00,						// no association
	.bSourceID			= ENC_UNIT_ID_EXT,			// ENC_UNIT_ID_PROCESSOR
	.iTerminal			= 0x00,						// unused
};


struct uvc_selector_unit_descriptor_enc selector_unit_descriptor_enc = {
	.bLength		= sizeof(struct uvc_selector_unit_descriptor_enc),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType	= VC_SELECTOR_UNIT,
	.bUnitID			= ENC_UNIT_SELECTOR_ID,
	.bNrInPins			= ENC_INPUT_ID_LAST - 1,
	.baSourceID = {
		ENC_INPUT_ID_AVDEC,
		ENC_INPUT_ID_LVPP,
	},
	.iSelector			= 0x00	// Not used
};

struct uvc_processing_unit_descriptor processing_unit_descriptor_tr_enc = {
	.bLength		= sizeof(struct uvc_processing_unit_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubType	= VC_PROCESSING_UNIT,
	.bUnitID		= ENC_UNIT_ID_PROCESSOR,
	.bSourceID		= ENC_UNIT_SELECTOR_ID,
	.wMaxMultiplier		= 0x0000,
#ifdef ENABLE_UVC_1_1
	.bControlSize		= 0x03,
	.bmControls		= {0x00,0x00,0x00},
#else
	.bControlSize		= 0x02,
	.bmControls		= {0x00,0x00},

#endif
	.iProcessing		= 0x00
};

struct uvc_videnc_extension_descriptor extension_unit_descriptor_tr_enc = 
{
	.bLength			= sizeof(struct uvc_videnc_extension_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubtype	= VC_EXTENSION_UNIT,
	.bUnitID			= ENC_UNIT_ID_EXT,
	.guidExtensionCode	= GUID_VIDENC_EXT,
	.bNumControls		= UVC_EXT_PARAM_ID_LAST - 1,
	.bNrInPins			= 0x01,
	.baSourceID			= {ENC_UNIT_ID_PROCESSOR},
	.bControlSize		= 4,
	.bmControls			= UVC_EXT_CTRL_COUNT_MASK,
	.iExtension			= 0x00,
};

struct uvc_viddec_extension_descriptor extension_unit_descriptor_tr_dec = 
{
	.bLength			= sizeof(struct uvc_viddec_extension_descriptor),
	.bDescriptorType	= UVC_CS_INTERFACE,
	.bDescriptorSubtype	= VC_EXTENSION_UNIT,
	.bUnitID			= DEC_UNIT_ID_EXT,
	.guidExtensionCode	= GUID_VIDDEC_EXT,
	.bNumControls		= UVC_EXT_DEC_PARAM_ID_LAST - 1,
	.bNrInPins			= 0x01,
	.baSourceID			= {DEC_UNIT_ID_PROCESSOR},
	.bControlSize		= 4,
	.bmControls			= UVC_DEC_EXT_CTRL_COUNT_MASK,
	.iExtension			= 0x00,
};

/**
 *  if HAS_ENC_ISOCH == 0, this interface desribes bulk end point.
 */
static const struct usb_interface_descriptor standard_vs_interface_descriptor_tr_enc_alt0 = {
	.bLength 			= sizeof(struct usb_interface_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_ENC_STRM_IN_INDEX,
	.bAlternateSetting	= 0,
#if HAS_ENC_ISOCH == 1
	.bNumEndpoints 		= 0,						// isoch end point	
#else
	.bNumEndpoints 		= 1,						// bulk end point
#endif
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING		
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00					// Unused
};

static const struct usb_interface_descriptor standard_vs_interface_descriptor_tr_enc_alt1 = {
	.bLength 		= sizeof(struct usb_interface_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_ENC_STRM_IN_INDEX,
	.bAlternateSetting	= 1,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};

static const struct usb_interface_descriptor standard_vs_interface_descriptor_tr_dec_alt0 = {
	.bLength 			= sizeof(struct usb_interface_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_TRANS_STRM_OUT_INDEX,
	.bAlternateSetting	= 0,
#if HAS_DEC_ISOCH == 1
	.bNumEndpoints 		= 0,						// # of EP's excluding EP0
#else
	.bNumEndpoints 		= 1,						// bulk end point
#endif
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00					// Unused
};

static const struct usb_interface_descriptor standard_vs_interface_descriptor_tr_dec_alt1 = {
	.bLength 		= sizeof(struct usb_interface_descriptor),
	.bDescriptorType 	= USB_DT_INTERFACE,
	.bInterfaceNumber	= UVC_TRANS_STRM_OUT_INDEX,
	.bAlternateSetting	= 1,
	.bNumEndpoints 		= 1,						// # of EP's excluding EP0
	.bInterfaceClass 	= 0x0E, //CC_VIDEO
	.bInterfaceSubClass	= 0x02,	// SC_VIDEOSTREAMING
	.bInterfaceProtocol = 0x00,
	.iInterface 		= 0x00,
};


struct uvc_vs_input_header_descriptor_tr_t vs_header_descriptor_tr_enc =  {
	.bLength 			= sizeof( struct uvc_vs_input_header_descriptor_tr_t),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_INPUT_HEADER,
	.bNumFormats			= TRANS_SINK_FORMAT_INDEX_LAST - 1,
	.wTotalLength			= sizeof(struct uvc_vs_input_header_descriptor_tr_t) 
#if HAS_MJPEG_PREV == 1
					+ sizeof(struct uvc_vs_format_descriptor)	/*MJPG*/ 
					+ sizeof(struct uvc_vs_frame_descriptor_mjpg) * ( MJPEG_FRAME_INDEX_LAST - 1)
#endif
#if HAS_H264_MP2TS_TRANS_SINK == 1
					+ sizeof(struct uvc_vs_format_descriptor_mp2ts_t)/*MP2TS-AVC1*/
#endif
#if HAS_H264_VEN_STREAM_TRANS_SINK == 1
					+ sizeof(struct uvc_vs_format_descriptor_mp2ts_t)/*MP2TS-AVC1*/
#endif

#if HAS_H264_VEN_FRAME_TRANS_SINK == 1
							+ sizeof(struct uvc_vs_format_descriptor_frame_based)	/*H264*/ 
							+ sizeof(struct uvc_vs_frame_descriptor_frame_based) * ( H264_TRANS_SINK_FRAME_INDEX_LAST - 1)
#endif

					,	/* Comma here */
	.bEndpointAddress 	= USB_DIR_IN |  VID_TR_EP_ADDR,
	.bmInfo					= 0x00,
	.bTerminalLink			= ENC_UNIT_ID_OUT_TERMINAL,	// intf_ot
	.bStillCaptureMethod	= 0x00,	// Supported
	.bTriggerSupport		= 0x00,	// Hardware trigger
	.bTriggerUsage			= 0x00,
	.bControlSize			= 0x01,	// Size of BMA Control filed
	.bmaControls		= {
#if HAS_MJPEG_PREV == 1
					BMA_SUPPORTED_MJPEG,	
#endif
#if HAS_H264_MP2TS_TRANS_SINK
					BMHINT_SUPPORTED_H264_MP2TS,
#endif
#if HAS_H264_VEN_STREAM_TRANS_SINK
					BMHINT_SUPPORTED_H264_MP2TS,
#endif
#if HAS_H264_VEN_FRAME_TRANS_SINK
					BMHINT_SUPPORTED_H264,
#endif
	}

};
struct uvc_vs_output_header_descriptor_tr_t vs_header_descriptor_tr_dec =  {
	.bLength 			= sizeof( struct uvc_vs_output_header_descriptor_tr_t),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_OUTPUT_HEADER,
	.bNumFormats			= TRANS_SOURCE_FORMAT_INDEX_LAST - 1,
	.wTotalLength			= sizeof(struct uvc_vs_output_header_descriptor_tr_t) 
#if HAS_H264_MP2TS_TRANS_SOURCE == 1
							+ sizeof(struct uvc_vs_format_descriptor_mp2ts_t)
#endif
#if HAS_H264_VEN_TRANS_SOURCE  == 1
							+ sizeof(struct uvc_vs_format_descriptor_mp2ts_t)
#endif
					,	/* Comma here */
	.bEndpointAddress 	= USB_DIR_OUT |  VID_TR_EP_ADDR,
	.bTerminalLink			= DEC_UNIT_ID_INPUT,
	.bControlSize	= 0
};


#if HAS_MJPEG_PREV ==  1
struct uvc_vs_format_descriptor vs_format_descriptor_mjpg =  {
	.bLength 			= sizeof(vs_format_descriptor_mjpg),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_MJPEG,
	.bFormatIndex			= MJPEG_FORMAT_TRANS_SINK_INDEX,
	.bNumFrameDescriptors	= (MJPEG_FRAME_INDEX_LAST - 1),
	.bmFlags				= 0x00,
	.bDefaultFrameIndex		= 0x01,
	.bAspectRatioX			= 0x00,
	.bAspectRatioY			= 0x00,
	.bmInterlaceFlags		= 0x00,
	.bCopyProtect			= 0x00
};
#endif

#if HAS_H264_VEN_FRAME_TRANS_SINK
struct uvc_vs_format_descriptor_frame_based vs_format_descriptor_sink_h264 =  {
	.bLength 			= sizeof(struct uvc_vs_format_descriptor_frame_based),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_FRAME_BASED,
	.bFormatIndex			= H264_FORMAT_VEN_TRANS_SINK_INDEX,
	.bNumFrameDescriptors	= (H264_TRANS_SINK_FRAME_INDEX_LAST - 1),
	.bDefaultFrameIndex		= 0x01,
	.bAspectRatioX			= 0x00,
	.bAspectRatioY			= 0x00,
	.bmInterlaceFlags		= 0x00,
	.bCopyProtect			= 0x00,
	.bVariableSize			= 0x01
};
#endif

#if HAS_H264_MP2TS_TRANS_SINK == 1

struct uvc_vs_format_descriptor_mp2ts_t vs_format_descriptor_h264_mpeg2ts_tr =  {
	.bLength 			= sizeof(struct uvc_vs_format_descriptor_mp2ts_t),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_MPEG2TS,
	.bFormatIndex			= H264_FORMAT_MP2TS_TRANS_SINK_INDEX,
	.bDataOffset			= 0,
 	.bPacketLength			= 188,
 	.bStrideLength			= 188
};
#endif

/**
 * Use MP2TS descriptor for stream based until the code is completely moved to uvc 1.1
 */
#if HAS_H264_VEN_STREAM_TRANS_SINK == 1

struct uvc_vs_format_descriptor_mp2ts_t vs_format_descriptor_h264_ven_stream_tr =  {
	.bLength 			= sizeof(struct uvc_vs_format_descriptor_mp2ts_t),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_MPEG2TS,
	.bFormatIndex			= H264_FORMAT_VEN_STREAM_TRANS_SINK_INDEX,
	.bDataOffset			= 0,
 	.bPacketLength			= 188,
 	.bStrideLength			= 188
};
#endif

#if HAS_H264_MP2TS_TRANS_SOURCE == 1
struct uvc_vs_format_descriptor_mp2ts_t vs_trans_format_descriptor_mpeg2ts =  {
	.bLength 			= sizeof(struct uvc_vs_format_descriptor_mp2ts_t),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_MPEG2TS,
	.bFormatIndex			= H264_FORMAT_MP2TS_TRANS_SOURCE_INDEX, 
	.bDataOffset			= 0,
 	.bPacketLength			= 188,
 	.bStrideLength			= 188
};
#endif

#if HAS_H264_VEN_TRANS_SOURCE == 1
struct uvc_vs_format_descriptor_mp2ts_t vs_trans_src_format_descriptor_ven =  {
	.bLength 			= sizeof(vs_trans_src_format_descriptor_ven),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FORMAT_STREAM_BASED,
	.bFormatIndex			= H264_FORMAT_VEN_TRANS_SOURCE_INDEX,
	.bDataOffset			= 0,
 	.bPacketLength			= 188,
 	.bStrideLength			= 188
};
#endif

#endif

/******************************************************************************
 * Full & high speed endpoints: 
 *
 * usb 2.0 devices need to expose both high speed and full speed
 * descriptors, unless they only run at full speed.
 *
 * that means alternate endpoint descriptors (bigger packets)
 * and a "device qualifier" ... plus more construction options
 * for the config descriptor.
 ******************************************************************************/



/******************************************************************************
 * USB function
 ******************************************************************************/
const struct usb_descriptor_header *transcode_interface_descriptors[] = {
#if HAS_VID_TRANS == 1
	/* Video Encoder interface */
	(struct usb_descriptor_header *) &iad_desc_tr_enc,
	(struct usb_descriptor_header *) &standard_vc_interface_descriptor_tr_enc,
	(struct usb_descriptor_header *) &class_specific_vc_interface_descriptor_enc,
	(struct usb_descriptor_header *) &intf_it_internal_lvpp,
	(struct usb_descriptor_header *) &intf_it_internal_avdec,
	(struct usb_descriptor_header *) &intf_ot_enc,
	(struct usb_descriptor_header *) &selector_unit_descriptor_enc,
	(struct usb_descriptor_header *) &processing_unit_descriptor_tr_enc,
	(struct usb_descriptor_header *) &extension_unit_descriptor_tr_enc,
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_tr_enc_alt0,
	(struct usb_descriptor_header *) &vs_header_descriptor_tr_enc,

#if HAS_MJPEG_PREV == 1
	(struct usb_descriptor_header *) &vs_format_descriptor_mjpg,
	DEFINE_MJPG_FRAME_DESCRIPT
#endif // MJPEG FORMAT

#if HAS_H264_MP2TS_TRANS_SINK == 1
	(struct usb_descriptor_header *) &vs_format_descriptor_h264_mpeg2ts_tr,
#endif
#if HAS_H264_VEN_STREAM_TRANS_SINK == 1
	(struct usb_descriptor_header *) &vs_format_descriptor_h264_ven_stream_tr,
#endif
	
#if HAS_H264_VEN_FRAME_TRANS_SINK == 1
	(struct usb_descriptor_header *) &vs_format_descriptor_sink_h264,
	DEFINE_VEN_FRAME_DESCRIPT
#endif

#if HAS_ENC_ISOCH == 1
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_tr_enc_alt1,
#endif
	(struct usb_descriptor_header *) &ep_trans_desc_enc,

	/* Video Decoder interface */
	(struct usb_descriptor_header *) &iad_desc_tr_dec,
	(struct usb_descriptor_header *) &standard_vc_interface_descriptor_tr_dec,
	(struct usb_descriptor_header *) &class_specific_vc_interface_descriptor_dec,
	(struct usb_descriptor_header *) &intf_it_dec,
	(struct usb_descriptor_header *) &intf_ot_dec_internal,
	(struct usb_descriptor_header *) &processing_unit_descriptor_tr_dec,
	(struct usb_descriptor_header *) &extension_unit_descriptor_tr_dec,

	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_tr_dec_alt0,
	(struct usb_descriptor_header *) &vs_header_descriptor_tr_dec,
#if HAS_H264_MP2TS_TRANS_SOURCE == 1
	(struct usb_descriptor_header *) &vs_trans_format_descriptor_mpeg2ts,
#endif
#if HAS_H264_VEN_TRANS_SOURCE == 1
	(struct usb_descriptor_header *) &vs_trans_src_format_descriptor_ven,
#endif
#if HAS_DEC_ISOCH == 1
	(struct usb_descriptor_header *) &standard_vs_interface_descriptor_tr_dec_alt1,
#endif
	(struct usb_descriptor_header *) &ep_trans_desc_dec,
#endif // HAS_VID_TRANS == 1
	NULL,
};

struct usb_endpoint_descriptor *get_tr_endpoint_descriptor(int intf, int alt_setting)
{
#if HAS_VID_TRANS == 1
	if(intf == UVC_ENC_STRM_IN_INDEX) {
		return &ep_trans_desc_enc;
	} else	if(intf == UVC_TRANS_STRM_OUT_INDEX) {
		return &ep_trans_desc_dec;
	}
	return NULL;
#else
	return 0;
#endif
}
