/*
 * usb_pu_ctrl.c USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file implements handling of process unit API 
 *
 */

#include "uvcdescript.h"
#include "uvc_codec_if.h"
#include "uvc_callback.h"

#include "dbgout.h"
#define INDX_MIN	0
#define INDX_MAX	1
#define INDX_DEF	2
#define INDX_RES	3
#define INDX_CUR	4
#define INDX_LAST	5


struct vid_pu_param_t
{
	__u16 wBacklightCompensation[INDX_LAST];
	__u16 wBrightness[INDX_LAST];		
	__u16 wContrast[INDX_LAST];
	__u16 wGain[INDX_LAST];
	__u8  bPowerLineFrequency[INDX_LAST];
	__u16 wHue[INDX_LAST];
	__u8  bHueAuto[INDX_LAST];
	__u16 wSaturation[INDX_LAST];
	__u16 wSharpness[INDX_LAST];
	__u16 wGamma[INDX_LAST];
	__u16 wWhiteBalanceTemperature[INDX_LAST];
	__u8  bWhiteBalanceTemperatureAuto[INDX_LAST];
	__u16 wWhiteBalanceBlue[INDX_LAST];
	__u16 wWhiteBalanceRed[INDX_LAST];
	__u8  bWhiteBalanceComponentAuto[INDX_LAST];
	__u16 wMultiplierStep[INDX_LAST];	
	__u16 wMultiplierLimit[INDX_LAST];	
};


// TODO : Fill with suitable values based on the Camera capabilities
struct vid_pu_param_t vid_pu_param = 
{
                                /*min    max    def    res    cur*/
  .wBacklightCompensation =	    {0,      0,     0,     0,     0},
  .wBrightness  =				{0,      100,   0,     1,     0},
  .wContrast =                  {0,      4,     4,     1,     4},
  .wGain =                      {0,      0,     0,     0,     0},
  .bPowerLineFrequency = 	    {0,      0,     0,     0,     0},
  .wHue =                       {0,      0,     0,     0,     0},
  .bHueAuto =                   {0,      0,     0,     0,     0},
  .wSaturation =                {0,      100,   100,   1,     100},
  .wSharpness = 	            {0,      0,     0,     0,     0},
  .wGamma =                     {100,    500,   100,   1,     100},
  .wWhiteBalanceTemperature =   {0,      0,     0,     0,     0},
  .bWhiteBalanceTemperatureAuto={0,      0,     0,     0,     0},
  .wWhiteBalanceBlue =          {0,      0,     0,     0,     0},
  .wWhiteBalanceRed =           {0,      0,     0,     0,     0},
  .bWhiteBalanceComponentAuto = {0,      0,     0,     0,     0},
  .wMultiplierStep =            {0,      0,     0,     0,     0},
  .wMultiplierLimit =           {0,      0,     0,     0,     0}	
};

static int ProcessWRequest(__u16	*pwParamBase, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int result = -1;
	switch(ctrl->bRequest){
		case SET_CUR:
			pwParamBase[INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[0]);
			result = 0;
			break;
		case GET_CUR:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase[INDX_CUR]);
			result = 2;
			break;
		case GET_MIN:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase[INDX_MIN]);
			result = 2;
			break;

		case GET_MAX:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase[INDX_MAX]);
			result = 2;
			break;

		case GET_RES:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase[INDX_RES]);
			result = 2;
			break;
		case GET_DEF:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase[INDX_DEF]);
			result = 2;
			break;

		case GET_LEN:
			req_buf[0] = 2;
			result = 1;
			break;

		case GET_INFO:
			*(__u8*)req_buf = 0x03;
			result = 1;
			break;
		default:
			UAV_DBG_MSG("Unknown Request %d\n",ctrl->bRequest);

	}
	return result;
}
static int ProcessBRequest(__u8	*pbParamBase, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int result = -1;
	switch(ctrl->bRequest){
		case SET_CUR:
			pbParamBase[INDX_CUR] = req_buf[0];
			result = 0;
			break;
		case GET_CUR:
			req_buf[0] = pbParamBase[INDX_CUR];
			result = 1;
			break;
		case GET_MIN:
			req_buf[0] = pbParamBase[INDX_MIN];
			result = 1;
			break;

		case GET_MAX:
			req_buf[0] = pbParamBase[INDX_MAX];
			result = 1;
			break;

		case GET_RES:
			req_buf[0] = pbParamBase[INDX_RES];
			result = 1;
			break;
		case GET_DEF:
			req_buf[0] = pbParamBase[INDX_DEF];
			result = 1;
			break;

		case GET_LEN:
			req_buf[0] = 1;
			result = 1;
			break;

		case GET_INFO:
			*(__u8*)req_buf = 0x03;
			result = 1;
			break;
		default:
			UAV_DBG_MSG("Unknown Request %d\n",ctrl->bRequest);

	}
	return result;
}
static int Process2WRequest(__u16	*pwParamBase0, __u16	*pwParamBase1, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int result = -1;
	switch(ctrl->bRequest){
		case SET_CUR:
			pwParamBase0[INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[0]);
			pwParamBase1[INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[2]);
			result = 0;
			break;
		case GET_CUR:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase0[INDX_CUR]);
			*(__le16 *)&req_buf[2] = __cpu_to_le16(pwParamBase1[INDX_CUR]);
			result = 4;
			break;
		case GET_MIN:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase0[INDX_MIN]);
			*(__le16 *)&req_buf[2] = __cpu_to_le16(pwParamBase1[INDX_MIN]);
			result = 4;
			break;

		case GET_MAX:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase0[INDX_MAX]);
			*(__le16 *)&req_buf[2] = __cpu_to_le16(pwParamBase1[INDX_MAX]);
			result = 4;
			break;

		case GET_RES:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase0[INDX_RES]);
			*(__le16 *)&req_buf[2] = __cpu_to_le16(pwParamBase1[INDX_RES]);
			result = 4;
			break;
		case GET_DEF:
			*(__le16 *)&req_buf[0] = __cpu_to_le16(pwParamBase0[INDX_DEF]);
			*(__le16 *)&req_buf[2] = __cpu_to_le16(pwParamBase1[INDX_DEF]);
			result = 4;
			break;

		case GET_LEN:
			req_buf[0] = 4;
			result = 1;
			break;

		case GET_INFO:
			*(__u8*)req_buf = 0x03;
			result = 1;
			break;
		default:
			UAV_DBG_MSG("Unknown Request %d\n",ctrl->bRequest);
			break;
	}
	return 0;
}

int handle_pu_control(void *pCtx, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	struct vid_pu_param_t *pPram = (struct vid_pu_param_t *)pCtx;
	pu_config_t PuCfg = {0};
	pu_config_t *pPuCfg = &PuCfg;
	int result = 0;
	__u16	w_value = __le16_to_cpu(ctrl->wValue);
	//__u16	w_length = __le16_to_cpu(ctrl->wLength);
	int control_selector = w_value  >> 8;
	__u16	*pwParamBase = 0;
	__u8	*pbParamBase = 0;
	pu_get_state(pPuCfg);
	pPuCfg->dwStreamId = STREAM_ID_PU;
	UAV_DBG_MSG("control_selector=%d\n",control_selector);
	switch(control_selector){
		case PU_BACKLIGHT_COMPENSATION_CONTROL:
			pwParamBase = pPram->wBacklightCompensation;
			result =  ProcessWRequest(pwParamBase, req_buf, ctrl);
			if(ctrl->bRequest == SET_CUR) {
				pPuCfg->dwBacklightCompensation = pPram->wBacklightCompensation[INDX_CUR];
			}
			break;
		case PU_BRIGHTNESS_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->wBrightness[INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[0]);
					pPuCfg->dwBrightness = pPram->wBrightness[INDX_CUR];
					result = 0;
					break;
				case GET_CUR:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wBrightness[INDX_CUR]);
					result = 2;
					break;
				case GET_MIN:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wBrightness[INDX_MIN]);
					result = 2;
					break;

				case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wBrightness[INDX_MAX]);
					result = 2;
					break;

				case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wBrightness[INDX_RES]);
					result = 2;
					break;
				case GET_DEF:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wBrightness[INDX_DEF]);
					result = 2;
					break;

				case GET_LEN:
					req_buf[0] = 2;
					req_buf[1] = 0;
					result = 2;
					break;

				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				default:
					UAV_DBG_MSG("Unknown Request %d\n",ctrl->bRequest);

			}
			break;


		case PU_CONTRAST_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->wContrast[INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[0]);
					pPuCfg->dwContrast = pPram->wContrast[INDX_CUR];
					result = 0;
					break;
				case GET_CUR:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wContrast[INDX_CUR]);
					result = 2;
					break;
				case GET_MIN:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wContrast[INDX_MIN]);
					result = 2;
					break;

				case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wContrast[INDX_MAX]);
					result = 2;
					break;

				case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wContrast[INDX_RES]);
					result = 2;
					break;
				case GET_DEF:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wContrast[INDX_DEF]);
					result = 2;
					break;

				case GET_LEN:
					req_buf[0] = 2;
					req_buf[1] = 0;
					result = 2;
					break;

				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				default:
					UAV_DBG_MSG("Unknown Request %d\n",ctrl->bRequest);

			}
			break;
			
		case PU_POWER_LINE_FREQUENCY_CONTROL:
			pbParamBase = pPram->bPowerLineFrequency;
			result =  ProcessBRequest(pbParamBase, req_buf, ctrl);
			break;
		case PU_HUE_CONTROL:
			pwParamBase = pPram->wHue;
			result =  ProcessWRequest(pwParamBase, req_buf, ctrl);
			if(ctrl->bRequest == SET_CUR) {
				pPuCfg->dwHue = pPram->wHue[INDX_CUR];
			}
			break;
		case PU_HUE_AUTO_CONTROL:
			pbParamBase = pPram->bHueAuto;
			result =  ProcessBRequest(pbParamBase, req_buf, ctrl);
			break;
		case PU_SATURATION_CONTROL:
			pwParamBase = pPram->wSaturation;
			result =  ProcessWRequest(pwParamBase, req_buf, ctrl);
			if(ctrl->bRequest == SET_CUR) {
				pPuCfg->dwSaturation = pPram->wSaturation[INDX_CUR];
			}
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->wSaturation[INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[0]);
					pPuCfg->dwSaturation = pPram->wSaturation[INDX_CUR];
					result = 0;
					break;
				case GET_CUR:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wSaturation[INDX_CUR]);
					result = 2;
					break;
				case GET_MIN:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wSaturation[INDX_MIN]);
					result = 2;
					break;

				case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wSaturation[INDX_MAX]);
					result = 2;
					break;

				case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wSaturation[INDX_RES]);;
					result = 2;
					break;
				case GET_DEF:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wSaturation[INDX_DEF]);
					result = 2;
					break;

				case GET_LEN:
					req_buf[0] = 2;
					req_buf[1] = 0;
					result = 2;
					break;

				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				default:
					UAV_DBG_MSG("Unknown Request %d\n",ctrl->bRequest);

			}
			break;



			break;
		case PU_SHARPNESS_CONTROL:
			pwParamBase = pPram->wSharpness;
			result =  ProcessWRequest(pwParamBase, req_buf, ctrl);
			if(ctrl->bRequest == SET_CUR) {
				pPuCfg->dwSharpness = pPram->wSharpness[INDX_CUR];
			}

			break;
		case PU_GAMMA_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->wGamma[INDX_CUR] = __le16_to_cpup((__le16 *)&req_buf[0]);
					pPuCfg->dwGamma = pPram->wGamma[INDX_CUR];
					result = 0;
					break;
				case GET_CUR:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wGamma[INDX_CUR]);
					result = 2;
					break;
				case GET_MIN:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wGamma[INDX_MIN]);
					result = 2;
					break;

				case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wGamma[INDX_MAX]);
					result = 2;
					break;

				case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wGamma[INDX_RES]);;
					result = 2;
					break;
				case GET_DEF:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wGamma[INDX_DEF]);
					result = 2;
					break;

				case GET_LEN:
					req_buf[0] = 2;
					req_buf[1] = 0;
					result = 2;
					break;

				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				default:
					UAV_DBG_MSG("Unknown Request %d\n",ctrl->bRequest);

			}
			break;

		case PU_WHITE_BALANCE_TEMPERATURE_CONTROL:
			pwParamBase = pPram->wWhiteBalanceTemperature;
			result = ProcessWRequest(pwParamBase, req_buf, ctrl);
			break;
		case PU_WHITE_BALANCE_TEMPERATURE_AUTO_CONTROL:
			pbParamBase = pPram->bWhiteBalanceTemperatureAuto;
			result =  ProcessBRequest(pbParamBase, req_buf, ctrl);
			break;
		case PU_WHITE_BALANCE_COMPONENT_CONTROL:
			{
				__u16	*pwParamBase0 = pPram->wWhiteBalanceBlue;
				__u16	*pwParamBase1 = pPram->wWhiteBalanceRed;
				result =  Process2WRequest(pwParamBase0,pwParamBase1,  req_buf, ctrl);
			}
			break;

		case PU_WHITE_BALANCE_COMPONENT_AUTO_CONTROL:
			pbParamBase = pPram->bWhiteBalanceComponentAuto;
			result =  ProcessBRequest(pbParamBase, req_buf, ctrl);
			break;
		case PU_DIGITAL_MULTIPLIER_LIMIT_CONTROL:
			pwParamBase = pPram->wBrightness;
			result =  ProcessWRequest(pwParamBase, req_buf, ctrl);
			break;
	}
	pu_set_state(pPuCfg);
	return result;
}

//TODO : Initialize with proper defaults
void *get_pu_control(void)
{
	return &vid_pu_param;
}
