/*
 * uvcextension.c USB Video Class Video Extension implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 */

#include <linux/string.h>
#include "uvcdescript.h"
#include "uvc_codec_if.h"
#include "platform_caps.h"
#include "uvc_vs_ctrl.h"
#include "dbgout.h"
#include "uvc_callback.h"

#define INIT_UVC_MG3500_BITRATE_TABLE 
#include "uvc_ext_api.h"

#define RES_IDX_MIN	0
#define RES_IDX_MAX	1
#define RES_IDX_DEF	2


struct uvc_ext_cmd_t		host_cmd_cur = {0};
struct uvc_ext_cmd_t		host_cmd_min = {0};
struct uvc_ext_cmd_t		host_cmd_max = {0xFFFFFF};
struct uvc_ext_cmd_t		host_cmd_def = {0};
struct uvc_ext_cmd_t		host_cmd_res = {0};

void DumpVidExtCmd(struct uvc_ext_cmd_t *pCmd)
{
	UAV_DBG_MSG(" data				=0x%lx\n",pCmd->data);
	//UAV_DBG_MSG(" ext_data			=0x%lx\n",pCmd->ext_data);
}


unsigned long GetMinBitRate(long dwResolution)
{
	if(dwResolution >= VID_DST_RES_INDEX_LAST){
		dwResolution = VID_DST_RES_INDEX_LAST;
	}
	return listBitRates[dwResolution][RES_IDX_MIN];
}

unsigned long GetMaxBitRate(long dwResolution)
{
	if(dwResolution >= VID_DST_RES_INDEX_LAST){
		dwResolution = VID_DST_RES_INDEX_LAST;
	}
	return listBitRates[dwResolution][RES_IDX_MAX];
}

extern int init_vidcap_defualts(vid_codec_config_t *codec_cfg, long dwResolution)
{
	if(dwResolution >= VID_DST_RES_INDEX_LAST){
		return 0;
	}
	codec_cfg->dwBitRate = listBitRates[dwResolution][RES_IDX_DEF];
	return 0;
}

extern int init_vidcap_control_video_extension(vid_codec_config_t *codec_cfg)
{
	/* Set defaults for AVC codec */
	// TODO initializat the defualts based on a table */
	codec_cfg->dwFrameRate = FRAME_RATE_FULL;
#if (BOARD_ID == BOARD_ID_MOBICAM3)
	codec_cfg->dwCapSource = VID_SRC_CAMERA;
	codec_cfg->dwResultion = VID_DST_RES_1280X720;
#else
	codec_cfg->dwCapSource = VID_SRC_COMPOSITE;
	codec_cfg->dwResultion = VID_DST_RES_720X480;
#endif
	codec_cfg->dwProfile = AVC_PROFILE_HIGH;
	codec_cfg->dwLevel = 40;
	codec_cfg->dwGopStructure = GOP_STRUCTURE_IP;
	codec_cfg->dwPictureCoding = PCITURE_CODING_FRAME;
	codec_cfg->dwGopLen = 15;
	codec_cfg->fExtActive = 1;
#if HAS_AVMUX_AS_DEFAULT == 1
	codec_cfg->dwAVMuxEnable = 1;
	codec_cfg->dwAudBitRate = 64000;
	codec_cfg->dwAudSampleRate = 32000;
	codec_cfg->dwAudNumChan = 2;
#else
	codec_cfg->dwAVMuxEnable = 0;
	codec_cfg->dwAudBitRate = 0;
	codec_cfg->dwAudSampleRate = 0;
	codec_cfg->dwAudNumChan = 0;
#endif




	init_vidcap_defualts(codec_cfg, codec_cfg->dwResultion);
	return 0;
}

extern int init_enc_control_video_extension(vid_codec_config_t *codec_cfg)
{
	/* Set defaults for AVC codec */
	// TODO initializat the defualts based on a table */
	codec_cfg->dwCapSource = VID_SRC_AVDEC; //VID_SRC_PREVIEW;
	codec_cfg->dwFrameRate = FRAME_RATE_FULL;
#if (BOARD_ID == BOARD_ID_MOBICAM3)
	codec_cfg->dwResultion = VID_DST_RES_1280X720;
#else
	codec_cfg->dwResultion = VID_DST_RES_720X480;
#endif
	codec_cfg->dwProfile = AVC_PROFILE_HIGH;
	codec_cfg->dwLevel = 40;
	codec_cfg->dwGopStructure = GOP_STRUCTURE_IP;
	codec_cfg->dwPictureCoding = PCITURE_CODING_FRAME;
	codec_cfg->dwGopLen = 15;
	codec_cfg->fExtActive = 1;

	init_vidcap_defualts(codec_cfg, codec_cfg->dwResultion);
	return 0;
}

extern int init_dec_control_video_extension(vid_codec_config_t *codec_cfg)
{
	/* Default Settings */
	codec_cfg->dwCapSource = 164; //4113;
	codec_cfg->dwResultion = VID_DST_RES_1280X720;
	codec_cfg->dwFrameWidth = 1280;
	codec_cfg->dwFrameHeight = 720;
	codec_cfg->dwCodecFormat = DEC_PAYLOAD_MPEG2_TS;
	codec_cfg->dwFrameInterval = (3003 * 1000 / 9);
	codec_cfg->dwProgressive = 0;
	codec_cfg->fExtActive = 1;
	return 0;
}

int handle_vidcap_control_video_extension(int intf_num, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int fNotifyImmed = 0;
	int	value = -1;
	__u16	w_value = __le16_to_cpu(ctrl->wValue);
	__u16	w_length = __le16_to_cpu(ctrl->wLength);
	int control_selector = w_value  >> 8;
	vid_codec_config_t Param = {0};

	UAV_DBG_MSG("control_selector=%d w_length=%d\n",control_selector,w_length);
	switch(intf_num){
#if HAS_VID_CAP == 1
		case UVC_CTRL_INTERFACE_INDEX:
			vid_cap_get_state(&Param);
			if(!Param.fExtActive) {
				/* First time initialization */
				init_vidcap_control_video_extension(&Param);
			}
			break;
#endif
#if HAS_VID_TRANS == 1
		case UVC_ENC_CTRL_IN_INDEX:
			vid_enc_get_state(&Param);
			if(!Param.fExtActive) {
				/* First time initialization */
				init_enc_control_video_extension(&Param);
			}
			break;
#endif
		default:
			return value;
	}
	switch(ctrl->bRequest){
		case SET_CUR:
		{
			value = 0;
			if(w_length > sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer overflow=%d\n",w_length);
				return -1;
			}
			memcpy(&host_cmd_cur, req_buf, w_length);
			DumpVidExtCmd((struct uvc_ext_cmd_t *)req_buf);
			switch(control_selector) {
				case PARAM_VID_BIT_RATE:
					Param.dwBitRate = host_cmd_cur.data;
					break;
				case PARAM_VID_AVC_PROFILE:
					Param.dwProfile = host_cmd_cur.data;
					break;

				case PARAM_VID_AVC_LEVEL:
					Param.dwLevel = host_cmd_cur.data;
					break;


				case PARAM_VID_PICTURE_CODING:
					Param.dwPictureCoding = host_cmd_cur.data;
					break;
				case PARAM_VID_GOP_STRUCTURE:
					Param.dwGopStructure = host_cmd_cur.data;
					break;
				case PARAM_VID_FRAME_RATE:
					Param.dwFrameRate = host_cmd_cur.data;
					break;
				case PARAM_VID_DST_RES:
					Param.dwResultion = host_cmd_cur.data;
					init_vidcap_defualts(&Param, Param.dwResultion);
					break;
				case PARAM_VID_GOP_LEN:
					Param.dwGopLen = host_cmd_cur.data;
					break;
				case PARAM_AVMUX_ENABLE:
					Param.dwAVMuxEnable = host_cmd_cur.data;
					break;
				case PARAM_AUD_BIT_RATE:
					Param.dwAudBitRate = host_cmd_cur.data;
					break;
				case PARAM_SAMPLE_RATE:
					Param.dwAudSampleRate = host_cmd_cur.data;
					break;
				case PARAM_NUM_CHAN:
					Param.dwAudNumChan = host_cmd_cur.data;
					break;

				case PARAM_CAP_STOP:
					Param.dwStreamState = CODEC_STATE_STOP;
					fNotifyImmed = 1;
					break;

				case PARAM_VID_FORCE_I_FRAME:
					Param.dwForceIframe += 1;
					break;
			}
		}

		switch(intf_num){
#if HAS_VID_CAP == 1
		case UVC_CTRL_INTERFACE_INDEX:
			vid_cap_set_state(&Param, fNotifyImmed || Param.dwStreamState == CODEC_STATE_RUN);
			break;
#endif
#if HAS_VID_TRANS == 1
		case UVC_ENC_CTRL_IN_INDEX:
			vid_enc_set_state(&Param, fNotifyImmed || Param.dwStreamState == CODEC_STATE_RUN);
			break;
#endif
		}
		value = 0;
		break;
	case GET_LEN:
		{
			/* Returns the length of the Probe data structure */
			__u16 len = sizeof(struct uvc_ext_cmd_t);
			req_buf[0] = len & 0xFF;
			req_buf[1] = (len >> 8) & 0xFF;
			value = 2;
		}
	break;
	case GET_DEF:
		{
			value = 0;
			if(w_length < sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer underflow=%d\n",w_length);
				return -1;
			}
			memcpy(req_buf, &host_cmd_def, w_length);
		}
		value = w_length;
		break;

	case GET_CUR:
		{
			value = 0;
			if(w_length > sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer overflow=%d\n",w_length);
				return -1;
			}
			switch(control_selector) {
				case PARAM_VID_BIT_RATE:
					host_cmd_cur.data = Param.dwBitRate ;
					break;
				case PARAM_VID_AVC_PROFILE:
					host_cmd_cur.data = Param.dwProfile;
					break;

				case PARAM_VID_AVC_LEVEL:
					host_cmd_cur.data = Param.dwLevel;
					break;

				case PARAM_VID_PICTURE_CODING:
					host_cmd_cur.data = Param.dwPictureCoding;
					break;
				case PARAM_VID_GOP_STRUCTURE:
					host_cmd_cur.data = Param.dwGopStructure;
					break;
				case PARAM_VID_FRAME_RATE:
					host_cmd_cur.data = Param.dwFrameRate;
					break;
				case PARAM_VID_DST_RES:
					host_cmd_cur.data = Param.dwResultion;
					break;
				case PARAM_VID_GOP_LEN:
					host_cmd_cur.data = Param.dwGopLen;
					break;

				case PARAM_AVMUX_ENABLE:
					host_cmd_cur.data = Param.dwAVMuxEnable;
					break;

				case PARAM_AUD_BIT_RATE:
					host_cmd_cur.data = Param.dwAudBitRate;
					break;
				case PARAM_SAMPLE_RATE:
					host_cmd_cur.data = Param.dwAudSampleRate;
					break;
				case PARAM_NUM_CHAN:
					host_cmd_cur.data = Param.dwAudNumChan;
					break;

				case PARAM_CAP_STOP:
					host_cmd_cur.data = Param.dwStreamState;
					break;
				case PARAM_CAP_QUERY_EOS:
					host_cmd_cur.data = Param.dwEoS;
					break;
				case UVC_CAP_EXT_GET_VERSION:
					host_cmd_cur.data = UVC_CAP_EXT_VERSION;
					break;
			}
			memcpy(req_buf, &host_cmd_cur, w_length);
		}
		value = w_length;
		break;
	case GET_MIN:
		{
			value = 0;
			if(w_length < sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer underflow=%d\n",w_length);
				return -1;
			}
			if(control_selector == PARAM_VID_BIT_RATE) {
				host_cmd_min.data = GetMinBitRate(Param.dwResultion);;
			}
			memcpy(req_buf, &host_cmd_min, w_length);
		}
		value = w_length;
		break;
	case GET_MAX:
		{
			value = 0;
			if(w_length < sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer underflow=%d\n",w_length);
				return -1;
			}
			if(control_selector == PARAM_VID_BIT_RATE) {
				host_cmd_max.data = GetMaxBitRate(Param.dwResultion);
			}
			memcpy(req_buf, &host_cmd_max, w_length);
		}
		value = w_length;
		break;
	case GET_RES:
		{
			value = 0;
			if(w_length < sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer underflow=%d\n",w_length);
				return -1;
			}
			memcpy(req_buf, &host_cmd_res, w_length);
		}
		value = w_length;
		break;
	case GET_INFO:
		*(__u8*)req_buf = 0x03;
		value = 1;
		break;
	}
	UAV_DBG_MSG("control_selector=%d return value=%d\n",control_selector,value);
	return value;
}

int handle_dec_control_video_extension(int intf_num, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int	value = -1;
	int fNotifyImmed = 0;
	__u16	w_value = __le16_to_cpu(ctrl->wValue);
	__u16	w_length = __le16_to_cpu(ctrl->wLength);
	int control_selector = w_value  >> 8;
	vid_codec_config_t Param = {0};

	UAV_DBG_MSG("control_selector=%d w_length=%d\n",control_selector,w_length);
	vid_dec_get_state(&Param);
	if(!Param.fExtActive) {
		/* First time initialization */
		init_dec_control_video_extension(&Param);
	}

	switch(ctrl->bRequest){
		case SET_CUR:
		{
			value = 0;
			if(w_length > sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer overflow=%d\n",w_length);
				return -1;
			}
			memcpy(&host_cmd_cur, req_buf, w_length);
			DumpVidExtCmd((struct uvc_ext_cmd_t *)req_buf);
			switch(control_selector) {
				case PARAM_VID_DEC_PID:
					Param.dwCapSource = host_cmd_cur.data;
					break;

				case PARAM_VID_DEC_FORMAT:
					Param.dwCodecFormat = host_cmd_cur.data;
					break;

				case PARAM_VID_DEC_WIDTH:
					Param.dwFrameWidth = host_cmd_cur.data;
					break;

				case PARAM_VID_DEC_HEIGHT:
					Param.dwFrameHeight = host_cmd_cur.data;
					break;
				case PARAM_VID_DEC_FRAME_INTERVAL:
					Param.dwFrameInterval = host_cmd_cur.data;
					break;

				case PARAM_VID_DEC_PROGRESSIVE:
					Param.dwProgressive = host_cmd_cur.data;
					break;

				case PARAM_VID_DEC_EOS:
					Param.dwStreamState = CODEC_STATE_STOP;
					fNotifyImmed = 1;
					break;
			}
		}
		vid_dec_set_state(&Param, fNotifyImmed);
		value = 0;
		break;
	case GET_LEN:
		{
			/* Returns the length of the Probe data structure */
			__u16 len = sizeof(struct uvc_ext_cmd_t);
			req_buf[0] = len & 0xFF;
			req_buf[1] = (len >> 8) & 0xFF;
			value = 2;
		}
	break;
	case GET_DEF:
		{
			value = 0;
			if(w_length < sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer underflow=%d\n",w_length);
				return -1;
			}
			memcpy(req_buf, &host_cmd_def, w_length);
		}
		value = w_length;
		break;

	case GET_CUR:
		{
			value = 0;
			if(w_length > sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer overflow=%d\n",w_length);
				return -1;
			}
			switch(control_selector) {
				case PARAM_VID_DEC_PID:
					host_cmd_cur.data = Param.dwCodecFormat ;
					break;
				case PARAM_VID_DEC_FORMAT:
					host_cmd_cur.data = Param.dwCodecFormat;
					break;

				case PARAM_VID_DEC_WIDTH:
					host_cmd_cur.data = Param.dwFrameWidth;
					break;

				case PARAM_VID_DEC_HEIGHT:
					host_cmd_cur.data = Param.dwFrameHeight;
					break;

				case PARAM_VID_DEC_FRAME_INTERVAL:
					host_cmd_cur.data = Param.dwFrameInterval;
					break;

				case PARAM_VID_DEC_PROGRESSIVE:
					host_cmd_cur.data = Param.dwProgressive;
					break;

			}
			memcpy(req_buf, &host_cmd_cur, w_length);
		}
		value = w_length;
		break;
	case GET_MIN:
		{
			value = 0;
			if(w_length < sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer underflow=%d\n",w_length);
				return -1;
			}
			if(control_selector == PARAM_VID_BIT_RATE) {
				host_cmd_min.data = GetMinBitRate(Param.dwResultion);;
			}
			memcpy(req_buf, &host_cmd_min, w_length);
		}
		value = w_length;
		break;
	case GET_MAX:
		{
			value = 0;
			if(w_length < sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer underflow=%d\n",w_length);
				return -1;
			}
			if(control_selector == PARAM_VID_BIT_RATE) {
				host_cmd_max.data = GetMaxBitRate(Param.dwResultion);
			}
			memcpy(req_buf, &host_cmd_max, w_length);
		}
		value = w_length;
		break;
	case GET_RES:
		{
			value = 0;
			if(w_length < sizeof(struct uvc_ext_cmd_t)){
				UAV_DBG_MSG("buffer underflow=%d\n",w_length);
				return -1;
			}
			memcpy(req_buf, &host_cmd_res, w_length);
		}
		value = w_length;
		break;
	case GET_INFO:
		*(__u8*)req_buf = 0x03;
		value = 1;
		break;
	}
	UAV_DBG_MSG("control_selector=%d return value=%d\n",control_selector,value);
	return value;
}

