/*
 * USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 * The file defines functions for video encoder interface 
 * This interface is used between application/command dispatcher and uvc driver.
 *
 */

#ifndef __UVC_CODEC_IF__
#define __UVC_CODEC_IF__

#define MAX_COMP_QUALITY 10000
#define MAX_FILE_NAME	64

/**
 * For application use
 * TODO : Derive from the driver name
 */
#define CODEC_CFG_CTRL_FILE_NAME	"/dev/usbav/ctrl"
#define CODEC_VID_CAP_STREAM_0		"/dev/usbav/uvc0"
//#define CODEC_VID_CAP_STREAM_1	"/dev/usbav/uvc1"
#define CODEC_VID_TRANS_DEC			"/dev/usbav/dec0"
#define CODEC_VID_TRANS_ENC			"/dev/usbav/enc0"
#define CODEC_AUD_CAP_STREAM		"/dev/usbav/uac"
#define CODEC_CFG_STATUS			"/dev/usbav/status"

/**
 * For driver use
 */
#define FILE_CFG_CTRL_FILE_NAME	"ctrl"
#define FILE_VID_CAP_STREAM_0	"uvc0"
//#define FILE_VID_CAP_STREAM_1	"uvc1"
#define FILE_ID_TRANS_DEC		"dec0"
#define FILE_VID_TRANS_ENC		"enc0"
#define FILE_AUD_CAP_STREAM		"uac"
#define FILE_CFG_STATUS			"status"

typedef enum tag_codec_state_t
{
	CODEC_STATE_UNDEFINED,
	CODEC_STATE_RUN,
	CODEC_STATE_PAUSE,
	CODEC_STATE_STOP,
} codec_state_t;

typedef enum tag_stream_id_t
{
	STREAM_ID_VIDCAP_0,
	STREAM_ID_AUDCAP,
	STREAM_ID_TRANS_DEC,
	STREAM_ID_TRANS_ENC,
	STREAM_ID_PU,
	STREAM_ID_CAMERA,
	STREAM_ID_LAST,
} stream_id_t;

typedef enum tag_codec_format_t
{
	FORMAT_MJPEG,
	FORMAT_H264_TS,
	FORMAT_H264_VEN,
	FORMAT_PCM,
	FORMAT_MPEG2,
	FORMAT_YUV12,
}codec_format_t;

typedef enum tag_vid_cap_src_id_t
{
	VID_SRC_HDMI,
	VID_SRC_COMPONENT,
	VID_SRC_SVIDEO,
	VID_SRC_COMPOSITE,
	VID_SRC_CAMERA,
} vid_cap_src_id_t;

typedef enum tag_vid_enc_src_id_t
{
	/* The following sources are used for encoder(transcoder) interface */
	VID_SRC_PREVIEW,		// Output from processing unit
	VID_SRC_AVDEC,			// Output form decoder
	VID_SRC_MULTIPORT_0,	// Control port (for composited video from) multiple input sources
	VID_SRC_MULTIPORT_1,	// Substream - 1
	VID_SRC_MULTIPORT_2,	// Substream - 2
	VID_SRC_MULTIPORT_3,	// Substream - 3
	VID_SRC_MULTIPORT_4,	// Substream - 4
} vid_enc_src_id_t;

typedef enum tag_vid_dest_id_t
{
	VID_DEST_HDMI,
	VID_DEST_COMPONENT,
	VID_DEST_SVIDEO,
	VID_DEST_COMPOSITE,
} vid_dest_id_t;

typedef enum tag_vid_standard_t
{
	VID_STD_UNKNOWN,
	VID_STD_NTSC_525_60,
	VID_STD_PAL_625_50,
	VID_STD_SECAM_625_60,
	VID_STD_NTSC_625_60,
	VID_STD_PAL_525_60,
	/* Following are not part of UVC */
	VID_STD_720P_25,
	VID_STD_720P_30,
	VID_STD_1080I,
	VID_STD_1080P,
} vid_standard_id_t;

typedef struct tag_codec_config_hdr_t
{
	unsigned long	dwStreamId;
	unsigned long	dwStreamState;
	unsigned long	dwEpPacketSize;		
	unsigned long	dwEpInterval;		
	unsigned long	dwEpIsoc;
} codec_config_hdr_t;

typedef struct tag_vid_codec_config_t
{
	/*codec_config_hdr_t */
	unsigned long	dwStreamId;
	unsigned long	dwStreamState;
	unsigned long	dwEpPacketSize;		
	unsigned long	dwEpInterval;		
	unsigned long	dwEpIsoc;

	unsigned long	dwCapSource;		
	
	/* UVC Parameters */
	unsigned long	dwCodecFormat;
	unsigned long	dwFrameWidth;
	unsigned long	dwFrameHeight;
	unsigned long	dwFrameInterval;
	unsigned long	dwKeyFrameRate;
	unsigned long	dwPFrameRate;
	unsigned long	dwCompQuality;
	unsigned long	dwCompWindowSize;
	unsigned long	dwMaxVideoFrameSize;
	unsigned long	dwMaxPayloadTransferSize;

	/* UVC Extension Parameters for AVC Codec*/
	int				fExtActive;
	unsigned long	dwFrameRate;
	unsigned long	dwBitRate;
	unsigned long	dwProfile;
	unsigned long	dwLevel;
	unsigned long	dwGopStructure;
	unsigned long	dwPictureCoding;
	unsigned long	dwProgressive;
	unsigned long	dwResultion;
	unsigned long	dwGopLen;
	unsigned long	dwMinBitRate;
	unsigned long	dwMaxBitRate;

	unsigned long	dwForceIframe;
	
	/* UVC Extension Parameters for AAC stream muxed with audio*/
	unsigned long	dwAVMuxEnable;
	unsigned long	dwAudBitRate;
	unsigned long	dwAudSampleRate;
	unsigned long	dwAudNumChan;

	/* Application or Streaming originated state changes*/
	unsigned long	dwEoS;

} vid_codec_config_t;

typedef struct tag_aud_codec_config_t
{
	/*codec_config_hdr_t */
	unsigned long	dwStreamId;
	unsigned long	dwStreamState;
	unsigned long	dwEpPacketSize;		// ISOC Packet Size
	unsigned long	dwEpInterval;		// ISOC Packet Size
	unsigned long	dwEpIsoc;

	unsigned long	dwFormatIndex;
	unsigned long	dwSampleRate;
	unsigned long	dwNumChannels;
	unsigned long	dwSampleSize;

	unsigned long	dwCopyProtect; 	/* Current Copy Protection Setting*/
	unsigned long	dwSelector;
	unsigned long	dwMute;
	unsigned long	dwAGC;
	unsigned long	dwVol;
	unsigned long	dwMid;
	unsigned long	dwBass;
	unsigned long	dwTreb;
	unsigned long	dwDelay;

} aud_codec_config_t;

typedef struct tag_pu_codec_config_t
{
	/* codec_config_hdr_t */
	unsigned long	dwStreamId;
	unsigned long	dwStreamState;
	unsigned long	dwEpPacketSize;	
	unsigned long	dwEpInterval;	
	unsigned long	dwEpIsoc;

	unsigned long	dwBacklightCompensation;
	unsigned long	dwBrightness;
	unsigned long	dwContrast;
	unsigned long	dwGain;
	unsigned long	dwHue;
	unsigned long	dwHueAuto;
	unsigned long	dwSaturation;
	unsigned long	dwSharpness;
	unsigned long	dwGamma;
	unsigned long	dwWhiteBalanceTemperature;
	unsigned long	dwWhiteBalanceTemperatureAuto;
	unsigned long	dwWhiteBalanceBlue;
	unsigned long	dwWhiteBalanceRed;
	unsigned long	dwWhiteBalanceComponentAuto;
	unsigned long	dwMultiplierStep;
	unsigned long	wMultiplierLimit;
} pu_config_t;

typedef struct tag_camera_codec_config_t
{
	/*codec_config_hdr_t */
	unsigned long	dwStreamId;
	unsigned long	dwStreamState;
	unsigned long	dwEpPacketSize;		// Unused
	unsigned long	dwEpInterval;		// Un used
	unsigned long	dwEpIsoc;

	unsigned long	dwScanningMode;		//0: Interlaced, 1: Progressive
	unsigned long	dwAutoExposureMode;
							/* D0: Manual Mode - manual Exposure Time, manual Iris
							 * D1: Auto Mode - auto Exposure Time, auto Iris
							 * D2: Shutter Priority Mode - manual Exposure Time, auto Iris
							 * D3: Aperture Priority Mode - auto Exposure Time, manual Iris
							 */
	unsigned long	dwAutoExposurePriority;
							/* A result of 1 indicates that the frame rate may be dynamically varied by the device. The default result is zero (0). */
	unsigned long	dwExposureTimeAbsolute;
							/* Exposure Time (Absolute) Control:
							 * 0: Reserved
							 * 1: 0.0001 sec
							 * 100000: 10 sec
							 */

	unsigned long	dwExposureTimeRelative;
							/* Exposure Time (Relative) Control:
							 * 0: default
							 * 1: incremented by 1 step
							 * 0xFF: decremented by 1 step
							 */
	unsigned long	dwFocusAbsolute;		/* This result is expressed in millimeters. */

	unsigned long	dwFocusRelative;
							/* 0: Stop
							 * 1: Focus Near direction
							 * 0xFF: Focus Infinite direction
							 */
	long	dwFocusSpeed;				/* Speed for the control change */

	long	dwFocusAuto;

	long	dwIrisAbsolute;

	long	dwIrisRelative;

	long	dwZoom;
	long	bZoomSpeedMin;
	long	bZoomSpeedMax;

	long	dwDigitalZoom;
	long	dwZoomSpeed;

	long	dwPanAbsolute;
	long	dwPanAbsoluteMin;
	long	dwPanAbsoluteMax;

	long	dwTiltAbsolute;
	long	dwTiltAbsoluteMin;
	long	dwTiltAbsoluteMax;

	long	dwPanRelative;
	long	dwPanSpeed;
	long	dwTiltRelative;
	long	dwTiltSpeed;
	long	dwRollAbsolute;
	long	dwRollRelative;
	long	dwRollSpeed;
	int				fInitOk;
} camera_config_t;

typedef union tag_codec_config_t
{
	codec_config_hdr_t	config_hdr;
	vid_codec_config_t	vid_codec;
	aud_codec_config_t	aud_codec;
	camera_config_t		camera_cfg;
	pu_config_t			pu_cfg;
} codec_config_t;

int codec_set_state(vid_codec_config_t *pParam);

#endif //__UVC_CODEC_IF__
