/*
 * usb_cap_interface.c USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file implements handling of camera controls 
 *
 */

#include "uvcdescript.h"
#include "uvc_codec_if.h"
#include "dbgout.h"
#include "uvc_callback.h"

extern __u8 bCrntVcErrCode;


struct vid_cap_camera_param_t
{
	__u8  bScanningMode;		//0: Interlaced, 1: Progressive
	__u8  bAutoExposureMode;
							// D0: Manual Mode - manual Exposure Time, manual Iris
							// D1: Auto Mode - auto Exposure Time, auto Iris
							// D2: Shutter Priority Mode - manual Exposure Time, auto Iris
							// D3: Aperture Priority Mode - auto Exposure Time, manual Iris
	__u8  bAutoExposurePriority;
							// A result of 1 indicates that the frame rate may be dynamically varied by the device. The default result is zero (0).
	__u32 dwExposureTimeAbsolute;
							// Exposure Time (Absolute) Control:
							// 0: Reserved
							// 1: 0.0001 sec
							// 100000: 10 sec
	__u8  bExposureTimeRelative;
							// Exposure Time (Relative) Control:
							// 0: default
							// 1: incremented by 1 step
							// 0xFF: decremented by 1 step
	__u16  wFocusAbsolute;	// This result is expressed in millimeters.

	__u8  bFocusRelative;
							// 0: Stop
							// 1: Focus Near direction
							// 0xFF: Focus Infinite direction
	__u8  bFocusSpeed;				// Speed for the control change
	__u8  bFocusSpeedMin;
	__u8  bFocusSpeedMax;
	__u8  bFocusSpeedRes;
	__u8  bFocusSpeedDef;

	__u8  bFocusAuto;
	__u8  bFocusAutoDef;

	__u16 wIrisAbsolute;
	__u16 wIrisAbsoluteMin;
	__u16 wIrisAbsoluteMax;
	__u16 wIrisAbsoluteRes;
	__u16 wIrisAbsoluteDef;

	__u8  bIrisRelative;
	__u16 wObjectiveFocalLength;
	__u16 wObjectiveFocalLengthMin;
	__u16 wObjectiveFocalLengthMax;
	__u16 wObjectiveFocalLengthRes;
	__u16 wObjectiveFocalLengthDef;

	__u8  bZoom;
	__u8  bDigitalZoom;
	__u8  bZoomSpeed;
	__u8  bZoomSpeedMin;
	__u8  bZoomSpeedMax;
	__u8  bZoomSpeedRes;
	__u8  bZoomSpeedDef;

	long  dwPanAbsolute;
	long  dwPanAbsoluteMin;
	long  dwPanAbsoluteMax;
	long  dwPanAbsoluteRes;
	long  dwPanAbsoluteDef;

	long  dwTiltAbsolute;
	long  dwTiltAbsoluteMin;
	long  dwTiltAbsoluteMax;
	long  dwTiltAbsoluteRes;
	long  dwTiltAbsoluteDef;

	__u8  bPanRelative;
	__u8  bPanSpeed;
	__u8  bTiltRelative;
	__u8  bTiltSpeed;
	__u16 wRollAbsolute;
	__u16 wRollAbsoluteMin;
	__u16 wRollAbsoluteMax;
	__u16 wRollAbsoluteRes;
	__u16 wRollAbsoluteDef;
	__u8  bRollRelative;
	__u8  bRollSpeed;
	__u8  bRollSpeedMin;			// Speed for the control change
	__u8  bRollSpeedMax;			// Speed for the control change
	__u8  bRollSpeedDef;			// Speed for the control change
	__u8  bRollSpeedRes;			// Speed for the control change


	__u8  bPrivacy;
};

// TODO : Fill with suitable values based on the Camera capabilities
struct vid_cap_camera_param_t camera_device = 
{
	.bScanningMode = 0,		//0: Interlaced, 1: Progressive
	.bAutoExposureMode = 0,
					// D0: Manual Mode  manual Exposure Time, manual Iris
					// D1: Auto Mode  auto Exposure Time, auto Iris
					// D2: Shutter Priority Mode  manual Exposure Time, auto Iris
					// D3: Aperture Priority Mode  auto Exposure Time, manual Iris
	.bAutoExposurePriority = 0,
					// A result of 1 indicates that the frame rate may be dynamically varied by the device. The default result is zero (0).
	.dwExposureTimeAbsolute = 0,
				// Exposure Time (Absolute) Control:
				// 0: Reserved
				// 1: 0.0001 sec
				// 100000: 10 sec
	.bExposureTimeRelative = 0,
				// Exposure Time (Relative) Control:
				// 0: default
				// 1: incremented by 1 step
				// 0xFF: decremented by 1 step
	.wFocusAbsolute = 0,	// This result is expressed in millimeters.

	.bFocusRelative = 0,
				// 0: Stop
				// 1: Focus Near direction
				// 0xFF: Focus Infinite direction
	.bFocusSpeed = 0,				// Speed for the control change
	.bFocusSpeedMin = 0,
	.bFocusSpeedMax = 0,
	.bFocusSpeedRes = 0,
	.bFocusSpeedDef = 0,

	.bFocusAuto = 0,
	.bFocusAutoDef = 0,

	.wIrisAbsolute = 0,
	.wIrisAbsoluteMin = 0,
	.wIrisAbsoluteMax = 0,
	.wIrisAbsoluteRes = 0,
	.wIrisAbsoluteDef = 0,

	.bIrisRelative = 0,
	.wObjectiveFocalLength = 0,
	.wObjectiveFocalLengthMin = 0,
	.wObjectiveFocalLengthMax = 0,
	.wObjectiveFocalLengthRes = 0,
	.wObjectiveFocalLengthDef = 0,

	.bZoom = 0,
	.bDigitalZoom = 0,
	.bZoomSpeed = 0,
	.bZoomSpeedMin = 0,
	.bZoomSpeedMax = 0,
	.bZoomSpeedRes = 0,
	.bZoomSpeedDef = 0,

	.dwPanAbsolute = 0,
	.dwPanAbsoluteMin = CAP_PAN_MIN,
	.dwPanAbsoluteMax = CAP_PAN_MAX,
	.dwPanAbsoluteRes = CAP_PAN_RES,
	.dwPanAbsoluteDef = 0,

	.dwTiltAbsolute = 0,
	.dwTiltAbsoluteMin = CAP_TILT_MIN,
	.dwTiltAbsoluteMax = CAP_TILT_MAX,
	.dwTiltAbsoluteRes = CAP_TILT_RES,
	.dwTiltAbsoluteDef = 0,

	.bPanRelative = 0,
	.bPanSpeed = 0,
	.bTiltRelative = 0,
	.bTiltSpeed = 0,
	.wRollAbsolute = 0,
	.wRollAbsoluteMin = 0,
	.wRollAbsoluteMax = 0,
	.wRollAbsoluteRes = 0,
	.wRollAbsoluteDef = 0,
	.bRollRelative = 0,
	.bRollSpeed = 0,
	.bRollSpeedMin = 0,			// Speed for the control change
	.bRollSpeedMax = 0,			// Speed for the control change
	.bRollSpeedMin = 0,			// Speed for the control change
	.bRollSpeedDef = 0,			// Speed for the control change
	.bRollSpeedRes = 0,			// Speed for the control change


	.bPrivacy = 0,
};

void init_camera_cfg(camera_config_t *pCameraCfg)
{
	struct vid_cap_camera_param_t *pCtx = (struct vid_cap_camera_param_t *)&camera_device;
	pCameraCfg->dwStreamId = STREAM_ID_CAMERA;
	pCameraCfg->dwPanAbsolute = 0;
	pCameraCfg->dwTiltAbsolute = 0;
	pCameraCfg->dwPanAbsoluteMin = pCtx->dwPanAbsoluteMin;
	pCameraCfg->dwPanAbsoluteMax = pCtx->dwPanAbsoluteMax;
	pCameraCfg->dwTiltAbsoluteMin = pCtx->dwTiltAbsoluteMin;
	pCameraCfg->dwTiltAbsoluteMax = pCtx->dwTiltAbsoluteMax;
	pCameraCfg->fInitOk = 1;
}

int handle_vidcap_control_camera(void *pCtx, char *req_buf, const struct usb_ctrlrequest *ctrl)
{
	int result = -1;
	camera_config_t CameraCfg = {0};
	camera_config_t *pCameraCfg = &CameraCfg;
	struct vid_cap_camera_param_t *pPram = (struct vid_cap_camera_param_t *)pCtx;
	__u16	w_value = __le16_to_cpu(ctrl->wValue);
	int control_selector = w_value >> 8;
	UAV_DBG_MSG("control_selector=%d\n",control_selector);
	camera_get_state(&CameraCfg);
	
	if(!pCameraCfg->fInitOk){
		init_camera_cfg(pCameraCfg);
	}
	switch(control_selector){
		case CT_SCANNING_MODE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bScanningMode = req_buf[0];
					result = 0;
					break;
				case GET_CUR:

#if HAS_CT_SCANNING_MODE_CONTROL == 1
					req_buf[0] = pPram->bScanningMode;
					result = 1;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_LEN:
					req_buf[0] = 1;
					result = 1;
					break;

				case GET_MIN:
				case GET_MAX:
				case GET_RES:
				case GET_DEF:
					result = -1;
					break;
				case GET_INFO:
#if HAS_CT_SCANNING_MODE_CONTROL == 1
					*(__u8*)req_buf = 0x03;
					result = 1;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;

			}
		break;

		case CT_AE_MODE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bAutoExposureMode = req_buf[0];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_AE_MODE_CONTROL == 1
					req_buf[0] = pPram->bAutoExposureMode;
					result = 1;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:
				case GET_DEF:
					result = -1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				case GET_LEN:
					req_buf[0] = 1;
					result = 1;
					break;


			}

		case CT_AE_PRIORITY_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bAutoExposurePriority = req_buf[0];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_AE_PRIORITY_CONTROL == 1
					req_buf[0] = pPram->bAutoExposurePriority;
					result = 1;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:
				case GET_DEF:
					result = -1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				case GET_LEN:
					req_buf[0] = 1;
					result = 1;
					break;


			}

		case CT_EXPOSURE_TIME_ABSOLUTE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->dwExposureTimeAbsolute = __le32_to_cpup((__le32 *)&req_buf[0]);
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_EXPOSURE_TIME_ABSOLUTE_CONTROL == 1
					*(__le32 *)&req_buf[0] = __cpu_to_le32(pPram->dwExposureTimeAbsolute);
					result = 4;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:
				case GET_DEF:
					result = -1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				case GET_LEN:
					req_buf[0] = 1;
					result = 1;
					break;


			}
			break;
		case CT_EXPOSURE_TIME_RELATIVE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bExposureTimeRelative = req_buf[0];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_EXPOSURE_TIME_RELATIVE_CONTROL == 1
					req_buf[0] = pPram->bExposureTimeRelative;
					result = 1;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:
				case GET_DEF:
					result = -1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				case GET_LEN:
					req_buf[0] = 1;
					result = 1;
					break;


			}
			break;

		case CT_FOCUS_ABSOLUTE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->wFocusAbsolute = __le16_to_cpup((__le16 *)&req_buf[0]);
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_FOCUS_ABSOLUTE_CONTROL == 1
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wFocusAbsolute);
					result = 2;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:
				case GET_DEF:
					result = -1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				case GET_LEN:
					req_buf[0] = 2;
					result = 1;
					break;


			}
			break;

		case CT_FOCUS_RELATIVE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bFocusRelative = req_buf[0];
					pPram->bFocusSpeed = req_buf[1];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_FOCUS_RELATIVE_CONTROL == 1
					req_buf[0] = pPram->bFocusRelative;
					req_buf[1] = pPram->bFocusSpeed;
					result = 2;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
					req_buf[0] = pPram->bFocusRelative;
					req_buf[1] = pPram->bFocusSpeedMin;
					result = 2;
					break;

				case GET_MAX:
					req_buf[0] = pPram->bFocusRelative;
					req_buf[1] = pPram->bFocusSpeedMax;
					result = 2;
					break;

				case GET_RES:
					req_buf[0] = pPram->bFocusRelative;
					req_buf[1] = pPram->bFocusSpeedRes;
					result = 2;
					break;

				case GET_LEN:
					req_buf[0] = 1;
					result = 1;
					break;
				case GET_DEF:
					req_buf[0] = pPram->bFocusRelative;
					req_buf[1] = pPram->bFocusSpeed;
					result = 2;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;

			}
			break;

		case CT_FOCUS_AUTO_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bFocusAuto = req_buf[0];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_FOCUS_AUTO_CONTROL == 1
					req_buf[0] = pPram->bFocusAuto;
					result = 1;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:
					break;
				case GET_DEF:
					req_buf[0] = pPram->bFocusAutoDef;
					result = 1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				case GET_LEN:
					req_buf[0] = 1;
					result = 1;


			}
			break;

		case CT_IRIS_ABSOLUTE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->wIrisAbsolute = __le16_to_cpup((__le16 *)&req_buf[0]);
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_IRIS_ABSOLUTE_CONTROL == 1
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wIrisAbsolute);
					result = 2;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wIrisAbsoluteMin);
					result = 1;
					break;

				case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wIrisAbsoluteMax);
					result = 1;
					break;

				case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wIrisAbsoluteRes);
					result = 1;
					break;

				case GET_LEN:
					req_buf[0] = 2;
					result = 1;
					break;
				case GET_DEF:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wIrisAbsoluteDef);
					result = 1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
			}
			break;

		case CT_IRIS_RELATIVE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bIrisRelative = __le16_to_cpup((__le16 *)&req_buf[0]);
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_IRIS_RELATIVE_CONTROL == 1
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->bIrisRelative);
					result = 2;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:

				case GET_DEF:
					result = -1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				case GET_LEN:
					req_buf[0] = 2;
					result = 1;

			}
			break;

		case CT_ZOOM_ABSOLUTE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->wObjectiveFocalLength = __le16_to_cpup((__le16 *)&req_buf[0]);
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_ZOOM_ABSOLUTE_CONTROL == 1
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wObjectiveFocalLength);
					result = 2;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wObjectiveFocalLengthMin);
					result = 2;
					break;
				case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wObjectiveFocalLengthMax);
					result = 2;
					break;

				case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wObjectiveFocalLengthRes);
					result = 2;
					break;

				case GET_LEN:
					req_buf[0] = 2;
					result = 1;
					break;

				case GET_DEF:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wObjectiveFocalLengthDef);
					result = 2;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;

			}
			break;

		case CT_ZOOM_RELATIVE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bZoom = req_buf[0];
					pPram->bDigitalZoom = req_buf[1];
					pPram->bZoomSpeed = req_buf[2];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_ZOOM_RELATIVE_CONTROL == 1
					req_buf[0] = pPram->bZoom;
					req_buf[1] = pPram->bDigitalZoom;
					req_buf[2] = pPram->bZoomSpeed;
					result = 3;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
					req_buf[0] = pPram->bZoom;
					req_buf[1] = pPram->bDigitalZoom;
					req_buf[2] = pPram->bZoomSpeedMin;
					result = 3;
					break;

				case GET_MAX:
					req_buf[0] = pPram->bZoom;
					req_buf[1] = pPram->bDigitalZoom;
					req_buf[2] = pPram->bZoomSpeedMax;
					result = 3;
					break;

				case GET_RES:
					req_buf[0] = pPram->bZoom;
					req_buf[1] = pPram->bDigitalZoom;
					req_buf[2] = pPram->bZoomSpeedRes;
					result = 3;
					break;

				case GET_LEN:
					req_buf[0] = 3;
					result = 1;
					break;

				case GET_DEF:
					req_buf[0] = pPram->bZoom;
					req_buf[1] = pPram->bDigitalZoom;
					req_buf[2] = pPram->bZoomSpeedDef;
					result = 3;
					break;

				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;

			}
			break;

		case CT_PANTILT_ABSOLUTE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
				{
					long dwPanAbsolute = 0;
					long dwTiltAbsolute = 0;
					UAV_DBG_MSG("SET_CUR %2x %2x %2x %2x %2x %2x %2x %2x\n",req_buf[0],req_buf[1],req_buf[2],req_buf[3],req_buf[4],req_buf[5],req_buf[6],req_buf[7]);

					dwPanAbsolute = __le32_to_cpup((__le32 *)&req_buf[0]);
					dwTiltAbsolute = __le32_to_cpup((__le32 *)&req_buf[4]);
					if(dwPanAbsolute >= pPram->dwPanAbsoluteMin && dwPanAbsolute <= pPram->dwPanAbsoluteMax){
						pPram->dwPanAbsolute = dwPanAbsolute;
						pCameraCfg->dwPanAbsolute = dwPanAbsolute;
					}
					if(dwTiltAbsolute >= pPram->dwTiltAbsoluteMin && dwTiltAbsolute <= pPram->dwTiltAbsoluteMax){
						pPram->dwTiltAbsolute = dwTiltAbsolute;
						pCameraCfg->dwTiltAbsolute = dwTiltAbsolute;
					}
					//UAV_DBG_MSG("SET_CUR dwPanAbsolute=%d dwTiltAbsolute=%d dwPanAbsolute(ctx)=%d dwTiltAbsolute(ctx)=%d\n",dwPanAbsolute, dwTiltAbsolute, pPram->dwPanAbsolute, pPram->dwTiltAbsolute);
				}

				result = 0;
				break;
				case GET_CUR:
#if HAS_CT_PANTILT_ABSOLUTE_CONTROL == 1
					*(__le32 *)&req_buf[0] = __cpu_to_le32(pPram->dwPanAbsolute);
					*(__le32 *)&req_buf[4] = __cpu_to_le32(pPram->dwTiltAbsolute);
					result = 8;
					//UAV_DBG_MSG("GET_CUR dwPanAbsolute=%d dwTiltAbsolute=%d\n",pPram->dwPanAbsolute, pPram->dwTiltAbsolute);
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
					*(__le32 *)&req_buf[0] = __cpu_to_le32(pPram->dwPanAbsoluteMin);
					*(__le32 *)&req_buf[4] = __cpu_to_le32(pPram->dwTiltAbsoluteMin);
					result = 8;
					break;

				case GET_MAX:
					*(__le32 *)&req_buf[0] = __cpu_to_le32(pPram->dwPanAbsoluteMax);
					*(__le32 *)&req_buf[4] = __cpu_to_le32(pPram->dwTiltAbsoluteMax);
					result = 8;
					break;

				case GET_RES:
					*(__le32 *)&req_buf[0] = __cpu_to_le32(pPram->dwPanAbsoluteRes);
					*(__le32 *)&req_buf[4] = __cpu_to_le32(pPram->dwTiltAbsoluteRes);
					result = 8;
					break;

				case GET_LEN:
					req_buf[0] = 8;
					req_buf[1] = 0;
					result = 2;
					break;

				case GET_DEF:
					*(__le32 *)&req_buf[0] = __cpu_to_le32(pPram->dwPanAbsoluteDef);
					*(__le32 *)&req_buf[4] = __cpu_to_le32(pPram->dwTiltAbsoluteDef);
					result = 8;
					break;

				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;

			}
			break;

		case CT_PANTILT_RELATIVE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bPanRelative = req_buf[0];
					pPram->bPanSpeed = req_buf[1];
					pPram->bTiltRelative = req_buf[2];
					pPram->bTiltSpeed = req_buf[3];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_PANTILT_RELATIVE_CONTROL == 1
					req_buf[0] = pPram->bPanRelative;
					req_buf[1] = pPram->bPanSpeed;
					req_buf[2] = pPram->bTiltRelative;
					req_buf[3] = pPram->bTiltSpeed;
					result = 4;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:
				case GET_DEF:
					result = -1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;

				case GET_LEN:
					req_buf[0] = 4;
					result = 1;
					break;

			}
			break;

		case CT_ROLL_ABSOLUTE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->wRollAbsolute = __le16_to_cpup((__le16 *)&req_buf[0]);
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_ROLL_ABSOLUTE_CONTROL == 1
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wRollAbsolute);
					result = 2;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wRollAbsoluteMin);
					result = 2;
					break;

				case GET_MAX:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wRollAbsoluteMax);
					result = 2;
					break;

				case GET_RES:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wRollAbsoluteRes);
					result = 2;
					break;

				case GET_LEN:
					req_buf[0] = 2;
					result = 1;
					break;

					break;

				case GET_DEF:
					*(__le16 *)&req_buf[0] = __cpu_to_le16(pPram->wRollAbsoluteDef);
					result = 2;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;

			}
			break;

		case CT_ROLL_RELATIVE_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bRollRelative = req_buf[0];
					pPram->bRollSpeed = req_buf[1];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_ROLL_RELATIVE_CONTROL
					req_buf[0] = pPram->bRollRelative;
					req_buf[1] = pPram->bRollSpeed;
					result = 2;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
					req_buf[0] = pPram->bRollRelative;
					req_buf[1] = pPram->bRollSpeedMin;
					result = 2;
					break;
				case GET_MAX:
					req_buf[0] = pPram->bRollRelative;
					req_buf[1] = pPram->bRollSpeedMax;
					result = 2;
					break;

				case GET_RES:
					req_buf[0] = pPram->bRollRelative;
					req_buf[1] = pPram->bRollSpeedRes;
					result = 2;
					break;

				case GET_LEN:
					req_buf[0] = 2;
					result = 1;
						
				case GET_DEF:
					req_buf[0] = pPram->bRollRelative;
					req_buf[1] = pPram->bRollSpeedDef;
					result = 2;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
			}
			break;

		case CT_PRIVACY_CONTROL:
			switch(ctrl->bRequest){
				case SET_CUR:
					pPram->bPrivacy = req_buf[0];
					result = 0;
					break;
				case GET_CUR:
#if HAS_CT_PRIVACY_CONTROL
					req_buf[0] = pPram->bPrivacy;
					result = 1;
#else
					bCrntVcErrCode = ERR__INVALID_CONTROL;
#endif
					break;
				case GET_MIN:
				case GET_MAX:
				case GET_RES:

				case GET_DEF:
					result = 1;
					break;
				case GET_INFO:
					*(__u8*)req_buf = 0x03;
					result = 1;
					break;
				case GET_LEN:
					req_buf[0] = 1;
					result = 1;


			}
			break;

		default:
			break;
	}
	camera_set_state(&CameraCfg);
	return result;
}

//TODO : Initialize with proper defaults
void *get_vidcap_control_camera(void)
{
	return &camera_device;
}
