#include "uacdescript.h"
#include "uac_defs.h"
#include "dbgout.h"

#define STN_PRODUCT	2
#define HAS_LINE_IN	0
#define HAS_SELECTOR	0
#define HAS_MIC_IN	1

// TODO : move to platform_caps.h
#define HAS_AUD_FREQ_8000	0
#define HAS_AUD_FREQ_16000	0
#define HAS_AUD_FREQ_41000	0
#define HAS_AUD_FREQ_48000	1

#if HAS_AUD_CAP ==  1
// DO not modify the following
typedef enum _uac_alt_setting_index_t
{
	UAC_ALT_SETTING_INDEX_0,
#if HAS_AUD_FREQ_8000 == 1
	UAC_ALT_SETTING_INDEX_8000,
#endif
#if HAS_AUD_FREQ_16000 == 1
	UAC_ALT_SETTING_INDEX_16000,
#endif
#if HAS_AUD_FREQ_41000 == 1
	UAC_ALT_SETTING_INDEX_41000,
#endif
#if HAS_AUD_FREQ_48000 == 1
	UAC_ALT_SETTING_INDEX_48000,
#endif
	UAC_ALT_SETTING_INDEX_LAST
}uac_alt_setting_index_t;


#if HAS_AUD_FREQ_8000 == 1
struct usb_endpoint_descriptor uac_as_ep_alt_8000 = {
        .bLength                = DT_ENDPOINT_AUDIO_SIZE,
        .bDescriptorType        = DT_ENDPOINT,
        .bEndpointAddress       = DIR_IN |  AUD_CAP_EP_ADDR,
        .bmAttributes           = USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type,
        .wMaxPacketSize         = 0x10,
        .bInterval              = 0x4,
        .bRefresh               = 0x0,
        .bSynchAddress          = 0x0,
};
#endif
#if HAS_AUD_FREQ_16000 == 1
struct usb_endpoint_descriptor uac_as_ep_alt_16000 = {
        .bLength                = DT_ENDPOINT_AUDIO_SIZE,
        .bDescriptorType        = DT_ENDPOINT,
        .bEndpointAddress       = DIR_IN |  AUD_CAP_EP_ADDR,
        .bmAttributes           = USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type,
        .wMaxPacketSize         = 0x20,
        .bInterval              = 0x4,
        .bRefresh               = 0x0,
        .bSynchAddress          = 0x0,
};
#endif
#if HAS_AUD_FREQ_41000 == 1
struct usb_endpoint_descriptor uac_as_ep_alt_41000 = {
        .bLength                = DT_ENDPOINT_AUDIO_SIZE,
        .bDescriptorType        = DT_ENDPOINT,
        .bEndpointAddress       = DIR_IN |  AUD_CAP_EP_ADDR,
        .bmAttributes           = USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type,
        .wMaxPacketSize         = 0x52,
        .bInterval              = 0x4,
        .bRefresh               = 0x0,
        .bSynchAddress          = 0x0,
};
#endif
#if HAS_AUD_FREQ_48000 == 1
struct usb_endpoint_descriptor uac_as_ep_alt_48000 = {
        .bLength                = DT_ENDPOINT_AUDIO_SIZE,
        .bDescriptorType        = DT_ENDPOINT,
        .bEndpointAddress       = DIR_IN |  AUD_CAP_EP_ADDR,
        .bmAttributes           = USB_ENDPOINT_XFER_ISOC | (0x01 << 2),	// Asynchronous Synch type,
        .wMaxPacketSize         = 0x60,
        .bInterval              = 0x4,
        .bRefresh               = 0x0,
        .bSynchAddress          = 0x0,
};
#endif

struct uac_isoch_endpoint_descriptor as_isoch_endpoint_descriptor =  {
	.bLength				= 0x07,
	.bDescriptorType		= CS_ENDPOINT,	// CS_ENDPOINT.
	.bDescriptorSubType		= AS_GENERAL,	// General
	.bmAttributes			= 0x00, // sampling frequency control
	.bLockDelayUnits		= 0x00,
	.wLockDelay				= 0x00
};

static struct usb_interface_assoc_descriptor uac_iad_desc = 
{
	.bLength 		= sizeof(struct usb_interface_assoc_descriptor),
	.bDescriptorType 	= DT_INTERFACE_ASSOCIATION,
	.bFirstInterface	= UAC_CTRL_INTERFACE_INDEX, 	// interface # of the AudioControl interface that is associated with this function
	.bInterfaceCount	= 2,
	.bFunctionClass		= CLASS_AUDIO,			// Audio
	.bFunctionSubClass	= 0x00,				// 
	.bFunctionProtocol	= 0x00,				// UVC_PC_PROTOCOL_UNDEFINED,
	.iFunction		= STN_PRODUCT			// Index of a string descriptor that describes this interface. 
								// This must be used for the device (function) name and be 
								// implemented in US English (LANGID = 0x0409) at the minimum.
};

static const struct usb_interface_descriptor uac_audctrl_interface_descriptor = {
        .bLength                = 0x09, //sizeof(intf_main_srcsink),
        .bDescriptorType        = DT_INTERFACE, //INTERFACE descriptor type,
        .bInterfaceNumber       = UAC_CTRL_INTERFACE_INDEX,
        .bAlternateSetting      = 0x0,
        .bNumEndpoints          = 0x0,
        .bInterfaceClass        = CLASS_AUDIO, 
        .bInterfaceSubClass     = SUBCLASS_AUDIOCONTROL, 
        .bInterfaceProtocol     = 0x00, 
        .iInterface             = 0x00  
};

static const struct usb_interface_descriptor uac_as_interface_3_alt_0 = {
        .bLength                = 0x09, //sizeof(intf_main_srcsink),
        .bDescriptorType        = DT_INTERFACE, //INTERFACE descriptor type,
        .bInterfaceNumber       = UAC_STRM_INTERFACE_INDEX,
        .bAlternateSetting      = 0x0,
        .bNumEndpoints          = 0x0,
        .bInterfaceClass        = CLASS_AUDIO, //AUDIO,
        .bInterfaceSubClass     = SUBCLASS_AUDIOSTREAMING, //AUDIO_STREAMING,
        .bInterfaceProtocol     = 0x00, //UNUSED,
        .iInterface             = 0x00  //UNUSED,
};


#if HAS_AUD_FREQ_8000 == 1
static const struct usb_interface_descriptor uac_as_interface_alt_8000 = {
        .bLength                = 0x09, //sizeof(intf_main_srcsink),
        .bDescriptorType        = DT_INTERFACE, //INTERFACE descriptor type,
        .bInterfaceNumber       = UAC_STRM_INTERFACE_INDEX,
        .bAlternateSetting      = UAC_ALT_SETTING_INDEX_8000,
        .bNumEndpoints          = 0x01,
        .bInterfaceClass        = CLASS_AUDIO, //AUDIO,
        .bInterfaceSubClass     = SUBCLASS_AUDIOSTREAMING, //AUDIO_STREAMING,
        .bInterfaceProtocol     = 0x00, //UNUSED,
        .iInterface             = 0x00  //UNUSED,
};
#endif

#if HAS_AUD_FREQ_16000 == 1
static const struct usb_interface_descriptor uac_as_interface_alt_16000 = {
        .bLength                = 0x09, //sizeof(intf_main_srcsink),
        .bDescriptorType        = DT_INTERFACE, //INTERFACE descriptor type,
        .bInterfaceNumber       = UAC_STRM_INTERFACE_INDEX,
        .bAlternateSetting      = UAC_ALT_SETTING_INDEX_16000,
        .bNumEndpoints          = 0x01,
        .bInterfaceClass        = CLASS_AUDIO, //AUDIO,
        .bInterfaceSubClass     = SUBCLASS_AUDIOSTREAMING, //AUDIO_STREAMING,
        .bInterfaceProtocol     = 0x00, //UNUSED,
        .iInterface             = 0x00  //UNUSED,
};
#endif

#if HAS_AUD_FREQ_41000 == 1
static const struct usb_interface_descriptor uac_as_interface_alt_41000 = {
        .bLength                = 0x09, //sizeof(intf_main_srcsink),
        .bDescriptorType        = DT_INTERFACE, //INTERFACE descriptor type,
        .bInterfaceNumber       = UAC_STRM_INTERFACE_INDEX,
        .bAlternateSetting      = UAC_ALT_SETTING_INDEX_41000,
        .bNumEndpoints          = 0x01,
        .bInterfaceClass        = CLASS_AUDIO, //AUDIO,
        .bInterfaceSubClass     = SUBCLASS_AUDIOSTREAMING, //AUDIO_STREAMING,
        .bInterfaceProtocol     = 0x00, //UNUSED,
        .iInterface             = 0x00  //UNUSED,
};
#endif

#if HAS_AUD_FREQ_48000 == 1
static const struct usb_interface_descriptor uac_as_interface_alt_48000 = {
        .bLength                = 0x09, //sizeof(intf_main_srcsink),
        .bDescriptorType        = DT_INTERFACE, //INTERFACE descriptor type,
        .bInterfaceNumber       = UAC_STRM_INTERFACE_INDEX,
        .bAlternateSetting      = UAC_ALT_SETTING_INDEX_48000,
        .bNumEndpoints          = 0x01,
        .bInterfaceClass        = CLASS_AUDIO, //AUDIO,
        .bInterfaceSubClass     = SUBCLASS_AUDIOSTREAMING, //AUDIO_STREAMING,
        .bInterfaceProtocol     = 0x00, //UNUSED,
        .iInterface             = 0x00  //UNUSED,
};
#endif

static const struct uac_input_terminal_descriptor intf_it_mic = {
        .bLength                = 0x0C,
        .bDescriptorType        = CS_INTERFACE, // CS_INTERFACE.,
        .bDescriptorSubType     = INPUT_TERMINAL,         // INPUT_TERMINAL,
        .bTerminalID            = INPUT_TERMINAL_MIC_ID,         // ID of this terminal
        .wTerminalType          = MICROPHONE,       // Mic Input,
        .bAssocTerminal         = 0x00,         // no association
        .bNrChannels            = 0x01,         // unused
        .wChannelConfig         = 0x0000,       // Mono
        .iChannelNames          = 0x00,
        .iTerminal              = 0x00,
};

// camera IT
static const struct uac_input_terminal_descriptor intf_it_line = {
        .bLength                = 0x0C,
        .bDescriptorType        = CS_INTERFACE,
        .bDescriptorSubType     = INPUT_TERMINAL,
        .bTerminalID            = INPUT_TERMINAL_LINE_ID,         // ID of this terminal
        .wTerminalType          = LINE_CONNECTOR,       // Line
        .bAssocTerminal         = 0x00,         // no association
        .bNrChannels            = 0x01,         // 1 channel
        .wChannelConfig         = 0x00,         //Mono set
        .iChannelNames          = 0x00,         // Not used
        .iTerminal              = 0x00,         //Not used
};

static const struct uac_feature_unit_descriptor aud_feature_unit_descriptor = {
        .bLength		= 0x0B,                 /* 6 +(ch+1)*4  bytes */
        .bDescriptorType	= CS_INTERFACE,      /* CS_INTERFACE */
        .bDescriptorSubType	= FEATURE_UNIT,       	/* FEATURE_UNIT */
        .bUnitID		= FEATURE_UNIT_ID,
        .bSourceID		= 0x01,                	/* ID of the Unit or Terminal to which first Clk Input Pin of this Mixer Unit is connected */
	.bControlSize 		= 0x02,
        .bmaControls00		= 0x01,            	/* Mute Control*/
        .bmaControls01		= 0x00,            	/* Mute Control*/
        .bmaControls10		= 0x02,            	/* Vol Control*/
        .bmaControls11		= 0x00,            	/* Vol Control*/
        .iFeature               = 0x00,   		/* Index of String Desc, describing iFeature Unit */
};

static const struct uac_output_terminal_descriptor intf_ot_aud = {
        .bLength                = 0x09,
        .bDescriptorType        = CS_INTERFACE,
        .bDescriptorSubType     = OUTPUT_TERMINAL,
        .bTerminalID            = OUTPUT_TERMINAL_ID, // ID of this terminal
        .wTerminalType          = USB_STREAMING,// USB Streaming
        .bAssocTerminal         = 0x00, // no association
        .bSourceID              = FEATURE_UNIT_ID, // our IN Endpoint -> input control -> Feature -> output control -> host
        .iTerminal              = 0x00, // unused
};

struct uac_selector_unit_descriptor aud_selector_unit_descriptor = {
        .bLength                = 0x09,
        .bDescriptorType        = CS_INTERFACE, 	// VC_SELECTOR_UNIT
        .bDescriptorSubType     = SELECTOR_UNIT,	// Selector unit
        .bUnitID                = SELECTOR_UNIT_ID,
        .bNrInPins              = 0x02, 		// number of input pins
        .baSourceID[0]          = 0x01, 		// connected to UNIT ID 0x01
        .baSourceID[1]          = 0x02, 		// connected to UNIT ID 0x02
        .iSelector              = 0x00  		// Not used
};

static const struct uac_ac_interface_descriptor uac_ac_class_interface_desc = {
        .bLength                = 0x09,
        .bDescriptorType        = CS_INTERFACE,      //CS_INTERFACE,
        .bDescriptorSubType     = HEADER,               // VC_HEADER,
        .bcdADC                 = 0x0100,
        .wTotalLength           = (sizeof(const struct uac_ac_interface_descriptor) 
#if HAS_MIC_IN == 1
                                                         + sizeof(const struct uac_input_terminal_descriptor) 
#endif
#if HAS_LINE_IN == 1                                     
							 + sizeof(const struct uac_input_terminal_descriptor) 
#endif
							 + sizeof(const struct uac_feature_unit_descriptor)
							 + sizeof(const struct uac_output_terminal_descriptor) 
#if HAS_SELECTOR == 1
                                                         + sizeof(const struct uac_selector_unit_descriptor)
#endif
														 ),
        .bInCollection          = 0x01,                 //Number of streaming interfaces
        .baInterfaceNr          = UAC_STRM_INTERFACE_INDEX,                 // audio streaming interface number 
};


struct uac_as_general_descriptor as_general_descriptor =  {
        .bLength                        = 0x07,
        .bDescriptorType                = CS_INTERFACE,
        .bDescriptorSubType             = AS_GENERAL,         // General
        .bTerminalLink                  = 0x04,		// Unit ID of the Output Terminal
        .bDelay                         = 0x01,         // Interface delay
        .wFormatTag                     = PCM,       // PCM
};

#if HAS_AUD_FREQ_8000 == 1

struct uac_as_type1_format_descriptor_singlefreq as_type1_format_descriptor_8000 =  {
        .bLength                        = 0x0B,
        .bDescriptorType                = CS_INTERFACE,
        .bDescriptorSubType             = FORMAT_TYPE,   //FORMAT Type
        .bFormatType                    = FORMAT_TYPE_I, // Format Type 1
        .bNrChannels                    = 0x01,
        .bSubFrameSize                  = 0x02, // Two bytes per slot
        .bBitResolution                 = 0x10, // 16 bit
        .bSamFreqType                   = 0x01, // One sampling freq
        .tSamFreq00                     = 0x40,
        .tSamFreq01                     = 0x1F,
        .tSamFreq02                     = 0x00,
};
#endif

#if HAS_AUD_FREQ_16000 == 1

struct uac_as_type1_format_descriptor_singlefreq as_type1_format_descriptor_16000 =  {
        .bLength                        = 0x0B,
        .bDescriptorType                = CS_INTERFACE,
        .bDescriptorSubType             = FORMAT_TYPE,   //FORMAT Type
        .bFormatType                    = FORMAT_TYPE_I, // Format Type 1
        .bNrChannels                    = 0x01,
        .bSubFrameSize                  = 0x02, // Two bytes per slot
        .bBitResolution                 = 0x10, // 16 bit
        .bSamFreqType                   = 0x01, // two sampling freq
        .tSamFreq00                     = 0x80,
        .tSamFreq01                     = 0x3E,
        .tSamFreq02                     = 0x00,
};

#endif

#if HAS_AUD_FREQ_41000 == 1

struct uac_as_type1_format_descriptor_singlefreq as_type1_format_descriptor_44100 =  {
        .bLength                        = 0x0B,
        .bDescriptorType                = CS_INTERFACE,
        .bDescriptorSubType             = FORMAT_TYPE,   //FORMAT Type
        .bFormatType                    = FORMAT_TYPE_I, // Format Type 1
        .bNrChannels                    = 0x01,
        .bSubFrameSize                  = 0x02, // Two bytes per slot
        .bBitResolution                 = 0x10, // 16 bit
        .bSamFreqType                   = 0x01, // One sampling freq
        .tSamFreq00                     = 0x44,
        .tSamFreq01                     = 0xAC,
        .tSamFreq02                     = 0x00,
};
#endif
#if HAS_AUD_FREQ_48000 == 1
struct uac_as_type1_format_descriptor_singlefreq as_type1_format_descriptor_48000 =  {
        .bLength                        = 0x0B,
        .bDescriptorType                = CS_INTERFACE,
        .bDescriptorSubType             = FORMAT_TYPE,   //FORMAT Type
        .bFormatType                    = FORMAT_TYPE_I, // Format Type 1
        .bNrChannels                    = 0x01,
        .bSubFrameSize                  = 0x02, // Two bytes per slot
        .bBitResolution                 = 0x10, // 16 bit
        .bSamFreqType                   = 0x01, // One sampling freq
        .tSamFreq00                     = 0x80,
        .tSamFreq01                     = 0xBB,
        .tSamFreq02                     = 0x00,
};
#endif

#endif


/******************************************************************************
 * USB function
 ******************************************************************************/
const struct usb_descriptor_header *uac_interface_descriptors[] = {
	// TODO : Add it under conditional compile for UV 1.0 only
	(struct usb_descriptor_header *)&uac_iad_desc,
#if HAS_AUD_CAP == 1
	(struct usb_descriptor_header *) &uac_audctrl_interface_descriptor,
        (struct usb_descriptor_header *) &uac_ac_class_interface_desc,
#if HAS_MIC_IN == 1
        (struct usb_descriptor_header *) &intf_it_mic,
#endif
#if HAS_LINE_IN == 1
        /*(struct usb_descriptor_header *) &intf_it_line,*/
#endif
        (struct usb_descriptor_header *) &aud_feature_unit_descriptor,
        (struct usb_descriptor_header *) &intf_ot_aud,
#if HAS_SELECTOR == 1
        (struct usb_descriptor_header *) &aud_selector_unit_descriptor,  / / Implement this one later to select between source*/
#endif
        (struct usb_descriptor_header *) &uac_as_interface_3_alt_0,

#if HAS_AUD_FREQ_8000 == 1
        (struct usb_descriptor_header *) &uac_as_interface_alt_8000,
	(struct usb_descriptor_header *) &as_general_descriptor,
	(struct usb_descriptor_header *) &as_type1_format_descriptor_8000,
        (struct usb_descriptor_header *) &uac_as_ep_alt_8000,
	(struct usb_descriptor_header *) &as_isoch_endpoint_descriptor,
#endif

#if HAS_AUD_FREQ_16000 == 1

	(struct usb_descriptor_header *) &uac_as_interface_alt_16000,
	(struct usb_descriptor_header *) &as_general_descriptor,
	(struct usb_descriptor_header *) &as_type1_format_descriptor_16000,
        (struct usb_descriptor_header *) &uac_as_ep_alt_16000,
	(struct usb_descriptor_header *) &as_isoch_endpoint_descriptor,
#endif
#if HAS_AUD_FREQ_41000 == 1
	(struct usb_descriptor_header *) &uac_as_interface_alt_41000,
	(struct usb_descriptor_header *) &as_general_descriptor,
	(struct usb_descriptor_header *) &as_type1_format_descriptor_44100,
        (struct usb_descriptor_header *) &uac_as_ep_alt_41000,
	(struct usb_descriptor_header *) &as_isoch_endpoint_descriptor,
#endif
#if HAS_AUD_FREQ_48000 == 1
	(struct usb_descriptor_header *) &uac_as_interface_alt_48000,
	(struct usb_descriptor_header *) &as_general_descriptor,
	(struct usb_descriptor_header *) &as_type1_format_descriptor_48000,
        (struct usb_descriptor_header *) &uac_as_ep_alt_48000,
	(struct usb_descriptor_header *) &as_isoch_endpoint_descriptor,
#endif
#endif
	NULL
};

struct usb_endpoint_descriptor *uac_get_endp_desc(int alt_setting)
{
	UAV_DBG_MSG("alt setting %d\n", alt_setting);
#if HAS_AUD_CAP == 1
	switch(alt_setting)
	{
#if HAS_AUD_FREQ_8000 == 1
		case UAC_ALT_SETTING_INDEX_8000:
			return &uac_as_ep_alt_8000;
			break;
#endif
#if HAS_AUD_FREQ_16000 == 1
		case UAC_ALT_SETTING_INDEX_16000:
			return &uac_as_ep_alt_16000;
			break;
#endif
#if HAS_AUD_FREQ_41000 == 1
		case UAC_ALT_SETTING_INDEX_41000:
			return &uac_as_ep_alt_41000;
			break;
#endif
#if HAS_AUD_FREQ_48000 == 1
		case UAC_ALT_SETTING_INDEX_48000:
			return &uac_as_ep_alt_48000;
			break;
#endif
		case UAC_ALT_SETTING_INDEX_0:
		default:
			UAV_DBG_MSG("Unknown alt setting %d\n", alt_setting);
			return NULL;
			break;
	}
#endif
	return NULL;
}

