/*
 * USB Audio Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 *
 */

#define DIR_IN			0x80
#define DIR_OUT			0

#define CLASS_PER_INTERFACE     0       /* for DeviceClass */
#define CLASS_AUDIO             1
#define CLASS_HID               3
#define CLASS_PHYSICAL          5
#define CLASS_STILL_IMAGE       6
#define CLASS_CDC_DATA          0x0a
#define CLASS_CONTENT_SEC       0x0d    /* content security */
#define CLASS_VIDEO             0x0e
#define CLASS_MISC              0xef
#define CLASS_APP_SPEC          0xfe
#define CLASS_VENDOR_SPEC       0xff



/* A.2 Audio Interface Subclass Codes */
#define SUBCLASS_AUDIOCONTROL       0x01
#define SUBCLASS_AUDIOSTREAMING     0x02
#define SUBCLASS_MIDISTREAMING      0x03


#define DT_DEVICE               	0x01
#define DT_CONFIG               	0x02
#define DT_STRING               	0x03
#define DT_INTERFACE            	0x04
#define DT_ENDPOINT             	0x05
#define DT_DEVICE_QUALIFIER     	0x06
#define DT_OTHER_SPEED_CONFIG   	0x07
#define DT_INTERFACE_POWER      	0x08
#define DT_INTERFACE_ASSOCIATION      	0x0B

#define DT_ENDPOINT_AUDIO_SIZE		9

#define AS_DESCRIPTOR_UNDEFINED 	0x00
#define AS_GENERAL              	0x01
#define FORMAT_TYPE             	0x02
#define FORMAT_SPECIFIC         	0x03




#define CS_UNDEFINED     		0x20
#define CS_DEVICE        		0x21
#define CS_CONFIGURATION 		0x22
#define CS_STRING        		0x23
#define CS_INTERFACE     		0x24
#define CS_ENDPOINT      		0x25



#define REQUEST_CODE_UNDEFINED  	0x00
#define SET_CUR                 	0x01
#define GET_CUR                 	0x81
#define SET_MIN                 	0x02
#define GET_MIN                 	0x82
#define SET_MAX                 	0x03
#define GET_MAX                 	0x83
#define SET_RES                 	0x04
#define GET_RES                 	0x84
#define SET_MEM                 	0x05
#define GET_MEM                 	0x85
#define GET_STAT                	0xFF



#define AC_DESCRIPTOR_UNDEFINED 	0x00
#define HEADER                  	0x01
#define INPUT_TERMINAL          	0x02
#define OUTPUT_TERMINAL         	0x03
#define MIXER_UNIT              	0x04
#define SELECTOR_UNIT           	0x05
#define FEATURE_UNIT            	0x06
#define PROCESSING_UNIT         	0x07
#define EXTENSION_UNIT          	0x08


#define INPUT_TERMINAL_MIC_ID           0x01
#define INPUT_TERMINAL_LINE_ID          0x02
#define FEATURE_UNIT_ID                 0x03
#define OUTPUT_TERMINAL_ID              0x04
#define SELECTOR_UNIT_ID                0x05

/*                  TERMINAL TYPES                            */

#define INPUT_UNDEFINED         	0x0200  // Input Terminal, undefined Type.
#define MICROPHONE              	0x0201  // generic microphone 
#define DESKTOP_MICROPHONE      	0x0202 	// microphone on desktop or integrated into the monitor.
#define PERSONAL_MICROPHONE     	0x0203 	// head-mounted or clip-on microphone.
#define OMNI_DIRECTIONAL_MICROPHONE 	0x0204 	// microphone designed to pick up voice from more than one speaker at relatively long ranges.
#define MICROPHONE_ARRAY        	0x0205 	// array of microphones designed for directional processing using host-based signal processing algorithms.
#define PROCESSING_MICROPHONE_ARRAY     0x0206
#define LINE_CONNECTOR			0x0603
#define USB_UNDEFINE       		0x0100   // I/O USB Terminal, undefined Type.
#define USB_STREAMING       		0x0101   // I/O A Terminal dealing with a signal carried
                               			 // over an endpoint in an AudioStreaming
                               			 // interface. The AudioStreaming interface
                               			 // descriptor points to the associated
                               			 //Terminal through the bTerminalLink field.
#define USB_VENDOR_SPECIFIC 		0x01FF

/*                     Control Selector               */

#define	TE_CONTROL_UNDEFINED    	0x00
#define COPY_PROTECT_CONTROL    	0x01
#define FU_CONTROL_UNDEFINED    	0x00
#define MUTE_CONTROL            	0x01
#define VOLUME_CONTROL          	0x02
#define BASS_CONTROL            	0x03
#define MID_CONTROL             	0x04
#define TREBLE_CONTROL          	0x05
#define GRAPHIC_EQUALIZER_CONTROL	0x06
#define AUTOMATIC_GAIN_CONTROL          0x07
#define DELAY_CONTROL                   0x08
#define BASS_BOOST_CONTROL              0x09
#define LOUDNESS_CONTROL                0x0A

#define TYPE_I_UNDEFINED 		0x0000
#define PCM              		0x0001
#define PCM8             		0x0002
#define IEEE_FLOAT       		0x0003
#define ALAW             		0x0004
#define MULAW            		0x0005


#define TYPE_II_UNDEFINED 		0x1000
#define MPEG				0x1001
#define AC_3				0x1002

#define FORMAT_TYPE_UNDEFINED 		0x00
#define FORMAT_TYPE_I         		0x01
#define FORMAT_TYPE_II        		0x02


/*
 * Endpoints
 */
#define ENDPOINT_NUMBER_MASK        0x0f    /* in bEndpointAddress */
#define ENDPOINT_DIR_MASK           0x80

#define ENDPOINT_XFERTYPE_MASK      0x03    /* in bmAttributes */
#define ENDPOINT_XFER_CONTROL       0
#define ENDPOINT_XFER_ISOC          1
#define ENDPOINT_XFER_BULK          2
#define ENDPOINT_XFER_INT           3
#define ENDPOINT_MAX_ADJUSTABLE     0x80


/*
*Below are definition for Channel Configuration
* where F - Front/Frequency
*      L - Left/Low
*        C - Center
*        B - Back
*        R - Right
*        S - Side
*        T - Top
*        RD - Raw Data
*/
#define FL      (1 << 0)
#define FR      (1 << 1)
#define FC      (1 << 2)
#define LFE     (1 << 3)
#define BL      (1 << 4)
#define BR      (1 << 5)
#define FLC     (1 << 6)
#define FRC     (1 << 7)
#define B       (1 << 8)
#define SL      (1 << 9)
#define SR      (1 << 10)
#define TC      (1 << 11)
#define TFL     (1 << 12)
#define TFC     (1 << 13)
#define TFR     (1 << 14)
#define TBL     (1 << 15)
#define TBC     (1 << 16)
#define TBR     (1 << 17)
#define TFLC    (1 << 18)
#define TFRC    (1 << 19)
#define LLFE    (1 << 20)
#define RLFE    (1 << 21)
#define TSL     (1 << 22)
#define TSR     (1 << 23)
#define BC      (1 << 24)
#define BLC     (1 << 25)
#define BRC     (1 << 26)
#define RD      (1 << 31)

