/*
 * usb_cap_interface.c USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 *
 * The file implements mjpeg frame descriptors. These desciptors are common
 * for capture or encode interfaces.
 *
 */

#include "mjpg_frame_descript.h"


#if HAS_MJPEG_RES_120	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_120 = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_120),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			=  MJPEG_FRAME_INDEX_RES_120,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					= 160,
	.wHeight				= 120,
	.dwMinBitRate			= MJPEG_160_120_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_160_120_BITRATE_MAX,
	.dwMaxVideoFrameBufSize = MJPEG_160_120_MAX_FRM_SIZE,
	.dwDefaultFrameInterval	= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif

#if HAS_MJPEG_RES_144	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_144 = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_144),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			=  MJPEG_FRAME_INDEX_RES_144,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					= 176,
	.wHeight				= 144,
	.dwMinBitRate			= MJPEG_176_144_BITRATE_MIN,	
	.dwMaxBitRate			= MJPEG_176_144_BITRATE_MAX,
	.dwMaxVideoFrameBufSize = MJPEG_176_144_MAX_FRM_SIZE,
	.dwDefaultFrameInterval		= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif

#if HAS_MJPEG_RES_240	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_240 = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_240),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			=  MJPEG_FRAME_INDEX_RES_240,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					= 320,
	.wHeight				= 240,
	.dwMinBitRate			= MJPEG_320_240_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_320_240_BITRATE_MAX,
	.dwMaxVideoFrameBufSize = MJPEG_320_240_MAX_FRM_SIZE,
	.dwDefaultFrameInterval	= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif

#if HAS_MJPEG_RES_240W	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_240W = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_240W),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			=  MJPEG_FRAME_INDEX_RES_240W,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					= 384,
	.wHeight				= 240,
	.dwMinBitRate			= MJPEG_320_240_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_320_240_BITRATE_MAX,
	.dwMaxVideoFrameBufSize = MJPEG_320_240_MAX_FRM_SIZE,
	.dwDefaultFrameInterval	= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif
#if HAS_MJPEG_RES_288	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_288 = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_288),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			= MJPEG_FRAME_INDEX_RES_288,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					= 352,
	.wHeight				= 288,
	.dwMinBitRate			= MJPEG_352_288_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_352_288_BITRATE_MAX,
	.dwMaxVideoFrameBufSize = MJPEG_352_288_MAX_FRM_SIZE,
	.dwDefaultFrameInterval	= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif

#if HAS_MJPEG_RES_480I	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_480I = {
    .bLength                        = sizeof(vs_frame_descriptor_mjpg_480I),
    .bDescriptorType                = USB_DT_CS_INTERFACE,
    .bDescriptorSubType             = VS_FRAME_MJPEG,
    .bFrameIndex                    = MJPEG_FRAME_INDEX_RES_480I,
    .bmCapabilities                 = MJPEG_BMCAPABILITIES,
    .wWidth                         = 720,
    .wHeight                        = 480,
    .dwMinBitRate                   = MJPEG_640_480_BITRATE_MIN,
    .dwMaxBitRate                   = MJPEG_640_480_BITRATE_MAX,
    .dwMaxVideoFrameBufSize         = MJPEG_640_480_MAX_FRM_SIZE,
    .dwDefaultFrameInterval		= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif


#if HAS_MJPEG_RES_480P	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_480P = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_480P),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			= MJPEG_FRAME_INDEX_RES_480P,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					= 640,
	.wHeight				= 480,
	.dwMinBitRate			= MJPEG_640_480_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_640_480_BITRATE_MAX,
	.dwMaxVideoFrameBufSize = MJPEG_640_480_MAX_FRM_SIZE,
	.dwDefaultFrameInterval	= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif

#if HAS_MJPEG_RES_480W	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_480W = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_480W),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			= MJPEG_FRAME_INDEX_RES_480W,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					= 768,
	.wHeight				= 480,
	.dwMinBitRate			=MJPEG_640_480_BITRATE_MIN,
	.dwMaxBitRate			=MJPEG_640_480_BITRATE_MAX,
	.dwMaxVideoFrameBufSize =MJPEG_640_480_MAX_FRM_SIZE,
	.dwDefaultFrameInterval	= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif

#if HAS_MJPEG_RES_576I	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_576I = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_576I),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			= MJPEG_FRAME_INDEX_RES_576I,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					=  704,
	.wHeight				=  576,
	.dwMinBitRate			= MJPEG_640_480_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_640_480_BITRATE_MAX,
	.dwMaxVideoFrameBufSize = MJPEG_640_480_MAX_FRM_SIZE,
	.dwDefaultFrameInterval	= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif


#if HAS_MJPEG_RES_576P	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_576P = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_576P),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			= MJPEG_FRAME_INDEX_RES_576P,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					=  704,
	.wHeight				=  576,
	.dwMinBitRate			= MJPEG_640_480_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_640_480_BITRATE_MAX,
	.dwMaxVideoFrameBufSize = MJPEG_640_480_MAX_FRM_SIZE,
	.dwDefaultFrameInterval	= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif

#if HAS_MJPEG_RES_720	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_720 = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_720),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			= MJPEG_FRAME_INDEX_RES_720,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth					= 0x0500,	// 1280
	.wHeight				= 0x02D0,	// 720
	.dwMinBitRate			= MJPEG_1280_720_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_1280_720_BITRATE_MAX,	
	.dwMaxVideoFrameBufSize = MJPEG_1280_720_MAX_FRM_SIZE,	
	.dwDefaultFrameInterval	= 0x00145855,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif

  
#if HAS_MJPEG_RES_800	== 1
struct uvc_vs_frame_descriptor_mjpg vs_frame_descriptor_mjpg_800 = {
	.bLength 			= sizeof(vs_frame_descriptor_mjpg_800),
	.bDescriptorType		= USB_DT_CS_INTERFACE,
	.bDescriptorSubType		= VS_FRAME_MJPEG,
	.bFrameIndex			= MJPEG_FRAME_INDEX_RES_800,
	.bmCapabilities			= MJPEG_BMCAPABILITIES,
	.wWidth				= 1280,	
	.wHeight			= 800,		
	.dwMinBitRate			= MJPEG_1280_720_BITRATE_MIN,
	.dwMaxBitRate			= MJPEG_1280_720_BITRATE_MAX,	
	.dwMaxVideoFrameBufSize = MJPEG_1280_720_MAX_FRM_SIZE,	
	.dwDefaultFrameInterval		= 0x0051615,
	.bFrameIntervalType		= NUM_MJPEG_FRMAE_INTERVALS,
	.dwFrameInterval		= LISTMJPEG_FRMAE_INTERVALS
};
#endif




const struct usb_descriptor_header *mjpeg_frame_descriptors[] = 
{
	DEFINE_MJPG_FRAME_DESCRIPT
};


struct uvc_streaming_control_request	mjpeg_param_table[MJPEG_FRAME_INDEX_LAST][PROBE_INDEX_LAST] = 
{
#if HAS_MJPEG_RES_480P	== 1
/*
**  bmHnt     bFormatIndex   bFrameIndex    dwFrameInterval     wKeyFrmRate    wPFrmeRate     wCompQuality   wCompWindowSize     wDelay         dwMaxVideoFrameSize      dwMaxPayloadTransferSize
*/
 {
  { 0x0000,   0,             0,             333333,             1,             0,             0,              0,                 50,             32000,                  PKT_SIZE_ISOC6},	/* MIN */
  { 0x0000,   0,             0,             3333330,            1000,          0,             10000,          0,                 50,            128000,                  PKT_SIZE_ISOC6},	/* Max */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,             64000,                  PKT_SIZE_ISOC6},	/* Def */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,             64000,                  PKT_SIZE_ISOC6},	/* Cur */
  { 0x0000,   0,             0,             333333,             1,             0,             100,            0,                 0,             0,                       0},	/* Res */
 },

#endif
#if HAS_MJPEG_RES_288	== 1
 {
  {0x0000,    0,          0,                 10000000,            1,               0,	          0,            0,               50,             64000,                   PKT_SIZE_ISOC5},	/* MIN */
  {0x0000,    0,          0,                 330000,              1000,            0,	          10000,        0,               50,             64000,                   PKT_SIZE_ISOC5},	/* Max */
  {0x0000,    0,          0,                 330000,              15,              0,	          5000,         0,               50,             64000,                   PKT_SIZE_ISOC5},	/* Def */
  {0x0000,    0,          0,                 330000,              15,              0,             5000,         0,               50,             64000,                   PKT_SIZE_ISOC5},	/* Cur */
  {0x0000,    0,          0,                 330000,              1,               0,             100,          0,                0,             0,                       0},	/* Res */
 },
#endif
/*
**  bmHnt     bFormatIndex   bFrameIndex    dwFrameInterval     wKeyFrmRate    wPFrmeRate     wCompQuality   wCompWindowSize     wDelay         dwMaxVideoFrameSize      dwMaxPayloadTransferSize
*/

#if HAS_MJPEG_RES_240	== 1
 {
  {0x0000,    0,          0,                 10000000,            1,               0,	          0,            0,               50,             64000,                   PKT_SIZE_ISOC5},	/* MIN */
  {0x0000,    0,          0,                 330000,              1000,            0,	          10000,        0,               50,             64000,                   PKT_SIZE_ISOC5},	/* Max */
  {0x0000,    0,          0,                 330000,              15,              0,	          5000,         0,               50,             64000,                   PKT_SIZE_ISOC5},	/* Def */
  {0x0000,    0,          0,                 330000,              15,              0,             5000,         0,               50,             64000,                   PKT_SIZE_ISOC5},	/* Cur */
  {0x0000,    0,          0,                 330000,              1,               0,             100,          0,                0,             0,                       0},	/* Res */
 },
#endif
#if HAS_MJPEG_RES_144	== 1
 {
  {0x0000,     0,          0,                 10000000,           1,               0,              0,            0,              50,             128000,                  PKT_SIZE_ISOC5},	/* MIN */
  {0x0000,     0,          0,                 330000,             1000,            0,              10000,        0,              50,             128000,                  PKT_SIZE_ISOC5},	/* Max */
  {0x0000,     0,          0,                 330000,             15,              0,              5000,         0,              50,             128000,                  PKT_SIZE_ISOC5},	/* Def */
  {0x0000,     0,          0,                 330000,             15,              0,              5000,         0,              50,             128000,                  PKT_SIZE_ISOC5},	/* Cur */
  {0x0000,     0,          0,                 330000,             1,               0,              100,          0,              0,              0,                       0},	/* Res */
 },
#endif
#if HAS_MJPEG_RES_120	== 1
 {
  {0x0000,     0,          0,                 10000000,           1,               0,              0,            0,              50,             128000,                  PKT_SIZE_ISOC5},	/* MIN */
  {0x0000,     0,          0,                 330000,             1000,            0,              10000,        0,              50,             128000,                  PKT_SIZE_ISOC5},	/* Max */
  {0x0000,     0,          0,                 330000,             15,              0,              5000,         0,              50,             128000,                  PKT_SIZE_ISOC5},	/* Def */
  {0x0000,     0,          0,                 330000,             15,              0,              5000,         0,              50,             128000,                  PKT_SIZE_ISOC5},	/* Cur */
  {0x0000,     0,          0,                 330000,             1,               0,              100,          0,              0,              0,                       0},	/* Res */
 },
#endif
#if HAS_MJPEG_RES_720	== 1
/*
**  bmHnt     bFormatIndex   bFrameIndex    dwFrameInterval     wKeyFrmRate    wPFrmeRate     wCompQuality   wCompWindowSize     wDelay         dwMaxVideoFrameSize      dwMaxPayloadTransferSize
*/

 {
  {  0x0000,  0,             0,             0x00051615,         1,             0,             0,             0,                  50,             0x00010000,                PKT_SIZE_ISOC7},	/* MIN */
  {  0x0000,  0,             0,             0x001E8480,         1000,          0,             10000,         0,                  50,             0x00020000,                PKT_SIZE_ISOC7},	/* Max */
  {  0x0000,  0,             0,             0x00051615,         500,           0,             5000,          0,                  50,             0x00020000,                PKT_SIZE_ISOC7},	/* Def */
  {  0x0000,  0,             0,             0x0007A120,         500,           0,             5000,          0,                  50,             0x00020000,                PKT_SIZE_ISOC7},	/* Cur */
  {  0x0000,  0,             0,             0,                  1,             0,             100,           0,                  0,              0,                       0},	/* Res */
 },
#endif

#if HAS_MJPEG_RES_480I	== 1
/*
**  bmHnt     bFormatIndex   bFrameIndex    dwFrameInterval     wKeyFrmRate    wPFrmeRate     wCompQuality   wCompWindowSize     wDelay         dwMaxVideoFrameSize      dwMaxPayloadTransferSize
*/

 {
  { 0x0000,   0,             0,             333333,             1,             0,             0,              0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* MIN */
  { 0x0000,   0,             0,             3333330,            1000,          0,             10000,          0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Max */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Def */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Cur */
  { 0x0000,   0,             0,             333333,             1,             0,             100,            0,                 0,             0,                       0},	/* Res */
 },
#endif
#if HAS_MJPEG_RES_480W	== 1
 {
  { 0x0000,   0,             0,             333333,             1,             0,             0,              0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* MIN */
  { 0x0000,   0,             0,             3333330,            1000,          0,             10000,          0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Max */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Def */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Cur */
  { 0x0000,   0,             0,             333333,             1,             0,             100,            0,                 0,             0,                       0},	/* Res */
 },
#endif
#if HAS_MJPEG_RES_576I	== 1
 {
  { 0x0000,   0,             0,             333333,             1,             0,             0,              0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* MIN */
  { 0x0000,   0,             0,             3333330,            1000,          0,             10000,          0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Max */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Def */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Cur */
  { 0x0000,   0,             0,             333333,             1,             0,             100,            0,                 0,             0,                       0},	/* Res */
 },
#endif
#if HAS_MJPEG_RES_576P	== 1
 {
  { 0x0000,   0,             0,             333333,             1,             0,             0,              0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* MIN */
  { 0x0000,   0,             0,             3333330,            1000,          0,             10000,          0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Max */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Def */
  { 0x0000,   0,             0,             333333,             15,            0,             5000,           0,                 50,            256000,                  PKT_SIZE_ISOC6},	/* Cur */
  { 0x0000,   0,             0,             333333,             1,             0,             100,            0,                 0,             0,                       0},	/* Res */
 },
#endif
#if HAS_MJPEG_RES_800	== 1
 {
  {  0x0000,  0,             0,             330000,             1,             0,             0,             0,                  50,            512000,                  PKT_SIZE_ISOC7},	/* MIN */
  {  0x0000,  0,             0,             10000000,           1000,          0,             10000,         0,                  50,            512000,                  PKT_SIZE_ISOC7},	/* Max */
  {  0x0000,  0,             0,             330000,             15,            0,             5000,          0,                  50,            512000,                  PKT_SIZE_ISOC7},	/* Def */
  {  0x0000,  0,             0,             330000,             15,            0,             5000,          0,                  50,            512000,                  PKT_SIZE_ISOC7},	/* Cur */
  {  0x0000,  0,             0,             330000,             1,             0,             100,           0,                  0,             0,                       0},	/* Res */
 },
#endif
};
