/*
 * USB Video Class interface implementation
 *
 * (C) Copyright 2009 MCN Technologies Inc.
 *
 * The file defines bitrate ranges for MJPEG and H264 
 *
 */

#ifndef __MJPEG_PARAM__
#define __MJPEG_PARAM__

#define NUM_MJPEG_FRMAE_INTERVALS	6
/*
** Supported frame intervals in 100 nano second units
*/
//#define LISTMJPEG_FRMAE_INTERVALS	{0x00051615, 0x00061A80, 0x0007A120, 0x000A2C2A, 0x000F4240, 0x001E8480}
#define LISTMJPEG_FRMAE_INTERVALS	{0x00051615/*33.33 ms */, 0x00061A80, 0x0007A120, 0x000A2C2A, 0x00145855, 0x001E8480/*200ms*/}

/*
** min and max bitartes for MJPEG
** XXX_BITRATE_MIN	is bit rate corresponding low quality(0) lowest frame rate(5fps)
** XXX_BITRATE_MAX	is bit rate corresponding high quality(10000) highest frame rate(30fps)
** XXX_MAX_FRM_SIZE ia maximum frame size in bytes
*/
#define MJPEG_160_120_BITRATE_MIN	128000
#define MJPEG_160_120_BITRATE_MAX	256000
#define MJPEG_160_120_MAX_FRM_SIZE	10000

#define MJPEG_176_144_BITRATE_MIN	128000
#define MJPEG_176_144_BITRATE_MAX	256000
#define MJPEG_176_144_MAX_FRM_SIZE	10000

#define MJPEG_320_240_BITRATE_MIN	512000
#define MJPEG_320_240_BITRATE_MAX	1000000
#define MJPEG_320_240_MAX_FRM_SIZE	20000

#define MJPEG_352_288_BITRATE_MIN	512000
#define MJPEG_352_288_BITRATE_MAX	1000000
#define MJPEG_352_288_MAX_FRM_SIZE	20000

// TODO: Low bitrates show blockiness. Set higher bit rates for now
#define MJPEG_640_480_BITRATE_MIN	4000000
#define MJPEG_640_480_BITRATE_MAX	6000000
#define MJPEG_640_480_MAX_FRM_SIZE	64000

#define MJPEG_704_576_BITRATE_MIN	4000000
#define MJPEG_704_576_BITRATE_MAX	6000000
#define MJPEG_704_576_MAX_FRM_SIZE	64000

// TODO: Enable the higher bitrates after enabling multiple pkts per micro-frame on  ISOC
#define MJPEG_1280_720_BITRATE_MIN	6000000
#define MJPEG_1280_720_BITRATE_MAX	8000000
#define MJPEG_1280_720_MAX_FRM_SIZE	128000

#define MJPEG_1280_800_BITRATE_MIN	6000000
#define MJPEG_1280_800_BITRATE_MAX	8000000
#define MJPEG_1280_800_MAX_FRM_SIZE	128000

#endif //__MJPEG_PARAM__
