#ifndef __DBG_OUT_H__
#define __DBG_OUT_H__
#include <linux/types.h>
#include <linux/kernel.h>
extern uint32_t dbg_mask;

#define DBG_ANY		(0xFF)
#define DBG_OFF		0

#define DBG_ERR		(0x01)
#define DBG_WARN	(0x02)
#define DBG_CFG		(0x04)
#define DBG_MSG		(0x08)
#define DBG_STRM	(0x10)	

/** Prefix string for DWC_DEBUG print macros. */
#define USB_DWC "DWC_otg: "

#ifdef DEBUG

# define UAV_DBG(msk, fmt, x...) \
	do{ \
		if ((msk) & dbg_mask) \
			printk(/*KERN_DEBUG*/ "UAV[%s] " fmt, __func__, ##x); \
	} while(0)

# define UAV_ERR(msk, fmt, x...) \
	do{ \
			printk(/*KERN_DEBUG*/ "UAV[%s] " fmt, __func__, ##x); \
	} while(0)

# define UAV_DBG_ERR(x...)	UAV_DBG(DBG_ERR, x )
# define UAV_DBG_WARN(x...)	UAV_DBG(DBG_WARN, x )
# define UAV_DBG_CFG(x...)	UAV_DBG(DBG_CFG, x )
# define UAV_DBG_MSG(x...)	UAV_DBG(DBG_MSG, x )
# define UAV_DBG_STRM(x...)	UAV_DBG(DBG_STRM, x )
# define UAV_DBG_STATE(x...)	UAV_DBG(DBG_STATE, x )
#else

# define UAV_DBG_MSG(lvl, x...) do{}while(0)
# define UAV_DBG_WARN(x...)	
# define UAV_DBG_CFG(x...)
# define UAV_DBG_ERR(x...)
# define UAV_DBG_STRM(x...)	
# define UAV_DBG_STATE(x...)	

#endif /*DEBUG*/


#endif //__DBG_OUT_H__
