/*******************************************************************************
* 
* The content of this file or document is CONFIDENTIAL and PROPRIETARY
* to Mobilygen Corporation.  It is subject to the terms of a
* License Agreement between Licensee and Mobilygen Corporation.
* restricting among other things, the use, reproduction, distribution
* and transfer.  Each of the embodiments, including this information and
* any derivative work shall retain this copyright notice.
* 
* Copyright 2007 Mobilygen Corporation
* All rights reserved.
* 
* QuArc is a registered trademark of Mobilygen Corporation.
* 
*******************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <endian.h>

#define DEBUG 0

/* these are take from qmmreset_qcc_defs.h */
enum qcc_cmds {
	QCC_NONE	= 0x00,
	QCC_READ	= 'R',
	QCC_WRITE	= 'W',
	QCC_POLL	= 'P',
	QCC_CHECK	= 'C',
	QCC_MODIFY	= 'M',
	QCC_WAIT	= 'D',
};

/* taken from /tools/pub/qmm/hsi/merlin/include/src/m5_qcc_bid.h */
#define QCC_BID_QDBG_SYS        1       /* QMM Debug Unit (System QMM) */
#define QCC_BID_MBOX            2       /* Inter-CPU Mailbox (between System QMM & Arm or external Host) */
#define QCC_BID_QDBG_VID        3       /* QMM Debug Unit (Video QMM) */
#define QCC_BID_UART            5       /* QMM UART */
#define QCC_BID_BITSIF          6       /* Bitstream Interface */
#define QCC_BID_CHIPCTL         8       /* Chip Control register block */
#define QCC_BID_MMU             16      /* Memory Management Unit */
#define QCC_BID_PMC             17      /* Physical Memory Ctl. (SDRAM) */
#define QCC_BID_PMU             18      /* Partition Management Unit */
#define QCC_BID_AII0            24      /* Audio Input 0 Interface */
#define QCC_BID_AII1            25      /* Audio Input 1 Interface */
#define QCC_BID_AOI             26      /* Audio Output  Interface */
#define QCC_BID_VPU             32      /* Video Processing Unit (Video Output) */
#define QCC_BID_PME             34      /* Pre-Motion Estimation */
#define QCC_BID_VPP0            48      /* Video Pre-Processor 0 */
#define QCC_BID_VIN0            49      /* Video Input 0 */
#define QCC_BID_FBR             50      /* Frame Buffer Read Module (loop back to VPP) */
#define QCC_BID_VPP1            54      /* Video Pre-Processor 1 */
#define QCC_BID_VIN1            55      /* Video Input 1 */

FILE *input_fp, *output_fp;
#define MAX_LINE_LEN 1024

#define SWAP32(A) (((A & 0xff000000) >> 24) | \
		((A & 0x00ff0000) >> 8 ) | \
		((A & 0x0000ff00) << 8 ) | \
		((A & 0x000000ff) << 24))

#define SWAP16(A) (((A & 0xff00) >> 8 ) | \
		((A & 0x00ff) << 8 ))

#define FWRITE_DEBUG 0

#if DEBUG
#define dprintf(x...)  printf(x)
#if FWRITE_DEBUG
#define FWRITE(ptr, size, num, fp) \
	printf("fwrite: %x, %d, %d\n", *((uint32_t*)ptr), size, num); \
fwrite(ptr, size, num, fp)
#else
#define FWRITE(ptr, size, num, fp) \
	fwrite(ptr, size, num, fp)
#endif
#else
#define dprintf(x...)  do {} while(0)
#define FWRITE(ptr, size, num, fp) \
	fwrite(ptr, size, num, fp)
#endif

int fwriten(void *ptr, size_t size, size_t nmemb, FILE *stream)
{
	uint16_t short_data;
	uint32_t word_data;

	if (size == 1) {
		//dprintf("fwrite: 0x%01x, %d, %d\n", *(uint8_t*)ptr, size, nmemb);
		fwrite(ptr, size, nmemb, stream);
	}
	else if (size == 2) {
		short_data = SWAP16(*(uint16_t*)ptr);
		//dprintf("fwrite: 0x%04x, %d, %d\n", *(uint16_t*)ptr, size, nmemb);
		fwrite(&short_data, size, nmemb, stream);
	}
	else if (size == 4) {
		word_data = SWAP32(*(uint32_t*)ptr);
		//dprintf("fwrite: 0x%08x, %d, %d\n", word_data, size, nmemb);
		fwrite(&word_data, size, nmemb, stream);
	}
}

int8_t is_emptyline(char *line)
{        
	/* need to handle blank lines, # and 'comment' */
	if ((strlen(line) == 0)   || /* blank line */
			*line == '\0'     || /* null    */
			*line == '\n'     || /* lf    */
			*line == '#'      || /* comment    */
			(strncmp(line, "comment", 7) == 0)) {  /* reg file comment */
		return 1;
	}
	return 0;
}

#define CONDITION_CODE_EQ	0x1
#define CONDITION_CODE_NE	0x2
#define CONDITION_CODE_LT	0x3
#define CONDITION_CODE_LE	0x4
#define CONDITION_CODE_GT	0x5
#define CONDITION_CODE_GE	0x6

#define bytes_to_qccsize(bytes) (bytes == 4 ? 0 : bytes);


int read_csr_cmds(FILE *fp)
{
	char cmd_str[20];
	char str_arg[20];
	char env_var[256] = { '\0' };
	char line[MAX_LINE_LEN];
	char cmd[12];

	while (NULL != fgets(line, MAX_LINE_LEN, fp)) {

		uint32_t arg[5];
		uint32_t blockId=0, mask=0, addr=0, size=0, data=0, delay=0, cc=0;

		if (is_emptyline(line))
			continue;

		/* lets overscan */
		memset(arg, 0x0, sizeof(arg));
		sscanf(line, "%s %x %x %x %x %x %s",
				cmd_str, &arg[0], &arg[1], &arg[2], &arg[3], &arg[4], str_arg);

		/* we don't need chip control stuff */
		if (strcmp(cmd_str, "wait") != 0 && arg[0] == 8)
			continue;

		blockId = arg[0];

		if (strcmp(cmd_str, "read") == 0) {
			addr = arg[1];
			size = bytes_to_qccsize(arg[2]);
			data = 0x0;
			mask = 0x0;

			printf("\t{ %-12s %2d, 0x%04x, %d, 0x%08x, 0x%08x }, ",
					"QCC_READ,", blockId, addr, size, data, mask);
		}
		else if (strcmp(cmd_str, "write") == 0) {
			addr = arg[1];
			size = bytes_to_qccsize(arg[2]);
			data = arg[3];
			mask = 0x0;

			if (blockId != QCC_BID_PMU || (blockId == QCC_BID_PMU && addr < 0x200))
				printf("\t{ %-12s %2d, 0x%04x, %d, 0x%08x, 0x%08x }, ",
						"QCC_WRITE,", blockId, addr, size, data, mask);

		} 
#if 1
		else {
			fprintf(stderr, "Skipping unsupported command: %s\n", cmd_str);
			continue;
		}
#else
		else if (strcmp(cmd_str, "poll") == 0) {
			addr = arg[1];
			size = bytes_to_qccsize(arg[2]);
			mask = arg[3];
			data = arg[4];

			printf("\t{ %-12s %d, 0x%04x, %d, 0x%08x, 0x%08x }, ",
					"QCC_POLL,", blockId, addr, size, data, mask);

		}
		else if (strcmp(cmd_str, "check") == 0) {
			addr = arg[1];
			size = bytes_to_qccsize(arg[2]);
			mask = arg[3];
			data = arg[4];

			printf("\t{ %-12s %d, 0x%04x, %d, 0x%08x, 0x%08x }, ",
					"QCC_CHECK,", blockId, addr, size, data, mask);

			/*
			if (strcmp(str_arg, "eq") == 0) {
				cc = CONDITION_CODE_EQ;
			}
			else if (strcmp(str_arg, "ne") == 0) {
				cc = CONDITION_CODE_NE;
			} 
			else if (strcmp(str_arg, "lt") == 0) {
				cc = CONDITION_CODE_LT;
			} 
			else if (strcmp(str_arg, "le") == 0) {
				cc = CONDITION_CODE_LE;
			} 
			else if (strcmp(str_arg, "gt") == 0) {
				cc = CONDITION_CODE_GT;
			} 
			else if (strcmp(str_arg, "ge") == 0) {
				cc = CONDITION_CODE_GE;
			} 
			else {
				cc = CONDITION_CODE_EQ;
			}
			fwriten(&cc, 1, 1, output_fp);
			section_size += 14;
			*/
		}
		else if (strcmp(cmd_str, "modify") == 0) {
			addr = arg[1];
			size = bytes_to_qccsize(arg[2]);
			mask = arg[3];
			data = arg[4];

			printf("\t{ %-12s %d, 0x%04x, %d, 0x%08x, 0x%08x }, ",
					"QCC_MODIFY,", blockId, addr, size, data, mask);

		}
		else if (strcmp(cmd_str, "wait") == 0) {
			blockId = 0x0;
			addr = 0x0;
			size = 0x0;
			data = arg[0];
			mask = 0x0;

			printf("\t{ %-12s %d, 0x%04x, %d, 0x%08x, 0x%08x }, ",
					"QCC_WAIT,", blockId, addr, size, data, mask);
		}
#endif

		if (strcmp(cmd_str, "wait") != 0) {
			switch (blockId) {
				case QCC_BID_QDBG_SYS:
					printf("/* QDBG_SYS */\n");
					break;
				case QCC_BID_MBOX:
					printf("/* MBOX     */\n");
					break;
				case QCC_BID_QDBG_VID:
					printf("/* VID      */\n");
					break;
				case QCC_BID_UART:
					printf("/* UART     */\n");
					break;
				case QCC_BID_BITSIF:
					printf("/* BITSIF   */\n");
					break;
				case QCC_BID_CHIPCTL:
					printf("/* CHIPCTL  */\n");
					break;
				case QCC_BID_MMU:
					printf("/* MMU      */\n");
					break;
				case QCC_BID_PMC:
					printf("/* PMC      */\n");
					break;
				case QCC_BID_PMU:
					if (addr < 0x200)
						printf("/* PMU      */\n");
					break;
				case QCC_BID_AII0:
					printf("/* AII0     */\n");
					break;
				case QCC_BID_AII1:
					printf("/* AII1     */\n");
					break;
				case QCC_BID_AOI:
					printf("/* AOI      */\n");
					break;
				case QCC_BID_VPU:
					printf("/* VPU      */\n");
					break;
				case QCC_BID_PME:
					printf("/* PME      */\n");
					break;
				case QCC_BID_VPP0:
					printf("/* VPP0     */\n");
					break;
				case QCC_BID_VIN0:
					printf("/* VIN0     */\n");
					break;
				case QCC_BID_FBR:
					printf("/* FBR      */\n");
					break;
				case QCC_BID_VPP1:
					printf("/* VPP1     */\n");
					break;
				case QCC_BID_VIN1:
					printf("/* VIN1     */\n");
					break;
			}
		}
	}

	return 0;
}

#if 0
int read_arm_cmds(FILE *fp)
{

	char cmd_str[20];
	char line[MAX_LINE_LEN];
	char armfile[128];
	int section_size = 0;
	FILE *armfile_fp = NULL;
	int armfile_size = 0;

	while (NULL != fgets(line, MAX_LINE_LEN, input_fp)) {

		uint32_t arg[3];
		uint32_t cmd=0, addr=0, data=0, mask=0, delay=0;

		//dprintf("%s read line: %s", __func__, line);
		if (is_emptyline(line))
			continue;

		memset(arg, 0x0, sizeof(arg));
		sscanf(line, "%s %x %x", cmd_str, &arg[0], &arg[1], &arg[2]);

		if (strcmp(cmd_str, "write") == 0) {
			/* cfg format:  write <addr> <data>
			*  env format:  'W' <addr> <data>
			*  size: 9
			 */
			cmd = 'W';
			addr = arg[0];
			data = arg[1];

			fwriten(&cmd, 1, 1, output_fp);
			fwriten(&addr, 4, 1, output_fp); /* addr */
			fwriten(&data, 4, 1, output_fp); /* data */
			section_size += 9; 
		}
		else if (strcmp(cmd_str, "read") == 0) {
			/* cfg format:  read <addr>
			*  env format:  'R' <addr> 
			*  size: 5
			 */
			cmd = 'R';
			addr = arg[0];

			fwriten(&cmd, 1, 1, output_fp);
			fwriten(&addr, 4, 1, output_fp);
			section_size += 5; 
		} 
		else if (strcmp(cmd_str, "poll") == 0) {
			/* cfg format:  poll ????
			*  env format:  'P'  ????
			*  size: ?????
			 */
			cmd = 'P';
			addr = arg[0];
			data = arg[1];
			mask = arg[2];

			fwriten(&cmd, 1, 1, output_fp);
			fwriten(&addr, 4, 1, output_fp);
			fwriten(&data, 4, 1, output_fp);
			fwriten(&mask, 4, 1, output_fp);
			section_size += 13; 
		}
		else if (strcmp(cmd_str, "wait") == 0) {
			/* cfg format:  wait count
			*  env format:  'W'  count
			*  size: ?
			 */
			cmd = 'D';
			delay = arg[0];

			fwriten(&cmd, 1, 1, output_fp);
			fwriten(&delay, 4, 1, output_fp);
			section_size += 5; 
		}
		else if (strcmp(cmd_str, "readfile") == 0) {
			sscanf(line, "%s %s", cmd_str, armfile);
			armfile_fp = fopen(armfile, "r");
			if (NULL == armfile_fp) {
				fprintf(stderr, "Failed to open csr file: %s\n", armfile_fp);
				return(-1);
			}
			armfile_size = read_arm_cmds(armfile_fp);
			fclose(armfile_fp);
			if (armfile_size < 0) {
				return(-1);
			}
			else {
				section_size += armfile_size;
			}
		}
		else if (strcmp(cmd_str, env_sections_str[ENV_END_SECTION]) == 0) {
			break;
		}
		else {
			fprintf(stderr, "Unrecognized cmd in ARM section: %s\n",
					cmd_str);
			return(-1);
		}
	}

	return(section_size);
}
#endif

int main(int argc, char *argv[])
{
	char buffer[MAX_LINE_LEN];
	int c;
	int ret = 0;
	char *input_file = NULL;
	char *output_file = NULL;

	while ((c = getopt(argc, argv, "i:")) != EOF) {
		switch (c) {
			case 'i':
				input_file = strdup(optarg);
				break;
			case 'o':
				fprintf(stderr, "Output file currently not supported\n");
				return(-1);
				output_file = strdup(optarg);
				break;
			default:
				fprintf(stderr, "USAGE: reg2cmds -i <input_file>\n");
				return(-1);
		}
	}

	if (input_file == NULL) {
		fprintf(stderr, "You must provide an input file\n");
		fprintf(stderr, "USAGE: reg2cmds -i <input_file>\n");
		return(-1);
	}

	input_fp = fopen(input_file, "r");
	if (NULL == input_fp) {
		fprintf(stderr, "Failed to open input file: %s\n", input_file);
		return(-1);
	}

	if (output_file != NULL) {
		output_fp = fopen(output_file, "w");
		if (NULL == output_fp) {
			fprintf(stderr, "Failed to open output file: %s\n", output_file);
			fclose(input_fp);
			return(-1);
		}
	}

	printf("/*\n");
	printf(" *\n");
	printf(" * Copyright (C) Mobilygen Corp\n");
	printf(" *\n");
	printf(" * This program is free software; you can redistribute it and/or modify\n");
	printf(" * it under the terms of the GNU General Public License as published by\n");
	printf(" * the Free Software Foundation; either version 2 of the License, or\n");
	printf(" * (at your option) any later version.\n");
	printf(" *\n");
	printf(" * This program is distributed in the hope that it will be useful,\n");
	printf(" * but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
	printf(" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
	printf(" * GNU General Public License for more details.\n");
	printf(" *\n");
	printf(" * You should have received a copy of the GNU General Public License\n");
	printf(" * along with this program; if not, write to the Free Software\n");
	printf(" * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA\n");
	printf(" */\n");
	printf("\n");
	printf("#include \"codec_reset_qccdefs.h\"\n");
	printf("\n");
	printf("\n");
	printf("struct qcc_cmd_def qcc_reset_cmds[] = {\n");
	printf("\t/* cmd       blkID addr  size    data     mask */\n");
	printf("\t/* set pmc waterLevel to 0 */\n");
	printf("\t{ QCC_WRITE,   17, 0x001e, 1, 0x00000000, 0x00000000 }, /* PMC      */\n");
	printf("\t/* codec reset in chipctl */\n");
	printf("\t{ QCC_WRITE,    8, 0x00c8, 0, 0x00000001, 0x00000000 }, /* CHIPCTL  */\n");
	printf("\t/* this is table is mostly automatically generated but some editing must be */\n");
	printf("\t/* done to complete the task.  All PMC write must occur first, move any     */\n");
	printf("\t/* other blkID writes to the end of the table, after the last MMU command,  */\n");
	printf("\t/* in the order they are found. Also note, sizes are converted to the qcc   */\n");
	printf("\t/* format so 4 byte writes will appear as 0 in the table                    */\n");

	read_csr_cmds(input_fp);
	printf("};\n");

	if (NULL != output_fp) 
		fclose(output_fp);

	fclose(input_fp);

	if (input_file)
		free(input_file);

	if (output_file)
		free(output_file);

	fprintf(stderr, "\n\nWARNING: Edit output file to move all non PMC/MMU commands to after\n");
	fprintf(stderr, "         the last MMU instance\n\n");


	return(ret);
}


