/*HEADER_START*/
/*
 *
 *  Copyright (C) 2006 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*HEADER_STOP*/

#ifndef DOXYGEN_SKIP

#include <linux/errno.h>
#include <linux/init.h>
#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/moduleparam.h>
#include <linux/platform_device.h>
#include <linux/types.h>
#include <linux/version.h>
#include <linux/proc_fs.h>

#include <mach/platform.h>
#include <mach/irqs.h>
#include <mach/mg3500_devices.h>
#include <mach/mobi_ioctrl.h>

#include <linux/spi/spi.h>
#include <linux/spi/eeprom.h>
#include <linux/mobi_usb_device.h>
#include <linux/gpioi2c.h>
#include <linux/i2c-gpio.h>
#include <linux/jiffies.h>

#include "board_desc.h"

#endif

struct board_desc board_desc = {
	.bd_type = "mobicam3",
};

struct nand_board_config_t nand_config = {

	/* init data passed to nand device */
	.device_data.databus_16bit     = 0,
	.device_data.banks_per_system  = 1,
	.device_data.chips_per_bank    = 1,
	.device_data.use_dma = 1,
	.device_data.clk_name = "ahb",

	/*
	 * only set new timing values for those you want to change, default
	 * values will be use for remaining timing values.  Make sure to set 
	 * the corresponding bit in the bitmask so the device know which 
	 * timing value to use, for example:
	 .device_data.board_timings[NAND_TIMING_TDS] = 16,
	 .device_data.board_timings[NAND_TIMING_TRR] = 40,
	 .device_data.board_set_timing_bitmask = 
	 NAND_TIMING_TDS_SET 
	 | NAND_TIMING_TRR_SET,
	 */

	/* board specific setup data, not passed to driver */
	.hmux.ce = HMUX_NAND_CE0,
	.hmux.cs = HMUX_HOST_CS1,
};

struct pata_board_config_t pata_config = {

	/* device driver platform data */
	.device_data.gpio_shift = 0,
	.device_data.gpio = 1,
	.device_data.irq = MOBI_IRQ_GPIO1,

	.hmux0.ce = HMUX_CF_CE0,
	.hmux0.cs = HMUX_HOST_CS0,
	.hmux1.ce = HMUX_CF_CE1,
	.hmux1.cs = HMUX_HOST_CS5,
};

struct wdt_board_config_t wdt_config = {
	/* device driver platform data */
	.wdt_data.timeout_msec = 0,
	.wdt_data.timeout_sec  = WATCHDOG_DEFAULT_HEARTBEAT,
	.wdt_data.clk_name = "apb",

	/* board specific setup data, not passed to driver */
	.rsvd = 0,
};

struct sdmmc_board_config_t sdmmc_config = {

	/* device driver platform data */
	.device_data.use_dma 			= 0,
	.device_data.disable_highspeed 	= 1,
	.device_data.dedicated_dma_channel 	= 0,
	.device_data.clk_name 			= "sdmmc",
	.device_data.clk_rate 			= 25000000,

	/* board specific setup data, not passed to driver */
	.rsvd = 0,
};

struct gmac_board_config_t gmac_config = {

	/* device driver platform data */
	.gmac_data.clk_name = "ahb",
	.gmac_data.options = DWGMAC_O_NONE,
	/* and example for forcing the speed */
	/*.gmac_data.options = DWGMAC_O_FORCE_SPEED_100, */

	/* board specific setup data, not passed to driver */
	.rsvd = 0,
};

struct usb_board_config_t usb_config = {

	/* device driver platform data */
	.otg_data.options = 0x0,

	/* board specific setup data, not passed to driver */
	.rsvd = 0,
};

/*
 * SPI Busses and Devices
 */
static struct spi_eeprom eeprom0_data = {
	.name			= "EEPROM0",
	.byte_len		= 32768,
	.page_size 		= 64,
	.flags 			= EE_ADDR2,
};

/*
 * SPI Busses and Devices
 */
struct spi_board_info spi0_devices[] = {
	/* SPI_0 MASTER bus: has 2 chipselects */
	{
		.bus_num	= 0,
		.modalias	= "at25",
		.platform_data	= &eeprom0_data,
		/* Mode 3 is actually a mode 0 for the DW_apb_spi component 
		 *  (but mode 0 chip-unselects after every byte sent) */
		.mode		= 3, 
		.max_speed_hz   = 500000,
		.chip_select	= 0,
	},
	{
		.bus_num		= 0,
		.modalias		= "spidev",
		.platform_data  = NULL,
		.mode			= 3, 
		.max_speed_hz   = 10000,
		.chip_select	= 1,
	},
};

static struct dwapbssi_bus_data spi0_bus_data = {
	.devices		= spi0_devices,
	.num_devices	= ARRAY_SIZE(spi0_devices),
	.num_chipselect	= ARRAY_SIZE(spi0_devices),
	.use_tx_dma 	= 0,
	.use_rx_dma		= 0,
};

struct spi_board_info spi1_devices[] = {
	/* SPI_1 MASTER bus: has 2 chipselects */
	{
		.bus_num		= 1,
		.modalias		= "spidev",
		.platform_data  = NULL,
		.mode			= 3,
		.max_speed_hz   = 10000,
		.chip_select	= 0,
	},
	{
		.bus_num		= 1,
		.modalias		= "spidev",
		.platform_data  = NULL,
		.mode			= 3, 
		.max_speed_hz   = 10000,
		.chip_select	= 1,
	},
};

static struct dwapbssi_bus_data spi1_bus_data = {
	.devices		= spi1_devices,
	.num_devices	= ARRAY_SIZE(spi1_devices),
	.num_chipselect	= ARRAY_SIZE(spi1_devices),
};

struct spi_board_info spi2_devices[] = {
	/* SPI_2 SLAVE bus */
	{
		.bus_num		= 2,
		.modalias		= "spidev",
		.platform_data  = NULL,
		.mode			= 3,
		.max_speed_hz   = 10000,
		.chip_select	= 0,
	},
};

static struct dwapbssi_bus_data spi2_bus_data = {
	.devices		= spi2_devices,
	.num_devices	= ARRAY_SIZE(spi2_devices),
	.num_chipselect	= ARRAY_SIZE(spi2_devices),
};

/*
 * I2C Busses
 */
static struct dwapbi2c_bus_data i2c0_bus_data = {
	.i2c_speed 		= DWAPBI2C_CON_SPEED_STANDARD,
};

static struct dwapbi2c_bus_data i2c1_bus_data = {
	.i2c_speed 		= DWAPBI2C_CON_SPEED_STANDARD,
};

/*
 * PWM Blocks
 */
struct cadpwm_block_data pwm0_block_data = {};
struct cadpwm_block_data pwm1_block_data = {};
struct cadpwm_block_data pwm2_block_data = {};

/*
 * GPIO Blocks
 */
struct dwapbgpio_block_data gpio0_block_data = {
	.group = "native",
};

struct dwapbgpio_block_data gpio1_block_data = {
	.group = "native",
};

struct dwapbgpio_block_data gpio2_block_data = {
	.group = "native",
};

#if defined(CONFIG_I2C_GPIO) || defined(CONFIG_I2C_GPIO_MODULE)
/*
 * I2C Over GPIO Alternative Devices
 *
 * Note: This code is not enabled by default.  The pins used
 * below are the actual I2C pins driven by the I2C controller. To
 * actually use these same pins for i2c-gpio you must use ioctrl
 * to set these pins a gpio.  Or you can change the pins to 
 * any gpios available
 */
static struct i2c_gpio_platform_data gpioi2c_bus0_data = {
	/* I2C_0 */
	.scl_pin        = 61, /* bank 2, index 21 */
	.sda_pin        = 62, /* bank 2, index 22 */
	.udelay = 5,
};
static struct i2c_gpio_platform_data gpioi2c_bus1_data = {
	/* I2C_1 (V01) */
	.scl_pin        = 34, /* bank 1, index 26 */
	.sda_pin        = 35, /* bank 1, index 27 */
	.udelay = 5,
};
static struct i2c_gpio_platform_data gpioi2c_bus2_data = {
	/* I2C_1 (V23) */
	.scl_pin        = 54, /* bank 2, index 14 */
	.sda_pin        = 55, /* bank 2, index 15 */
	.udelay = 5,
};
static struct platform_device gpioi2c_bus0_dev = {
	.name	= "i2c-gpio",
	.id 	= 4,
	.dev	= { 
		.platform_data = &gpioi2c_bus0_data 
	},
};
static struct platform_device gpioi2c_bus1_dev = {
	.name	= "i2c-gpio",
	.id 	= 5,
	.dev	= { 
		.platform_data = &gpioi2c_bus1_data 
	},
};
static struct platform_device gpioi2c_bus2_dev = {
	.name	= "i2c-gpio",
	.id 	= 6,
	.dev	= { 
		.platform_data = &gpioi2c_bus2_data 
	},
};
#endif

static void setup_ioctrl(void)
{
	/* override some of the mg3500's defaults */
	mobi_ioctrl_set_gpio(12, IOCTRL_GPIO_CONTROL_FUNCTION, 
			IOCTRL_GPIO_FUNCTION_GPIO);
	mobi_ioctrl_set_gpio(13, IOCTRL_GPIO_CONTROL_FUNCTION, 
			IOCTRL_GPIO_FUNCTION_GPIO);
	mobi_ioctrl_set_gpio(14, IOCTRL_GPIO_CONTROL_FUNCTION,
			IOCTRL_GPIO_FUNCTION_GPIO);
	mobi_ioctrl_set_gpio(15, IOCTRL_GPIO_CONTROL_FUNCTION,
			IOCTRL_GPIO_FUNCTION_GPIO);
	mobi_ioctrl_set_gpio(46, IOCTRL_GPIO_CONTROL_FUNCTION, 
			IOCTRL_GPIO_FUNCTION_GPIO);
	mobi_ioctrl_set_gpio(64, IOCTRL_GPIO_CONTROL_FUNCTION,
			IOCTRL_GPIO_FUNCTION_GPIO);
	/*mobi_ioctrl_set_gpio(68,IOCTRL_GPIO_CONTROL_FUNCTION,
            IOCTRL_GPIO_FUNCTION_PRIMARY);*/
	mobi_ioctrl_set_gpio(69, IOCTRL_GPIO_CONTROL_FUNCTION,
			IOCTRL_GPIO_FUNCTION_GPIO);
	mobi_ioctrl_set_gpio(70, IOCTRL_GPIO_CONTROL_FUNCTION,
			IOCTRL_GPIO_FUNCTION_GPIO);
	mobi_ioctrl_set_gpio(71, IOCTRL_GPIO_CONTROL_FUNCTION,
			IOCTRL_GPIO_FUNCTION_GPIO);
	mobi_ioctrl_set_drivestrength(IOCTRL_GRP_VIDEO2,
			IOCTRL_DRIVESTRENGTH_12ma);
	mobi_ioctrl_set_drivestrength(IOCTRL_GRP_VIDEO3,
			IOCTRL_DRIVESTRENGTH_12ma);
	mobi_ioctrl_set_drivestrength(IOCTRL_GRP_AUDIO,
			IOCTRL_DRIVESTRENGTH_4ma);
	mobi_ioctrl_set_drivestrength(IOCTRL_GRP_SDMMC,
			IOCTRL_DRIVESTRENGTH_6ma);
}

static int board_proc_rd_type(char *buf, char **start, 
		off_t offset, int count, int *eof, void *data)
{
	int len = 0;
	len += sprintf(buf+len,"%s\n", board_desc.bd_type);
	return len;
}

/* 
 * this array is a list of devices that are to be enabled on
 * a specific board.  devices will be added in order listed here
 *
 * XXX Do not change the order of spi/i2c registration
 */
struct board_device_desc board_devices[] = {
	{
		.device = BOARD_DEVICE_NAND,
		.devid = 0,
		.platform_data = &nand_config,
	},
	{
		.device = BOARD_DEVICE_WATCHDOG,
		.devid = 0,
		.platform_data = &wdt_config,
	},
	{
		.device = BOARD_DEVICE_SDMMC,
		.devid = 0,
		.platform_data = &sdmmc_config,
	},
	{
		.device = BOARD_DEVICE_GMAC,
		.devid = 0,
		.platform_data = &gmac_config,
	},
	{
		.device = BOARD_DEVICE_USB,
		.devid = 0,
		.platform_data = &usb_config,
	},
	/* XXX Do not change the order of spi/i2c */
	/* spi2 disables spi0, spi1 disables i2c  */
	{
		.device = BOARD_DEVICE_SPI,
		.devid = 2,
		.platform_data = &spi2_bus_data,
	},
	{
		.device = BOARD_DEVICE_SPI,
		.devid = 1,
		.platform_data = &spi1_bus_data,
	},
	{
		.device = BOARD_DEVICE_SPI,
		.devid = 0,
		.platform_data = &spi0_bus_data,
	},
	{
		.device = BOARD_DEVICE_I2C,
		.devid = 0,
		.platform_data = &i2c0_bus_data,
	},
	{
		.device = BOARD_DEVICE_I2C,
		.devid = 1,
		.platform_data = &i2c1_bus_data,
	},
	{
		.device = BOARD_DEVICE_PWM,
		.devid = 0,
		.platform_data = &pwm0_block_data,
	},
	{
		.device = BOARD_DEVICE_PWM,
		.devid = 1,
		.platform_data = &pwm1_block_data,
	},
	{
		.device = BOARD_DEVICE_PWM,
		.devid = 2,
		.platform_data = &pwm2_block_data,
	},
	{
		.device = BOARD_DEVICE_GPIO,
		.devid = 0,
		.platform_data = &gpio0_block_data,
	},
	{
		.device = BOARD_DEVICE_GPIO,
		.devid = 1,
		.platform_data = &gpio1_block_data,
	},
	{
		.device = BOARD_DEVICE_GPIO,
		.devid = 2,
		.platform_data = &gpio2_block_data,
	},
};

static int __init mobicam3_board_init(void)
{
	struct proc_dir_entry *board_proc_dir = proc_mkdir(BOARD_PROCDIR, NULL);
	create_proc_read_entry("type",
			S_IRUSR | S_IRGRP | S_IROTH,
			board_proc_dir,
			board_proc_rd_type,
			NULL);

	printk(KERN_ERR "Loading driver for board type: %s\n", 
			board_desc.bd_type);
	/* optional board specific ioctrl setup */
	setup_ioctrl();
	arch_add_board_devices(board_devices, ARRAY_SIZE(board_devices));
#if defined(CONFIG_I2C_GPIO) || defined(CONFIG_I2C_GPIO_MODULE)
    gpioi2c_bus0_data.timeout = msecs_to_jiffies(3000);
	gpioi2c_bus1_data.timeout = msecs_to_jiffies(3000);
	gpioi2c_bus2_data.timeout = msecs_to_jiffies(3000);
	platform_device_register(&gpioi2c_bus0_dev);
	platform_device_register(&gpioi2c_bus1_dev);
	platform_device_register(&gpioi2c_bus2_dev);
#endif

#if 0
	/* Turn on the D1 LED.  The application can turn it off when encoding
	   has started.  This makes it easier for someone to know when they
	   can start the decoder */
	
	gpio_driver_handle gpio_drv_h;
	/* Find the driver associated with this GPIO. */
	gpio_drv_h = gpio_driver_find( NULL, 64, &gpio_index );
	if( likely( gpio_drv_h ))  {
		/* GPIO was found/is available, change the direction/value. */
		gpio_direction_output( gpio_drv_h, gpio_index, 0 );
		/* Release the handle. */
		gpio_driver_put( gpio_drv_h );
	}
#endif
	return 0;
}

static void __exit mobicam3_board_exit(void)
{
	return;
}
module_init(mobicam3_board_init);
module_exit(mobicam3_board_exit);

MODULE_AUTHOR("Jeff Hane");
MODULE_DESCRIPTION("Driver for Mobilygen mobicam3 board");
MODULE_LICENSE("GPL");
