/*
 *  This file Copyright (C) 2007 Mobilygen Corp.
 *
 *  This program is free software; you can redistribute  it and/or modify it
 *  under  the terms of  the GNU General  Public License as published by the
 *  Free Software Foundation;  either version 2 of the  License, or (at your
 *  option) any later version.
 *
 *  THIS  SOFTWARE  IS PROVIDED   ``AS  IS'' AND   ANY  EXPRESS OR IMPLIED
 *  WARRANTIES,   INCLUDING, BUT NOT  LIMITED  TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
 *  NO  EVENT  SHALL   THE AUTHOR  BE	LIABLE FOR ANY   DIRECT, INDIRECT,
 *  INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED   TO, PROCUREMENT OF  SUBSTITUTE GOODS  OR SERVICES; LOSS OF
 *  USE, DATA,  OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN  CONTRACT, STRICT LIABILITY, OR TORT
 *  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  You should have received a copy of the  GNU General Public License along
 *  with this program; if not, write  to the Free Software Foundation, Inc.,
 *  675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
#ifndef __PATA_AUMB4000_H
#define __PATA_AUMB4000_H

#include <asm/arch/mobi_dma.h>
#include <asm/arch/platform.h>
#include <asm/arch/aumb4000_regs.h>
#include <linux/dma-mapping.h>
#include <linux/gpio-core.h>

/* undef to enable, print facilities below */
#undef LOCAL_AUMB4000_DEBUG_ENABLE

#define UNUSED __attribute__((unused))

#define FIFO_SIZE                                   (256)
#define CF_COMMAND_NOP                              (0x0000)
#define CF_COMMAND_RESET                            (0x0001)
#define CF_COMMAND_READ_DATA                        (0x0020)
#define CF_COMMAND_READ_ERROR                       (0x0021)
#define CF_COMMAND_READ_SECTOR_COUNT                (0x0022)
#define CF_COMMAND_READ_SECTOR_NUMBER               (0x0023)
#define CF_COMMAND_READ_CYLINDER_LOW                (0x0024)
#define CF_COMMAND_READ_CYLINDER_HIGH               (0x0025)
#define CF_COMMAND_READ_DRIVE_HEAD                  (0x0026)
#define CF_COMMAND_READ_STATUS                      (0x0027)
#define CF_COMMAND_READ_ALTERNATE_STATUS            (0x0028)
#define CF_COMMAND_READ_DRIVE_ADDRESS               (0x0029)
#define CF_COMMAND_WRITE_DATA                       (0x0030)
#define CF_COMMAND_WRITE_FEATURE                    (0x0031)
#define CF_COMMAND_WRITE_SECTOR_COUNT               (0x0032)
#define CF_COMMAND_WRITE_SECTOR_NUMBER              (0x0033)
#define CF_COMMAND_WRITE_CYLINDER_LOW               (0x0034)
#define CF_COMMAND_WRITE_CYLINDER_HIGH              (0x0035)
#define CF_COMMAND_WRITE_DRIVE_HEAD                 (0x0036)
#define CF_COMMAND_WRITE_COMMAND                    (0x0037)
#define CF_COMMAND_WRITE_DEVICE_CONTROL             (0x0038)

#define CF_COMMAND_READ_ATTRIBUTE_MEMORY            (0x0040)
#define CF_COMMAND_READ_COMMON_MEMORY               (0x0041)
#define CF_COMMAND_READ_IO_BYTE                     (0x0042)
#define CF_COMMAND_READ_COMMON_MEMORY_HALF          (0x0045)
#define CF_COMMAND_READ_IO_HALF                     (0x0046)

#define CF_COMMAND_WRITE_ATTRIBUTE_MEMORY           (0x0050)
#define CF_COMMAND_WRITE_COMMON_MEMORY_BYTE         (0x0051)
#define CF_COMMAND_WRITE_IO_BYTE                    (0x0052)
#define CF_COMMAND_WRITE_COMMON_MEMORY_HALF         (0x0055)
#define CF_COMMAND_WRITE_IO_HALF                    (0x0056)
#define CF_COMMAND_CF_CARD_NOP                      (0x0100)
#define CF_COMMAND_CF_CARD_REQUEST_SENSE            (0x0103)
#define CF_COMMAND_CF_CARD_READ_SECTOR              (0x0120)
#define CF_COMMAND_CF_CARD_READ_SECTOR_2            (0x0121)
#define CF_COMMAND_CF_CARD_READ_LONG_SECTOR         (0x0122)
#define CF_COMMAND_CF_CARD_READ_LONG_SECTOR2        (0x0123)
#define CF_COMMAND_CF_CARD_WRITE_SECTOR             (0x0130)
#define CF_COMMAND_CF_CARD_WRITE_SECTOR_2           (0x0131)
#define CF_COMMAND_CF_CARD_WRITE_LONG_SECTOR        (0x0132)
#define CF_COMMAND_CF_CARD_WRITE_LONG_SECTOR_2      (0x0133)
#define CF_COMMAND_CF_CARD_WRITE_SECTOR_WO_ERASE    (0x0138)
#define CF_COMMAND_CF_CARD_WRITE_VERIFY             (0x013c)
#define CF_COMMAND_CF_CARD_READ_VERIFY              (0x0140)
#define CF_COMMAND_CF_CARD_READ_VERIFY_2            (0x0141)
#define CF_COMMAND_CF_CARD_FORMAT_TRACK             (0x0150)
#define CF_COMMAND_CF_CARD_SEEK                     (0x0170)
#define CF_COMMAND_CF_CARD_SEEK_2                   (0x0171)
#define CF_COMMAND_CF_CARD_SEEK_3                   (0x0172)
#define CF_COMMAND_CF_CARD_SEEK_4                   (0x0173)
#define CF_COMMAND_CF_CARD_SEEK_5                   (0x0174)
#define CF_COMMAND_CF_CARD_SEEK_6                   (0x0175)
#define CF_COMMAND_CF_CARD_SEEK_7                   (0x0176)
#define CF_COMMAND_CF_CARD_SEEK_8                   (0x0177)
#define CF_COMMAND_CF_CARD_SEEK_9                   (0x0178)
#define CF_COMMAND_CF_CARD_SEEK_10                  (0x0179)
#define CF_COMMAND_CF_CARD_SEEK_11                  (0x017a)
#define CF_COMMAND_CF_CARD_SEEK_12                  (0x017b)
#define CF_COMMAND_CF_CARD_SEEK_13                  (0x017c)
#define CF_COMMAND_CF_CARD_SEEK_14                  (0x017d)
#define CF_COMMAND_CF_CARD_SEEK_15                  (0x017e)
#define CF_COMMAND_CF_CARD_SEEK_16                  (0x017f)
#define CF_COMMAND_CF_CARD_TRANSLATE_SECTOR         (0x0187)
#define CF_COMMAND_CF_CARD_EXECUTE_DIAGNOSTIC       (0x0190)
#define CF_COMMAND_CF_CARD_INITIALIZE_PARAMETERS    (0x0191)
#define CF_COMMAND_CF_CARD_STANDBY_IMMEDIATE        (0x0194)
#define CF_COMMAND_CF_CARD_IDLE_IMMEDIATE           (0x0195)
#define CF_COMMAND_CF_CARD_STANDBY                  (0x0196)
#define CF_COMMAND_CF_CARD_IDLE                     (0x0197)
#define CF_COMMAND_CF_CARD_CHECK_POWER              (0x0198)
#define CF_COMMAND_CF_CARD_SLEEP                    (0x0199)
#define CF_COMMAND_CF_CARD_KEY_MANAGEMENT           (0x01b9)
#define CF_COMMAND_CF_CARD_ERASE_SECTOR             (0x01c0)
#define CF_COMMAND_CF_CARD_READ_MULTIPLE            (0x01c4)
#define CF_COMMAND_CF_CARD_WRITE_MULTIPLE           (0x01c5)
#define CF_COMMAND_CF_CARD_SET_MULTIPLE             (0x01c6)
#define CF_COMMAND_CF_CARD_READ_DMA                 (0x01c8)
#define CF_COMMAND_CF_CARD_READ_DMA_2               (0x01c9)
#define CF_COMMAND_CF_CARD_WRITE_DMA                (0x01ca)
#define CF_COMMAND_CF_CARD_WRITE_DMA_2              (0x01cb)
#define CF_COMMAND_CF_CARD_WRITE_MULTIPLE_WO_ERASE  (0x01cd)
#define CF_COMMAND_CF_CARD_STANDBY_IMMEDIATE_2      (0x01e0)
#define CF_COMMAND_CF_CARD_IDLE_IMMEDIATE_2         (0x01e1)
#define CF_COMMAND_CF_CARD_STANDBY_XX               (0x01e2)    // !!
#define CF_COMMAND_CF_CARD_IDLE_XX                  (0x01e3)    // !!
#define CF_COMMAND_CF_CARD_READ_BUFFER              (0x01e4)
#define CF_COMMAND_CF_CARD_CHECK_POWER_2            (0x01e5)
#define CF_COMMAND_CF_CARD_SLEEP_2                  (0x01e6)
#define CF_COMMAND_CF_CARD_FLUSH_CACHE              (0x01e7)
#define CF_COMMAND_CF_CARD_WRITE_BUFFER             (0x01e8)
#define CF_COMMAND_CF_CARD_IDENTIFY_DEVICE          (0x01ec)
#define CF_COMMAND_CF_CARD_SET_FEATURES             (0x01ef)
#define CF_COMMAND_CF_CARD_SECURITY_SET_PASSWORD    (0x01f1)
#define CF_COMMAND_CF_CARD_SECURITY_UNLOCK          (0x01f2)
#define CF_COMMAND_CF_CARD_SECURITY_ERASE_PREPARE   (0x01f3)
#define CF_COMMAND_CF_CARD_SECURITY_ERASE_UNIT      (0x01f4)
#define CF_COMMAND_CF_CARD_SECURITY_FREEZE_LOCK     (0x01f5)    // !!
#define CF_COMMAND_CF_CARD_WEAR_LEVEL               (0x01f5)    // !!
#define CF_COMMAND_CF_CARD_SECURITY_DISABLE_PASSWD  (0x01f6)
/*
32'h0010 0 4 02, ide w/mw8
32'h0010 0 4 03, ide w/mw8
32'h0010 0 5 02, ide w/mw16
32'h0010 0 5 03, ide w/mw16
32'h0010 0 6 02, ide w/udma8
32'h0010 0 7 02, ide w/udma16
32'h0010 4 4 02, ide w/mw8
32'h0010 4 4 03, ide w/mw8
32'h0010 4 5 02, ide w/mw16
32'h0010 4 5 03, ide w/mw16
32'h0010 4 6 02, ide w/udma8
32'h0010 4 7 02, ide w/udma16
32'h0010 8 4 02, ide w/mw8
32'h0010 8 4 03, ide w/mw8
32'h0010 8 5 02, ide w/mw16
32'h0010 8 5 03, ide w/mw16
32'h0010 8 6 02, ide w/udma8
32'h0010 8 7 02, ide w/udma16
*/

/*   1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1
**   f e d c b a 9 8 7 6 5 4 3 2 1 0 f e d c b a 9 8 7 6 5 4 3 2 1 0
**  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
**  |X X X X|w|w|r|r|X X|c|d|X|a|r|s|w|r|p  |X| mode|      size     |
**  |X X X X|f|e|f|e|X X|e|e|X|i|i|i|c|c|  c|X|     |               |
**  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
**         0       0       1       0       0       1       0       2
**
**  confirmed by peter April 18, 2007 !!!
**
**  aurora name: cf_ctl
r1,=0x00104502
**
**  ide: 0x05030508: 0000 0101 0000 0011 0000 0101 0000 1000
**                 :   XXXX 0101XX00X01100 00 X 101 00001000
**
**  pc : 0x0507c028: 0000 0101 0000 0111 1100 0000 0010 1000
**                 :   XXXX 0101XX00X11111 00 X 000 00001000
**
*/
typedef union flash_control {
#define CF_CONTROL (0x0000)
#define TRUE_IDE_8   (4)
#define TRUE_IDE_16  (5)
#define ULTRA_DMA_16 (7)
    uint32_t d32;
    struct {
        unsigned sz : 8;        // block size
        unsigned  m : 3;        // mode
        unsigned rsvd0 : 1;
        unsigned pc : 2;        // PC card configuration
        unsigned rc : 1;        // read status check
        unsigned wc : 1;        // write status check
        unsigned si : 1;        // 16-bit data ignore
        unsigned ri : 1;        // ready/wait ignore
        unsigned ai : 1;        // input acknowledge ignore
        unsigned rsvd1 : 1;     //
        unsigned de : 1;        // command done interrupt enable
        unsigned ce : 1;        // status change interrupt enable
        unsigned rsvd2 : 2;     //
        unsigned re : 1;        // read data buffer empty
        unsigned rf : 1;        // read data buffer full
        unsigned we : 1;        // write data buffer empty
        unsigned wf : 1;        // write data buffer full
        unsigned rsvd3 : 4;     // bit 31
    } b;
} flash_control_flags;

/*   f e d c b a 9 8 7 6 5 4 3 2 1 0 f e d c b a 9 8 7 6 5 4 3 2 1 0
**  +-+-+-+-.-+-+-+-.-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
**  |p|XXXXXXXXX|s|s|XXXXXXXXXXXXX|i|XXXXXXXXXXXXXXXXXXXXX|c|d|X|c|d|
**  |r|XXXXXXXXX|a|c|XXXXXXXXXXXXX|a|XXXXXXXXXXXXXXXXXXXXX|w|w|X|i|i|
**  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
**                                                         | |
**  aurora name: cf_int_stat                  write only --+-+
**  
*/
typedef union flash_status {
#define CF_STATUS (0x004c)
    uint32_t d32;
    struct {
        unsigned di : 1;        // command done interrupt
        unsigned ci : 1;        // status change interrupt
        unsigned rsvd0 : 1;     //
        unsigned dw : 1;        // command done write enable (WO)
        unsigned cw : 1;        // status change write enable (WO)
        unsigned rsvd1 : 10;    //
        unsigned ia : 1;        // input ack bit
        unsigned rsvd2 : 8;     //
        unsigned sc : 1;        // status change
        unsigned sa : 1;        // serial audio
        unsigned rsvd3 : 5;     //
        unsigned pr : 1;        // compact card present
    } b;

} flash_status_flags;
#define CLEAR_CMD_DONE(x) writel((readl(CF_STATUS+(x)) & ~1), CF_STATUS+(x))
#define STAT_SPIN_WAIT(x) while (0 == (0x01 & (readl(CF_STATUS+(x)))))
#define STAT_SPIN_WAIT_TO(t,x) while (--t && (0 == (0x01 & (readl(CF_STATUS+(x))))))

/*   f e d c b a 9 8 7 6 5 4 3 2 1 0 f e d c b a 9 8 7 6 5 4 3 2 1 0
**  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
**  | R S V D 2 |    A D D R E S S    |R S V D 1  |    C M D        |
**  |           |                     |           |                 |
**  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
**
*/
typedef union cf_flash_command {
#define CF_COMMAND (0x0004)
    uint32_t d32 ;
    struct {
        unsigned cmd    : 9 ;
        unsigned rsvd1  : 6;
        unsigned addr   : 11 ;
        unsigned rsvd2  : 6;
    } b;
} cf_flash_command_flags ;

typedef union cf_flash_rd0_timing {
#define CF_READ_TIMING_0 (0x0008)
#define CF_RDTIM0 (0x0008)
    uint32_t d32 ;
    struct {
        unsigned taosa  : 8;
        unsigned toaha  : 8;
        unsigned tceosa : 8;
        unsigned toceha : 8;
    } b;
} cf_flash_rd0_timing_flags ;

typedef union cf_flash_rd1_timing {
#define CF_READ_TIMING_1 (0x000c)
#define CF_RDTIM1 (0x000c)
    uint32_t d32 ;
    struct {
        unsigned tadela : 8;
        unsigned tcedela: 8;
        unsigned toedela: 8;
        unsigned trca   : 8;
    } b;
} cf_flash_rd1_timing_flags ;

typedef union cf_flash_rd2_timing {
#define CF_READ_TIMING_2 (0x0010)
#define CF_RDTIM2 (0x0010)
    uint32_t d32 ;
    struct {
        unsigned towha  : 8;
        unsigned toehza : 8;
        unsigned trpa   : 8;
        unsigned trdmarq: 8;
    } b;
} cf_flash_rd2_timing_flags ;

typedef union cf_flash_rd3_timing {
#define CF_READ_TIMING_3 (0x0014)
#define CF_RDTIM3 (0x0014)
    uint32_t d32 ;
    struct {
        unsigned taosc  : 8;
        unsigned toahc  : 8;
        unsigned tceosc : 8;
        unsigned tocehc : 8;
    } b;
} cf_flash_rd3_timing_flags ;

typedef union cf_flash_rd4_timing {
#define CF_READ_TIMING_4 (0x0018)
#define CF_RDTIM4 (0x0018)
    uint32_t d32 ;
    struct {
        unsigned tadelc : 8;
        unsigned tcedelc: 8;
        unsigned toedelc: 8;
        unsigned trcc   : 8;
    } b;
} cf_flash_rd4_timing_flags ;

typedef union cf_flash_rd5_timing {
#define CF_READ_TIMING_5 (0x001c)
#define CF_RDTIM5 (0x001c)
    uint32_t d32 ;
    struct {
        unsigned towhc  : 8;
        unsigned toehzc : 8;
        unsigned trpc   : 8;
        unsigned rsvd0  : 8;
    } b;
} cf_flash_rd5_timing_flags ;

typedef union cf_flash_wt0_timing {
#define CF_WRITE_TIMING_0 (0x0020)
#define CF_WRTIM0 (0x0020)
    uint32_t d32 ;
    struct {
        unsigned tawsa  : 8;
        unsigned twaha  : 8;
        unsigned tcewsa : 8;
        unsigned twceha : 8;
    } b;
} cf_flash_wt0_timing_flags ;

typedef union cf_flash_wt1_timing {
#define CF_WRITE_TIMING_1 (0x0024)
#define CF_WRTIM1 (0x0024)
    uint32_t d32 ;
    struct {
        unsigned taws2a : 8;
        unsigned tcewsa2: 8;
        unsigned tdwsa  : 8;
        unsigned twdha  : 8;
    } b;
} cf_flash_wt1_timing_flags ;

typedef union cf_flash_wt2_timing {
#define CF_WRITE_TIMING_2 (0x0028)
#define CF_WRTIM2 (0x0028)
    uint32_t d32 ;
    struct {
        unsigned twca   : 8;
        unsigned twpa   : 8;
        unsigned twoha  : 8;
        unsigned twdmarq: 8;
    } b;
} cf_flash_wt2_timing_flags ;

typedef union cf_flash_wt3_timing {
#define CF_WRITE_TIMING_3 (0x002c)
#define CF_WRTIM3 (0x002c)
    uint32_t d32 ;
    struct {
        unsigned tawsc  : 8;
        unsigned twahc  : 8;
        unsigned tcewsc : 8;
        unsigned twcehc : 8;
    } b;
} cf_flash_wt3_timing_flags ;

typedef union cf_flash_wt4_timing {
#define CF_WRITE_TIMING_4 (0x0030)
#define CF_WRTIM4 (0x0030)
    uint32_t d32 ;
    struct {
        unsigned taws2c : 8;
        unsigned tcews2c: 8;
        unsigned tdwsc  : 8;
        unsigned twdhc  : 8;
    } b;
} cf_flash_wt4_timing_flags ;

typedef union cf_flash_wt5_timing {
#define CF_WRITE_TIMING_5 (0x0034)
#define CF_WRTIM5 (0x0034)
    uint32_t d32 ;
    struct {
        unsigned twcc   : 8;
        unsigned twpc   : 8;
        unsigned twohc  : 8;
        unsigned tdhz   : 8;
    } b;
} cf_flash_wt5_timing_flags ;

typedef union cf_flash_cmd0_timing {
#define CF_COMMAND_TIMING_0 (0x0038)
#define CF_CMDTIM0 (0x0038)
    uint32_t d32 ;
    struct {
        unsigned tdiag  : 24;
        unsigned tcmd   : 8;
    } b;
} cf_flash_cmd0_timing_flags ;

typedef union cf_flash_cmd1_timing {
#define CF_COMMAND_TIMING_1 (0x003c)
#define CF_CMDTIM1 (0x003c)
    uint32_t d32 ;
    struct {
        unsigned trstp  : 16;
        unsigned tdevsel: 8;
        unsigned tdma   : 8;
    } b;
} cf_flash_cmd1_timing_flags ;

typedef union cf_flash_cmd2_timing {
#define CF_COMMAND_TIMING_2 (0x0040)
#define CF_CMDTIM2 (0x0040)
    uint32_t d32 ;
    struct {
        unsigned tsrst  : 24;
        unsigned rsvd0  : 8;
    } b;
} cf_flash_cmd2_timing_flags ;

typedef union cf_flash_cmd3_timing {
#define CF_COMMAND_TIMING_3 (0x0044)
#define CF_CMDTIM3 (0x0044)
    uint32_t d32 ;
    struct {
        unsigned thrst  : 24;
        unsigned rsvd0  : 8;
    } b;
} cf_flash_cmd3_timing_flags ;

typedef union cf_flash_cmd4_timing {
#define CF_COMMAND_TIMING_4 (0x0048)
#define CF_CMDTIM4 (0x0048)
    uint32_t d32 ;
    struct {
        unsigned tpwr   : 24;
        unsigned rsvd0  : 8;
    } b;
} cf_flash_cmd4_timing_flags ;

typedef union cf_card_data {
#define CF_CARD_DATA (0x0080)
    uint32_t d32 ;
    struct {
        unsigned data   : 16;
        unsigned rsvd0  : 16;
    } b;
} cf_card_data_flags ;

typedef union cf_card_features {
#define CF_CARD_FEATURES (0x0084)
    uint32_t d32 ;
    struct {
        unsigned ftr    : 16;
        unsigned rsvd0  : 16;
    } b;
} cf_card_features_flags ;

typedef union cf_card_sector_count {
#define CF_CARD_SECTOR_COUNT (0x0088)
    uint32_t d32 ;
    struct {
        unsigned scnt   :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_sector_count_flags ;

typedef union cf_card_sector_number {
#define CF_CARD_SECTOR_NUMBER (0x008c)
    uint32_t d32 ;
    struct {
        unsigned sno    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_sector_number_flags ;

typedef union cf_card_cylinder_low {
#define CF_CARD_CYL_LOW (0x0090)
    uint32_t d32 ;
    struct {
        unsigned clo    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_cylinder_low_flags ;

typedef union cf_card_cylinder_high {
#define CF_CARD_CYL_HIGH (0x0094)
    uint32_t d32 ;
    struct {
        unsigned chi    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_cylinder_high_flags ;

typedef union cf_card_drive_head {
#define CF_CARD_DRIVE_HEAD (0x0098)
    uint32_t d32 ;
    struct {
        unsigned drv    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_drive_head_flags ;

/*
** this guy's used to for write back space on a cf card command
** read request.
*/
typedef union cf_card_command {
#define CF_CARD_COMMAND (0x009c)
    uint32_t d32 ;
    struct {
        unsigned cmd    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_command_flags ;

typedef union cf_card_device_control {
#define CF_CARD_DEVICE_CONTROL (0x00a0)
    uint32_t d32 ;
    struct {
        unsigned dev    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_device_control_flags ;

typedef union cf_card_card_data_out {
#define CF_CARD_DATA_OUT (0x00c0)
    uint32_t d32 ;
    struct {
        unsigned data   : 16;
        unsigned rsvd0  : 16;
    } b;
} cf_card_card_data_out_flags ;

#define CF_CARD_ERROR_OUT       (0x00c4)
#define CF_CARD_ERROR_OUT_UNC   (1<<6)
#define CF_CARD_ERROR_OUT_MC    (1<<5)
#define CF_CARD_ERROR_OUT_IDNF  (1<<4)
#define CF_CARD_ERROR_OUT_MCR   (1<<3)
#define CF_CARD_ERROR_OUT_ABRT  (1<<2)
#define CF_CARD_ERROR_OUT_NM    (1<<1)
typedef union cf_card_error_out {
    uint32_t d32 ;
    struct {
        unsigned err    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_error_out_flags ;

#define CF_CARD_SECTOR_COUNT_OUT (0x00c8)
typedef union cf_card_sector_count_out {
    uint32_t d32 ;
    struct {
        unsigned scnt   :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_sector_count_out_flags ;

#define CF_CARD_SECTOR_NUMBER_OUT (0x00cc)
typedef union cf_card_sector_number_out {
    uint32_t d32 ;
    struct {
        unsigned sno    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_sector_number_out_flags ;

#define CF_CARD_CYL_LOW_OUT (0x00d0)
typedef union cf_card_cylinder_low_out {
    uint32_t d32 ;
    struct {
        unsigned clo    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_cylinder_low_out_flags ;

#define CF_CARD_CYL_HIGH_OUT (0x00d4)
typedef union cf_card_cylinder_high_out {
    uint32_t d32 ;
    struct {
        unsigned chi    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_cylinder_high_out_flags ;

#define CF_CARD_DRIVE_HEAD_OUT (0x00d8)
typedef union cf_card_drive_head_out {
    uint32_t d32 ;
    struct {
        unsigned drv    : 16;
        unsigned rsvd0  : 16;
    } b;
} cf_card_drive_head_out_flags ;

/*
**
** definition of content stored in both the cf_card_status_out and
** cf_card_alt_status_out. The difference between the two, is, the
** cf_card_alt_status_out does not clear any pending interrupt.
**
*/
typedef union cf_stat {
    unsigned char d8 ;
    struct {
        unsigned err    : 1 ;
        unsigned rsvd0  : 1 ;
        unsigned corr   : 1 ;
        unsigned drq    : 1 ;
        unsigned dsc    : 1 ;
        unsigned dwf    : 1 ;
        unsigned rdy    : 1 ;
        unsigned busy   : 1 ;
    } b ;
} cf_stat_flags ;

typedef union cf_card_status_out {
#define CF_CARD_STATUS_OUT (0x00dc)
/*
** DRQ -- device is ready to transfer a word of data between the host and device.
** DRDY-- set by the device prior to command completion
** DSC -- obsolete (formerly the DeviceSeekComplete bit).
** DF, DSC -- command dependent
**
*/
#define CF_CARD_STATUS_OUT_BSY  (1<<7)
#define CF_CARD_STATUS_OUT_DRDY (1<<6)
#define CF_CARD_STATUS_OUT_DF   (1<<5)
#define CF_CARD_STATUS_OUT_DSC  (1<<4)
#define CF_CARD_STATUS_OUT_DRQ  (1<<3)
#define CF_CARD_STATUS_OUT_CORR (1<<2)
#define CF_CARD_STATUS_OUT_ERR  (1<<0)
#define CF_DMA_BUSY (CF_CARD_STATUS_OUT_BSY|CF_CARD_STATUS_OUT_DRQ|CF_CARD_STATUS_OUT_DSC)
    uint32_t d32 ;
    struct {
        unsigned stat   :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_status_out_flags ;

#define CF_CARD_ALT_STATUS_OUT (0x00e0)
typedef union cf_card_alt_status_out {
    uint32_t d32 ;
    struct {
        unsigned alt    :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_alt_status_out_flags ;

#define CF_CARD_DRIVE_ADDR_OUT (0x00e4)
typedef union cf_card_address_out {
    uint32_t d32 ;
    struct {
        unsigned addr   :  8;
        unsigned rsvd0  : 24;
    } b;
} cf_card_address_out_flags ;

#define CF_CARD_WRITE_DATA_CONTROL (0x0100)
typedef union cf_card_write_data_control {
    uint32_t d32 ;
    struct {
        unsigned thresh : 11;
        unsigned rsvd1  : 5;
        unsigned de     : 1;
        unsigned se     : 1;
        unsigned rsvd0  : 12;
        unsigned da     : 1;
        unsigned dr     : 1;
    } b;
} cf_card_write_data_control_flags ;

/*   f e d c b a 9 8 7 6 5 4 3 2 1 0 f e d c b a 9 8 7 6 5 4 3 2 1 0
**  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
**  |d|d|      R S V D 0        |s|d|R S V D 1|      threshold      |
**  |r|a|                       |e|e|         |                     |
**  +-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
**
*/
#define CF_CARD_READ_DATA_CONTROL (0x0104)
typedef union cf_card_read_data_control {
    uint32_t d32 ;
    struct {
        unsigned thresh : 11;   // cf_dmard_req is asserted
        unsigned rsvd1  : 5;
        unsigned de     : 1;    // read dma request enable de ^ se
        unsigned se     : 1;    // split enable
        unsigned rsvd0  : 12;
        unsigned da     : 1;    // prior compact flash read has been serviced
        unsigned dr     : 1;    // cf_dmard_req is asserted
    } b;
} cf_card_read_data_control_flags ;

#define CF_CARD_WRITE_DATA_COUNT (0x0108)
typedef union cf_card_write_data_count {
    uint32_t d32 ;
    struct {
        unsigned write_data_control   : 16;
        unsigned rsvd0  : 16;
    } b;
} cf_card_write_data_count_flags ;

#if defined(LOCAL_AUMB4000_DEBUG_ENABLE) || defined(CONFIG_AUMB4000_DEBUG)
#define AUMB4000_DEBUG 1
#else
#define AUMB4000_DEBUG 0
#endif

static int __attribute__((unused)) loglevel = -1;

#if AUMB4000_DEBUG

#define DBGPFX "ATA:"
#define aumb4000_debug(dbglevel, dopfx, fmt, args...)	\
	do { \
		if (dbglevel && loglevel >= dbglevel) { \
			if (dopfx) \
				printk(DBGPFX"%s: " fmt, __func__, ##args); \
			else \
				printk(fmt, ##args); \
		} \
	} while(0)

#else
#define aumb4000_debug(n, fmt, args...)	do {} while(0)
#endif

#define dprintk(x...)	printk(x)
#define dprintk0(x...)	do {} while(0)
#define dprintk1(fmt, x...)	aumb4000_debug(1, 1, fmt, ##x)
#define dprintk2(fmt, x...)	aumb4000_debug(2, 1, fmt, ##x)
#define dprintk3(fmt, x...)	aumb4000_debug(3, 1, fmt, ##x)
#define dprintk4(fmt, x...)	aumb4000_debug(4, 1, fmt, ##x)
#define dprintk5(fmt, x...)	aumb4000_debug(5, 1, fmt, ##x)
/* no prefix - DBGPFX and function name */
#define dprintk1np(fmt, x...)	aumb4000_debug(1, 0, fmt, ##x)
#define dprintk2np(fmt, x...)	aumb4000_debug(2, 0, fmt, ##x)
#define dprintk3np(fmt, x...)	aumb4000_debug(3, 0, fmt, ##x)
#define dprintk4np(fmt, x...)	aumb4000_debug(4, 0, fmt, ##x)
#define dprintk5np(fmt, x...)	aumb4000_debug(5, 0, fmt, ##x)

#define dbg_func_in()	aumb4000_debug(0, 1, "IN\n")
#define dbg_func_out()	aumb4000_debug(0, 1, "OUT\n")

#define error(str, args...)  \
	printk(KERN_ERR DRV_NAME "Error: " str "\n", ##args)
#define warning(str, args...)  \
	printk(KERN_WARNING DRV_NAME "Warning: " str "\n", ##args)
#define info(str, args...)  \
	printk(KERN_INFO DRV_NAME "Info: " str "\n", ##args)


#define BIT_FLD24_MAX_VALUE	0x00ffffff
#define BIT_FLD16_MAX_VALUE	0x0000ffff
#define BIT_FLD8_MAX_VALUE	0x000000ff

/* just an array of our timing regs so we 
 * can work through them and the addresses are
 * not consecutive
 */
uint32_t timing_regs_offset[] = {
	AUMB4000_CF_TIMING_READ0_OFFSET,
	AUMB4000_CF_TIMING_READ1_OFFSET,
	AUMB4000_CF_TIMING_READ2_OFFSET,
	AUMB4000_CF_TIMING_READ3_OFFSET,
	AUMB4000_CF_TIMING_READ4_OFFSET,
	AUMB4000_CF_TIMING_READ5_OFFSET,
	AUMB4000_CF_TIMING_WRITE0_OFFSET,
	AUMB4000_CF_TIMING_WRITE1_OFFSET,
	AUMB4000_CF_TIMING_WRITE2_OFFSET,
	AUMB4000_CF_TIMING_WRITE3_OFFSET,
	AUMB4000_CF_TIMING_WRITE4_OFFSET,
	AUMB4000_CF_TIMING_WRITE5_OFFSET,
	AUMB4000_CF_TIMING_CMD0_OFFSET,
	AUMB4000_CF_TIMING_CMD1_OFFSET,
	AUMB4000_CF_TIMING_CMD2_OFFSET,
	AUMB4000_CF_TIMING_CMD3_OFFSET,
	AUMB4000_CF_TIMING_CMD4_OFFSET
};

/* xfer mode number in a such a way to index into
 * the timing table
 */
enum xfer_mode {
	PIO0    = 0, 
	PIO1	 = 1, 
	PIO2	 = 2, 
	PIO3	 = 3, 
	PIO4	 = 4, 
	PIO5	 = 5, 
	PIO6	 = 6,
	MWDMA0	 = 7,
	MWDMA1	 = 8, 
	MWDMA2	 = 9, 
	MWDMA3	 = 10, 
	MWDMA4	 = 11,
	UDMA0	 = 12,
	UDMA1	 = 13,
	UDMA2	 = 14,
	UDMA3	 = 15,
	UDMA4	 = 16,
	UDMA5	 = 17,
	UDMA6	 = 18,
};

#define NUMBER_OF_AUMB4000_TIMING_PARAMS	59
struct mode_timings_defs {
	uint32_t mode_timing_values[NUMBER_OF_AUMB4000_TIMING_PARAMS];
};

uint8_t read_commands[] = {
	CF_COMMAND_READ_DATA,
	CF_COMMAND_READ_ERROR,
	CF_COMMAND_READ_SECTOR_COUNT,
	CF_COMMAND_READ_SECTOR_NUMBER,
	CF_COMMAND_READ_CYLINDER_LOW,
	CF_COMMAND_READ_CYLINDER_HIGH,
	CF_COMMAND_READ_DRIVE_HEAD,
	CF_COMMAND_READ_STATUS,
	CF_COMMAND_READ_ALTERNATE_STATUS,
	CF_COMMAND_READ_DRIVE_ADDRESS
};

uint8_t write_commands[] = {
	CF_COMMAND_WRITE_DATA,
	CF_COMMAND_WRITE_FEATURE,
	CF_COMMAND_WRITE_SECTOR_COUNT,
	CF_COMMAND_WRITE_SECTOR_NUMBER,
	CF_COMMAND_WRITE_CYLINDER_LOW,
	CF_COMMAND_WRITE_CYLINDER_HIGH,
	CF_COMMAND_WRITE_DRIVE_HEAD,
	CF_COMMAND_WRITE_COMMAND,
	CF_COMMAND_WRITE_DEVICE_CONTROL
};

#define DMA_REQUEST_ERR			0x01
#define DMA_HANDLER_ERR			0x02
#define DMA_CONFIG_XFER_ERR		0x04
#define DMA_CONFIG_DST_ERR		0x08
#define DMA_CONFIG_SRC_ERR		0x10
#define DMA_ENABLE_ERR			0x20

#define DMA_ERROR_MASK			0x3f
#define DMA_SETUP_ERROR_MASK	\
	(DMA_REQUEST_ERR | \
	DMA_HANDLER_ERR | \
	DMA_CONFIG_XFER_ERR	| \
	DMA_CONFIG_DST_ERR  | \
	DMA_CONFIG_SRC_ERR)

struct mobi_ata_prv_data {
    int gpio_shift;
    int dma_status;
    int dma_event;
    int dma_dir;
	uint32_t dma_error;
	int dma_ref_count;
	int dev_id_cmd_done;
    char dmaPending;
    char bmdma_status;
    char cmdIntEnabled;
    gpio_driver_handle gpio_hdl;
    unsigned long transferCount;
    unsigned char crntCommand;
    struct ata_port *ap;
    struct ata_queued_cmd *qc;
    mobi_dma_handle dma_handle;
    unsigned long *buf;
    struct aumb4000_device_data_t *aumb4k;
};

#endif 
