/*
 *  linux/arch/arm/oprofile/fiq_int.S: FIQ handler for oprofile
 *
 */
#include <linux/linkage.h>
#include <asm/asm-offsets.h>
#include <asm/ptrace.h>

	.text
/*
 *  NOTE: If paging is enabled in the system.... then this may have futher complications.
 */
ENTRY(fiq_handler)
	ldr	ip, [r8]	@ clear the interupt
	ldr	ip, [r9]
	add	ip, ip, #1
	str	ip, [r9]	@ increment first counter

	sub	lr, lr, #4

	mrs	r10, spsr
	tst	r10, #PSR_I_BIT	@ if int disable bit is set then...
	beq	1f

	stmia	sp, {r0-r3,lr}
	mov	r0, lr
	mov	r1, r10
	ldr	r2, fast_add_sample_addr
	blx	r2 		@ ... avoid trying to dereference "current"
	ldmia	sp, {r0-r3,pc}^

1:
	ldr	ip, [r9, #4]
	add	ip, ip, #1
	str	ip, [r9, #4]	@ increment second counter

	stmia	sp, {r0, lr}	@ store r0, pc...
	str	r10, [sp, #8]	@ ... cspr

	mov	r0, sp
	msr	cpsr_c, #PSR_F_BIT|PSR_I_BIT|SVC_MODE	@ switch to svc mode

	sub	sp, sp, #S_FRAME_SIZE
	stmib	sp, {r1 - lr}

	ldmia	r0, {r1 - r3}
	add	r5, sp, #S_SP		@ here for interlock avoidance
	mov	r4, #-1			@  ""  ""      ""       ""
	add	r0, sp, #S_FRAME_SIZE   @  ""  ""      ""       ""
	str	r1, [sp]		@ save the "real" r0 copied
					@ from the exception stack

	mov	r1, lr

	@
	@ We are now ready to fill in the remaining blanks on the stack:
	@
	@  r0 - sp_svc
	@  r1 - lr_svc
	@  r2 - lr_<exception>, already fixed up for correct return/restart
	@  r3 - spsr_<exception>
	@  r4 - orig_r0 (see pt_regs definition in ptrace.h)
	@
	stmia	r5, {r0 - r4}

	mov	r0, sp
	mov	r1, #0
	ldr	r2, oprofile_add_sample_addr
	blx	r2

	ldmia	sp, {r0-lr}
	
	msr	cpsr_c, #PSR_F_BIT|PSR_I_BIT|FIQ_MODE	@ go back to fiq mode
	movs	pc, lr
	
fast_add_sample_addr:
	.word fast_add_sample
oprofile_add_sample_addr:
	.word oprofile_add_sample

ENTRY(fiq_handler_size)
	.word .-fiq_handler
