/*HEADER_START*/
/*
 *  linux/include/asm-arm/arch-merlin/reset.h
 *
 *  Copyright (C) 2006 Mobilygen Corp.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*HEADER_STOP*/

#ifndef __MACH_MERLIN_RESET_H
#define __MACH_MERLIN_RESET_H

#include <mach/mobi_reset.h>

#define RESET_PROC_DIR          "drivers/reset"

/* reset states */
#define RESET_STATE_DISABLE 	0x0
#define RESET_STATE_ENABLE 		0x1

/* disable as much as possible without hanging the system */
/* this may need to be changed				  */
#define SOC_DISABLE_ALL_MASK	RESET_ID_AES		| \
								RESET_ID_CF			| \
								RESET_ID_DMAC		| \
								RESET_ID_GMAC		| \
								RESET_ID_MHIF		| \
								RESET_ID_GMAC		| \
								RESET_ID_NAND		| \
								RESET_ID_OTGPHY		| \
								RESET_ID_QDSM		| \
								RESET_ID_SDMMC		| \
								RESET_ID_SHA		| \
								RESET_ID_USBP		| \
								RESET_ID_USBH		| \
								RESET_ID_WDT		| \
								RESET_ID_UART01		| \
								RESET_ID_PWM		| \
								RESET_ID_SSI		| \
								RESET_ID_GPIO		| \
								RESET_ID_I2C

struct reset_dev {
	const char		*name;
	uint32_t                id;
};

static uint32_t reset_control(uint32_t device_id, uint8_t action);

#endif  /* RESET_H */
