/*
 *  linux/include/asm-arm/arch-merlin/memory.h
 *
 *  Copyright (C) 2006 Mobilygen Corp
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __MACH_MERLIN_INCLUDE_MACH_MEMORY_H
#define __MACH_MERLIN_INCLUDE_MACH_MEMORY_H

#include <mach/platform.h>

/*
 * Physical DRAM offset.
 */
#define PHYS_OFFSET	UL(0x00000000)

/*
 * Map but reserve the high memory
 */
#ifndef __ASSEMBLY__

void mgx_adjust_zones(int node, unsigned long *size, unsigned long *holes);

#define arch_adjust_zones(node, size, holes) \
	mgx_adjust_zones(node, size, holes)

#endif

/*
 * Virtual view <-> DMA view memory address translations
 * virt_to_bus: Used to translate the virtual address to an
 *              address suitable to be passed to set_dma_addr
 * bus_to_virt: Used to convert an address for DMA operations
 *              to an address that the kernel can use.
 */
#define __virt_to_bus(x)	__virt_to_phys(x)
#define __bus_to_virt(x)	__phys_to_virt(x)

/*
 * On Merlin the DMA is using a different bridge than the ARM
 */
#define __arch_page_to_dma(dev, page)	\
	(((dma_addr_t)__virt_to_bus((unsigned long)page_address(page))) | MMU_BRIDGE_DMA_BASE)

#define __arch_dma_to_virt(dev, addr)	\
	((void *)__bus_to_virt(addr & (~MMU_BRIDGE_DMA_BASE)))

#define __arch_virt_to_dma(dev, addr)	\
	(((dma_addr_t)__virt_to_bus((unsigned long)(addr))) | MMU_BRIDGE_DMA_BASE)

#endif /* __MACH_MERLIN_INCLUDE_MACH_MEMORY_H */
