/*HEADER_START*/
/*
*  linux/arch/arm/mach-merlin/clock.h
*
*  Copyright (C) 2006 Mobilygen Corp
*  Derived from mach-versatile/clock.h
*
*  Copyright (C) 2004 ARM Limited.
*  Written by Deep Blue Solutions Limited.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
 */
/*HEADER_STOP*/

#ifndef __MACH_MERLIN_CLOCK_H
#define __MACH_MERLIN_CLOCK_H

struct module;

#define CLOCK_PROC_DIR	"drivers/clock"

/***************************************************/
/*   definitions for programming the PLLs          */
/***************************************************/
#define PLL_DISABLE  0
#define PLL_ENABLE   1

#define PLL_VCOSEL0 0
#define PLL_VCOSEL1 1

#define PLL_INTPROG_MIN 1
#define PLL_INTPROG_MAX 127

#define PLL_BYPASS_DISABLE 0
#define PLL_BYPASS_ENABLE  1

int pll_bw_values[] = { 
	100000, 
	200000,
	400000,
	800000,
	100000000,
	200000000,
	400000000,
	800000000
};
typedef enum {
	PLL_BW_100KHZ=0,
	PLL_BW_200KHZ,
	PLL_BW_400KHZ,
	PLL_BW_800KHZ,
	PLL_BW_1MHZ,
	PLL_BW_2MHZ,
	PLL_BW_4MHZ,
	PLL_BW_8MHZ
} pll_reg_bw_t;

int pll_bwmax_values[] = {  
	100000, 
	200000,
	400000,
	800000,
	100000000,
	200000000,
	400000000,
	800000000
};
typedef enum {
	PLL_BWMAX_100KHZ=0,
	PLL_BWMAX_200KHZ,
	PLL_BWMAX_400KHZ,
	PLL_BWMAX_800KHZ,
	PLL_BWMAX_1MHZ,
	PLL_BWMAX_2MHZ,
	PLL_BWMAX_4MHZ,
	PLL_BWMAX_8MHZ
} pll_reg_bwmax_t;

uint32_t pll_sdiv_values[] = { 8, 4, 2, 1 };
typedef enum {
	PLL_SDIV_8=0,
	PLL_SDIV_4,
	PLL_SDIV_2,
	PLL_SDIV_1
} pll_reg_sdiv_t;

uint32_t pll_sout_values[] = { 8, 4, 2, 1 };
typedef enum {
	PLL_SOUT_8=0,
	PLL_SOUT_4,
	PLL_SOUT_2,
	PLL_SOUT_1
} pll_reg_sout_t;

/***************************************************/
/*   definitions for programming the Scalers       */
/***************************************************/

#define SCALER_MAX_PRE_OUT_RATE 750000000

#define SCALER_DIV_MIN 1
#define SCALER_DIV_MAX 127

#define SCALER_BYPASS_DISABLE 0
#define SCALER_BYPASS_ENABLE  1

int scaler_pre_values[] = { 1, 2, 3, 4, 8 };
typedef enum {
	SCALER_PRE_1=0,
	SCALER_PRE_2,
	SCALER_PRE_3,
	SCALER_PRE_4,
	SCALER_PRE_8,
} scaler_reg_pre_t;

/***************************************************/

struct clk_callback {
	struct list_head	node;
	void 			(*callback_func)(void*);
	void 			*callback_data;
};

struct clk {
	struct list_head	node;
	const char		    *name;
	enum clock_id		id;
	unsigned long		shadow_reg;
	uint32_t			qcc_addr;
	uint32_t			enable_mask;
	uint32_t			flags;
	struct mutex		lock;

	struct list_head	callback_list;

	uint32_t dependencies[CLOCK_ID_MAX+1];

	struct module		*owner;

};

/* used internally to program the src for the video clocks */
#define VID_SRC_SELECT_NR   0
#define VID_SRC_SELECT_PLL2 1
#define VID_SRC_SELECT_PLL3 2

#define AUD_SRC_SELECT_PLL2 0
#define AUD_SRC_SELECT_PLL3 1

/* helpers */
static struct clk *clock_get_by_id(enum clock_id clk_id);
static int clock_disable(struct clk *clk);
static int32_t update_shadow_reg(struct clk *clk);
static void hl_calculate_div(unsigned long, 
		unsigned long, uint32_t*, uint32_t*, uint32_t);
static void nr_calculate_div(unsigned long fout, 
		unsigned long fin, int *ndiv, int *rdiv, uint32_t size);

static int32_t get_pll_freq(enum clock_id clk_id, unsigned long*);
static int32_t get_scaler_freq(enum clock_id clk_id, unsigned long*);
static int32_t get_nr_freq(struct clk *clk, unsigned long*);
static int32_t get_hl_freq(struct clk *clk, unsigned long*);

static int32_t set_pll_freq(struct clk *clk, unsigned long freq);
static int32_t set_scaler_freq(struct clk *clk, unsigned long freq);
static int32_t set_core_freq(struct clk *clk, unsigned long freq);

static int32_t handle_callbacks(struct clk *clk);

static int clk_register(struct clk *clk);
static void __attribute__((unused)) clk_unregister(struct clk *clk);

#endif
