/*HEADER_START*/
/*
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/*HEADER_STOP*/

#include <asm/mach-types.h>

#include <asm/mach/arch.h>
#include <asm/mach/irq.h>
#include <asm/mach/map.h>

#include <mach/hardware.h>
#include <mach/platform.h>
#include <mach/mobi_clock.h>
#include <mach/mobi_qcc.h>

void __init mg3500_map_io(void);
void __init mg3500_init_irq(void);
static void __init mg3500_board_init(void);

extern struct sys_timer mgx_sys_timer;
extern void __init mgx_ictl_init(void);
extern void __init __early_qccsisc_init(void);
extern void __early_clk_init(void);
extern void (*merlin_arch_reset)(void);
extern int mg3500_register_platform_drivers(void);

static struct map_desc mg3500_io_desc[] __initdata = {
	{
		.virtual	= IO_ADDRESS(UARTDBG_BASE),
		.pfn		= __phys_to_pfn(UARTDBG_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, 
	{
		.virtual	= IO_ADDRESS(ICTL_BASE),
		.pfn		= __phys_to_pfn(ICTL_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}, 
	{
		.virtual	= IO_ADDRESS(TIMERS_BASE),
		.pfn		= __phys_to_pfn(TIMERS_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	},
	{
		.virtual	= IO_ADDRESS(QCC_BASE),
		.pfn		= __phys_to_pfn(QCC_BASE),
		.length		= SZ_4K,
		.type		= MT_DEVICE,
	}
};

void __init mg3500_map_io(void)
{
	iotable_init(mg3500_io_desc, ARRAY_SIZE(mg3500_io_desc));
	/* after this runs, need to access the timer clock 
	*  and get it started so the sytem timer will start!
	 */
	__early_qccsisc_init();
	__early_clk_init();
}

void __init mg3500_init_irq(void)
{
	mgx_ictl_init();
}

static void mg3500_reset(void)
{
	mobi_qcc_write(QCC_BID_CHIPCTL, 
		QCC_CHIPCTL_SWCHIP_RESET_SET, 0x1, QCC_ACCESS_LEN_4);
}

static void __init mg3500_board_init(void)
{
	merlin_arch_reset = mg3500_reset;
	mg3500_register_platform_drivers();
	return;
}

MACHINE_START(MERLIN, "Mobilygen Merlin MG3500")
	.phys_io       = 0x80000000,
	.io_pg_offst   = ((0xf0000000) >> 18) & 0xfffc,
	.boot_params   = MMU_BRIDGE_ARM_BASE + 0x100,
	.map_io        = mg3500_map_io,
	.init_irq      = mg3500_init_irq,
	.timer         = &mgx_sys_timer,
	.init_machine  = mg3500_board_init,
MACHINE_END
