/*HEADER_START*/
/*
 *  linux/include/asm-arm/arch-falcon/ioctrl.h
 *
 *  Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*HEADER_STOP*/
#ifndef MACH_FALCON_IOCTRL_H
#define MACH_FALCON_IOCTRL_H

#include <linux/types.h>
#include <mach/platform.h>
#include <mach/mobi_qcc.h>

/* 
 * the structures in this file are used to describe different aspects
 *  of the ioctrl hw module.  the code will use these definitions to
 *  determine size, read and write registers.  doing it this way will
 *  make is possible to change the descriptions for future chips with
 *  changing the C code
 */
typedef struct gpio_desc_s {
	int16_t  pu_addr;
	uint32_t pu_mask;
	int16_t  pd_addr;
	uint32_t pd_mask;
} gpio_desc_t;

/* make sure this define is updated to match the gpio_desc array */
#define IOCTRL_NUM_GPIO_BANKS  3
gpio_desc_t gpio_desc[] = {
	{
		QCC_CHIPCTL_GPIO0PULLUPEN_OFFSET,
		QCC_CHIPCTL_GPIO0PULLUPEN_GPIO0PULLUPEN_MASK,
		QCC_CHIPCTL_GPIO0PULLDOWNEN_OFFSET,
		QCC_CHIPCTL_GPIO0PULLDOWNEN_GPIO0PULLDOWNEN_MASK
	},
	{
		QCC_CHIPCTL_GPIO1PULLUPEN_OFFSET,
		QCC_CHIPCTL_GPIO1PULLUPEN_GPIO1PULLUPEN_MASK,
		QCC_CHIPCTL_GPIO1PULLDOWNEN_OFFSET,
		QCC_CHIPCTL_GPIO1PULLDOWNEN_GPIO1PULLDOWNEN_MASK
	},
	{
		QCC_CHIPCTL_GPIO2PULLUPEN_OFFSET,
		QCC_CHIPCTL_GPIO2PULLUPEN_GPIO2PULLUPEN_MASK,
		QCC_CHIPCTL_GPIO2PULLDOWNEN_OFFSET,
		QCC_CHIPCTL_GPIO2PULLDOWNEN_GPIO2PULLDOWNEN_MASK
	}
};

/* for drivestrength and slewrate */
char *group_names[] = {
	"serial",
	"spi",
	"v01spi",
	"v23spi",
	"video0",
	"video1",
	"video2",
	"video3",
	"host",
	"ethernet",
	"audio",
	"sdmmc",
	NULL
};

struct function_info {
	char *name;
	char *state_names[2];
};

struct function_info functions[] = {
	{
		.name = "dbg_uart",
		.state_names[0] = "ARM DBG Uart",
		.state_names[1] = "QMM DBG Uart",
	},
	{
		.name = "i2c_cfg",
		.state_names[0] = "I2C_1 -> VO1",
		.state_names[1] = "I2C_1 -> V23",
	},
	{
		.name = "v23_mosi",
		.state_names[0] = "V23_MOSI",
		.state_names[1] = "V23_SDA",
	},
	{
		.name = "v23_mclk",
		.state_names[0] = "V23_MCLK",
		.state_names[1] = "V23_SCL",
	},
	{
		.name = "v01_mosi",
		.state_names[0] = "VOI_MOSI",
		.state_names[1] = "V01_SDA",
	},
	{
		.name = "v01_mclk",
		.state_names[0] = "VOI_MCLK",
		.state_names[1] = "V01_MCLK",
	},
	{
		.name = "spi_mosi",
		.state_names[0] = "SPI_MOSI",
		.state_names[1] = "BS_DATA",
	},
	{
		.name = "spi_mclk",
		.state_names[0] = "SPI_MCLK",
		.state_names[1] = "BS_CLK",
	},
	{
		.name = "spi_mss0",
		.state_names[0] = "SPI_MSS0",
		.state_names[1] = "BS_ENABLE",
	},
	{
		.name = "spi_mss1",
		.state_names[0] = "SPI_MSS1",
		.state_names[1] = "BS_REQ",
	},
	{
		.name = "spi_master",
		.state_names[0] = "SPI Slave",
		.state_names[1] = "SPI Master",
	},
	{
		.name = NULL,
	}
};

char *gpio_cmds[] = {
	"function",
	"pullup",
	"pulldown",
	"tristate",
	NULL
};

#endif  /* MACH_FALCON_IOCTRL_H */
