/*
 * include/asm-arm/arch-falcon/mobi_reset.h
 *
 *  Copyright (C) 2009 Maxim IC
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MACH_FALCON_RESET_IDS_H
#define __MACH_FALCON_RESET_IDS_H

/* this pulls in the register defintions for the bitmask and the API */
#include <mach/mobi_qcc.h>

/* 
 * we have two reset registers, the msb of for reset1 is not used, so we'll
 * use that bit to flag reset1 vs reset0
 */
#define IN_CTRL1_REG_MASK	0x80000000

/* reset control 0 */
#define RESET_ID_CHIP      		QCC_CHIPCTL_RESETCONTROLSET0_CHIPSWRESET_SET_MASK
#define RESET_ID_CODEC      	QCC_CHIPCTL_RESETCONTROLSET0_CODECSWRESET_SET_MASK
#define RESET_ID_PMC       		QCC_CHIPCTL_RESETCONTROLSET0_PMCSWRESET_SET_MASK
#define RESET_ID_AHB_PCI   		QCC_CHIPCTL_RESETCONTROLSET0_SW_AHB_PCI_RST_SET_MASK
#define RESET_ID_AXI_VIDEO 		QCC_CHIPCTL_RESETCONTROLSET0_SW_AXI_VIDEO_RST_SET_MASK
#define RESET_ID_AXI_MMU   		QCC_CHIPCTL_RESETCONTROLSET0_SW_AXI_MMU_RST_SET_MASK
#define RESET_ID_APB_SPI        QCC_CHIPCTL_RESETCONTROLSET0_SW_APB_SPI_HRESET_SET_MASK
#define RESET_ID_SPI0      		QCC_CHIPCTL_RESETCONTROLSET0_SW_SPI0_HRESET_SET_MASK
#define RESET_ID_SPI1      		QCC_CHIPCTL_RESETCONTROLSET0_SW_SPI1_HRESET_SET_MASK
#define RESET_ID_SPI2      		QCC_CHIPCTL_RESETCONTROLSET0_SW_SPI2_HRESET_SET_MASK
#define RESET_ID_I2C0      		QCC_CHIPCTL_RESETCONTROLSET0_SW_I2C0_PRESET_SET_MASK
#define RESET_ID_I2C1      		QCC_CHIPCTL_RESETCONTROLSET0_SW_I2C1_PRESET_SET_MASK
#define RESET_ID_PWM0      		QCC_CHIPCTL_RESETCONTROLSET0_SW_PWM0_PRESET_SET_MASK
#define RESET_ID_PWM1      		QCC_CHIPCTL_RESETCONTROLSET0_SW_PWM1_PRESET_SET_MASK
#define RESET_ID_PWM2      		QCC_CHIPCTL_RESETCONTROLSET0_SW_PWM2_PRESET_SET_MASK
#define RESET_ID_GPIO0     		QCC_CHIPCTL_RESETCONTROLSET0_SW_GPIO0_PRESET_SET_MASK
#define RESET_ID_GPIO1     		QCC_CHIPCTL_RESETCONTROLSET0_SW_GPIO1_PRESET_SET_MASK
#define RESET_ID_GPIO2     		QCC_CHIPCTL_RESETCONTROLSET0_SW_GPIO2_PRESET_SET_MASK
#define RESET_ID_UARTDBG   		QCC_CHIPCTL_RESETCONTROLSET0_SW_UART_DBG_RST_SET_MASK
#define RESET_ID_UART0     		QCC_CHIPCTL_RESETCONTROLSET0_SW_UART0_RST_SET_MASK
#define RESET_ID_UART1     		QCC_CHIPCTL_RESETCONTROLSET0_SW_UART1_RST_SET_MASK
#define RESET_ID_WDT       		QCC_CHIPCTL_RESETCONTROLSET0_SW_WDT_PRESET_SET_MASK
#define RESET_ID_TIMER1    		QCC_CHIPCTL_RESETCONTROLSET0_SW_TIMER1_RESET_SET_MASK
#define RESET_ID_TIMER2    		QCC_CHIPCTL_RESETCONTROLSET0_SW_TIMER2_RESET_SET_MASK
#define RESET_ID_TIMER3    		QCC_CHIPCTL_RESETCONTROLSET0_SW_TIMER3_RESET_SET_MASK
#define RESET_ID_TIMER4    		QCC_CHIPCTL_RESETCONTROLSET0_SW_TIMER4_RESET_SET_MASK
#define RESET_ID_TIMER5    		QCC_CHIPCTL_RESETCONTROLSET0_SW_TIMER5_RESET_SET_MASK
#define RESET_ID_APB_SS_HR      QCC_CHIPCTL_RESETCONTROLSET0_SW_APB_SS_HRESET_SET_MASK
#define RESET_ID_APB_SS_PRE     QCC_CHIPCTL_RESETCONTROLSET0_SW_APB_SS_PRESET_SET_MASK
/* note, this value is 0x20000000, if a resetID in ctrl uses the MSB, new encoding will be needed */
#define RESET_ID_AXI_SS         QCC_CHIPCTL_RESETCONTROLSET0_SW_AXI_SS_RST_SET_MASK


/* reset control 1, MSB set to indicate control 1 */
#define RESET_ID_SHA			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_SHA_HRESET_SET_MASK)
#define RESET_ID_AES			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_AES_HRESET_SET_MASK)
#define RESET_ID_NAND			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_FLASH_HRESET_SET_MASK)
#define RESET_ID_SDMMC			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_SDMMC_HRESET_SET_MASK)
#define RESET_ID_QDSM			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_QDSM_HRESET_SET_MASK)
#define RESET_ID_ICM2           (IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_ICM2_HRESET_SET_MASK)
#define RESET_ID_EH2H_PERIPH	(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_H2H_PER_HRESET_SET_MASK)
#define RESET_ID_ICM1           (IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_AHB1_ICM_HRESET_SET_MASK)
#define RESET_ID_ICTL			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_ICTL_HRESET_SET_MASK)
#define RESET_ID_DMAC			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_DMAC_HRESET_SET_MASK)
#define RESET_ID_DMA_MMU	    (IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_DMAMMU_HRESET_SET_MASK)
#define RESET_ID_SATA   		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_SATA_HRESET_SET_MASK)
#define RESET_ID_SATA_P0		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_SATA_P0_RST_SET_MASK)
#define RESET_ID_SATA_P1		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_SATA_P1_RST_SET_MASK)
#define RESET_ID_USBH			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_USB_LINK_HRST_SET_MASK)
#define RESET_ID_USBP			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_USB_LINK_PRST_SET_MASK)
#define RESET_ID_OTGPHY			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_USB_PHY_POR_SET_MASK)
#define RESET_ID_GMAC			(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_GMAC_HRESET_SET_MASK)
#define RESET_ID_PCIE_AMBA 		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_PCIE_AMBA_RST_SET_MASK)
#define RESET_ID_PCIE_CSR  		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_PCIE_CSR_RST_SET_MASK)
#define RESET_ID_PCIE_GPEX 		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_PCIE_GPEX_RST_SET_MASK)
#define RESET_ID_PCIE_LINK 		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_PCIE_LINK_RST_SET_MASK)
#define RESET_ID_PCIE_PAB  		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_PCIE_PAB_RST_SET_MASK)
#define RESET_ID_PCIE_PHY  		(IN_CTRL1_REG_MASK | QCC_CHIPCTL_RESETCONTROLSET1_SW_PCIE_PHY_RST_SET_MASK)

/*
 * mg3500 did not split out the individual reset, we'll add
 * these defines for simplicity but the individual ones
 * could be used if the need arises
 */
#define RESET_ID_SSI	RESET_ID_SPI0		| \
						RESET_ID_SPI1		| \
						RESET_ID_SPI2

#define RESET_ID_PWM	RESET_ID_PWM0		| \
						RESET_ID_PWM1		| \
						RESET_ID_PWM2

#define RESET_ID_I2C	RESET_ID_I2C0		| \
						RESET_ID_I2C1

#define RESET_ID_GPIO	RESET_ID_GPIO0		| \
						RESET_ID_GPIO1		| \
						RESET_ID_GPIO2

#define RESET_ID_UART01	RESET_ID_UART0		| \
						RESET_ID_UART1


/* do not define any one-hot reset_ids below this line! */
#define RESET_ID_WDTSYS		0x00000003 /* this is the watchdog system reset!! */

#endif
