/* ========================================================================= */
/* DO NOT EDIT -- automatically generated                                    */
/* mobi_flash: Source mobi_au_flash.r                                        */
/* Built by cregdefs.awk $Revision: 1879 $                                    */
/* ========================================================================= */

#if !defined(mobi_flash_INCLUDED)
#define mobi_flash_INCLUDED
/*                                                                           */
/*  This file contains the definitions for the Aurora                        */
/*  MB3000 NAND/NOR flash controller                                         */
/*                                                                           */
/*                                                                           */
/* Command opcodes for NAND controller                                       */
/*                                                                           */
#define  AUMB3000_NAND_CMD_NOP	0x0
#define  AUMB3000_NAND_CMD_DMA	0x1
#define  AUMB3000_NAND_CMD_RESET	0x2
#define  AUMB3000_NAND_CMD_NOP2	0x3
#define  AUMB3000_NAND_CMD_NOP3	0x4
#define  AUMB3000_NAND_CMD_NOP4	0x5
#define  AUMB3000_NAND_CMD_NOP5	0x6
#define  AUMB3000_NAND_CMD_CPBACK	0x7
#define  AUMB3000_NAND_CMD_NOP6	0x8
#define  AUMB3000_NAND_CMD_ERASE	0x9
#define  AUMB3000_NAND_CMD_READID	0xA
#define  AUMB3000_NAND_CMD_NOP7	0xB
#define  AUMB3000_NAND_CMD_RDSTATUS	0xC
#define  AUMB3000_NAND_CMD_NOP8	0xD
#define  AUMB3000_NAND_CMD_READ	0xE
#define  AUMB3000_NAND_CMD_PROGRAM	0xF
/*                                                                           */
/* Command opcodes for NOR controller                                        */
/*                                                                           */
#define  AUMB3000_NOR_CMD_NOP	0x0
#define  AUMB3000_NOR_CMD_DMA	0x1
#define  AUMB3000_NOR_CMD_LOCK	0x4
#define  AUMB3000_NOR_CMD_UNLOCK	0x5
#define  AUMB3000_NOR_CMD_LOCKD	0x6
#define  AUMB3000_NOR_CMD_DIRECTRD	0x7
#define  AUMB3000_NOR_CMD_READCFI	0x8
#define  AUMB3000_NOR_CMD_ERASE	0x9
#define  AUMB3000_NOR_CMD_READID	0xA
#define  AUMB3000_NOR_CMD_DIRECTWR	0xB
#define  AUMB3000_NOR_CMD_RDSTATUS	0xC
#define  AUMB3000_NOR_CMD_CLRSTATUS	0xD
#define  AUMB3000_NOR_CMD_READ	0xE
#define  AUMB3000_NOR_CMD_PROGRAM	0xF

/* ######################################################################### */
/*         MOBI_FLASH                                                        */
/* ######################################################################### */

#define MOBI_FLASH_BASE           FLASH_REG_BASE

/* ========================================================================= */
/*         MOBI_FLASH_NAND_CONTROL - NAND Control register                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_WD [2] - data bus width                   */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_WD_SIZE 2
#define     MOBI_FLASH_NAND_CONTROL_WD_MASK 0x00000003
#define     MOBI_FLASH_NAND_CONTROL_WD_R(x) (((x) & 0x00000003) >> 0)
#define     MOBI_FLASH_NAND_CONTROL_WD_W(x) (((x) << 0) & 0x00000003)
#define     MOBI_FLASH_NAND_CONTROL_WD_SET(x) (((x) |= 0x00000003))
#define     MOBI_FLASH_NAND_CONTROL_WD_CLR(x) (((x) &= ~(0x00000003)))
#define     MOBI_FLASH_NAND_CONTROL_WD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_WD_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_WD_W(y))
#define     MOBI_FLASH_NAND_CONTROL_WD_SHIFT 0
#define     MOBI_FLASH_NAND_CONTROL_WD_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_EB [2] - external banks                   */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_EB_SIZE 2
#define     MOBI_FLASH_NAND_CONTROL_EB_MASK 0x0000000c
#define     MOBI_FLASH_NAND_CONTROL_EB_R(x) (((x) & 0x0000000c) >> 2)
#define     MOBI_FLASH_NAND_CONTROL_EB_W(x) (((x) << 2) & 0x0000000c)
#define     MOBI_FLASH_NAND_CONTROL_EB_SET(x) (((x) |= 0x0000000c))
#define     MOBI_FLASH_NAND_CONTROL_EB_CLR(x) (((x) &= ~(0x0000000c)))
#define     MOBI_FLASH_NAND_CONTROL_EB_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_EB_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_EB_W(y))
#define     MOBI_FLASH_NAND_CONTROL_EB_SHIFT 2
#define     MOBI_FLASH_NAND_CONTROL_EB_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_SZ [3] - flash chip size                  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_SZ_SIZE 3
#define     MOBI_FLASH_NAND_CONTROL_SZ_MASK 0x00000070
#define     MOBI_FLASH_NAND_CONTROL_SZ_R(x) (((x) & 0x00000070) >> 4)
#define     MOBI_FLASH_NAND_CONTROL_SZ_W(x) (((x) << 4) & 0x00000070)
#define     MOBI_FLASH_NAND_CONTROL_SZ_SET(x) (((x) |= 0x00000070))
#define     MOBI_FLASH_NAND_CONTROL_SZ_CLR(x) (((x) &= ~(0x00000070)))
#define     MOBI_FLASH_NAND_CONTROL_SZ_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_SZ_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_SZ_W(y))
#define     MOBI_FLASH_NAND_CONTROL_SZ_SHIFT 4
#define     MOBI_FLASH_NAND_CONTROL_SZ_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_XS [1] - 16 bit data bus                  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_XS_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_XS_MASK 0x00000080
#define     MOBI_FLASH_NAND_CONTROL_XS_R(x) (((x) & 0x00000080) >> 7)
#define     MOBI_FLASH_NAND_CONTROL_XS_W(x) (((x) << 7) & 0x00000080)
#define     MOBI_FLASH_NAND_CONTROL_XS_SET(x) (((x) |= 0x00000080))
#define     MOBI_FLASH_NAND_CONTROL_XS_CLR(x) (((x) &= ~(0x00000080)))
#define     MOBI_FLASH_NAND_CONTROL_XS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_XS_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_XS_W(y))
#define     MOBI_FLASH_NAND_CONTROL_XS_SHIFT 7
#define     MOBI_FLASH_NAND_CONTROL_XS_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_IE [1] - interrupt enable                 */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_IE_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_IE_MASK 0x00000100
#define     MOBI_FLASH_NAND_CONTROL_IE_R(x) (((x) & 0x00000100) >> 8)
#define     MOBI_FLASH_NAND_CONTROL_IE_W(x) (((x) << 8) & 0x00000100)
#define     MOBI_FLASH_NAND_CONTROL_IE_SET(x) (((x) |= 0x00000100))
#define     MOBI_FLASH_NAND_CONTROL_IE_CLR(x) (((x) &= ~(0x00000100)))
#define     MOBI_FLASH_NAND_CONTROL_IE_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_IE_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_IE_W(y))
#define     MOBI_FLASH_NAND_CONTROL_IE_SHIFT 8
#define     MOBI_FLASH_NAND_CONTROL_IE_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_WP [1] - write protect                    */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_WP_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_WP_MASK 0x00000200
#define     MOBI_FLASH_NAND_CONTROL_WP_R(x) (((x) & 0x00000200) >> 9)
#define     MOBI_FLASH_NAND_CONTROL_WP_W(x) (((x) << 9) & 0x00000200)
#define     MOBI_FLASH_NAND_CONTROL_WP_SET(x) (((x) |= 0x00000200))
#define     MOBI_FLASH_NAND_CONTROL_WP_CLR(x) (((x) &= ~(0x00000200)))
#define     MOBI_FLASH_NAND_CONTROL_WP_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_WP_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_WP_W(y))
#define     MOBI_FLASH_NAND_CONTROL_WP_SHIFT 9
#define     MOBI_FLASH_NAND_CONTROL_WP_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_AU [1] - automatic writeback              */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_AU_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_AU_MASK 0x00000400
#define     MOBI_FLASH_NAND_CONTROL_AU_R(x) (((x) & 0x00000400) >> 10)
#define     MOBI_FLASH_NAND_CONTROL_AU_W(x) (((x) << 10) & 0x00000400)
#define     MOBI_FLASH_NAND_CONTROL_AU_SET(x) (((x) |= 0x00000400))
#define     MOBI_FLASH_NAND_CONTROL_AU_CLR(x) (((x) &= ~(0x00000400)))
#define     MOBI_FLASH_NAND_CONTROL_AU_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_AU_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_AU_W(y))
#define     MOBI_FLASH_NAND_CONTROL_AU_SHIFT 10
#define     MOBI_FLASH_NAND_CONTROL_AU_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_FD [1] - write fill disable               */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_FD_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_FD_MASK 0x00000800
#define     MOBI_FLASH_NAND_CONTROL_FD_R(x) (((x) & 0x00000800) >> 11)
#define     MOBI_FLASH_NAND_CONTROL_FD_W(x) (((x) << 11) & 0x00000800)
#define     MOBI_FLASH_NAND_CONTROL_FD_SET(x) (((x) |= 0x00000800))
#define     MOBI_FLASH_NAND_CONTROL_FD_CLR(x) (((x) &= ~(0x00000800)))
#define     MOBI_FLASH_NAND_CONTROL_FD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_FD_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_FD_W(y))
#define     MOBI_FLASH_NAND_CONTROL_FD_SHIFT 11
#define     MOBI_FLASH_NAND_CONTROL_FD_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_EG [2] - ECC generation enable            */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_EG_SIZE 2
#define     MOBI_FLASH_NAND_CONTROL_EG_MASK 0x00003000
#define     MOBI_FLASH_NAND_CONTROL_EG_R(x) (((x) & 0x00003000) >> 12)
#define     MOBI_FLASH_NAND_CONTROL_EG_W(x) (((x) << 12) & 0x00003000)
#define     MOBI_FLASH_NAND_CONTROL_EG_SET(x) (((x) |= 0x00003000))
#define     MOBI_FLASH_NAND_CONTROL_EG_CLR(x) (((x) &= ~(0x00003000)))
#define     MOBI_FLASH_NAND_CONTROL_EG_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_EG_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_EG_W(y))
#define     MOBI_FLASH_NAND_CONTROL_EG_SHIFT 12
#define     MOBI_FLASH_NAND_CONTROL_EG_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_EC [2] - ECC check enable                 */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_EC_SIZE 2
#define     MOBI_FLASH_NAND_CONTROL_EC_MASK 0x0000c000
#define     MOBI_FLASH_NAND_CONTROL_EC_R(x) (((x) & 0x0000c000) >> 14)
#define     MOBI_FLASH_NAND_CONTROL_EC_W(x) (((x) << 14) & 0x0000c000)
#define     MOBI_FLASH_NAND_CONTROL_EC_SET(x) (((x) |= 0x0000c000))
#define     MOBI_FLASH_NAND_CONTROL_EC_CLR(x) (((x) &= ~(0x0000c000)))
#define     MOBI_FLASH_NAND_CONTROL_EC_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_EC_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_EC_W(y))
#define     MOBI_FLASH_NAND_CONTROL_EC_SHIFT 14
#define     MOBI_FLASH_NAND_CONTROL_EC_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_CE [1] - copy enable                      */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_CE_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_CE_MASK 0x00010000
#define     MOBI_FLASH_NAND_CONTROL_CE_R(x) (((x) & 0x00010000) >> 16)
#define     MOBI_FLASH_NAND_CONTROL_CE_W(x) (((x) << 16) & 0x00010000)
#define     MOBI_FLASH_NAND_CONTROL_CE_SET(x) (((x) |= 0x00010000))
#define     MOBI_FLASH_NAND_CONTROL_CE_CLR(x) (((x) &= ~(0x00010000)))
#define     MOBI_FLASH_NAND_CONTROL_CE_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_CE_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_CE_W(y))
#define     MOBI_FLASH_NAND_CONTROL_CE_SHIFT 16
#define     MOBI_FLASH_NAND_CONTROL_CE_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_CC [1] - copy confirm                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_CC_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_CC_MASK 0x00020000
#define     MOBI_FLASH_NAND_CONTROL_CC_R(x) (((x) & 0x00020000) >> 17)
#define     MOBI_FLASH_NAND_CONTROL_CC_W(x) (((x) << 17) & 0x00020000)
#define     MOBI_FLASH_NAND_CONTROL_CC_SET(x) (((x) |= 0x00020000))
#define     MOBI_FLASH_NAND_CONTROL_CC_CLR(x) (((x) &= ~(0x00020000)))
#define     MOBI_FLASH_NAND_CONTROL_CC_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_CC_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_CC_W(y))
#define     MOBI_FLASH_NAND_CONTROL_CC_SHIFT 17
#define     MOBI_FLASH_NAND_CONTROL_CC_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_RC [1] - read confirm                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_RC_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_RC_MASK 0x00040000
#define     MOBI_FLASH_NAND_CONTROL_RC_R(x) (((x) & 0x00040000) >> 18)
#define     MOBI_FLASH_NAND_CONTROL_RC_W(x) (((x) << 18) & 0x00040000)
#define     MOBI_FLASH_NAND_CONTROL_RC_SET(x) (((x) |= 0x00040000))
#define     MOBI_FLASH_NAND_CONTROL_RC_CLR(x) (((x) &= ~(0x00040000)))
#define     MOBI_FLASH_NAND_CONTROL_RC_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_RC_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_RC_W(y))
#define     MOBI_FLASH_NAND_CONTROL_RC_SHIFT 18
#define     MOBI_FLASH_NAND_CONTROL_RC_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_I4 [1] - ID register read in 4 cycles     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_I4_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_I4_MASK 0x00080000
#define     MOBI_FLASH_NAND_CONTROL_I4_R(x) (((x) & 0x00080000) >> 19)
#define     MOBI_FLASH_NAND_CONTROL_I4_W(x) (((x) << 19) & 0x00080000)
#define     MOBI_FLASH_NAND_CONTROL_I4_SET(x) (((x) |= 0x00080000))
#define     MOBI_FLASH_NAND_CONTROL_I4_CLR(x) (((x) &= ~(0x00080000)))
#define     MOBI_FLASH_NAND_CONTROL_I4_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_I4_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_I4_W(y))
#define     MOBI_FLASH_NAND_CONTROL_I4_SHIFT 19
#define     MOBI_FLASH_NAND_CONTROL_I4_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_P3 [1] - page address in 3 cycles         */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_P3_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_P3_MASK 0x00100000
#define     MOBI_FLASH_NAND_CONTROL_P3_R(x) (((x) & 0x00100000) >> 20)
#define     MOBI_FLASH_NAND_CONTROL_P3_W(x) (((x) << 20) & 0x00100000)
#define     MOBI_FLASH_NAND_CONTROL_P3_SET(x) (((x) |= 0x00100000))
#define     MOBI_FLASH_NAND_CONTROL_P3_CLR(x) (((x) &= ~(0x00100000)))
#define     MOBI_FLASH_NAND_CONTROL_P3_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_P3_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_P3_W(y))
#define     MOBI_FLASH_NAND_CONTROL_P3_SHIFT 20
#define     MOBI_FLASH_NAND_CONTROL_P3_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_C2 [1] - column address in 2 cycles       */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_C2_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_C2_MASK 0x00200000
#define     MOBI_FLASH_NAND_CONTROL_C2_R(x) (((x) & 0x00200000) >> 21)
#define     MOBI_FLASH_NAND_CONTROL_C2_W(x) (((x) << 21) & 0x00200000)
#define     MOBI_FLASH_NAND_CONTROL_C2_SET(x) (((x) |= 0x00200000))
#define     MOBI_FLASH_NAND_CONTROL_C2_CLR(x) (((x) &= ~(0x00200000)))
#define     MOBI_FLASH_NAND_CONTROL_C2_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_C2_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_C2_W(y))
#define     MOBI_FLASH_NAND_CONTROL_C2_SHIFT 21
#define     MOBI_FLASH_NAND_CONTROL_C2_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_SE [1] - spare area enable                */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_SE_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_SE_MASK 0x00400000
#define     MOBI_FLASH_NAND_CONTROL_SE_R(x) (((x) & 0x00400000) >> 22)
#define     MOBI_FLASH_NAND_CONTROL_SE_W(x) (((x) << 22) & 0x00400000)
#define     MOBI_FLASH_NAND_CONTROL_SE_SET(x) (((x) |= 0x00400000))
#define     MOBI_FLASH_NAND_CONTROL_SE_CLR(x) (((x) &= ~(0x00400000)))
#define     MOBI_FLASH_NAND_CONTROL_SE_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_SE_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_SE_W(y))
#define     MOBI_FLASH_NAND_CONTROL_SE_SHIFT 22
#define     MOBI_FLASH_NAND_CONTROL_SE_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_SA [1] - spare area address               */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_SA_SIZE 1
#define     MOBI_FLASH_NAND_CONTROL_SA_MASK 0x00800000
#define     MOBI_FLASH_NAND_CONTROL_SA_R(x) (((x) & 0x00800000) >> 23)
#define     MOBI_FLASH_NAND_CONTROL_SA_W(x) (((x) << 23) & 0x00800000)
#define     MOBI_FLASH_NAND_CONTROL_SA_SET(x) (((x) |= 0x00800000))
#define     MOBI_FLASH_NAND_CONTROL_SA_CLR(x) (((x) &= ~(0x00800000)))
#define     MOBI_FLASH_NAND_CONTROL_SA_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_SA_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_SA_W(y))
#define     MOBI_FLASH_NAND_CONTROL_SA_SHIFT 23
#define     MOBI_FLASH_NAND_CONTROL_SA_REG MOBI_FLASH_NAND_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_CONTROL_ADDR [8] - address                        */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_CONTROL_ADDR_SIZE 8
#define     MOBI_FLASH_NAND_CONTROL_ADDR_MASK 0xff000000
#define     MOBI_FLASH_NAND_CONTROL_ADDR_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NAND_CONTROL_ADDR_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NAND_CONTROL_ADDR_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NAND_CONTROL_ADDR_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NAND_CONTROL_ADDR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_CONTROL_ADDR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_CONTROL_ADDR_W(y))
#define     MOBI_FLASH_NAND_CONTROL_ADDR_SHIFT 24
#define     MOBI_FLASH_NAND_CONTROL_ADDR_REG MOBI_FLASH_NAND_CONTROL

#define MOBI_FLASH_NAND_CONTROL_SEL   (MOBI_FLASH_BASE + 0x120)
#define MOBI_FLASH_NAND_CONTROL_OFFSET 0x120
#define MOBI_FLASH_NAND_CONTROL_SIZE  32
#define MOBI_FLASH_NAND_CONTROL_MASK  0xffffffff
#define MOBI_FLASH_NAND_CONTROL_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t wd	:  2 ;
		uint32_t eb	:  2 ;
		uint32_t sz	:  3 ;
		uint32_t xs	:  1 ;
		uint32_t ie	:  1 ;
		uint32_t wp	:  1 ;
		uint32_t au	:  1 ;
		uint32_t fd	:  1 ;
		uint32_t eg	:  2 ;
		uint32_t ec	:  2 ;
		uint32_t ce	:  1 ;
		uint32_t cc	:  1 ;
		uint32_t rc	:  1 ;
		uint32_t i4	:  1 ;
		uint32_t p3	:  1 ;
		uint32_t c2	:  1 ;
		uint32_t se	:  1 ;
		uint32_t sa	:  1 ;
		uint32_t addr	:  8 ;
	} b;
} mobi_flash_nand_control_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_COMMAND - NAND command register                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_COMMAND_CMD [4] - command                         */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_COMMAND_CMD_SIZE 4
#define     MOBI_FLASH_NAND_COMMAND_CMD_MASK 0x0000000f
#define     MOBI_FLASH_NAND_COMMAND_CMD_R(x) (((x) & 0x0000000f) >> 0)
#define     MOBI_FLASH_NAND_COMMAND_CMD_W(x) (((x) << 0) & 0x0000000f)
#define     MOBI_FLASH_NAND_COMMAND_CMD_SET(x) (((x) |= 0x0000000f))
#define     MOBI_FLASH_NAND_COMMAND_CMD_CLR(x) (((x) &= ~(0x0000000f)))
#define     MOBI_FLASH_NAND_COMMAND_CMD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_COMMAND_CMD_CLR(x);\
				((x) |= MOBI_FLASH_NAND_COMMAND_CMD_W(y))
#define     MOBI_FLASH_NAND_COMMAND_CMD_SHIFT 0
#define     MOBI_FLASH_NAND_COMMAND_CMD_REG MOBI_FLASH_NAND_COMMAND

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_COMMAND_ADDR [28] - address                       */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_COMMAND_ADDR_SIZE 28
#define     MOBI_FLASH_NAND_COMMAND_ADDR_MASK 0xfffffff0
#define     MOBI_FLASH_NAND_COMMAND_ADDR_R(x) (((x) & 0xfffffff0) >> 4)
#define     MOBI_FLASH_NAND_COMMAND_ADDR_W(x) (((x) << 4) & 0xfffffff0)
#define     MOBI_FLASH_NAND_COMMAND_ADDR_SET(x) (((x) |= 0xfffffff0))
#define     MOBI_FLASH_NAND_COMMAND_ADDR_CLR(x) (((x) &= ~(0xfffffff0)))
#define     MOBI_FLASH_NAND_COMMAND_ADDR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_COMMAND_ADDR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_COMMAND_ADDR_W(y))
#define     MOBI_FLASH_NAND_COMMAND_ADDR_SHIFT 4
#define     MOBI_FLASH_NAND_COMMAND_ADDR_REG MOBI_FLASH_NAND_COMMAND

#define MOBI_FLASH_NAND_COMMAND_SEL   (MOBI_FLASH_BASE + 0x124)
#define MOBI_FLASH_NAND_COMMAND_OFFSET 0x124
#define MOBI_FLASH_NAND_COMMAND_SIZE  32
#define MOBI_FLASH_NAND_COMMAND_MASK  0xffffffff
#define MOBI_FLASH_NAND_COMMAND_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t cmd	:  4 ;
		uint32_t addr	: 28 ;
	} b;
} mobi_flash_nand_command_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_TIMERINTVAL0 - Timing interval 0                  */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL0_TDS [8] - data setup to write pulse rising edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_MASK 0x000000ff
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL0_TDS_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL0_TDS_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_SHIFT 0
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TDS_REG MOBI_FLASH_NAND_TIMERINTVAL0

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL0_TCS [8] - chip enable setup to write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_MASK 0x0000ff00
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL0_TCS_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL0_TCS_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_SHIFT 8
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCS_REG MOBI_FLASH_NAND_TIMERINTVAL0

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL0_TALS [8] - address setup to write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_MASK 0x00ff0000
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL0_TALS_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL0_TALS_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_SHIFT 16
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TALS_REG MOBI_FLASH_NAND_TIMERINTVAL0

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL0_TCLS [8] - command setup to write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_MASK 0xff000000
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_SHIFT 24
#define     MOBI_FLASH_NAND_TIMERINTVAL0_TCLS_REG MOBI_FLASH_NAND_TIMERINTVAL0

#define MOBI_FLASH_NAND_TIMERINTVAL0_SEL (MOBI_FLASH_BASE + 0x128)
#define MOBI_FLASH_NAND_TIMERINTVAL0_OFFSET 0x128
#define MOBI_FLASH_NAND_TIMERINTVAL0_SIZE 32
#define MOBI_FLASH_NAND_TIMERINTVAL0_MASK 0xffffffff
#define MOBI_FLASH_NAND_TIMERINTVAL0_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tds	:  8 ;
		uint32_t tcs	:  8 ;
		uint32_t tals	:  8 ;
		uint32_t tcls	:  8 ;
	} b;
} mobi_flash_nand_timerintval0_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_TIMERINTVAL1 - Timing interval 1                  */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL1_TDH [8] - command hold from write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_MASK 0x000000ff
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL1_TDH_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL1_TDH_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_SHIFT 0
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TDH_REG MOBI_FLASH_NAND_TIMERINTVAL1

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL1_TCH [8] - address hold from write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_MASK 0x0000ff00
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL1_TCH_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL1_TCH_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_SHIFT 8
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCH_REG MOBI_FLASH_NAND_TIMERINTVAL1

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL1_TALH [8] - chip enable hold from write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_MASK 0x00ff0000
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL1_TALH_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL1_TALH_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_SHIFT 16
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TALH_REG MOBI_FLASH_NAND_TIMERINTVAL1

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL1_TCLH [8] - data hold from write pulse rising edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_MASK 0xff000000
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_SHIFT 24
#define     MOBI_FLASH_NAND_TIMERINTVAL1_TCLH_REG MOBI_FLASH_NAND_TIMERINTVAL1

#define MOBI_FLASH_NAND_TIMERINTVAL1_SEL (MOBI_FLASH_BASE + 0x12c)
#define MOBI_FLASH_NAND_TIMERINTVAL1_OFFSET 0x12c
#define MOBI_FLASH_NAND_TIMERINTVAL1_SIZE 32
#define MOBI_FLASH_NAND_TIMERINTVAL1_MASK 0xffffffff
#define MOBI_FLASH_NAND_TIMERINTVAL1_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tdh	:  8 ;
		uint32_t tch	:  8 ;
		uint32_t talh	:  8 ;
		uint32_t tclh	:  8 ;
	} b;
} mobi_flash_nand_timerintval1_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_TIMERINTVAL2 - Timing interval 2                  */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL2_TRR [8] - read setup to falling edge time */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_MASK 0x000000ff
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL2_TRR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL2_TRR_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_SHIFT 0
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TRR_REG MOBI_FLASH_NAND_TIMERINTVAL2

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL2_TWB [8] - write pulse rising edge to busy */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_MASK 0x0000ff00
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL2_TWB_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL2_TWB_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_SHIFT 8
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWB_REG MOBI_FLASH_NAND_TIMERINTVAL2

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL2_TWH [8] - write hold high time       */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_MASK 0x00ff0000
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL2_TWH_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL2_TWH_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_SHIFT 16
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWH_REG MOBI_FLASH_NAND_TIMERINTVAL2

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL2_TWP [8] - write pulse width          */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_MASK 0xff000000
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL2_TWP_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL2_TWP_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_SHIFT 24
#define     MOBI_FLASH_NAND_TIMERINTVAL2_TWP_REG MOBI_FLASH_NAND_TIMERINTVAL2

#define MOBI_FLASH_NAND_TIMERINTVAL2_SEL (MOBI_FLASH_BASE + 0x130)
#define MOBI_FLASH_NAND_TIMERINTVAL2_OFFSET 0x130
#define MOBI_FLASH_NAND_TIMERINTVAL2_SIZE 32
#define MOBI_FLASH_NAND_TIMERINTVAL2_MASK 0xffffffff
#define MOBI_FLASH_NAND_TIMERINTVAL2_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t trr	:  8 ;
		uint32_t twb	:  8 ;
		uint32_t twh	:  8 ;
		uint32_t twp	:  8 ;
	} b;
} mobi_flash_nand_timerintval2_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_TIMERINTVAL3 - Timing interval 3                  */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL3_TCEH [8] - chip enable from read pulse rising edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_MASK 0x000000ff
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_SHIFT 0
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TCEH_REG MOBI_FLASH_NAND_TIMERINTVAL3

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL3_TRB [8] - read pulse rising edge to busy */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_MASK 0x0000ff00
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL3_TRB_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL3_TRB_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_SHIFT 8
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRB_REG MOBI_FLASH_NAND_TIMERINTVAL3

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL3_TREH [8] - read high hold time       */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_MASK 0x00ff0000
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL3_TREH_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL3_TREH_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_SHIFT 16
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TREH_REG MOBI_FLASH_NAND_TIMERINTVAL3

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL3_TRP [8] - read pulse width           */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_MASK 0xff000000
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL3_TRP_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL3_TRP_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_SHIFT 24
#define     MOBI_FLASH_NAND_TIMERINTVAL3_TRP_REG MOBI_FLASH_NAND_TIMERINTVAL3

#define MOBI_FLASH_NAND_TIMERINTVAL3_SEL (MOBI_FLASH_BASE + 0x134)
#define MOBI_FLASH_NAND_TIMERINTVAL3_OFFSET 0x134
#define MOBI_FLASH_NAND_TIMERINTVAL3_SIZE 32
#define MOBI_FLASH_NAND_TIMERINTVAL3_MASK 0xffffffff
#define MOBI_FLASH_NAND_TIMERINTVAL3_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tceh	:  8 ;
		uint32_t trb	:  8 ;
		uint32_t treh	:  8 ;
		uint32_t trp	:  8 ;
	} b;
} mobi_flash_nand_timerintval3_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_TIMERINTVAL4 - Timing interval 4                  */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL4_TIR [8] - output high Z to read pulse falling edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_MASK 0x000000ff
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL4_TIR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL4_TIR_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_SHIFT 0
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TIR_REG MOBI_FLASH_NAND_TIMERINTVAL4

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL4_TWHR [8] - write pulse rising to read pulse falling  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_MASK 0x0000ff00
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_SHIFT 8
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TWHR_REG MOBI_FLASH_NAND_TIMERINTVAL4

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL4_TCLR [8] - cmd setup to read pulse falling edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_MASK 0x00ff0000
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_SHIFT 16
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TCLR_REG MOBI_FLASH_NAND_TIMERINTVAL4

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY [8] - read pulse falling to data valid time */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_MASK 0xff000000
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_SHIFT 24
#define     MOBI_FLASH_NAND_TIMERINTVAL4_TRDELAY_REG MOBI_FLASH_NAND_TIMERINTVAL4

#define MOBI_FLASH_NAND_TIMERINTVAL4_SEL (MOBI_FLASH_BASE + 0x138)
#define MOBI_FLASH_NAND_TIMERINTVAL4_OFFSET 0x138
#define MOBI_FLASH_NAND_TIMERINTVAL4_SIZE 32
#define MOBI_FLASH_NAND_TIMERINTVAL4_MASK 0xffffffff
#define MOBI_FLASH_NAND_TIMERINTVAL4_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tir	:  8 ;
		uint32_t twhr	:  8 ;
		uint32_t tclr	:  8 ;
		uint32_t trdelay	:  8 ;
	} b;
} mobi_flash_nand_timerintval4_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_TIMERINTVAL5 - Timing interval 5                  */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL5_TAR [8] - addressetup to read pulse falling edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_MASK 0x000000ff
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL5_TAR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL5_TAR_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_SHIFT 0
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TAR_REG MOBI_FLASH_NAND_TIMERINTVAL5

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ [8] - read pulse rising edge to output high Z */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_MASK 0x0000ff00
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_SHIFT 8
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TRHZ_REG MOBI_FLASH_NAND_TIMERINTVAL5

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_TIMERINTVAL5_TWW [8] - ready to write pulse falling edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_SIZE 8
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_MASK 0x00ff0000
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_TIMERINTVAL5_TWW_CLR(x);\
				((x) |= MOBI_FLASH_NAND_TIMERINTVAL5_TWW_W(y))
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_SHIFT 16
#define     MOBI_FLASH_NAND_TIMERINTVAL5_TWW_REG MOBI_FLASH_NAND_TIMERINTVAL5

#define MOBI_FLASH_NAND_TIMERINTVAL5_SEL (MOBI_FLASH_BASE + 0x13c)
#define MOBI_FLASH_NAND_TIMERINTVAL5_OFFSET 0x13c
#define MOBI_FLASH_NAND_TIMERINTVAL5_SIZE 32
#define MOBI_FLASH_NAND_TIMERINTVAL5_MASK 0x00ffffff
#define MOBI_FLASH_NAND_TIMERINTVAL5_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tar	:  8 ;
		uint32_t trhz	:  8 ;
		uint32_t tww	:  8 ;
	} b;
} mobi_flash_nand_timerintval5_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_STATUS - Flash status register                    */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_STATUS_STAT0 [8] - status from chip 0             */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_STATUS_STAT0_SIZE 8
#define     MOBI_FLASH_NAND_STATUS_STAT0_MASK 0x000000ff
#define     MOBI_FLASH_NAND_STATUS_STAT0_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NAND_STATUS_STAT0_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NAND_STATUS_STAT0_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NAND_STATUS_STAT0_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NAND_STATUS_STAT0_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_STATUS_STAT0_CLR(x);\
				((x) |= MOBI_FLASH_NAND_STATUS_STAT0_W(y))
#define     MOBI_FLASH_NAND_STATUS_STAT0_SHIFT 0
#define     MOBI_FLASH_NAND_STATUS_STAT0_REG MOBI_FLASH_NAND_STATUS

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_STATUS_STAT1 [8] - status from chip 1             */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_STATUS_STAT1_SIZE 8
#define     MOBI_FLASH_NAND_STATUS_STAT1_MASK 0x0000ff00
#define     MOBI_FLASH_NAND_STATUS_STAT1_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NAND_STATUS_STAT1_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NAND_STATUS_STAT1_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NAND_STATUS_STAT1_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NAND_STATUS_STAT1_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_STATUS_STAT1_CLR(x);\
				((x) |= MOBI_FLASH_NAND_STATUS_STAT1_W(y))
#define     MOBI_FLASH_NAND_STATUS_STAT1_SHIFT 8
#define     MOBI_FLASH_NAND_STATUS_STAT1_REG MOBI_FLASH_NAND_STATUS

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_STATUS_STAT2 [8] - status from chip 2             */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_STATUS_STAT2_SIZE 8
#define     MOBI_FLASH_NAND_STATUS_STAT2_MASK 0x00ff0000
#define     MOBI_FLASH_NAND_STATUS_STAT2_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NAND_STATUS_STAT2_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NAND_STATUS_STAT2_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NAND_STATUS_STAT2_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NAND_STATUS_STAT2_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_STATUS_STAT2_CLR(x);\
				((x) |= MOBI_FLASH_NAND_STATUS_STAT2_W(y))
#define     MOBI_FLASH_NAND_STATUS_STAT2_SHIFT 16
#define     MOBI_FLASH_NAND_STATUS_STAT2_REG MOBI_FLASH_NAND_STATUS

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_STATUS_STAT3 [8] - status from chip 3             */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_STATUS_STAT3_SIZE 8
#define     MOBI_FLASH_NAND_STATUS_STAT3_MASK 0xff000000
#define     MOBI_FLASH_NAND_STATUS_STAT3_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NAND_STATUS_STAT3_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NAND_STATUS_STAT3_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NAND_STATUS_STAT3_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NAND_STATUS_STAT3_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_STATUS_STAT3_CLR(x);\
				((x) |= MOBI_FLASH_NAND_STATUS_STAT3_W(y))
#define     MOBI_FLASH_NAND_STATUS_STAT3_SHIFT 24
#define     MOBI_FLASH_NAND_STATUS_STAT3_REG MOBI_FLASH_NAND_STATUS

#define MOBI_FLASH_NAND_STATUS_SEL    (MOBI_FLASH_BASE + 0x140)
#define MOBI_FLASH_NAND_STATUS_OFFSET 0x140
#define MOBI_FLASH_NAND_STATUS_SIZE   32
#define MOBI_FLASH_NAND_STATUS_MASK   0xffffffff
#define MOBI_FLASH_NAND_STATUS_RINIT  0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t stat0	:  8 ;
		uint32_t stat1	:  8 ;
		uint32_t stat2	:  8 ;
		uint32_t stat3	:  8 ;
	} b;
} mobi_flash_nand_status_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_ID - ID register                                  */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_ID_ID4 [8] - info from 4th ID read cycle          */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_ID_ID4_SIZE 8
#define     MOBI_FLASH_NAND_ID_ID4_MASK 0x000000ff
#define     MOBI_FLASH_NAND_ID_ID4_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NAND_ID_ID4_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NAND_ID_ID4_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NAND_ID_ID4_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NAND_ID_ID4_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_ID_ID4_CLR(x);\
				((x) |= MOBI_FLASH_NAND_ID_ID4_W(y))
#define     MOBI_FLASH_NAND_ID_ID4_SHIFT 0
#define     MOBI_FLASH_NAND_ID_ID4_REG MOBI_FLASH_NAND_ID

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_ID_ID3 [8] - info from 3rd ID read cycle          */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_ID_ID3_SIZE 8
#define     MOBI_FLASH_NAND_ID_ID3_MASK 0x0000ff00
#define     MOBI_FLASH_NAND_ID_ID3_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NAND_ID_ID3_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NAND_ID_ID3_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NAND_ID_ID3_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NAND_ID_ID3_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_ID_ID3_CLR(x);\
				((x) |= MOBI_FLASH_NAND_ID_ID3_W(y))
#define     MOBI_FLASH_NAND_ID_ID3_SHIFT 8
#define     MOBI_FLASH_NAND_ID_ID3_REG MOBI_FLASH_NAND_ID

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_ID_DEV [8] - chip device code                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_ID_DEV_SIZE 8
#define     MOBI_FLASH_NAND_ID_DEV_MASK 0x00ff0000
#define     MOBI_FLASH_NAND_ID_DEV_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NAND_ID_DEV_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NAND_ID_DEV_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NAND_ID_DEV_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NAND_ID_DEV_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_ID_DEV_CLR(x);\
				((x) |= MOBI_FLASH_NAND_ID_DEV_W(y))
#define     MOBI_FLASH_NAND_ID_DEV_SHIFT 16
#define     MOBI_FLASH_NAND_ID_DEV_REG MOBI_FLASH_NAND_ID

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_ID_MKR [8] - chip manufacturer code               */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_ID_MKR_SIZE 8
#define     MOBI_FLASH_NAND_ID_MKR_MASK 0xff000000
#define     MOBI_FLASH_NAND_ID_MKR_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NAND_ID_MKR_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NAND_ID_MKR_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NAND_ID_MKR_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NAND_ID_MKR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_ID_MKR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_ID_MKR_W(y))
#define     MOBI_FLASH_NAND_ID_MKR_SHIFT 24
#define     MOBI_FLASH_NAND_ID_MKR_REG MOBI_FLASH_NAND_ID

#define MOBI_FLASH_NAND_ID_SEL        (MOBI_FLASH_BASE + 0x144)
#define MOBI_FLASH_NAND_ID_OFFSET     0x144
#define MOBI_FLASH_NAND_ID_SIZE       32
#define MOBI_FLASH_NAND_ID_MASK       0xffffffff
#define MOBI_FLASH_NAND_ID_RINIT      0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t id4	:  8 ;
		uint32_t id3	:  8 ;
		uint32_t dev	:  8 ;
		uint32_t mkr	:  8 ;
	} b;
} mobi_flash_nand_id_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_COPY - Copy Address register                      */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_COPY_ADDR [32] - dest addr for copy back command  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_COPY_ADDR_SIZE 32
#define     MOBI_FLASH_NAND_COPY_ADDR_MASK 0xffffffff
#define     MOBI_FLASH_NAND_COPY_ADDR_R(x) (((x) & 0xffffffff) >> 0)
#define     MOBI_FLASH_NAND_COPY_ADDR_W(x) (((x) << 0) & 0xffffffff)
#define     MOBI_FLASH_NAND_COPY_ADDR_SET(x) (((x) |= 0xffffffff))
#define     MOBI_FLASH_NAND_COPY_ADDR_CLR(x) (((x) &= ~(0xffffffff)))
#define     MOBI_FLASH_NAND_COPY_ADDR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_COPY_ADDR_CLR(x);\
				((x) |= MOBI_FLASH_NAND_COPY_ADDR_W(y))
#define     MOBI_FLASH_NAND_COPY_ADDR_SHIFT 0
#define     MOBI_FLASH_NAND_COPY_ADDR_REG MOBI_FLASH_NAND_COPY

#define MOBI_FLASH_NAND_COPY_SEL      (MOBI_FLASH_BASE + 0x148)
#define MOBI_FLASH_NAND_COPY_OFFSET   0x148
#define MOBI_FLASH_NAND_COPY_SIZE     32
#define MOBI_FLASH_NAND_COPY_MASK     0xffffffff
#define MOBI_FLASH_NAND_COPY_RINIT    0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t addr	: 32 ;
	} b;
} mobi_flash_nand_copy_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_LENGTH - Flash length register                    */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_LENGTH_CMD [4] - flash chip operation in progress */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_LENGTH_CMD_SIZE 4
#define     MOBI_FLASH_NAND_LENGTH_CMD_MASK 0x0000000f
#define     MOBI_FLASH_NAND_LENGTH_CMD_R(x) (((x) & 0x0000000f) >> 0)
#define     MOBI_FLASH_NAND_LENGTH_CMD_W(x) (((x) << 0) & 0x0000000f)
#define     MOBI_FLASH_NAND_LENGTH_CMD_SET(x) (((x) |= 0x0000000f))
#define     MOBI_FLASH_NAND_LENGTH_CMD_CLR(x) (((x) &= ~(0x0000000f)))
#define     MOBI_FLASH_NAND_LENGTH_CMD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_LENGTH_CMD_CLR(x);\
				((x) |= MOBI_FLASH_NAND_LENGTH_CMD_W(y))
#define     MOBI_FLASH_NAND_LENGTH_CMD_SHIFT 0
#define     MOBI_FLASH_NAND_LENGTH_CMD_REG MOBI_FLASH_NAND_LENGTH

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_LENGTH_UNUSED [10] - unused                       */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_LENGTH_UNUSED_SIZE 10
#define     MOBI_FLASH_NAND_LENGTH_UNUSED_MASK 0x00003ff0
#define     MOBI_FLASH_NAND_LENGTH_UNUSED_R(x) (((x) & 0x00003ff0) >> 4)
#define     MOBI_FLASH_NAND_LENGTH_UNUSED_W(x) (((x) << 4) & 0x00003ff0)
#define     MOBI_FLASH_NAND_LENGTH_UNUSED_SET(x) (((x) |= 0x00003ff0))
#define     MOBI_FLASH_NAND_LENGTH_UNUSED_CLR(x) (((x) &= ~(0x00003ff0)))
#define     MOBI_FLASH_NAND_LENGTH_UNUSED_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_LENGTH_UNUSED_CLR(x);\
				((x) |= MOBI_FLASH_NAND_LENGTH_UNUSED_W(y))
#define     MOBI_FLASH_NAND_LENGTH_UNUSED_SHIFT 4
#define     MOBI_FLASH_NAND_LENGTH_UNUSED_REG MOBI_FLASH_NAND_LENGTH

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_LENGTH_LENGTH [15] - remaining byte count minus 1 */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_LENGTH_LENGTH_SIZE 15
#define     MOBI_FLASH_NAND_LENGTH_LENGTH_MASK 0x1fffc000
#define     MOBI_FLASH_NAND_LENGTH_LENGTH_R(x) (((x) & 0x1fffc000) >> 14)
#define     MOBI_FLASH_NAND_LENGTH_LENGTH_W(x) (((x) << 14) & 0x1fffc000)
#define     MOBI_FLASH_NAND_LENGTH_LENGTH_SET(x) (((x) |= 0x1fffc000))
#define     MOBI_FLASH_NAND_LENGTH_LENGTH_CLR(x) (((x) &= ~(0x1fffc000)))
#define     MOBI_FLASH_NAND_LENGTH_LENGTH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_LENGTH_LENGTH_CLR(x);\
				((x) |= MOBI_FLASH_NAND_LENGTH_LENGTH_W(y))
#define     MOBI_FLASH_NAND_LENGTH_LENGTH_SHIFT 14
#define     MOBI_FLASH_NAND_LENGTH_LENGTH_REG MOBI_FLASH_NAND_LENGTH

#define MOBI_FLASH_NAND_LENGTH_SEL    (MOBI_FLASH_BASE + 0x14c)
#define MOBI_FLASH_NAND_LENGTH_OFFSET 0x14c
#define MOBI_FLASH_NAND_LENGTH_SIZE   32
#define MOBI_FLASH_NAND_LENGTH_MASK   0x1fffffff
#define MOBI_FLASH_NAND_LENGTH_RINIT  0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t cmd	:  4 ;
		uint32_t unused	: 10 ;
		uint32_t length	: 15 ;
	} b;
} mobi_flash_nand_length_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NAND_INTERRUPT - Interrupt done register               */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NAND_INTERRUPT_DI [1] - interrupt done when equal 1    */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NAND_INTERRUPT_DI_SIZE 1
#define     MOBI_FLASH_NAND_INTERRUPT_DI_MASK 0x00000001
#define     MOBI_FLASH_NAND_INTERRUPT_DI_R(x) (((x) & 0x00000001) >> 0)
#define     MOBI_FLASH_NAND_INTERRUPT_DI_W(x) (((x) << 0) & 0x00000001)
#define     MOBI_FLASH_NAND_INTERRUPT_DI_SET(x) (((x) |= 0x00000001))
#define     MOBI_FLASH_NAND_INTERRUPT_DI_CLR(x) (((x) &= ~(0x00000001)))
#define     MOBI_FLASH_NAND_INTERRUPT_DI_CLR_AND_SET(x, y) \
				MOBI_FLASH_NAND_INTERRUPT_DI_CLR(x);\
				((x) |= MOBI_FLASH_NAND_INTERRUPT_DI_W(y))
#define     MOBI_FLASH_NAND_INTERRUPT_DI_SHIFT 0
#define     MOBI_FLASH_NAND_INTERRUPT_DI_REG MOBI_FLASH_NAND_INTERRUPT

#define MOBI_FLASH_NAND_INTERRUPT_SEL (MOBI_FLASH_BASE + 0x150)
#define MOBI_FLASH_NAND_INTERRUPT_OFFSET 0x150
#define MOBI_FLASH_NAND_INTERRUPT_SIZE 32
#define MOBI_FLASH_NAND_INTERRUPT_MASK 0x00000001
#define MOBI_FLASH_NAND_INTERRUPT_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t di	:  1 ;
	} b;
} mobi_flash_nand_interrupt_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_CONTROL - NOR Control register                     */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_WD [2] - data bus width                    */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_WD_SIZE 2
#define     MOBI_FLASH_NOR_CONTROL_WD_MASK 0x00000003
#define     MOBI_FLASH_NOR_CONTROL_WD_R(x) (((x) & 0x00000003) >> 0)
#define     MOBI_FLASH_NOR_CONTROL_WD_W(x) (((x) << 0) & 0x00000003)
#define     MOBI_FLASH_NOR_CONTROL_WD_SET(x) (((x) |= 0x00000003))
#define     MOBI_FLASH_NOR_CONTROL_WD_CLR(x) (((x) &= ~(0x00000003)))
#define     MOBI_FLASH_NOR_CONTROL_WD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_WD_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_WD_W(y))
#define     MOBI_FLASH_NOR_CONTROL_WD_SHIFT 0
#define     MOBI_FLASH_NOR_CONTROL_WD_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_EB [2] - external banks                    */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_EB_SIZE 2
#define     MOBI_FLASH_NOR_CONTROL_EB_MASK 0x0000000c
#define     MOBI_FLASH_NOR_CONTROL_EB_R(x) (((x) & 0x0000000c) >> 2)
#define     MOBI_FLASH_NOR_CONTROL_EB_W(x) (((x) << 2) & 0x0000000c)
#define     MOBI_FLASH_NOR_CONTROL_EB_SET(x) (((x) |= 0x0000000c))
#define     MOBI_FLASH_NOR_CONTROL_EB_CLR(x) (((x) &= ~(0x0000000c)))
#define     MOBI_FLASH_NOR_CONTROL_EB_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_EB_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_EB_W(y))
#define     MOBI_FLASH_NOR_CONTROL_EB_SHIFT 2
#define     MOBI_FLASH_NOR_CONTROL_EB_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_SZ [2] - flash chip size                   */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_SZ_SIZE 2
#define     MOBI_FLASH_NOR_CONTROL_SZ_MASK 0x00000030
#define     MOBI_FLASH_NOR_CONTROL_SZ_R(x) (((x) & 0x00000030) >> 4)
#define     MOBI_FLASH_NOR_CONTROL_SZ_W(x) (((x) << 4) & 0x00000030)
#define     MOBI_FLASH_NOR_CONTROL_SZ_SET(x) (((x) |= 0x00000030))
#define     MOBI_FLASH_NOR_CONTROL_SZ_CLR(x) (((x) &= ~(0x00000030)))
#define     MOBI_FLASH_NOR_CONTROL_SZ_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_SZ_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_SZ_W(y))
#define     MOBI_FLASH_NOR_CONTROL_SZ_SHIFT 4
#define     MOBI_FLASH_NOR_CONTROL_SZ_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_XS [1] - 16 bit data bus                   */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_XS_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_XS_MASK 0x00000040
#define     MOBI_FLASH_NOR_CONTROL_XS_R(x) (((x) & 0x00000040) >> 6)
#define     MOBI_FLASH_NOR_CONTROL_XS_W(x) (((x) << 6) & 0x00000040)
#define     MOBI_FLASH_NOR_CONTROL_XS_SET(x) (((x) |= 0x00000040))
#define     MOBI_FLASH_NOR_CONTROL_XS_CLR(x) (((x) &= ~(0x00000040)))
#define     MOBI_FLASH_NOR_CONTROL_XS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_XS_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_XS_W(y))
#define     MOBI_FLASH_NOR_CONTROL_XS_SHIFT 6
#define     MOBI_FLASH_NOR_CONTROL_XS_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_IE [1] - interrupt enable                  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_IE_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_IE_MASK 0x00000080
#define     MOBI_FLASH_NOR_CONTROL_IE_R(x) (((x) & 0x00000080) >> 7)
#define     MOBI_FLASH_NOR_CONTROL_IE_W(x) (((x) << 7) & 0x00000080)
#define     MOBI_FLASH_NOR_CONTROL_IE_SET(x) (((x) |= 0x00000080))
#define     MOBI_FLASH_NOR_CONTROL_IE_CLR(x) (((x) &= ~(0x00000080)))
#define     MOBI_FLASH_NOR_CONTROL_IE_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_IE_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_IE_W(y))
#define     MOBI_FLASH_NOR_CONTROL_IE_SHIFT 7
#define     MOBI_FLASH_NOR_CONTROL_IE_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_WP [1] - write protect                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_WP_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_WP_MASK 0x00000100
#define     MOBI_FLASH_NOR_CONTROL_WP_R(x) (((x) & 0x00000100) >> 8)
#define     MOBI_FLASH_NOR_CONTROL_WP_W(x) (((x) << 8) & 0x00000100)
#define     MOBI_FLASH_NOR_CONTROL_WP_SET(x) (((x) |= 0x00000100))
#define     MOBI_FLASH_NOR_CONTROL_WP_CLR(x) (((x) &= ~(0x00000100)))
#define     MOBI_FLASH_NOR_CONTROL_WP_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_WP_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_WP_W(y))
#define     MOBI_FLASH_NOR_CONTROL_WP_SHIFT 8
#define     MOBI_FLASH_NOR_CONTROL_WP_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_AU [1] - automatic writeback               */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_AU_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_AU_MASK 0x00000200
#define     MOBI_FLASH_NOR_CONTROL_AU_R(x) (((x) & 0x00000200) >> 9)
#define     MOBI_FLASH_NOR_CONTROL_AU_W(x) (((x) << 9) & 0x00000200)
#define     MOBI_FLASH_NOR_CONTROL_AU_SET(x) (((x) |= 0x00000200))
#define     MOBI_FLASH_NOR_CONTROL_AU_CLR(x) (((x) &= ~(0x00000200)))
#define     MOBI_FLASH_NOR_CONTROL_AU_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_AU_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_AU_W(y))
#define     MOBI_FLASH_NOR_CONTROL_AU_SHIFT 9
#define     MOBI_FLASH_NOR_CONTROL_AU_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_KZ [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_KZ_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_KZ_MASK 0x00000400
#define     MOBI_FLASH_NOR_CONTROL_KZ_R(x) (((x) & 0x00000400) >> 10)
#define     MOBI_FLASH_NOR_CONTROL_KZ_W(x) (((x) << 10) & 0x00000400)
#define     MOBI_FLASH_NOR_CONTROL_KZ_SET(x) (((x) |= 0x00000400))
#define     MOBI_FLASH_NOR_CONTROL_KZ_CLR(x) (((x) &= ~(0x00000400)))
#define     MOBI_FLASH_NOR_CONTROL_KZ_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_KZ_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_KZ_W(y))
#define     MOBI_FLASH_NOR_CONTROL_KZ_SHIFT 10
#define     MOBI_FLASH_NOR_CONTROL_KZ_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_BB [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_BB_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_BB_MASK 0x00000800
#define     MOBI_FLASH_NOR_CONTROL_BB_R(x) (((x) & 0x00000800) >> 11)
#define     MOBI_FLASH_NOR_CONTROL_BB_W(x) (((x) << 11) & 0x00000800)
#define     MOBI_FLASH_NOR_CONTROL_BB_SET(x) (((x) |= 0x00000800))
#define     MOBI_FLASH_NOR_CONTROL_BB_CLR(x) (((x) &= ~(0x00000800)))
#define     MOBI_FLASH_NOR_CONTROL_BB_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_BB_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_BB_W(y))
#define     MOBI_FLASH_NOR_CONTROL_BB_SHIFT 11
#define     MOBI_FLASH_NOR_CONTROL_BB_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_TB [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_TB_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_TB_MASK 0x00001000
#define     MOBI_FLASH_NOR_CONTROL_TB_R(x) (((x) & 0x00001000) >> 12)
#define     MOBI_FLASH_NOR_CONTROL_TB_W(x) (((x) << 12) & 0x00001000)
#define     MOBI_FLASH_NOR_CONTROL_TB_SET(x) (((x) |= 0x00001000))
#define     MOBI_FLASH_NOR_CONTROL_TB_CLR(x) (((x) &= ~(0x00001000)))
#define     MOBI_FLASH_NOR_CONTROL_TB_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_TB_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_TB_W(y))
#define     MOBI_FLASH_NOR_CONTROL_TB_SHIFT 12
#define     MOBI_FLASH_NOR_CONTROL_TB_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_BZ [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_BZ_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_BZ_MASK 0x00002000
#define     MOBI_FLASH_NOR_CONTROL_BZ_R(x) (((x) & 0x00002000) >> 13)
#define     MOBI_FLASH_NOR_CONTROL_BZ_W(x) (((x) << 13) & 0x00002000)
#define     MOBI_FLASH_NOR_CONTROL_BZ_SET(x) (((x) |= 0x00002000))
#define     MOBI_FLASH_NOR_CONTROL_BZ_CLR(x) (((x) &= ~(0x00002000)))
#define     MOBI_FLASH_NOR_CONTROL_BZ_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_BZ_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_BZ_W(y))
#define     MOBI_FLASH_NOR_CONTROL_BZ_SHIFT 13
#define     MOBI_FLASH_NOR_CONTROL_BZ_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_LD [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_LD_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_LD_MASK 0x00004000
#define     MOBI_FLASH_NOR_CONTROL_LD_R(x) (((x) & 0x00004000) >> 14)
#define     MOBI_FLASH_NOR_CONTROL_LD_W(x) (((x) << 14) & 0x00004000)
#define     MOBI_FLASH_NOR_CONTROL_LD_SET(x) (((x) |= 0x00004000))
#define     MOBI_FLASH_NOR_CONTROL_LD_CLR(x) (((x) &= ~(0x00004000)))
#define     MOBI_FLASH_NOR_CONTROL_LD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_LD_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_LD_W(y))
#define     MOBI_FLASH_NOR_CONTROL_LD_SHIFT 14
#define     MOBI_FLASH_NOR_CONTROL_LD_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_LE [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_LE_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_LE_MASK 0x00008000
#define     MOBI_FLASH_NOR_CONTROL_LE_R(x) (((x) & 0x00008000) >> 15)
#define     MOBI_FLASH_NOR_CONTROL_LE_W(x) (((x) << 15) & 0x00008000)
#define     MOBI_FLASH_NOR_CONTROL_LE_SET(x) (((x) |= 0x00008000))
#define     MOBI_FLASH_NOR_CONTROL_LE_CLR(x) (((x) &= ~(0x00008000)))
#define     MOBI_FLASH_NOR_CONTROL_LE_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_LE_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_LE_W(y))
#define     MOBI_FLASH_NOR_CONTROL_LE_SHIFT 15
#define     MOBI_FLASH_NOR_CONTROL_LE_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_FD [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_FD_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_FD_MASK 0x00010000
#define     MOBI_FLASH_NOR_CONTROL_FD_R(x) (((x) & 0x00010000) >> 16)
#define     MOBI_FLASH_NOR_CONTROL_FD_W(x) (((x) << 16) & 0x00010000)
#define     MOBI_FLASH_NOR_CONTROL_FD_SET(x) (((x) |= 0x00010000))
#define     MOBI_FLASH_NOR_CONTROL_FD_CLR(x) (((x) &= ~(0x00010000)))
#define     MOBI_FLASH_NOR_CONTROL_FD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_FD_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_FD_W(y))
#define     MOBI_FLASH_NOR_CONTROL_FD_SHIFT 16
#define     MOBI_FLASH_NOR_CONTROL_FD_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_BR [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_BR_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_BR_MASK 0x00020000
#define     MOBI_FLASH_NOR_CONTROL_BR_R(x) (((x) & 0x00020000) >> 17)
#define     MOBI_FLASH_NOR_CONTROL_BR_W(x) (((x) << 17) & 0x00020000)
#define     MOBI_FLASH_NOR_CONTROL_BR_SET(x) (((x) |= 0x00020000))
#define     MOBI_FLASH_NOR_CONTROL_BR_CLR(x) (((x) &= ~(0x00020000)))
#define     MOBI_FLASH_NOR_CONTROL_BR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_BR_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_BR_W(y))
#define     MOBI_FLASH_NOR_CONTROL_BR_SHIFT 17
#define     MOBI_FLASH_NOR_CONTROL_BR_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_CE [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_CE_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_CE_MASK 0x00040000
#define     MOBI_FLASH_NOR_CONTROL_CE_R(x) (((x) & 0x00040000) >> 18)
#define     MOBI_FLASH_NOR_CONTROL_CE_W(x) (((x) << 18) & 0x00040000)
#define     MOBI_FLASH_NOR_CONTROL_CE_SET(x) (((x) |= 0x00040000))
#define     MOBI_FLASH_NOR_CONTROL_CE_CLR(x) (((x) &= ~(0x00040000)))
#define     MOBI_FLASH_NOR_CONTROL_CE_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_CE_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_CE_W(y))
#define     MOBI_FLASH_NOR_CONTROL_CE_SHIFT 18
#define     MOBI_FLASH_NOR_CONTROL_CE_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_BW [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_BW_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_BW_MASK 0x00080000
#define     MOBI_FLASH_NOR_CONTROL_BW_R(x) (((x) & 0x00080000) >> 19)
#define     MOBI_FLASH_NOR_CONTROL_BW_W(x) (((x) << 19) & 0x00080000)
#define     MOBI_FLASH_NOR_CONTROL_BW_SET(x) (((x) |= 0x00080000))
#define     MOBI_FLASH_NOR_CONTROL_BW_CLR(x) (((x) &= ~(0x00080000)))
#define     MOBI_FLASH_NOR_CONTROL_BW_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_BW_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_BW_W(y))
#define     MOBI_FLASH_NOR_CONTROL_BW_SHIFT 19
#define     MOBI_FLASH_NOR_CONTROL_BW_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_BS [1]                                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_BS_SIZE 1
#define     MOBI_FLASH_NOR_CONTROL_BS_MASK 0x00100000
#define     MOBI_FLASH_NOR_CONTROL_BS_R(x) (((x) & 0x00100000) >> 20)
#define     MOBI_FLASH_NOR_CONTROL_BS_W(x) (((x) << 20) & 0x00100000)
#define     MOBI_FLASH_NOR_CONTROL_BS_SET(x) (((x) |= 0x00100000))
#define     MOBI_FLASH_NOR_CONTROL_BS_CLR(x) (((x) &= ~(0x00100000)))
#define     MOBI_FLASH_NOR_CONTROL_BS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_BS_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_BS_W(y))
#define     MOBI_FLASH_NOR_CONTROL_BS_SHIFT 20
#define     MOBI_FLASH_NOR_CONTROL_BS_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_BRTY [4]                                   */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_BRTY_SIZE 4
#define     MOBI_FLASH_NOR_CONTROL_BRTY_MASK 0x01e00000
#define     MOBI_FLASH_NOR_CONTROL_BRTY_R(x) (((x) & 0x01e00000) >> 21)
#define     MOBI_FLASH_NOR_CONTROL_BRTY_W(x) (((x) << 21) & 0x01e00000)
#define     MOBI_FLASH_NOR_CONTROL_BRTY_SET(x) (((x) |= 0x01e00000))
#define     MOBI_FLASH_NOR_CONTROL_BRTY_CLR(x) (((x) &= ~(0x01e00000)))
#define     MOBI_FLASH_NOR_CONTROL_BRTY_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_BRTY_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_BRTY_W(y))
#define     MOBI_FLASH_NOR_CONTROL_BRTY_SHIFT 21
#define     MOBI_FLASH_NOR_CONTROL_BRTY_REG MOBI_FLASH_NOR_CONTROL

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CONTROL_ADDR [4]                                   */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CONTROL_ADDR_SIZE 4
#define     MOBI_FLASH_NOR_CONTROL_ADDR_MASK 0x1e000000
#define     MOBI_FLASH_NOR_CONTROL_ADDR_R(x) (((x) & 0x1e000000) >> 25)
#define     MOBI_FLASH_NOR_CONTROL_ADDR_W(x) (((x) << 25) & 0x1e000000)
#define     MOBI_FLASH_NOR_CONTROL_ADDR_SET(x) (((x) |= 0x1e000000))
#define     MOBI_FLASH_NOR_CONTROL_ADDR_CLR(x) (((x) &= ~(0x1e000000)))
#define     MOBI_FLASH_NOR_CONTROL_ADDR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CONTROL_ADDR_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CONTROL_ADDR_W(y))
#define     MOBI_FLASH_NOR_CONTROL_ADDR_SHIFT 25
#define     MOBI_FLASH_NOR_CONTROL_ADDR_REG MOBI_FLASH_NOR_CONTROL

#define MOBI_FLASH_NOR_CONTROL_SEL    (MOBI_FLASH_BASE + 0x120)
#define MOBI_FLASH_NOR_CONTROL_OFFSET 0x120
#define MOBI_FLASH_NOR_CONTROL_SIZE   32
#define MOBI_FLASH_NOR_CONTROL_MASK   0x1fffffff
#define MOBI_FLASH_NOR_CONTROL_RINIT  0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t wd	:  2 ;
		uint32_t eb	:  2 ;
		uint32_t sz	:  2 ;
		uint32_t xs	:  1 ;
		uint32_t ie	:  1 ;
		uint32_t wp	:  1 ;
		uint32_t au	:  1 ;
		uint32_t kz	:  1 ;
		uint32_t bb	:  1 ;
		uint32_t tb	:  1 ;
		uint32_t bz	:  1 ;
		uint32_t ld	:  1 ;
		uint32_t le	:  1 ;
		uint32_t fd	:  1 ;
		uint32_t br	:  1 ;
		uint32_t ce	:  1 ;
		uint32_t bw	:  1 ;
		uint32_t bs	:  1 ;
		uint32_t brty	:  4 ;
		uint32_t addr	:  4 ;
	} b;
} mobi_flash_nor_control_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_COMMAND - NOR command register                     */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_COMMAND_CMD [4] - command                          */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_COMMAND_CMD_SIZE 4
#define     MOBI_FLASH_NOR_COMMAND_CMD_MASK 0x0000000f
#define     MOBI_FLASH_NOR_COMMAND_CMD_R(x) (((x) & 0x0000000f) >> 0)
#define     MOBI_FLASH_NOR_COMMAND_CMD_W(x) (((x) << 0) & 0x0000000f)
#define     MOBI_FLASH_NOR_COMMAND_CMD_SET(x) (((x) |= 0x0000000f))
#define     MOBI_FLASH_NOR_COMMAND_CMD_CLR(x) (((x) &= ~(0x0000000f)))
#define     MOBI_FLASH_NOR_COMMAND_CMD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_COMMAND_CMD_CLR(x);\
				((x) |= MOBI_FLASH_NOR_COMMAND_CMD_W(y))
#define     MOBI_FLASH_NOR_COMMAND_CMD_SHIFT 0
#define     MOBI_FLASH_NOR_COMMAND_CMD_REG MOBI_FLASH_NOR_COMMAND

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_COMMAND_ADDR [28] - address                        */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_COMMAND_ADDR_SIZE 28
#define     MOBI_FLASH_NOR_COMMAND_ADDR_MASK 0xfffffff0
#define     MOBI_FLASH_NOR_COMMAND_ADDR_R(x) (((x) & 0xfffffff0) >> 4)
#define     MOBI_FLASH_NOR_COMMAND_ADDR_W(x) (((x) << 4) & 0xfffffff0)
#define     MOBI_FLASH_NOR_COMMAND_ADDR_SET(x) (((x) |= 0xfffffff0))
#define     MOBI_FLASH_NOR_COMMAND_ADDR_CLR(x) (((x) &= ~(0xfffffff0)))
#define     MOBI_FLASH_NOR_COMMAND_ADDR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_COMMAND_ADDR_CLR(x);\
				((x) |= MOBI_FLASH_NOR_COMMAND_ADDR_W(y))
#define     MOBI_FLASH_NOR_COMMAND_ADDR_SHIFT 4
#define     MOBI_FLASH_NOR_COMMAND_ADDR_REG MOBI_FLASH_NOR_COMMAND

#define MOBI_FLASH_NOR_COMMAND_SEL    (MOBI_FLASH_BASE + 0x124)
#define MOBI_FLASH_NOR_COMMAND_OFFSET 0x124
#define MOBI_FLASH_NOR_COMMAND_SIZE   32
#define MOBI_FLASH_NOR_COMMAND_MASK   0xffffffff
#define MOBI_FLASH_NOR_COMMAND_RINIT  0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t cmd	:  4 ;
		uint32_t addr	: 28 ;
	} b;
} mobi_flash_nor_command_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_TIMERINTVAL0 - Timing interval 0                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL0_TDS [8] - data setup to write pulse rising edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_MASK 0x000000ff
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL0_TDS_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL0_TDS_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_SHIFT 0
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TDS_REG MOBI_FLASH_NOR_TIMERINTVAL0

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL0_TCS [8] - chip enable setup to write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL0_TCS_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL0_TCS_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_SHIFT 8
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TCS_REG MOBI_FLASH_NOR_TIMERINTVAL0

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL0_TAS [8] - address setup to write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL0_TAS_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL0_TAS_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_SHIFT 16
#define     MOBI_FLASH_NOR_TIMERINTVAL0_TAS_REG MOBI_FLASH_NOR_TIMERINTVAL0

#define MOBI_FLASH_NOR_TIMERINTVAL0_SEL (MOBI_FLASH_BASE + 0x128)
#define MOBI_FLASH_NOR_TIMERINTVAL0_OFFSET 0x128
#define MOBI_FLASH_NOR_TIMERINTVAL0_SIZE 32
#define MOBI_FLASH_NOR_TIMERINTVAL0_MASK 0x00ffffff
#define MOBI_FLASH_NOR_TIMERINTVAL0_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tds	:  8 ;
		uint32_t tcs	:  8 ;
		uint32_t tas	:  8 ;
	} b;
} mobi_flash_nor_timerintval0_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_TIMERINTVAL1 - Timing interval 1                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL1_TDH [8] - command hold from write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_MASK 0x000000ff
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL1_TDH_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL1_TDH_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_SHIFT 0
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TDH_REG MOBI_FLASH_NOR_TIMERINTVAL1

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL1_TCH [8] - chip enable hold from write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL1_TCH_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL1_TCH_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_SHIFT 8
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TCH_REG MOBI_FLASH_NOR_TIMERINTVAL1

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL1_TAH [8] - address hold from write pulse */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL1_TAH_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL1_TAH_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_SHIFT 16
#define     MOBI_FLASH_NOR_TIMERINTVAL1_TAH_REG MOBI_FLASH_NOR_TIMERINTVAL1

#define MOBI_FLASH_NOR_TIMERINTVAL1_SEL (MOBI_FLASH_BASE + 0x12c)
#define MOBI_FLASH_NOR_TIMERINTVAL1_OFFSET 0x12c
#define MOBI_FLASH_NOR_TIMERINTVAL1_SIZE 32
#define MOBI_FLASH_NOR_TIMERINTVAL1_MASK 0x00ffffff
#define MOBI_FLASH_NOR_TIMERINTVAL1_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tdh	:  8 ;
		uint32_t tch	:  8 ;
		uint32_t tah	:  8 ;
	} b;
} mobi_flash_nor_timerintval1_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_TIMERINTVAL2 - Timing interval 2                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL [8] - first status reg read.... */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_MASK 0x000000ff
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_SHIFT 0
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TPOLL_REG MOBI_FLASH_NOR_TIMERINTVAL2

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL2_TCEH [8] - chip enable hold time      */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_SHIFT 8
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TCEH_REG MOBI_FLASH_NOR_TIMERINTVAL2

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL2_TWH [8] - write hold time             */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL2_TWH_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL2_TWH_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_SHIFT 16
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWH_REG MOBI_FLASH_NOR_TIMERINTVAL2

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL2_TWP [8] - write pulse width           */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_MASK 0xff000000
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL2_TWP_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL2_TWP_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_SHIFT 24
#define     MOBI_FLASH_NOR_TIMERINTVAL2_TWP_REG MOBI_FLASH_NOR_TIMERINTVAL2

#define MOBI_FLASH_NOR_TIMERINTVAL2_SEL (MOBI_FLASH_BASE + 0x130)
#define MOBI_FLASH_NOR_TIMERINTVAL2_OFFSET 0x130
#define MOBI_FLASH_NOR_TIMERINTVAL2_SIZE 32
#define MOBI_FLASH_NOR_TIMERINTVAL2_MASK 0xffffffff
#define MOBI_FLASH_NOR_TIMERINTVAL2_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tpoll	:  8 ;
		uint32_t tceh	:  8 ;
		uint32_t twh	:  8 ;
		uint32_t twp	:  8 ;
	} b;
} mobi_flash_nor_timerintval2_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_TIMERINTVAL3 - Timing interval 3                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY [8] - reset to data valid    */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_MASK 0x000000ff
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_SHIFT 0
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRPDELAY_REG MOBI_FLASH_NOR_TIMERINTVAL3

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY [8] - chip enable to data valid */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_SHIFT 8
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TCDELAY_REG MOBI_FLASH_NOR_TIMERINTVAL3

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY [8] - address to data valid   */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_SHIFT 16
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TADELAY_REG MOBI_FLASH_NOR_TIMERINTVAL3

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL3_TRC [8] - read cycle time             */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_MASK 0xff000000
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL3_TRC_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL3_TRC_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_SHIFT 24
#define     MOBI_FLASH_NOR_TIMERINTVAL3_TRC_REG MOBI_FLASH_NOR_TIMERINTVAL3

#define MOBI_FLASH_NOR_TIMERINTVAL3_SEL (MOBI_FLASH_BASE + 0x134)
#define MOBI_FLASH_NOR_TIMERINTVAL3_OFFSET 0x134
#define MOBI_FLASH_NOR_TIMERINTVAL3_SIZE 32
#define MOBI_FLASH_NOR_TIMERINTVAL3_MASK 0xffffffff
#define MOBI_FLASH_NOR_TIMERINTVAL3_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t trpdelay	:  8 ;
		uint32_t tcdelay	:  8 ;
		uint32_t tadelay	:  8 ;
		uint32_t trc	:  8 ;
	} b;
} mobi_flash_nor_timerintval3_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_TIMERINTVAL4 - Timing interval 4                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL4_TIR [8] - output high Z to read pulse falling edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_MASK 0x000000ff
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL4_TIR_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL4_TIR_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_SHIFT 0
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TIR_REG MOBI_FLASH_NOR_TIMERINTVAL4

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL4_TWHR [8] - write pulse rising to read pulse falling  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_SHIFT 8
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TWHR_REG MOBI_FLASH_NOR_TIMERINTVAL4

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY [8] - burst read addr to valid time */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_SHIFT 16
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TABDELAY_REG MOBI_FLASH_NOR_TIMERINTVAL4

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY [8] - output enable falling to data valid  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_MASK 0xff000000
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_SHIFT 24
#define     MOBI_FLASH_NOR_TIMERINTVAL4_TRDELAY_REG MOBI_FLASH_NOR_TIMERINTVAL4

#define MOBI_FLASH_NOR_TIMERINTVAL4_SEL (MOBI_FLASH_BASE + 0x138)
#define MOBI_FLASH_NOR_TIMERINTVAL4_OFFSET 0x138
#define MOBI_FLASH_NOR_TIMERINTVAL4_SIZE 32
#define MOBI_FLASH_NOR_TIMERINTVAL4_MASK 0xffffffff
#define MOBI_FLASH_NOR_TIMERINTVAL4_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t tir	:  8 ;
		uint32_t twhr	:  8 ;
		uint32_t tabdelay	:  8 ;
		uint32_t trdelay	:  8 ;
	} b;
} mobi_flash_nor_timerintval4_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_TIMERINTVAL5 - Timing interval 5                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL5_TRPH [8] - reset to write pulse falling edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_MASK 0x000000ff
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_SHIFT 0
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRPH_REG MOBI_FLASH_NOR_TIMERINTVAL5

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ [8] - output enable rising to output high Z */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_SHIFT 8
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TRHZ_REG MOBI_FLASH_NOR_TIMERINTVAL5

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_TIMERINTVAL5_TACS [8] - enable setup to read falling edge */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_SIZE 8
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_TIMERINTVAL5_TACS_CLR(x);\
				((x) |= MOBI_FLASH_NOR_TIMERINTVAL5_TACS_W(y))
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_SHIFT 16
#define     MOBI_FLASH_NOR_TIMERINTVAL5_TACS_REG MOBI_FLASH_NOR_TIMERINTVAL5

#define MOBI_FLASH_NOR_TIMERINTVAL5_SEL (MOBI_FLASH_BASE + 0x13c)
#define MOBI_FLASH_NOR_TIMERINTVAL5_OFFSET 0x13c
#define MOBI_FLASH_NOR_TIMERINTVAL5_SIZE 32
#define MOBI_FLASH_NOR_TIMERINTVAL5_MASK 0x00ffffff
#define MOBI_FLASH_NOR_TIMERINTVAL5_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t trph	:  8 ;
		uint32_t trhz	:  8 ;
		uint32_t tacs	:  8 ;
	} b;
} mobi_flash_nor_timerintval5_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_STATUS - Flash status register                     */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_STATUS_STAT0 [8] - status from chip 0              */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_STATUS_STAT0_SIZE 8
#define     MOBI_FLASH_NOR_STATUS_STAT0_MASK 0x000000ff
#define     MOBI_FLASH_NOR_STATUS_STAT0_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_STATUS_STAT0_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_STATUS_STAT0_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_STATUS_STAT0_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_STATUS_STAT0_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_STATUS_STAT0_CLR(x);\
				((x) |= MOBI_FLASH_NOR_STATUS_STAT0_W(y))
#define     MOBI_FLASH_NOR_STATUS_STAT0_SHIFT 0
#define     MOBI_FLASH_NOR_STATUS_STAT0_REG MOBI_FLASH_NOR_STATUS

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_STATUS_STAT1 [8] - status from chip 1              */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_STATUS_STAT1_SIZE 8
#define     MOBI_FLASH_NOR_STATUS_STAT1_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_STATUS_STAT1_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_STATUS_STAT1_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_STATUS_STAT1_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_STATUS_STAT1_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_STATUS_STAT1_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_STATUS_STAT1_CLR(x);\
				((x) |= MOBI_FLASH_NOR_STATUS_STAT1_W(y))
#define     MOBI_FLASH_NOR_STATUS_STAT1_SHIFT 8
#define     MOBI_FLASH_NOR_STATUS_STAT1_REG MOBI_FLASH_NOR_STATUS

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_STATUS_STAT2 [8] - status from chip 2              */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_STATUS_STAT2_SIZE 8
#define     MOBI_FLASH_NOR_STATUS_STAT2_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_STATUS_STAT2_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_STATUS_STAT2_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_STATUS_STAT2_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_STATUS_STAT2_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_STATUS_STAT2_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_STATUS_STAT2_CLR(x);\
				((x) |= MOBI_FLASH_NOR_STATUS_STAT2_W(y))
#define     MOBI_FLASH_NOR_STATUS_STAT2_SHIFT 16
#define     MOBI_FLASH_NOR_STATUS_STAT2_REG MOBI_FLASH_NOR_STATUS

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_STATUS_STAT3 [8] - status from chip 3              */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_STATUS_STAT3_SIZE 8
#define     MOBI_FLASH_NOR_STATUS_STAT3_MASK 0xff000000
#define     MOBI_FLASH_NOR_STATUS_STAT3_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NOR_STATUS_STAT3_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NOR_STATUS_STAT3_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NOR_STATUS_STAT3_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NOR_STATUS_STAT3_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_STATUS_STAT3_CLR(x);\
				((x) |= MOBI_FLASH_NOR_STATUS_STAT3_W(y))
#define     MOBI_FLASH_NOR_STATUS_STAT3_SHIFT 24
#define     MOBI_FLASH_NOR_STATUS_STAT3_REG MOBI_FLASH_NOR_STATUS

#define MOBI_FLASH_NOR_STATUS_SEL     (MOBI_FLASH_BASE + 0x140)
#define MOBI_FLASH_NOR_STATUS_OFFSET  0x140
#define MOBI_FLASH_NOR_STATUS_SIZE    32
#define MOBI_FLASH_NOR_STATUS_MASK    0xffffffff
#define MOBI_FLASH_NOR_STATUS_RINIT   0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t stat0	:  8 ;
		uint32_t stat1	:  8 ;
		uint32_t stat2	:  8 ;
		uint32_t stat3	:  8 ;
	} b;
} mobi_flash_nor_status_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_ID - ID register                                   */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_ID_ID4 [8] - info from 4th ID read cycle           */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_ID_ID4_SIZE 8
#define     MOBI_FLASH_NOR_ID_ID4_MASK 0x000000ff
#define     MOBI_FLASH_NOR_ID_ID4_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_ID_ID4_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_ID_ID4_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_ID_ID4_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_ID_ID4_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_ID_ID4_CLR(x);\
				((x) |= MOBI_FLASH_NOR_ID_ID4_W(y))
#define     MOBI_FLASH_NOR_ID_ID4_SHIFT 0
#define     MOBI_FLASH_NOR_ID_ID4_REG MOBI_FLASH_NOR_ID

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_ID_ID3 [8] - info from 3rd ID read cycle           */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_ID_ID3_SIZE 8
#define     MOBI_FLASH_NOR_ID_ID3_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_ID_ID3_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_ID_ID3_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_ID_ID3_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_ID_ID3_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_ID_ID3_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_ID_ID3_CLR(x);\
				((x) |= MOBI_FLASH_NOR_ID_ID3_W(y))
#define     MOBI_FLASH_NOR_ID_ID3_SHIFT 8
#define     MOBI_FLASH_NOR_ID_ID3_REG MOBI_FLASH_NOR_ID

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_ID_DEV [8] - chip device code                      */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_ID_DEV_SIZE 8
#define     MOBI_FLASH_NOR_ID_DEV_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_ID_DEV_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_ID_DEV_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_ID_DEV_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_ID_DEV_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_ID_DEV_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_ID_DEV_CLR(x);\
				((x) |= MOBI_FLASH_NOR_ID_DEV_W(y))
#define     MOBI_FLASH_NOR_ID_DEV_SHIFT 16
#define     MOBI_FLASH_NOR_ID_DEV_REG MOBI_FLASH_NOR_ID

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_ID_MKR [8] - chip manufacturer code                */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_ID_MKR_SIZE 8
#define     MOBI_FLASH_NOR_ID_MKR_MASK 0xff000000
#define     MOBI_FLASH_NOR_ID_MKR_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NOR_ID_MKR_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NOR_ID_MKR_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NOR_ID_MKR_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NOR_ID_MKR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_ID_MKR_CLR(x);\
				((x) |= MOBI_FLASH_NOR_ID_MKR_W(y))
#define     MOBI_FLASH_NOR_ID_MKR_SHIFT 24
#define     MOBI_FLASH_NOR_ID_MKR_REG MOBI_FLASH_NOR_ID

#define MOBI_FLASH_NOR_ID_SEL         (MOBI_FLASH_BASE + 0x144)
#define MOBI_FLASH_NOR_ID_OFFSET      0x144
#define MOBI_FLASH_NOR_ID_SIZE        32
#define MOBI_FLASH_NOR_ID_MASK        0xffffffff
#define MOBI_FLASH_NOR_ID_RINIT       0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t id4	:  8 ;
		uint32_t id3	:  8 ;
		uint32_t dev	:  8 ;
		uint32_t mkr	:  8 ;
	} b;
} mobi_flash_nor_id_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_CFI - CFI register                                 */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CFI_CFI0 [8] - CFI from chip 0                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CFI_CFI0_SIZE 8
#define     MOBI_FLASH_NOR_CFI_CFI0_MASK 0x000000ff
#define     MOBI_FLASH_NOR_CFI_CFI0_R(x) (((x) & 0x000000ff) >> 0)
#define     MOBI_FLASH_NOR_CFI_CFI0_W(x) (((x) << 0) & 0x000000ff)
#define     MOBI_FLASH_NOR_CFI_CFI0_SET(x) (((x) |= 0x000000ff))
#define     MOBI_FLASH_NOR_CFI_CFI0_CLR(x) (((x) &= ~(0x000000ff)))
#define     MOBI_FLASH_NOR_CFI_CFI0_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CFI_CFI0_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CFI_CFI0_W(y))
#define     MOBI_FLASH_NOR_CFI_CFI0_SHIFT 0
#define     MOBI_FLASH_NOR_CFI_CFI0_REG MOBI_FLASH_NOR_CFI

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CFI_CFI1 [8] - CFI from chip 1                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CFI_CFI1_SIZE 8
#define     MOBI_FLASH_NOR_CFI_CFI1_MASK 0x0000ff00
#define     MOBI_FLASH_NOR_CFI_CFI1_R(x) (((x) & 0x0000ff00) >> 8)
#define     MOBI_FLASH_NOR_CFI_CFI1_W(x) (((x) << 8) & 0x0000ff00)
#define     MOBI_FLASH_NOR_CFI_CFI1_SET(x) (((x) |= 0x0000ff00))
#define     MOBI_FLASH_NOR_CFI_CFI1_CLR(x) (((x) &= ~(0x0000ff00)))
#define     MOBI_FLASH_NOR_CFI_CFI1_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CFI_CFI1_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CFI_CFI1_W(y))
#define     MOBI_FLASH_NOR_CFI_CFI1_SHIFT 8
#define     MOBI_FLASH_NOR_CFI_CFI1_REG MOBI_FLASH_NOR_CFI

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CFI_CFI2 [8] - CFI from chip 2                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CFI_CFI2_SIZE 8
#define     MOBI_FLASH_NOR_CFI_CFI2_MASK 0x00ff0000
#define     MOBI_FLASH_NOR_CFI_CFI2_R(x) (((x) & 0x00ff0000) >> 16)
#define     MOBI_FLASH_NOR_CFI_CFI2_W(x) (((x) << 16) & 0x00ff0000)
#define     MOBI_FLASH_NOR_CFI_CFI2_SET(x) (((x) |= 0x00ff0000))
#define     MOBI_FLASH_NOR_CFI_CFI2_CLR(x) (((x) &= ~(0x00ff0000)))
#define     MOBI_FLASH_NOR_CFI_CFI2_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CFI_CFI2_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CFI_CFI2_W(y))
#define     MOBI_FLASH_NOR_CFI_CFI2_SHIFT 16
#define     MOBI_FLASH_NOR_CFI_CFI2_REG MOBI_FLASH_NOR_CFI

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_CFI_CFI3 [8] - CFI from chip 3                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_CFI_CFI3_SIZE 8
#define     MOBI_FLASH_NOR_CFI_CFI3_MASK 0xff000000
#define     MOBI_FLASH_NOR_CFI_CFI3_R(x) (((x) & 0xff000000) >> 24)
#define     MOBI_FLASH_NOR_CFI_CFI3_W(x) (((x) << 24) & 0xff000000)
#define     MOBI_FLASH_NOR_CFI_CFI3_SET(x) (((x) |= 0xff000000))
#define     MOBI_FLASH_NOR_CFI_CFI3_CLR(x) (((x) &= ~(0xff000000)))
#define     MOBI_FLASH_NOR_CFI_CFI3_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_CFI_CFI3_CLR(x);\
				((x) |= MOBI_FLASH_NOR_CFI_CFI3_W(y))
#define     MOBI_FLASH_NOR_CFI_CFI3_SHIFT 24
#define     MOBI_FLASH_NOR_CFI_CFI3_REG MOBI_FLASH_NOR_CFI

#define MOBI_FLASH_NOR_CFI_SEL        (MOBI_FLASH_BASE + 0x148)
#define MOBI_FLASH_NOR_CFI_OFFSET     0x148
#define MOBI_FLASH_NOR_CFI_SIZE       32
#define MOBI_FLASH_NOR_CFI_MASK       0xffffffff
#define MOBI_FLASH_NOR_CFI_RINIT      0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t cfi0	:  8 ;
		uint32_t cfi1	:  8 ;
		uint32_t cfi2	:  8 ;
		uint32_t cfi3	:  8 ;
	} b;
} mobi_flash_nor_cfi_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_LENGTH - Flash length register                     */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_LENGTH_CMD [4] - flash chip operation in progress  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_LENGTH_CMD_SIZE 4
#define     MOBI_FLASH_NOR_LENGTH_CMD_MASK 0x0000000f
#define     MOBI_FLASH_NOR_LENGTH_CMD_R(x) (((x) & 0x0000000f) >> 0)
#define     MOBI_FLASH_NOR_LENGTH_CMD_W(x) (((x) << 0) & 0x0000000f)
#define     MOBI_FLASH_NOR_LENGTH_CMD_SET(x) (((x) |= 0x0000000f))
#define     MOBI_FLASH_NOR_LENGTH_CMD_CLR(x) (((x) &= ~(0x0000000f)))
#define     MOBI_FLASH_NOR_LENGTH_CMD_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_LENGTH_CMD_CLR(x);\
				((x) |= MOBI_FLASH_NOR_LENGTH_CMD_W(y))
#define     MOBI_FLASH_NOR_LENGTH_CMD_SHIFT 0
#define     MOBI_FLASH_NOR_LENGTH_CMD_REG MOBI_FLASH_NOR_LENGTH

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_LENGTH_UNUSED [10] - unused                        */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_LENGTH_UNUSED_SIZE 10
#define     MOBI_FLASH_NOR_LENGTH_UNUSED_MASK 0x00003ff0
#define     MOBI_FLASH_NOR_LENGTH_UNUSED_R(x) (((x) & 0x00003ff0) >> 4)
#define     MOBI_FLASH_NOR_LENGTH_UNUSED_W(x) (((x) << 4) & 0x00003ff0)
#define     MOBI_FLASH_NOR_LENGTH_UNUSED_SET(x) (((x) |= 0x00003ff0))
#define     MOBI_FLASH_NOR_LENGTH_UNUSED_CLR(x) (((x) &= ~(0x00003ff0)))
#define     MOBI_FLASH_NOR_LENGTH_UNUSED_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_LENGTH_UNUSED_CLR(x);\
				((x) |= MOBI_FLASH_NOR_LENGTH_UNUSED_W(y))
#define     MOBI_FLASH_NOR_LENGTH_UNUSED_SHIFT 4
#define     MOBI_FLASH_NOR_LENGTH_UNUSED_REG MOBI_FLASH_NOR_LENGTH

/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_LENGTH_LENGTH [15] - remaining byte count minus 1  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_LENGTH_LENGTH_SIZE 15
#define     MOBI_FLASH_NOR_LENGTH_LENGTH_MASK 0x1fffc000
#define     MOBI_FLASH_NOR_LENGTH_LENGTH_R(x) (((x) & 0x1fffc000) >> 14)
#define     MOBI_FLASH_NOR_LENGTH_LENGTH_W(x) (((x) << 14) & 0x1fffc000)
#define     MOBI_FLASH_NOR_LENGTH_LENGTH_SET(x) (((x) |= 0x1fffc000))
#define     MOBI_FLASH_NOR_LENGTH_LENGTH_CLR(x) (((x) &= ~(0x1fffc000)))
#define     MOBI_FLASH_NOR_LENGTH_LENGTH_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_LENGTH_LENGTH_CLR(x);\
				((x) |= MOBI_FLASH_NOR_LENGTH_LENGTH_W(y))
#define     MOBI_FLASH_NOR_LENGTH_LENGTH_SHIFT 14
#define     MOBI_FLASH_NOR_LENGTH_LENGTH_REG MOBI_FLASH_NOR_LENGTH

#define MOBI_FLASH_NOR_LENGTH_SEL     (MOBI_FLASH_BASE + 0x14c)
#define MOBI_FLASH_NOR_LENGTH_OFFSET  0x14c
#define MOBI_FLASH_NOR_LENGTH_SIZE    32
#define MOBI_FLASH_NOR_LENGTH_MASK    0x1fffffff
#define MOBI_FLASH_NOR_LENGTH_RINIT   0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t cmd	:  4 ;
		uint32_t unused	: 10 ;
		uint32_t length	: 15 ;
	} b;
} mobi_flash_nor_length_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_INTERRUPT - Interrupt done register                */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_INTERRUPT_DI [1] - interrupt done when equal 1     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_INTERRUPT_DI_SIZE 1
#define     MOBI_FLASH_NOR_INTERRUPT_DI_MASK 0x00000001
#define     MOBI_FLASH_NOR_INTERRUPT_DI_R(x) (((x) & 0x00000001) >> 0)
#define     MOBI_FLASH_NOR_INTERRUPT_DI_W(x) (((x) << 0) & 0x00000001)
#define     MOBI_FLASH_NOR_INTERRUPT_DI_SET(x) (((x) |= 0x00000001))
#define     MOBI_FLASH_NOR_INTERRUPT_DI_CLR(x) (((x) &= ~(0x00000001)))
#define     MOBI_FLASH_NOR_INTERRUPT_DI_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_INTERRUPT_DI_CLR(x);\
				((x) |= MOBI_FLASH_NOR_INTERRUPT_DI_W(y))
#define     MOBI_FLASH_NOR_INTERRUPT_DI_SHIFT 0
#define     MOBI_FLASH_NOR_INTERRUPT_DI_REG MOBI_FLASH_NOR_INTERRUPT

#define MOBI_FLASH_NOR_INTERRUPT_SEL  (MOBI_FLASH_BASE + 0x150)
#define MOBI_FLASH_NOR_INTERRUPT_OFFSET 0x150
#define MOBI_FLASH_NOR_INTERRUPT_SIZE 32
#define MOBI_FLASH_NOR_INTERRUPT_MASK 0x00000001
#define MOBI_FLASH_NOR_INTERRUPT_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t di	:  1 ;
	} b;
} mobi_flash_nor_interrupt_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_DIRECT - Direct acccess address                    */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_DIRECT_ADDR [32] - direct byte address             */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_DIRECT_ADDR_SIZE 32
#define     MOBI_FLASH_NOR_DIRECT_ADDR_MASK 0xffffffff
#define     MOBI_FLASH_NOR_DIRECT_ADDR_R(x) (((x) & 0xffffffff) >> 0)
#define     MOBI_FLASH_NOR_DIRECT_ADDR_W(x) (((x) << 0) & 0xffffffff)
#define     MOBI_FLASH_NOR_DIRECT_ADDR_SET(x) (((x) |= 0xffffffff))
#define     MOBI_FLASH_NOR_DIRECT_ADDR_CLR(x) (((x) &= ~(0xffffffff)))
#define     MOBI_FLASH_NOR_DIRECT_ADDR_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_DIRECT_ADDR_CLR(x);\
				((x) |= MOBI_FLASH_NOR_DIRECT_ADDR_W(y))
#define     MOBI_FLASH_NOR_DIRECT_ADDR_SHIFT 0
#define     MOBI_FLASH_NOR_DIRECT_ADDR_REG MOBI_FLASH_NOR_DIRECT

#define MOBI_FLASH_NOR_DIRECT_SEL     (MOBI_FLASH_BASE + 0x154)
#define MOBI_FLASH_NOR_DIRECT_OFFSET  0x154
#define MOBI_FLASH_NOR_DIRECT_SIZE    32
#define MOBI_FLASH_NOR_DIRECT_MASK    0xffffffff
#define MOBI_FLASH_NOR_DIRECT_RINIT   0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t addr	: 32 ;
	} b;
} mobi_flash_nor_direct_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_DIRECT_LOW - Direct Access Data Low register       */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_DIRECT_LOW_DATA [4] - low data                     */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_SIZE 4
#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_MASK 0x0000000f
#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_R(x) (((x) & 0x0000000f) >> 0)
#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_W(x) (((x) << 0) & 0x0000000f)
#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_SET(x) (((x) |= 0x0000000f))
#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_CLR(x) (((x) &= ~(0x0000000f)))
#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_DIRECT_LOW_DATA_CLR(x);\
				((x) |= MOBI_FLASH_NOR_DIRECT_LOW_DATA_W(y))
#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_SHIFT 0
#define     MOBI_FLASH_NOR_DIRECT_LOW_DATA_REG MOBI_FLASH_NOR_DIRECT_LOW

#define MOBI_FLASH_NOR_DIRECT_LOW_SEL (MOBI_FLASH_BASE + 0x158)
#define MOBI_FLASH_NOR_DIRECT_LOW_OFFSET 0x158
#define MOBI_FLASH_NOR_DIRECT_LOW_SIZE 32
#define MOBI_FLASH_NOR_DIRECT_LOW_MASK 0x0000000f
#define MOBI_FLASH_NOR_DIRECT_LOW_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t data	:  4 ;
	} b;
} mobi_flash_nor_direct_low_t;

#endif /* __ASSEMBLY__ */

/* ========================================================================= */
/*         MOBI_FLASH_NOR_DIRECT_HIGH - Direct Access Data High register     */
/* ========================================================================= */


/* ------------------------------------------------------------------------- */
/*         MOBI_FLASH_NOR_DIRECT_HIGH_DATA [32] - high data                  */
/* ------------------------------------------------------------------------- */

#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_SIZE 32
#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_MASK 0xffffffff
#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_R(x) (((x) & 0xffffffff) >> 0)
#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_W(x) (((x) << 0) & 0xffffffff)
#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_SET(x) (((x) |= 0xffffffff))
#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_CLR(x) (((x) &= ~(0xffffffff)))
#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_CLR_AND_SET(x, y) \
				MOBI_FLASH_NOR_DIRECT_HIGH_DATA_CLR(x);\
				((x) |= MOBI_FLASH_NOR_DIRECT_HIGH_DATA_W(y))
#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_SHIFT 0
#define     MOBI_FLASH_NOR_DIRECT_HIGH_DATA_REG MOBI_FLASH_NOR_DIRECT_HIGH

#define MOBI_FLASH_NOR_DIRECT_HIGH_SEL (MOBI_FLASH_BASE + 0x15c)
#define MOBI_FLASH_NOR_DIRECT_HIGH_OFFSET 0x15c
#define MOBI_FLASH_NOR_DIRECT_HIGH_SIZE 32
#define MOBI_FLASH_NOR_DIRECT_HIGH_MASK 0xffffffff
#define MOBI_FLASH_NOR_DIRECT_HIGH_RINIT 0x00000000

#ifndef __ASSEMBLY__

typedef union {
	unsigned int r;
	struct {
		uint32_t data	: 32 ;
	} b;
} mobi_flash_nor_direct_high_t;

#endif /* __ASSEMBLY__ */

#endif /* !defined(mobi_flash_INCLUDED) */
