/*HEADER_START*/
/*
*  linux/arch/arm/mach-falcon/clock.h
*
*  Copyright (C) 2006 Mobilygen Corp
*  Derived from mach-versatile/clock.h
*
*  Copyright (C) 2004 ARM Limited.
*  Written by Deep Blue Solutions Limited.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 2 as
* published by the Free Software Foundation.
 */
/*HEADER_STOP*/

#ifndef __MACH_FALCON_CLOCK_H
#define __MACH_FALCON_CLOCK_H

#include <mach/mobi_clock.h>
#include <mach/mobi_qcc.h>

#define CLOCK_PROC_DIR	"drivers/clock"

/* the number of bits in the N/R fields + 1 */
#define NR_FIELD_LIMIT (QCC_CHIPCTL_QMMGENCONTROL_QMMGENCONTROL_R_R(QCC_CHIPCTL_QMMGENCONTROL_QMMGENCONTROL_R_MASK)+1)

#if 0
/* for reference, from commit 464efaf0d72a09c6e0086ae010bcd0933a721e6f */
typedef union {
	unsigned int r;
	struct {
		uint32_t pll0config0_load   :  1 ;
		uint32_t pll0config0_resetb :  1 ;
		uint32_t pll0config0_bypass :  1 ;
		uint32_t pll0config0_constant   :  1 ;
		uint32_t pll0config0_srcsel :  2 ;
		uint32_t rsvd0  :  7 ;
		uint32_t pll0config0_m  : 10 ;
		uint32_t pll0config0_p  :  6 ;
		uint32_t pll0config0_s  :  3 ;
	} b;
} qcc_chipctl_pll0config0_t;

typedef union {
	unsigned int r;
	struct {
		uint32_t qmmgencontrol_load :  1 ;
		uint32_t qmmgencontrol_clken    :  1 ;
		uint32_t qmmgencontrol_bypass   :  1 ;
		uint32_t rsvd0  :  5 ;
		uint32_t qmmgencontrol_srcsel   :  4 ;
		uint32_t qmmgencontrol_r    :  8 ;
		uint32_t rsvd1  :  2 ;
		uint32_t qmmgencontrol_n    :  8 ;
		uint32_t rsvd2  :  2 ;
	} b;
} qcc_chipctl_qmmgencontrol_t;

typedef union {
	unsigned int r;
	struct {
		uint32_t mmcgencontrol_load :  1 ;
		uint32_t mmcgencontrol_clken    :  1 ;
		uint32_t mmcgencontrol_bypass   :  1 ;
		uint32_t rsvd0  :  5 ;
		uint32_t mmcgencontrol_srcsel   :  4 ;
		uint32_t mmcgencontrol_low  :  8 ;
		uint32_t rsvd1  :  2 ;
		uint32_t mmcgencontrol_high :  8 ;
		uint32_t rsvd2  :  2 ;
	} b;
} qcc_chipctl_mmcgencontrol_t;

typedef union {
	unsigned int r;
	struct {
		uint32_t pll0config1_k  : 16 ;
		uint32_t rsvd0  : 14 ;
		uint32_t pll0config1_icp    :  2 ;
	} b;
} qcc_chipctl_pll0config1_t;
#endif

/* 
 * we have four type of ctrl regs, pll(0/1), HL and NR, so we
 * just pick 3 represenative types and put them in a union. pll's
 * have two regs so one of them has to exist outside the union
 * the * type of clock is embedded in the upper bits of the clock id
 */
typedef struct clk_ctrl_s {
	union {
		uint32_t reg;
		qcc_chipctl_pll0config0_t	 pll0;
		qcc_chipctl_qmmgencontrol_t	 nr;
		qcc_chipctl_mmcgencontrol_t  hl;
	} ctrl;
	qcc_chipctl_pll1config1_t	 pll1;
} clk_ctrl_t;

/***************************************************/
struct clk {
	struct list_head	node;
	const char		    *name;
	clock_id_t			id;
	uint32_t			qcc_addr;
	gated_clock_id_t	gclk_id;
	struct mutex		lock;
	struct module		*owner;
};

#endif
