/* Creates two threads, one printing 10000 "a"s, the other printing
   10000 "b"s.
   Illustrates: thread creation, thread joining. */

#define NUMBER	10000
/* #define NUMBER	10 */

#include <stddef.h>
#include <stdio.h>
#include <unistd.h>
#include "pthread.h"

void * process(void * arg)
{
  int i;
/* fprintf(stderr, "in subroutine process\n"); sleep(1); */
  fprintf(stderr, "Starting process %s\n", (char *) arg);
  for (i = 0; i < NUMBER; i++) {
    write(1, (char *) arg, 1);
  }
/* fprintf(stderr, "subroutine process leaving\n"); sleep(1); */
  return NULL;
}

int main(void)
{
/* fprintf(stderr, "main\n"); sleep(1); */
  int retcode;
/* fprintf(stderr, "main #1\n"); sleep(1); */
  pthread_t th_a, th_b;
/* fprintf(stderr, "main #2\n"); sleep(1); */
  void * retval;

/* fprintf(stderr, "main #3\n"); sleep(1); */
  retcode = pthread_create(&th_a, NULL, process, (void *) "a");
/* fprintf(stderr, "after pthread_create a\n"); sleep(1); */
  if (retcode != 0) fprintf(stderr, "create a failed %d\n", retcode);
  else fprintf(stderr, "create a succeeded %d\n", retcode);
/* fprintf(stderr, "before pthread_create b\n"); sleep(1); */
  retcode = pthread_create(&th_b, NULL, process, (void *) "b");
/* fprintf(stderr, "after pthread_create b\n"); sleep(1); */
  if (retcode != 0) fprintf(stderr, "create b failed %d\n", retcode);
  else fprintf(stderr, "create b succeeded %d\n", retcode);
/* fprintf(stderr, "before pthread_join a\n"); sleep(1); */
  retcode = pthread_join(th_a, &retval);
/* fprintf(stderr, "after pthread_join a\n"); sleep(1); */
  if (retcode != 0) fprintf(stderr, "join a failed %d\n", retcode);
  else fprintf(stderr, "join a succeeded %d\n", retcode);
/* fprintf(stderr, "before pthread_join b\n"); sleep(1); */
  retcode = pthread_join(th_b, &retval);
/* fprintf(stderr, "after pthread_join b\n"); sleep(1); */
  if (retcode != 0) fprintf(stderr, "join b failed %d\n", retcode);
  else fprintf(stderr, "join b succeeded %d\n", retcode);
/* fprintf(stderr, "main leaving\n"); sleep(1); */
  return 0;
}
