/* Copyright (C) 1992, 1995, 1997 Free Software Foundation, Inc.
   This file is part of the GNU C Library.
   Contributed by Brendan Kehoe (brendan@zen.org).

   The GNU C Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License as published by the Free Software Foundation; either
   version 2.1 of the License, or (at your option) any later version.

   The GNU C Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the GNU C Library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307 USA.  */

/* Note: .abicalls goes at top of routine, and only one of them. */

#ifdef PROF
#define PROFSTRING \
	.set	noat;		\
	move	$1,$31;		\
	subu	sp,sp,8;	\
	jal	_mcount;	\
	.set	at;
#else
#define PROFSTRING
#endif

#ifndef __UCLIBC_USE_UNIFIED_SYSCALL__
#define SYSCALL__(name)				\
	.text;					\
NESTED(name, 0, ra);				\
	PROFSTRING				\
	li	v0, __NR_##name ;		\
	syscall;				\
	la	t3, errno;			\
	beqz	a3, 1f;				\
	sw	v0, 0(t3);			\
	li	v0, -1;				\
  1:	;					\
	j	ra;				\
END(name)
#else	/* __UCLIBC_USE_UNIFIED_SYSCALL__ */
#define SYSCALL__(name)				\
	.text;					\
NESTED(name, 0, ra);				\
	PROFSTRING				\
	li	v0, __NR_##name ;		\
	syscall;				\
	j	__uClibc_syscall;		\
END(name)
#endif	/* __UCLIBC_USE_UNIFIED_SYSCALL__ */

#include <asm/asm.h>
#include <asm/unistd.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>

#define _SYSCALL0(type,name)	SYSCALL__(name)
_SYSCALL0(pid_t, vfork);

