#include <features.h>

#ifdef PROF
#define PROFSTRING \
	.set		noat;			\
	move		$1,ra;			\
	subu		sp,sp,8;		\
	jal		_mcount;		\
	.set		at;
#else
#define PROFSTRING
#endif						\

#ifndef __UCLIBC_USE_UNIFIED_SYSCALL__
#define SYSCALL__(name)				\
NESTED(name, 0, ra);				\
	PROFSTRING				\
	li	v0, __NR_##name ;		\
	syscall;				\
	la	t3, errno;			\
	beqz	a3, 1f;				\
	sw	v0, 0(t3);			\
	li	v0, -1;				\
  1:	;					\
	j	ra;				\
END(name)
#else	/* __UCLIBC_USE_UNIFIED_SYSCALL__ */
#define SYSCALL__(name)				\
NESTED(name, 0, ra);				\
	PROFSTRING				\
	li	v0, __NR_##name ;		\
	syscall;				\
	j	__uClibc_syscall;		\
END(name)
#endif	/* __UCLIBC_USE_UNIFIED_SYSCALL__ */

#include <asm/asm.h>
#include <asm/unistd.h>
#include <asm/mipsregs.h>
#include <asm/regdef.h>

#define _SYSCALL0(type,name)	SYSCALL__(name)
_SYSCALL0(pid_t, fork);

