/*	$Id: crt0.c,v 1.4 2002/10/31 07:28:03 mrustad Exp $	*/
/*	$OpenBSD: loader.c,v 1.4 2000/10/13 05:21:10 drahn Exp $ */

/*
 * Copyright (c) 1998 Per Fogelstrom, Opsycon AB
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed under OpenBSD by
 *	Per Fogelstrom, Opsycon AB, Sweden.
 * 4. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#define	_DYN_LOADER

#include <stdlib.h>
#include <string.h>

/* ------------------------------------------------------------------------ */
extern void __uClibc_main(int argc,void *argv,void *envp);

/* ------------------------------------------------------------------------ */
/* This are main variables used thru-out the system. */
char	*__progname = "";

extern int _fdata;
int *_f_d_a_t_a_ = &_fdata;
/* ------------------------------------------------------------------------ */

/* void _start(const void *sp) */
void _start(const void *sp)
{
	struct kframe {
		int	kargc;
		char	*kargv[1];	/* size depends on kargc */
		char	kargstr[1];	/* size varies */
		char	kenvstr[1];	/* size varies */
	};

	char	      **argv;
	int		argc;
	char	      **envp;
	struct kframe  *kfp;

	kfp = (struct kframe *) sp;
/* Scan argument and environment vectors. */
	argc = kfp->kargc;
	argv = &kfp->kargv[0];
	envp = &argv[argc + 1];

	{
		char	*ap = (char *)argv[0];

		if (ap != 0) {
			if ((__progname = (char *)strrchr(ap, '/')) == 0) {
				__progname = ap;
			} else {
				++__progname;
			}
		}
	}

	__uClibc_main(argc, argv, envp);
}

/* ------------------------------------------------------------------------ */
int h_errno;
