/*
 * $Id: __uClibc_syscall.S,v 1.5 2003/02/01 03:53:31 m4 Exp $
 *
 * __uClibc_syscall.S - MIPS version.
 *
 * Derived from x86 implementation to reduce memory footprint
 * for syscalls.
 *
 * Mark Rustad, 03/21/2002
 * Copyright 2002 BRECIS Communications Corp.
 *
 * uClibc is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with uClibc; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307 USA.
 */
 
#include <sys/regdef.h>
#include <asm/asm.h>
 
	.text
LEAF(__uClibc_syscall)
/* 	syscall */
	.set	noreorder
	beqz	a3, 1f
	lui	t3, %hi(errno)
	.set	reorder
	sw	v0, %lo(errno)(t3)
	li	v0, -1
1:
	j	ra
END(__uClibc_syscall)

/* #define CHECKSYSCALLREGISTERS */
#ifdef CHECKSYSCALLREGISTERS
	.text
NESTED(CHECK_ALL_REGS_FAIL, 0, ra)
	la	$8, SAVE_FAILED_HERE
	sw	$9, 0($8)
	sw	$10, 4($8)
	sw	$11, 8($8)
	sw	$31, 12($8)	/* ra */
	jal	_M4_reg_fail_
	la	$8, SAVE_FAILED_HERE
	lw	$31, 12($8)	/* ra */
	jr	$31		/* return from where we came */
END(CHECK_ALL_REGS_FAIL)



NESTED(CHECK_STACK_FAIL,0,ra)
	la	$8, SAVE_STACK_HERE_FAIL
	sw	$29, 0($8)	/* sp */
	sw	$4, 4($8)	/* a0 (moved from t0) */
	sw	$5, 8($8)	/* a1 (moved from t1) */
	sw	$31, 12($8)	/* ra */
	jal	_M4_stack_fail_
	la	$8, SAVE_STACK_HERE_FAIL
	lw	$31, 12($8)	/* ra */
	jr	$31		/* return from where we came */
END(CHECK_STACK_FAIL)



	.data
	.globl	SAVE_ALL_REGS_HERE
SAVE_ALL_REGS_HERE:
	.word	0	/* at, 1 -- NOT USED */
	.word	0	/* v1, 3 */
	.word	0	/* a0, 4 */
	.word	0	/* a1, 5 */
	.word	0	/* a2, 6 */
	.word	0	/* a3, 7 -- NOT USED */
	.word	0	/* s0, 16 */
	.word	0	/* s1, 17 */
	.word	0	/* s2, 18 */
	.word	0	/* s3, 19 */
	.word	0	/* s4, 20 */
	.word	0	/* s5, 21 */
	.word	0	/* s6, 22 */
	.word	0	/* s7, 23 */
	.word	0	/* t9, 25 */
	.word	0	/* gp, 28 */
	.word	0	/* sp, 29 */
	.word	0	/* s8, 30 */
	.word	0	/* ra, 31 */

	.globl	SAVE_FAILED_HERE
SAVE_FAILED_HERE:
	.word	0	/* should be register contents */
	.word	0	/* register # that is bad */
	.word	0	/* contents of the bad register */
	.word	0	/* ra */

	.globl	SAVE_STACK_HERE
SAVE_STACK_HERE:
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0;
    .word 0	/* *(sp) is here */
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0
    .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0; .word 0;
    .word 0	/* extra, just in case */

	.globl	SAVE_STACK_HERE_FAIL
SAVE_STACK_HERE_FAIL:
	.word	0	/* sp */
	.word	0	/* t0 */
	.word	0	/* t1 */
	.word	0	/* ra */
#endif
