/*
 * Carsten Langgaard, carstenl@mips.com
 * Copyright (C) 1999,2000 MIPS Technologies, Inc.  All rights reserved.
 *
 *  This program is free software; you can distribute it and/or modify it
 *  under the terms of the GNU General Public License (Version 2) as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope it will be useful, but WITHOUT
 *  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 *  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 *  for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  59 Temple Place - Suite 330, Boston MA 02111-1307, USA.
 *
 * PROM library initialisation code.
 */
#include <stdio.h>
#include <string.h>
#include <sys/utsname.h>
#include <asm/brecis/prom.h>

static char MSPDefaultFeatures[] = "EM";
static char MSP2000DefaultFeatures[] = "EMEMEMSDTDZD";
static char MSP2000REVBDefaultFeatures[] = "EMEMEMSD";
static char MSP5000DefaultFeatures[] = "EMEMSTTTZT";

static char *getFeatures(char *buf)
{
	FILE *f;
	int featuresnamelen = strlen(FEATURES);
	struct utsname name;

	f = fopen(PROM_ENV_FILE, "r");

	if (f != NULL)
	{
		while (fgets(buf, sizeof(buf), f) != NULL)
		{
			if ('=' == buf[featuresnamelen] &&
			    strncmp(FEATURES, buf, featuresnamelen) == 0)
			{
				fclose(f);
				return (&buf[featuresnamelen+1]);
			}
		}
		fclose(f);
	}

	if (uname(&name) == -1)
		return NULL;

	if (strncmp(name.machine, MACHINE_TYPE_MSP2000REVB,
		    strlen(MACHINE_TYPE_MSP2000REVB)) == 0)
		return MSP2000REVBDefaultFeatures;
	else if (strncmp(name.machine, MACHINE_TYPE_MSP5000,
			 strlen(MACHINE_TYPE_MSP5000)) == 0)
		return MSP5000DefaultFeatures;
	else if (strncmp(name.machine, MACHINE_TYPE_DUET,
			 strlen(MACHINE_TYPE_DUET)) == 0)
		return MSP2000DefaultFeatures;
	else
		return MSPDefaultFeatures;
}

static char testFeature(char c)
{
	char buf[PROM_ENV_SIZE];
	char *feature = getFeatures(buf);

	while (*feature)
	{
		if (*feature++ == c)
			return *feature;
		feature++;
	}

	return FEATURE_NOEXIST;
}

char identify_pci(void)
{
	return testFeature(PCI_KEY);
}

char identify_sec(void)
{
	return testFeature(SEC_KEY);
}

char identify_spad(void)
{
	return testFeature(SPAD_KEY);
}

char identify_tdm(void)
{
	return testFeature(TDM_KEY);
}

char identify_zsp(void)
{
	return testFeature(ZSP_KEY);
}

char identify_enet(unsigned long interfaceNum)
{
	char buf[PROM_ENV_SIZE];
	char *feature = getFeatures(buf);

	while (*feature)
	{
		if (*feature++ == ENET_KEY && interfaceNum-- == 0)
			return *feature;
		feature++;
	}

	return FEATURE_NOEXIST;
}




