/* sleep - delay for a specified amount of time. */

#include <stdio.h>
#include <time.h>
#include <unistd.h>
#include <stdlib.h>

int             main(int argc, char **argv)
{
  int             i;
  char *endptr;
  long time1;
  long time2 = 0;
  struct timespec r;

  if (argc != 2) {
    fprintf(stderr, "sleep: Wrong number of arguments (%d). Need exactly one argument.\n", argc - 1);
    exit(1);
  }

  argv++;
  time1 = strtol(*argv, &endptr, 10);
  if (*endptr == '.') {
    endptr++;
    for (i = 100000000; i > 0; i /= 10) {
      if (*endptr == '\0') {
	break;
      }
      if (*endptr < '0' || *endptr > '9') {
	break;
      }
      time2 += (*endptr++ - '0') * i;
    }
  }
  if (*endptr != '\0') {
    fprintf(stderr, "sleep: Not a floating point character 0x%x (%c).\n", *endptr, *endptr);
    exit(1);
  }
  r.tv_sec = time1;
  r.tv_nsec = time2;
  nanosleep(&r, NULL);

  exit(0);
}
