#include "iwlib.h"
#include "wireless.h"
#include <stdio.h>

int
main(int	argc,
     char **	argv)
{
  int skfd;		/* generic raw socket desc.	*/
  char wdslink[24];
  char buffer[24];
  char link_no[24];
  char c_temp1[28];
  int goterr = 0;
  struct iwreq 	wrq;
  FILE 			*fp;

  /* Create a channel to the NET kernel. */
  if((skfd = iw_sockets_open()) < 0)
    {
      printf("socket open error");
      exit(-1);
    }
   printf("\r\n\r\nwdslink: 1. skfd = %d \n",skfd);

  /* No argument : show the list of all device + info */
  if(argc < 5)
  {
    printf("Useage : wdslink <device> <wdslinkadd|wdslinkdel> <MAC address> <link no>\n");
    	return 0;
  }

    /* Set device name */
    strcpy((char *)wrq.ifr_name, argv[1]);

	/* Set wdslink add or wdslink del */
	strcpy(wdslink,argv[2]);

    /* set Cmd and arg */
    wrq.u.data.pointer = (caddr_t)buffer;
	strcpy(buffer,argv[3]);
		
	sprintf(link_no,"/var/config/wds_%s",argv[4]);
	
	/* print the parameter */
	printf("wdslink: 2. interface name = %s \n",(char *)wrq.ifr_name );
	printf("wdslink:    wdslink command = %s \n", wdslink);
	printf("wdslink:    MAC address =%s \n",buffer);
	printf("wdslink:    file link no =%s \n",link_no);


	
	if ( strcmp(wdslink,"wdslinkadd") == 0 )
	{
		printf("wdslink: 3. enter wdslinkadd process \n");
    	/* Do the request */
		 
    	goterr = ioctl(skfd, SIOCIWFIRSTPRIV + 0x10, &wrq);
    	printf("wdslink: 4. goterr = %d \n",goterr);
    	
    	if( goterr == 0 )
    	{
    		if ( (fp = fopen(link_no,"w")) != NULL )
    		{
    			fprintf(fp,"%s\n",buffer);
    			fclose(fp);
    		}
    		
    	}
    }
    
#if 0    
    if ( strcmp(wdslink,"wdslinkdel") == 0 )
	{
		printf("wdslink: enter wdslinkdel process \n");
    	/* Do the request */
    	goterr = ioctl(skfd, SIOCIWFIRSTPRIV + 0x11, &wrq);
    	
		if ( (fp = fopen(link_no,"r")) != NULL )
		{
			fclose(fp);
			sprintf(c_temp1,"rm -f %s",link_no);
			system(c_temp1);
			printf("wdslink: %s \n",c_temp1);
		}
    	
    }
    
#endif
  
  /* Close the socket. */
  close(skfd);
  if(goterr < 0)
  {
  	printf("Error : %s\n",strerror(errno));
  }
/*  else if(wrq.u.data.flags == 0)
  	printf("Result = 0x%lx\n",(long)wrq.u.data.pointer);
*/
  return(goterr);
}
