#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <wait.h>

#include <errno.h>
#include <linux/errno.h>

static char inbuf[1024];

/* ------------------------------------------------------------------------ */
static void Headers()
{
  printf("Content-type: text/html\n");
  printf("\n");
  printf("<HTML>\n");
  printf("<HEAD>\n");
  printf("<TITLE>CGI test-post program</TITLE>\n");
  printf("</HEAD>\n");
  printf("<H3>CGI test-post program</H3>\n");
  printf("<PRE>\n");
}	/* End of Headers */

/* ------------------------------------------------------------------------ */
static void Trailers()
{
  printf("\n");
  printf("\n");
  printf("The End\n");
  printf("</PRE>\n");
  printf("</BODY>\n");
  printf("</HTML>\n");
}	/* End of Trailers */

/* ------------------------------------------------------------------------ */
static long contentlength(char *envp[])
{
  int i;
  char *p;
  long value;

  i = 0;
  while (envp[i] != NULL) { 
    if (strncmp("CONTENT_LENGTH=",envp[i], 15)==0) {
      p = index(envp[i],'=');
      p++;
      value = strtol(p,NULL,10);
      printf("CONTENT_LENGTH=%ld\n", value);
      return(value);
    }
    i++;
  }
  if (envp[i] == NULL) {
    printf("No CONTENT_LENGTH= environment variable\n");
  }
  return(0);
}	/* End of contentlength */

/* ------------------------------------------------------------------------ */
#ifdef NOVFORK
static void print_date()
{
  int pid;

  printf("Date:\n");
  fflush(stdout);
  if ((pid = vfork()) < 0) {
    perror("vfork date");
    exit(1);
  } else if (pid == 0) {
/*     printf("child vforked\n"); fflush(stdout); */
/*     sleep(1); */
    execl("/bin/date", "/bin/date", NULL);
/*     printf("child vforked\n"); fflush(stdout); sleep(1); */
    perror("execl date");
    _exit(1);
  } else {
    int wait_val;

    if (waitpid(pid, &wait_val, 0) == -1) {
      perror("wait4 date");
    } else {
      ;
    }
  }
  printf("\n");
}	/* End of print_date */

/* ------------------------------------------------------------------------ */
static void print_env()
{
  int pid;

  printf("Env:\n");
  fflush(stdout);
  if ((pid = vfork()) < 0) {
    perror("vfork printenv");
    exit(1);
  } else if (pid == 0) {
/*     printf("child vforked\n"); fflush(stdout); */
    execl("/bin/printenv", "/bin/printenv", NULL);
/*     printf("child vforked\n"); fflush(stdout); sleep(1); */
    perror("execl printenv");
    _exit(1);
  } else {
    int wait_val;

    if (waitpid(pid, &wait_val, 0) == -1) {
      perror("wait4 printenv");
    } else {
      ;
    }
  }
  printf("\n");
}	/* End of print_env */
#endif	/* NOVFORK */

/* ------------------------------------------------------------------------ */
int main(int argc, char *argv[], char *envp[])
{
#if 0
  int pid;
#endif	/* 0 */
  long value = 0;
  int i;

  Headers();

#ifdef NOVFORK
  print_date();

  print_env();
#endif	/* NOVFORK */

  printf("Input:\n");

  value = contentlength(envp);
  fflush(stdout);	/* switching from buffered to direct */

  if (value > 0) {
    int tryagain = 0;

    while (value > 0) {
      int j;
      if (value > sizeof(inbuf)) {
	j = sizeof(inbuf);
      } else {
	j = value;
      }
      i = read(0, inbuf, j);
      if (i < 0) {
	int saveerrno = errno;

	snprintf(inbuf, sizeof(inbuf), "from read, i=%d, j=%d, errno=%d\n", i, j, errno);
	perror("read");
	printf(inbuf);
	fflush(stdout);
	if (saveerrno == EAGAIN) {
	  if (tryagain++ < 10) {
	    continue;
	  }
	}
	break;
      } else if (i == 0) {
	printf("i== 0, huh?\n");
	break;
      } else {
	write(1,inbuf,i);
      }
      value = value - i;
    }
  }

  Trailers();
  fflush(stdout);

  exit(0);
}
